/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.datepicker;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;

public class DateTimePicker
extends JPanel {
    private static final String CLOCK_ICON = "images/Clock.gif";
    private static final String POPUP_ICON = "images/Popup.gif";
    private static final String NEXT_ICON = "images/Next.gif";
    private static final String PREV_ICON = "images/Previous.gif";
    protected static final SimpleDateFormat MONTH_NAME = new SimpleDateFormat("MMMM");
    protected static final SimpleDateFormat YEAR = new SimpleDateFormat("yyyy");
    protected static final SimpleDateFormat ODS_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    protected Calendar calendar;
    protected String format;
    protected JLabel label;
    protected JButton actDate;
    protected JButton popupBut;
    protected int hourIncrease;
    protected int hourDecrease;
    protected int minuteIncrease;
    protected int minuteDecrease;
    protected int secondIncrease;
    protected int secondDecrease;

    public DateTimePicker() {
        this(new GregorianCalendar(), DateTimePicker.getDateFormat());
    }

    public DateTimePicker(Calendar calendar) {
        this(calendar, DateTimePicker.getDateFormat());
    }

    public DateTimePicker(String format) {
        this(new GregorianCalendar(), format);
    }

    public DateTimePicker(Calendar calendar, String format) {
        this.calendar = calendar;
        this.format = format;
        this.setHourIncrease(1);
        this.setHourDecrease(1);
        this.setMinuteIncrease(15);
        this.setMinuteDecrease(15);
        this.setSecondIncrease(1);
        this.setSecondDecrease(1);
        this.createComponents();
    }

    public void setASAMODSDate(String date) throws ParseException {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(ODS_DATE_FORMAT.parse(date));
        this.setCalendar(c);
    }

    public String getASAMODSDate() {
        return ODS_DATE_FORMAT.format(this.calendar.getTime());
    }

    public void setHourIncrease(int value) {
        this.hourIncrease = Math.abs(value);
    }

    public int getHourIncrease() {
        return this.hourIncrease;
    }

    public void setHourDecrease(int value) {
        this.hourDecrease = Math.abs(value);
    }

    public int getHourDecrease() {
        return this.hourDecrease;
    }

    public void setMinuteIncrease(int value) {
        this.minuteIncrease = Math.abs(value);
    }

    public int getMinuteIncrease() {
        return this.minuteIncrease;
    }

    public void setMinuteDecrease(int value) {
        this.minuteDecrease = Math.abs(value);
    }

    public int getMinuteDecrease() {
        return this.minuteDecrease;
    }

    public void setSecondIncrease(int value) {
        this.secondIncrease = Math.abs(value);
    }

    public int getSecondIncrease() {
        return this.secondIncrease;
    }

    public void setSecondDecrease(int value) {
        this.secondDecrease = Math.abs(value);
    }

    public int getSecondDecrease() {
        return this.secondDecrease;
    }

    protected int increaseValue(int value, int increase, int mod) {
        if ((value = (value + increase) % mod) % increase != 0) {
            value = value / increase * increase % mod;
        }
        return value;
    }

    protected int decreaseValue(int value, int decrease, int mod) {
        if ((value = (value - decrease < 0 ? 60 + (value - decrease) : value - decrease) % 60) % decrease != 0) {
            value = (value / decrease + 1) * decrease % mod;
        }
        return value;
    }

    protected void setTextValue(JLabel widget, int val) {
        if (val < 10) {
            widget.setText("0" + Integer.toString(val));
        } else {
            widget.setText(Integer.toString(val));
        }
    }

    public void createComponents() {
        this.label = new JLabel();
        this.label.setText(this.format);
        this.actDate = DateTimePicker.createIconButton(CLOCK_ICON);
        this.actDate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DateTimePicker.this.setCalendar(new GregorianCalendar());
            }
        });
        this.popupBut = new JButton(new ImageIcon(DateTimePicker.class.getResource(POPUP_ICON)));
        this.popupBut.setBorder(BorderFactory.createRaisedBevelBorder());
        this.popupBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DateTimePicker.this.showPopup();
            }
        });
        Dimension dim = this.popupBut.getPreferredSize();
        int min = Math.min(dim.width, dim.height);
        this.popupBut.setPreferredSize(new Dimension(min, min));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", this.label);
        panel.add("East", this.popupBut);
        panel.setBorder(BorderFactory.createBevelBorder(1));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.actDate, gbc);
        ++gbc.gridx;
        gbc.weightx = 100.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        this.add((Component)panel, gbc);
    }

    protected void updateComponents() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.format);
        this.label.setText(dateFormat.format(this.calendar.getTime()));
    }

    protected void showPopup() {
        PopupWindow pw = new PopupWindow();
        pw.setVisible(true);
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = new GregorianCalendar();
        this.calendar.setTime(calendar.getTime());
        this.updateComponents();
    }

    public Calendar getCalendar() {
        GregorianCalendar ret = new GregorianCalendar();
        ret.setTime(this.calendar.getTime());
        return ret;
    }

    public void setFormat(String format) {
        this.format = format;
        this.updateComponents();
    }

    protected static JButton createIconButton(String resource) {
        JButton ret = new JButton(new ImageIcon(DateTimePicker.class.getResource(resource)));
        DateTimePicker.configureButton(ret);
        return ret;
    }

    protected static void configureButton(JButton ret) {
        ret.setBorder(null);
        Dimension dim = ret.getPreferredSize();
        ret.setPreferredSize(new Dimension(dim.width + 2, dim.height + 2));
        ret.addMouseListener(new MouseInputAdapter(){

            public void mouseEntered(MouseEvent ev) {
                ((JButton)ev.getSource()).setBorder(BorderFactory.createRaisedBevelBorder());
            }

            public void mouseExited(MouseEvent ev) {
                ((JButton)ev.getSource()).setBorder(null);
            }
        });
    }

    protected static String getDateFormat() {
        String ret = null;
        String lang = Locale.getDefault().getLanguage();
        ret = lang.compareToIgnoreCase("de") == 0 ? "dd.MM.yyyy HH:mm:ss" : "yyyy.MM.dd HH:mm:ss";
        return ret;
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        JFrame frame = new JFrame();
        DateTimePicker picker = new DateTimePicker();
        frame.getContentPane().add(picker);
        frame.pack();
        frame.setVisible(true);
    }

    protected class PopupWindow
    extends JPopupMenu {
        JLabel month;
        JLabel year;
        JLabel hours;
        JLabel minutes;
        JLabel seconds;
        JButton[] days = new JButton[42];
        Calendar localCalendar = new GregorianCalendar();

        public PopupWindow() {
            this.localCalendar.setTime(DateTimePicker.this.getCalendar().getTime());
            this.localCalendar.set(14, 0);
            this.createComponents();
            this.pack();
            Point p = this.getPopupLocation();
            this.show(DateTimePicker.this, p.x, p.y);
        }

        private Point getPopupLocation() {
            Point p = DateTimePicker.this.popupBut.getLocation();
            Dimension butSize = DateTimePicker.this.popupBut.getSize();
            Dimension size = this.getPreferredSize();
            return new Point(p.x - size.width, p.y + butSize.height);
        }

        protected void createComponents() {
            JButton ok = new JButton(FwkPropertyBus.getProperty("Text.Ok"));
            DateTimePicker.configureButton(ok);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    DateTimePicker.this.setCalendar(PopupWindow.this.localCalendar);
                    PopupWindow.this.setVisible(false);
                }
            });
            JButton cancel = new JButton(FwkPropertyBus.getProperty("Text.Cancel"));
            DateTimePicker.configureButton(cancel);
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    PopupWindow.this.setVisible(false);
                }
            });
            JPanel yearSelector = this.createYearSelector();
            JPanel monthSelector = this.createMonthSelector();
            JPanel daySelector = this.createDaySelector();
            JPanel timeSelector = this.createTimeSelector();
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.add((Component)yearSelector, gbc);
            ++gbc.gridy;
            this.add((Component)monthSelector, gbc);
            ++gbc.gridy;
            this.add((Component)daySelector, gbc);
            ++gbc.gridy;
            this.add((Component)timeSelector, gbc);
            gbc.gridx = 0;
            gbc.gridwidth = 1;
            ++gbc.gridy;
            gbc.insets = new Insets(5, 0, 0, 5);
            this.add((Component)cancel, gbc);
            ++gbc.gridx;
            gbc.insets = new Insets(5, 5, 0, 0);
            this.add((Component)ok, gbc);
            this.setBorderPainted(true);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.setOpaque(false);
            this.setDoubleBuffered(true);
            this.setFocusable(false);
        }

        protected void setMonthLabel() {
            this.month.setText(MONTH_NAME.format(this.localCalendar.getTime()));
        }

        protected JPanel createMonthSelector() {
            JPanel ret = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            JButton next = DateTimePicker.createIconButton(DateTimePicker.NEXT_ICON);
            next.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    int val = PopupWindow.this.localCalendar.get(2);
                    val = val == 11 ? 0 : val + 1;
                    PopupWindow.this.localCalendar.set(2, val);
                    PopupWindow.this.setMonthLabel();
                    PopupWindow.this.setDayButtons();
                }
            });
            JButton prev = DateTimePicker.createIconButton(DateTimePicker.PREV_ICON);
            prev.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    int val = PopupWindow.this.localCalendar.get(2);
                    val = val == 0 ? 11 : val - 1;
                    PopupWindow.this.localCalendar.set(2, val);
                    PopupWindow.this.setMonthLabel();
                    PopupWindow.this.setDayButtons();
                }
            });
            this.month = new JLabel();
            this.month.setHorizontalAlignment(0);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 0;
            gbc.insets = new Insets(0, 0, 0, 0);
            ret.add((Component)prev, gbc);
            gbc.fill = 2;
            ++gbc.gridx;
            gbc.weightx = 100.0;
            gbc.weighty = 100.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            ret.add((Component)this.month, gbc);
            ++gbc.gridx;
            gbc.fill = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            ret.add((Component)next, gbc);
            this.setMonthLabel();
            return ret;
        }

        protected void setYearLabel() {
            this.year.setText(YEAR.format(this.localCalendar.getTime()));
        }

        protected JPanel createYearSelector() {
            JPanel ret = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            JButton next = DateTimePicker.createIconButton(DateTimePicker.NEXT_ICON);
            next.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    int val = PopupWindow.this.localCalendar.get(1);
                    PopupWindow.this.localCalendar.set(1, ++val);
                    PopupWindow.this.setYearLabel();
                    PopupWindow.this.setDayButtons();
                }
            });
            JButton prev = DateTimePicker.createIconButton(DateTimePicker.PREV_ICON);
            prev.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    int val = PopupWindow.this.localCalendar.get(1);
                    PopupWindow.this.localCalendar.set(1, --val);
                    PopupWindow.this.setYearLabel();
                    PopupWindow.this.setDayButtons();
                }
            });
            this.year = new JLabel();
            this.year.setHorizontalAlignment(0);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 0;
            gbc.insets = new Insets(0, 0, 0, 0);
            ret.add((Component)prev, gbc);
            gbc.fill = 2;
            ++gbc.gridx;
            gbc.weightx = 100.0;
            gbc.weighty = 100.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            ret.add((Component)this.year, gbc);
            ++gbc.gridx;
            gbc.fill = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            ret.add((Component)next, gbc);
            this.setYearLabel();
            return ret;
        }

        protected void setDayButtons() {
            int cell;
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(this.localCalendar.getTime());
            int dom = 1;
            c.set(5, dom);
            int fdw = c.getFirstDayOfWeek();
            int col = c.get(7) - fdw;
            if (col < 0) {
                col += 7;
            }
            int row = 0;
            int firstCell = cell = col + row * 7;
            for (int i = 0; i < this.days.length; ++i) {
                this.days[i].setForeground(Color.black);
                this.days[i].setVisible(false);
            }
            do {
                this.days[cell].setText("" + c.get(5));
                this.days[cell].setVisible(true);
                ((Calendar)c).roll(5, 1);
                ++col;
                if ((col %= 7) == 0) {
                    ++row;
                }
                dom = c.get(5);
                cell = col + row * 7;
            } while (dom != 1);
            cell = firstCell + this.localCalendar.get(5) - 1;
            this.days[cell].setForeground(Color.red);
        }

        protected JPanel createDaySelector() {
            JPanel ret = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 0, 0, 0);
            SimpleDateFormat format = new SimpleDateFormat("EEE");
            GregorianCalendar c = new GregorianCalendar();
            c.set(7, this.localCalendar.getFirstDayOfWeek());
            for (int i = 0; i < 7; ++i) {
                JLabel lab = new JLabel(format.format(c.getTime()));
                ((Calendar)c).roll(7, 1);
                lab.setHorizontalAlignment(0);
                ret.add((Component)lab, gbc);
                ++gbc.gridx;
            }
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    int val = Integer.parseInt(((JButton)ev.getSource()).getText());
                    PopupWindow.this.localCalendar.set(5, val);
                    PopupWindow.this.setDayButtons();
                }
            };
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 0, 0, 0);
            int width = 7;
            int height = 6;
            for (int j = 0; j < height; ++j) {
                gbc.gridy += j;
                for (int i = 0; i < width; ++i) {
                    gbc.gridx = i;
                    JButton but = new JButton(i + "/" + j);
                    but.addActionListener(al);
                    but.setHorizontalAlignment(4);
                    DateTimePicker.configureButton(but);
                    ret.add((Component)but, gbc);
                    this.days[j * 7 + i] = but;
                }
            }
            CardLayout cl = new CardLayout();
            JPanel cardPanel = new JPanel(cl);
            JPanel sizeHolder = new JPanel();
            sizeHolder.setBackground(Color.green);
            sizeHolder.setPreferredSize(ret.getPreferredSize());
            cardPanel.add((Component)ret, "visible");
            cardPanel.add((Component)sizeHolder, "sizeHolder");
            cl.show(cardPanel, "visible");
            this.setDayButtons();
            return cardPanel;
        }

        protected void setTimeFields() {
            SimpleDateFormat format = new SimpleDateFormat("HH");
            this.hours.setText(format.format(this.localCalendar.getTime()));
            format = new SimpleDateFormat("mm");
            this.minutes.setText(format.format(this.localCalendar.getTime()));
            format = new SimpleDateFormat("ss");
            this.seconds.setText(format.format(this.localCalendar.getTime()));
        }

        protected JPanel createTimeSelector() {
            JPanel ret = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.hours = new JLabel("HH");
            this.minutes = new JLabel("mm");
            this.seconds = new JLabel("ss");
            JButton nextHour = DateTimePicker.createIconButton(DateTimePicker.NEXT_ICON);
            nextHour.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    int val = Integer.parseInt(PopupWindow.this.hours.getText());
                    val = DateTimePicker.this.increaseValue(val, ((PopupWindow)PopupWindow.this).DateTimePicker.this.hourIncrease, 24);
                    PopupWindow.this.localCalendar.set(11, val);
                    DateTimePicker.this.setTextValue(PopupWindow.this.hours, val);
                }
            });
            JButton prevHour = DateTimePicker.createIconButton(DateTimePicker.PREV_ICON);
            prevHour.setBorder(null);
            prevHour.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    int val = Integer.parseInt(PopupWindow.this.hours.getText());
                    val = DateTimePicker.this.decreaseValue(val, ((PopupWindow)PopupWindow.this).DateTimePicker.this.hourDecrease, 24);
                    PopupWindow.this.localCalendar.set(11, val);
                    DateTimePicker.this.setTextValue(PopupWindow.this.hours, val);
                }
            });
            JButton nextMinute = DateTimePicker.createIconButton(DateTimePicker.NEXT_ICON);
            nextMinute.setBorder(null);
            nextMinute.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    int val = Integer.parseInt(PopupWindow.this.minutes.getText());
                    val = DateTimePicker.this.increaseValue(val, ((PopupWindow)PopupWindow.this).DateTimePicker.this.minuteIncrease, 60);
                    PopupWindow.this.localCalendar.set(12, val);
                    DateTimePicker.this.setTextValue(PopupWindow.this.minutes, val);
                }
            });
            JButton prevMinute = DateTimePicker.createIconButton(DateTimePicker.PREV_ICON);
            prevMinute.setBorder(null);
            prevMinute.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    int val = Integer.parseInt(PopupWindow.this.minutes.getText());
                    val = DateTimePicker.this.decreaseValue(val, ((PopupWindow)PopupWindow.this).DateTimePicker.this.minuteDecrease, 60);
                    PopupWindow.this.localCalendar.set(12, val);
                    DateTimePicker.this.setTextValue(PopupWindow.this.minutes, val);
                }
            });
            JButton nextSecond = DateTimePicker.createIconButton(DateTimePicker.NEXT_ICON);
            nextSecond.setBorder(null);
            nextSecond.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    int val = Integer.parseInt(PopupWindow.this.seconds.getText());
                    val = DateTimePicker.this.increaseValue(val, ((PopupWindow)PopupWindow.this).DateTimePicker.this.secondIncrease, 60);
                    PopupWindow.this.localCalendar.set(13, val);
                    DateTimePicker.this.setTextValue(PopupWindow.this.seconds, val);
                }
            });
            JButton prevSecond = DateTimePicker.createIconButton(DateTimePicker.PREV_ICON);
            prevSecond.setBorder(null);
            prevSecond.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    int val = Integer.parseInt(PopupWindow.this.seconds.getText());
                    val = DateTimePicker.this.decreaseValue(val, ((PopupWindow)PopupWindow.this).DateTimePicker.this.secondDecrease, 60);
                    PopupWindow.this.localCalendar.set(13, val);
                    DateTimePicker.this.setTextValue(PopupWindow.this.seconds, val);
                }
            });
            ret.add((Component)prevHour, gbc);
            ++gbc.gridx;
            ret.add((Component)this.hours, gbc);
            ++gbc.gridx;
            ret.add((Component)nextHour, gbc);
            ++gbc.gridx;
            ret.add((Component)prevMinute, gbc);
            ++gbc.gridx;
            ret.add((Component)this.minutes, gbc);
            ++gbc.gridx;
            ret.add((Component)nextMinute, gbc);
            ++gbc.gridx;
            ret.add((Component)prevSecond, gbc);
            ++gbc.gridx;
            ret.add((Component)this.seconds, gbc);
            ++gbc.gridx;
            ret.add((Component)nextSecond, gbc);
            this.setTimeFields();
            return ret;
        }
    }
}

