/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkException;
import com.highqsoft.interfaces.fwk.FwkAppearanceInterface;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class FwkAppearance
implements FwkAppearanceInterface {
    public static final String version = "$Revision: 1.3 $";
    public static final BasicStroke[] STROKES = new BasicStroke[]{LINE_STROKE, DOT_STROKE, DASH_STROKE, DOT_DASH_STROKE, DOT_DOT_DASH_STROKE, null};
    public static boolean JDK1_3_TRANSPARENCY_BUG = true;
    public static Color DEFAULT_COLOR = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public static Color DEFAULT_BACKGROUNDCOLOR = new Color(0.7529412f, 0.7529412f, 0.7529412f, 1.0f);
    Color color = DEFAULT_COLOR;
    Color background = DEFAULT_BACKGROUNDCOLOR;
    Font font = new Font("Helvetica", 0, 12);
    BasicStroke stroke = new BasicStroke(1.0f);
    Shape fill = null;
    Shape shape = null;
    Shape clip = null;
    AffineTransform affineTransform = null;
    boolean visible = true;

    public String getVersion() {
        return version;
    }

    public FwkAppearance() {
        this.setTransparency(0.0f);
    }

    public FwkAppearance(Color c) {
        this();
        if (c != null) {
            this.color = c;
        }
    }

    public void release() {
    }

    public void setColor(Color c) {
        if (c != null) {
            this.color = c;
        }
    }

    public Color getColor() {
        if (JDK1_3_TRANSPARENCY_BUG) {
            if (this.color.getAlpha() < 128) {
                return new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 0);
            }
            return new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 255);
        }
        return new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
    }

    public void setTransparency(float t) {
        if (this.color != null) {
            float alpha = t > 1.0f ? (255.0f - t % 256.0f) / 255.0f : 1.0f - (t < 0.0f ? 0.0f : t);
            float[] rgb = new float[3];
            rgb = this.color.getRGBColorComponents(rgb);
            this.color = JDK1_3_TRANSPARENCY_BUG ? ((double)alpha > 0.5 ? new Color(rgb[0], rgb[1], rgb[2], 1.0f) : new Color(rgb[0], rgb[1], rgb[2], 0.0f)) : new Color(rgb[0], rgb[1], rgb[2], alpha);
        }
    }

    public float getTransparency() {
        if (JDK1_3_TRANSPARENCY_BUG) {
            if (this.color.getAlpha() > 127) {
                return 0.0f;
            }
            return 1.0f;
        }
        if (this.color != null) {
            return 1.0f - (float)this.color.getAlpha() / 255.0f;
        }
        return 1.0f;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setBackgroundColor(Color color) {
        if (color != null) {
            this.background = color;
        }
    }

    public Color getBackgroundColor() {
        if (JDK1_3_TRANSPARENCY_BUG) {
            if (this.background.getAlpha() < 128) {
                return new Color(this.background.getRed(), this.background.getGreen(), this.background.getBlue(), 0);
            }
            return new Color(this.background.getRed(), this.background.getGreen(), this.background.getBlue(), 255);
        }
        return new Color(this.background.getRed(), this.background.getGreen(), this.background.getBlue(), this.background.getAlpha());
    }

    public void setStroke(Stroke s) {
        try {
            float lw = this.getLineWidth();
            this.stroke = (BasicStroke)s;
            if (s != null) {
                this.setLineWidth(lw);
            }
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: FwkAppearance.java,v $", version, "AH 1999-09-03 21:26", "FwkAppearance.setStoke() takes java.awt.BasicStroke only.", this, null);
        }
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setLineWidth(float w) {
        this.stroke = this.stroke == null ? new BasicStroke(w) : new BasicStroke(w, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
    }

    public float getLineWidth() {
        if (this.stroke != null) {
            return this.stroke.getLineWidth();
        }
        return 0.0f;
    }

    public void setDashArray(float[] arr) {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(1.0f);
        }
        this.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), arr, this.stroke.getDashPhase());
    }

    public float[] getDashArray() {
        if (this.stroke != null) {
            return this.stroke.getDashArray();
        }
        return new float[0];
    }

    public void setDashPhase(float phase) {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(1.0f);
        }
        this.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), phase);
    }

    public float getDashPhase() {
        if (this.stroke != null) {
            return this.stroke.getDashPhase();
        }
        return 1.0f;
    }

    public void setEndCap(int cap) {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(1.0f);
        }
        this.stroke = new BasicStroke(this.stroke.getLineWidth(), cap, this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
    }

    public int getEndCap() {
        if (this.stroke != null) {
            return this.stroke.getEndCap();
        }
        return 0;
    }

    public void setLineJoin(int join) {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(1.0f);
        }
        this.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), join, this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
    }

    public int getLineJoin() {
        if (this.stroke != null) {
            return this.stroke.getLineJoin();
        }
        return 0;
    }

    public void setMiterLimit(float limit) {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(1.0f);
        }
        this.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), this.stroke.getLineJoin(), limit, this.stroke.getDashArray(), this.stroke.getDashPhase());
    }

    public float getMiterLimit() {
        if (this.stroke != null) {
            return this.stroke.getMiterLimit();
        }
        return 1.0f;
    }

    public void setFill(Shape s) {
        this.fill = s;
    }

    public Shape getFill() {
        return this.fill;
    }

    public void setTransform(AffineTransform t) {
        this.affineTransform = t;
    }

    public AffineTransform getTransform() {
        return this.affineTransform;
    }

    public void setTranslation(double x, double y) {
        if (this.affineTransform == null) {
            this.affineTransform = new AffineTransform();
        }
        this.affineTransform.translate(x, y);
    }

    public Point2D getTranslation() {
        if (this.affineTransform != null) {
            return new Point2D.Double(this.affineTransform.getTranslateX(), this.affineTransform.getTranslateX());
        }
        return new Point2D.Double(0.0, 0.0);
    }

    public void setScale(double sx, double sy) {
        if (this.affineTransform == null) {
            this.affineTransform = new AffineTransform();
        }
        this.affineTransform.scale(sx, sy);
    }

    public void setClip(double x, double y, double width, double height) {
        this.clip = new Rectangle2D.Double(x, y, width, height);
    }

    public void setClip(Shape clip) {
        this.clip = clip;
    }

    public Shape getClip() {
        return this.clip;
    }

    public void configure(Graphics2D g) {
        if (this.isVisible()) {
            g.setColor(this.getColor());
            g.setBackground(this.getBackgroundColor());
            if (this.font != null) {
                g.setFont(this.font);
            }
            if (this.stroke != null) {
                g.setStroke(this.stroke);
            }
            if (this.fill != null) {
                g.fill(this.fill);
            }
            if (this.clip != null) {
                g.setClip(this.clip);
            }
            if (this.affineTransform != null) {
                g.transform(this.affineTransform);
            }
        }
    }

    public boolean isVisible() {
        if (this.visible && JDK1_3_TRANSPARENCY_BUG) {
            return this.color.getAlpha() > 127;
        }
        return this.visible;
    }

    public void setVisible(boolean flag) {
        this.visible = flag;
    }

    public boolean getVisible() {
        return this.isVisible();
    }

    public BasicStroke scaleStroke(AffineTransform at, float lw) {
        if (this.getStroke() != null) {
            Point2D.Double pSrc = new Point2D.Double(lw, lw);
            Point2D.Double pDst = new Point2D.Double();
            at.deltaTransform(pSrc, pDst);
            lw = (float)((double)(lw * lw) / Math.min(Math.abs(pDst.x), Math.abs(pDst.y)));
            return new BasicStroke(lw, this.getEndCap(), this.getLineJoin(), this.getMiterLimit(), this.getDashArray(), this.getDashPhase());
        }
        return null;
    }

    public BasicStroke scaleStroke(AffineTransform at) {
        return this.scaleStroke(at, this.getLineWidth());
    }
}

