/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkApplicationBus;
import com.highqsoft.fwk.FwkChangeRegistry;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDOMHandler;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkInfoBusMember;
import com.highqsoft.fwk.FwkPanel;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkXmlInterpreter;
import com.highqsoft.fwk.util.FwkStatusLabel;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDOMHandlerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateEventInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateListenerInterface;
import com.highqsoft.interfaces.fwk.FwkPanelInterface;
import com.highqsoft.interfaces.fwk.FwkPortInterface;
import com.highqsoft.interfaces.fwk.FwkServiceControlManagerInterface;
import com.highqsoft.interfaces.fwk.FwkWindowInterface;
import com.highqsoft.interfaces.fwk.FwkXmlDtdInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class FwkApplication
extends FwkInfoBusMember
implements FwkApplicationInterface {
    public static final String version = "$Revision: 1.3 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    int threadPrio = 5;
    private static int threadCount;
    protected FwkPanelInterface panel = null;
    protected FwkPanelInterface statusPanel = null;
    protected FwkStatusLabel statusLabel = null;
    protected String[] args = null;
    protected transient Thread applicationThread;
    protected boolean eternal = false;
    protected PageFormat pageFormat = null;
    protected FwkPortInterface port = null;
    protected FwkControllerInterface controller = null;
    protected boolean readingDOM = false;
    protected FwkServiceControlManagerInterface serviceControlManager = null;
    protected HashMap executeStateListeners;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return descriptor;
    }

    public FwkApplication() {
        this.setDescriptor(descriptor);
        FwkContainer.addComponentProperties(this.getClass());
        this.executeStateListeners = new HashMap();
    }

    public boolean exit() {
        boolean ret = true;
        if (this.controller != null) {
            ret = this.controller.destroyController();
        }
        if (ret) {
            this.stop();
            this.unregister();
            FwkChangeRegistry.unregister(this);
            if (this.panel != null) {
                ((Component)((Object)this.panel)).setVisible(false);
            }
            if (this.statusPanel != null) {
                ((Component)((Object)this.statusPanel)).setVisible(false);
            }
        }
        return ret;
    }

    public boolean destroyController() {
        boolean ret = true;
        if (this.panel != null) {
            ret = this.panel.destroyController();
        }
        return ret;
    }

    public FwkPortInterface getFwkPort() {
        return this.port;
    }

    public FwkControllerInterface getController() {
        return this.controller;
    }

    public FwkPanelInterface getPanel() {
        if (this.panel == null) {
            this.setPanel(new FwkPanel());
        }
        return this.panel;
    }

    public void setPanel(FwkPanelInterface panel) {
        panel.setController(this);
        this.panel = panel;
    }

    public FwkPanelInterface getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new FwkPanel();
            this.statusPanel.setController(this);
            JPanel sp = (JPanel)((Object)this.statusPanel);
            sp.setLayout(new BorderLayout());
            this.statusLabel = new FwkStatusLabel();
            this.statusLabel.setText(FwkPropertyBus.getProperty("FwkContainer.Text.Ready"));
            this.addExecuteStateListener(this.statusLabel);
            sp.add("Center", this.statusLabel);
        }
        return this.statusPanel;
    }

    public boolean hasFwkPort() {
        return this.port != null;
    }

    public void init() {
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public boolean isRegistered() {
        return FwkContainer.isRegistered(this.getName());
    }

    public void register() throws FwkException {
        FwkArrayInterface arr = this.getFwkMimeTypes();
        this.register(arr.toArray(new String[0]));
    }

    public void register(FwkArrayInterface mimeTypes) throws FwkException {
        FwkContainer.register((FwkApplicationInterface)this, mimeTypes);
    }

    public void register(String[] mimeTypes) throws FwkException {
        FwkContainer.register((FwkApplicationInterface)this, mimeTypes);
    }

    public abstract void run();

    public void setArguments(String[] args) {
        this.args = args;
        this.setPropertyGroup(FwkContainer.getProperties(args));
    }

    public void setController(FwkControllerInterface controller) {
        this.controller = controller;
    }

    public void setEternal(boolean eternalFlag) {
        boolean old = this.eternal;
        this.eternal = eternalFlag;
        this.firePropertyChange("eternal", old, eternalFlag);
    }

    public void setServiceControlManager(FwkServiceControlManagerInterface serviceControlManager) {
        this.serviceControlManager = serviceControlManager;
    }

    public void addExecuteStateListener(FwkExecuteStateListenerInterface l) {
        this.executeStateListeners.put(l, l);
    }

    public void removeExecuteStateListener(FwkExecuteStateListenerInterface l) {
        this.executeStateListeners.remove(l);
    }

    public void fireExecuteStateEvent(FwkExecuteStateEventInterface event) {
        Iterator it = this.executeStateListeners.keySet().iterator();
        while (it.hasNext()) {
            try {
                ((FwkExecuteStateListenerInterface)it.next()).executeStateChanged(event);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        if (this.applicationThread == null) {
            this.applicationThread = new Thread(this);
            this.applicationThread.setPriority(this.threadPrio);
            this.applicationThread.setName("ApplicationThread-" + threadCount++ + "-" + FwkContainer.getBasicName(this.getName()));
            this.applicationThread.start();
        } else {
            Thread thread = this.applicationThread;
            synchronized (thread) {
                this.applicationThread.notify();
            }
        }
        if (this.isEternal()) {
            FwkApplicationBus.fetchEternal(this.getName());
        }
    }

    public void setPriority(int prio) {
        if (this.applicationThread != null) {
            this.applicationThread.setPriority(this.threadPrio);
        }
        this.threadPrio = prio;
    }

    public int getPriority() {
        if (this.applicationThread != null) {
            this.threadPrio = this.applicationThread.getPriority();
        }
        return this.threadPrio;
    }

    public boolean isInterrupted() {
        boolean ret = true;
        if (this.applicationThread != null) {
            ret = this.applicationThread.isInterrupted();
        }
        return ret;
    }

    public synchronized void stop() {
        if (this.serviceControlManager != null) {
            this.serviceControlManager.setState(3);
        }
        if (this.applicationThread != null) {
            try {
                this.applicationThread.interrupt();
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
    }

    public void unregister() {
        FwkContainer.unregister(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int print(Graphics gp, PageFormat pf, int pi) throws PrinterException {
        block9: {
            FwkPanelInterface panel = this.getPanel();
            if (panel != null) {
                try {
                    JComponent jComponent = (JComponent)((Object)panel);
                    Container container = jComponent.getTopLevelAncestor();
                    if (container != null) {
                        Object object = container.getTreeLock();
                        synchronized (object) {
                            if (pi == 0) {
                                Graphics2D g2 = (Graphics2D)gp;
                                double pWidth = pf.getImageableWidth();
                                double pHeight = pf.getImageableHeight();
                                double wWidth = container.getWidth();
                                double wHeight = container.getHeight();
                                double scale = Math.min(pWidth / wWidth, pHeight / wHeight);
                                double xMargin = (pWidth - wWidth * scale) / 2.0;
                                double yMargin = (pHeight - wHeight * scale) / 2.0;
                                g2.translate(xMargin + pf.getImageableX(), yMargin + pf.getImageableY());
                                g2.scale(scale, scale);
                                container.paint(g2);
                                return 0;
                            }
                            break block9;
                        }
                    }
                    System.err.println("FwkApplication.print() No prinable frame.");
                }
                catch (Throwable t) {
                    System.err.println("FwkApplication.print() No prinable panel.");
                }
            } else {
                System.err.println("FwkApplication.print() No panel.");
            }
        }
        return 1;
    }

    public int getNumberOfPages() {
        return 0;
    }

    public PageFormat getPageFormat(int pi) {
        if (this.pageFormat == null) {
            Container container;
            try {
                this.pageFormat = PrinterJob.getPrinterJob().defaultPage();
            }
            catch (Throwable tNoPermissionsForApplets) {
                this.pageFormat = new PageFormat();
            }
            if (this.panel != null && (container = ((JComponent)((Object)this.panel)).getTopLevelAncestor()) != null) {
                Dimension size = container.getSize();
                if (size.width > size.height) {
                    this.pageFormat.setOrientation(0);
                } else {
                    this.pageFormat.setOrientation(1);
                }
            }
        }
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pf, int pi) {
        this.pageFormat = pf;
        if (pf == null) {
            this.getPageFormat(pi);
        }
    }

    public Printable getPrintable(int pi) {
        return this;
    }

    public String getPrintJobName() {
        return this.getCompany() + " printing: " + this.getName();
    }

    public Object readConstructor(Document document, Element node) {
        return FwkDOMHandler.readConstructor(this, document, node);
    }

    public void readFromDOM(Document doc, Element element) {
        this.readingDOM(true);
        FwkDOMHandler.readFromDOM(this, doc, element);
        try {
            FwkPanelInterface panel;
            Node panelNode = doc.getElementsByTagName("Panel").item(0);
            if (this.panel == null) {
                panel = (FwkPanelInterface)FwkDOMHandler.readConstructor(this, doc, (Element)panelNode);
                this.setPanel(panel);
            } else {
                panel = this.getPanel();
            }
            panel.readFromDOM(doc, (Element)panelNode);
        }
        catch (Throwable tPanel) {
            tPanel.printStackTrace();
        }
        try {
            Node frameNode = doc.getElementsByTagName("Frame").item(0);
            FwkWindowInterface frame = FwkContainer.openFrame(this, false);
            FwkDOMHandler.readFromDOM(frame, doc, (Element)frameNode);
            frame.setVisible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.readingDOM(false);
    }

    public Element writeConstructor(Document document, FwkXmlDtdInterface dtd, Node node, Map classProperties) {
        return FwkDOMHandler.writeConstructor(this, "Application", true, document, dtd, node, classProperties, true);
    }

    public Element writeToDOM(Document document, FwkXmlDtdInterface dtd, Node node, Map classProperties) {
        Element thisNode = this.writeConstructor(document, dtd, node, classProperties);
        FwkDOMHandler.writeCommandsToDOM(this.getCommands(), document, dtd, thisNode, null);
        FwkDOMHandler.writePropertiesToDOM(this, document, dtd, thisNode, classProperties);
        FwkDOMHandler.writeFrameToDOM(this, document, dtd, thisNode);
        if (this.panel != null) {
            this.panel.writeToDOM(document, dtd, thisNode, classProperties);
        }
        return thisNode;
    }

    public boolean writeToXML(String filename, boolean validate) {
        return FwkDOMHandler.writeToXML((FwkDOMHandlerInterface)this, filename, FwkXmlInterpreter.class, validate);
    }

    public void readingDOM(boolean flag) {
        if (flag != this.readingDOM) {
            boolean old = this.readingDOM;
            this.readingDOM = flag;
            this.firePropertyChange("readingDOM", old, flag);
        }
    }

    public boolean readingDOM() {
        return this.readingDOM;
    }

    static {
        descriptor.setAuthor("Hans-Joachim Bothe");
        descriptor.setBuild(version);
        descriptor.setDescription("Default implementation of the FWK application functionality");
        descriptor.setTitleName("Fwk Application");
        descriptor.setName(FwkApplication.class.getName());
        descriptor.setCreationDate("$Date: 2005/01/04 08:10:21 $", null);
        threadCount = 0;
    }
}

