/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkApplicationConsumer;
import com.highqsoft.fwk.FwkApplicationProducer;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.interfaces.fwk.FwkApplicationBusInterface;
import com.highqsoft.interfaces.fwk.FwkApplicationConsumerInterface;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkApplicationProducerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class FwkApplicationBus
implements Serializable,
FwkApplicationBusInterface {
    public static final String version = "$Revision: 1.3 $";
    public static final String BUSDEFAULTNAME = "FwkApplicationBus";
    public static final String BUSNAMEKEY = "FwkApplicationBus.Name";
    public static String BUSNAME = FwkContainer.getSystemProperty("fwkApplicationBus", "FwkApplicationBus");
    private static FwkApplicationConsumerInterface cac = new FwkApplicationConsumer();
    private static FwkApplicationProducerInterface cap = new FwkApplicationProducer();

    public String getVersion() {
        return version;
    }

    public static FwkApplicationInterface findApplication(String applicationName) {
        return FwkApplicationBus.findApplication(applicationName, FwkContainer.getDataFlavor(FwkApplicationInterface.class));
    }

    public static FwkApplicationInterface findApplication(String applicationName, DataFlavor[] dataFlavor) {
        return cac.findApplication(applicationName, dataFlavor);
    }

    public static Object findDataItem(String applicationName) {
        return cac.findApplication(applicationName);
    }

    public static FwkApplicationInterface[] findMultipleApplications(String applicationName) {
        return FwkApplicationBus.findMultipleApplications(applicationName, FwkContainer.getDataFlavor(FwkApplicationInterface.class));
    }

    public static FwkApplicationInterface[] findMultipleApplications(String applicationName, DataFlavor[] dataFlavor) {
        return cac.findMultipleApplications(applicationName, dataFlavor);
    }

    public static Object findMultipleDataItems(String applicationName) {
        return cac.findMultipleApplications(applicationName);
    }

    public static boolean isEternal(String applicationName) {
        FwkApplicationInterface appl = FwkApplicationBus.findApplication(applicationName);
        if (appl != null) {
            return appl.isEternal();
        }
        return false;
    }

    public static boolean isRegistered(String applicationName) {
        return FwkApplicationBus.findApplication(applicationName) != null;
    }

    public static boolean isRegistered(FwkApplicationInterface appl) {
        return FwkApplicationBus.findApplication(appl.getName()) != null;
    }

    public static String getUniqueName(String applicationName) {
        return cap.getUniqueName(applicationName);
    }

    public static String register(FwkApplicationInterface application) throws FwkException {
        return cap.register(application);
    }

    public static String register(FwkApplicationInterface application, DataFlavor[] dataFlavor) throws FwkException {
        FwkApplicationInterface appl = FwkApplicationBus.findApplication(application.getName());
        if (appl != null && application != appl && appl.isEternal()) {
            DataFlavor[] df = FwkContainer.getDataFlavor(FwkApplicationInterface.class);
            int i = 0;
            int found = -1;
            int size = dataFlavor.length;
            while (found == -1 && i < size) {
                if (!df[0].equals(dataFlavor[i++])) continue;
                found = i - 1;
            }
            if (found != -1) {
                throw new FwkException(-2147461531, "$RCSfile: FwkApplicationBus.java,v $", version, "AH 1999-11-11 16-14", appl.getName(), null, null);
            }
        }
        return cap.register(application, dataFlavor);
    }

    public static void unregister(FwkApplicationInterface application) {
        cap.unregister(application);
    }

    public static FwkApplicationInterface fetchEternal(String applName) {
        return cap.fetchEternal(applName);
    }

    public static Object loadClass(String name) throws Throwable {
        Object instance = null;
        Class<?> clazz = null;
        if (name != null && name.length() > 0) {
            try {
                clazz = Class.forName(name);
            }
            catch (ClassNotFoundException exception) {
                FwkContainer.debug(5, "FwkApplicationBus.loadClass(): class not found: \"" + name + "\"\n%   " + exception);
            }
        } else {
            FwkContainer.debug(5, "FwkApplicationBus.loadClass(): no class name specified.");
        }
        if (clazz != null) {
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getConstructor(null);
            }
            catch (NoSuchMethodException nsme2) {
                // empty catch block
            }
            if (constructor != null) {
                try {
                    instance = constructor.newInstance(null);
                }
                catch (Throwable t) {
                    FwkContainer.debug(5, "FwkApplicationBus.loadClass(): class instantiation failed:a " + name + "\n" + t);
                    FwkContainer.debug(5, "FwkApplicationBus.loadClass(): class hasn't a default constructor.");
                    throw t;
                }
            }
            try {
                Method getInstance = clazz.getMethod("getInstance", null);
                if (getInstance != null) {
                    instance = getInstance.invoke(instance, null);
                }
            }
            catch (Exception exception) {
                FwkContainer.debug(5, "FwkApplicationBus.loadClass(): class instantiation failed:b " + name + "\n" + exception);
            }
        }
        return instance;
    }

    public static boolean launch(String resources) throws FwkException {
        boolean success = false;
        if (resources != null && resources.length() > 0) {
            StringTokenizer st = new StringTokenizer(resources, ", ");
            String token = null;
            String lower = null;
            while (st.hasMoreTokens()) {
                Object obj;
                block13: {
                    token = st.nextToken();
                    lower = token.toLowerCase();
                    if (lower.endsWith(".bml")) {
                        FwkContainer.debug(5, "BML file ignored (not yet supported): " + token);
                        continue;
                    }
                    if (lower.endsWith(".jacl")) {
                        FwkContainer.debug(5, "Java-TCL file ignored (not yet supported): " + token);
                        continue;
                    }
                    if (lower.endsWith(".jar")) {
                        FwkContainer.debug(5, "Java archive file ignored (not yet supported): " + token);
                        continue;
                    }
                    if (lower.endsWith(".java")) {
                        FwkContainer.debug(5, "JAVA file ignored (not yet supported): " + token);
                        continue;
                    }
                    if (lower.endsWith(".ser")) {
                        FwkContainer.debug(5, "Serialization file ignored (not yet supported): " + token);
                        continue;
                    }
                    if (lower.endsWith(".zip")) {
                        FwkContainer.debug(5, "ZIP file ignored (not yet supported): " + token);
                        continue;
                    }
                    obj = null;
                    try {
                        obj = FwkApplicationBus.loadClass(token);
                    }
                    catch (Throwable t) {
                        FwkDescriptionInterface des = FwkContainer.getClassDescriptor(token);
                        if (des == null) break block13;
                        String applName = FwkContainer.getTranslatedApplicationName(des.getName());
                        obj = FwkApplicationBus.fetchEternal(applName);
                    }
                }
                if (obj == null) continue;
                if (obj instanceof FwkApplicationInterface) {
                    try {
                        ((FwkApplicationInterface)obj).run();
                        success = true;
                    }
                    catch (Throwable t) {
                        FwkContainer.debug(5, "Could not start the application instance of class " + token + ".");
                        t.printStackTrace();
                    }
                    continue;
                }
                FwkContainer.debug(5, "Class " + token + " doesn't implement the FwkApplicationInterface.");
            }
        }
        return success;
    }
}

