/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkApplicationBus;
import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkInfoBusProducer;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkApplicationProducerInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyChangeListenerInterface;
import com.highqsoft.interfaces.fwk.FwkVetoableChangeListenerInterface;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataProducer;
import javax.infobus.InfoBusItemRequestedEvent;

public class FwkApplicationProducer
extends FwkInfoBusProducer
implements FwkApplicationProducerInterface,
FwkPropertyChangeListenerInterface,
FwkVetoableChangeListenerInterface {
    public static final String version = "$Revision: 1.6 $";
    Hashtable applicationRegistry = new Hashtable();
    Hashtable applicationMimeTypes;
    Hashtable eternalRegistry = new Hashtable();
    protected static int counter = 1;

    public String getVersion() {
        return version;
    }

    public FwkApplicationProducer() {
        super("FwkApplicationProducer[" + counter++ + "]@" + FwkApplicationBus.BUSNAME, FwkContainer.getMimeTypes(FwkApplicationInterface.class));
        this.applicationMimeTypes = new Hashtable();
        this.applicationMimeTypes.put(FwkContainer.getMimeType(FwkApplicationInterface.class), this.applicationRegistry);
    }

    public String getUniqueName(String applicationName) {
        int pos;
        if (applicationName == null) {
            applicationName = "";
        }
        if ((pos = applicationName.lastIndexOf("_")) > 0) {
            applicationName = applicationName.substring(0, pos);
        }
        String uniqueName = applicationName;
        if (this.eternalRegistry.containsKey(applicationName)) {
            int i = 2;
            do {
                uniqueName = applicationName + "_" + i;
                ++i;
            } while (this.eternalRegistry.containsKey(uniqueName));
        } else if (this.applicationRegistry.containsKey(applicationName)) {
            int i = 2;
            do {
                uniqueName = applicationName + "_" + i;
                ++i;
            } while (this.applicationRegistry.containsKey(uniqueName));
        }
        return uniqueName;
    }

    public String register(FwkApplicationInterface application) throws FwkException {
        String uniqueName = null;
        if (!this.applicationRegistry.contains(application)) {
            if (!this.eternalRegistry.contains(application)) {
                String applicationName = application.getName();
                FwkApplicationInterface appl = (FwkApplicationInterface)this.applicationRegistry.get(applicationName);
                if (appl == null) {
                    appl = (FwkApplicationInterface)this.eternalRegistry.get(applicationName);
                }
                if (appl != null && appl.isEternal()) {
                    throw new FwkException(-2147461531, "FwkApplicationProducer.java", this.getVersion(), "AH 1999-11-10 17:21", null, this, null);
                }
                uniqueName = this.getUniqueName(applicationName);
                if (uniqueName.compareTo(applicationName) != 0) {
                    application.setName(uniqueName);
                }
                application.addVetoableChangeListener("Name", this);
                application.addPropertyChangeListener("Name", this);
            } else {
                uniqueName = application.getName();
            }
            if ((FwkContainer.getTraceLevel() & 0x80L) != 0L) {
                FwkContainer.sendTrace(application, 128L, "Register <" + uniqueName + "> at " + FwkApplicationBus.BUSNAME, FwkContainer.getLocalHost(), FwkContainer.getUserName());
            }
            this.applicationRegistry.put(uniqueName, application);
            this.eternalRegistry.remove(uniqueName);
            application.setProperty("InfoBusSource", this);
            this.firePatternItemAvailable(uniqueName, FwkContainer.getDataFlavors(FwkContainer.getFwkMimeTypes(application)), this.applicationRegistry);
        } else {
            Enumeration e = this.applicationRegistry.keys();
            while (e.hasMoreElements() && this.applicationRegistry.get(uniqueName = (String)e.nextElement()) != application) {
            }
        }
        if (FwkContainer.getDebugLevel() >= 5) {
            String[] out = new String[2 + this.applicationRegistry.size() + this.eternalRegistry.size()];
            int outIndex = 0;
            out[outIndex++] = "Registered Applications: (new=" + uniqueName + ")";
            out[outIndex++] = "------------------------";
            Enumeration e = this.applicationRegistry.keys();
            while (e.hasMoreElements()) {
                out[outIndex++] = "   " + e.nextElement();
            }
            e = this.eternalRegistry.keys();
            while (e.hasMoreElements()) {
                out[outIndex++] = "   " + e.nextElement() + " (eternal)";
            }
            FwkContainer.debug(5, out);
        }
        return uniqueName;
    }

    public String register(FwkApplicationInterface application, DataFlavor[] dataFlavor) {
        String applicationName = application.getName();
        int i = 0;
        int size = dataFlavor.length;
        DataFlavor[] df = FwkContainer.getDataFlavor(FwkApplicationInterface.class);
        int found = -1;
        if (df != null && df.length != 0 && df[0] != null) {
            while (found < 0 && i < size) {
                if (!dataFlavor[i++].equals(df[0])) continue;
                found = i - 1;
                applicationName = this.register(application);
            }
        }
        InfoBus ib = null;
        if (this.isConnected()) {
            ib = this.getInfoBus();
        }
        int j = 0;
        df = found >= 0 ? new DataFlavor[size - 1] : new DataFlavor[size];
        for (i = 0; i < size; ++i) {
            if (i == found) continue;
            String mimeType = dataFlavor[i].getMimeType();
            Hashtable<String, FwkApplicationInterface> ht = (Hashtable<String, FwkApplicationInterface>)this.applicationMimeTypes.get(mimeType);
            if (ht == null) {
                ht = new Hashtable<String, FwkApplicationInterface>();
                this.applicationMimeTypes.put(mimeType, ht);
                this.addMimeType(mimeType);
            }
            ht.put(applicationName, application);
            df[j++] = dataFlavor[i];
        }
        if (ib != null) {
            ib.fireItemAvailable(applicationName, df, (InfoBusDataProducer)this);
        }
        return applicationName;
    }

    public boolean revoke(String itemName, DataFlavor[] flavor) {
        if (itemName == null) {
            return true;
        }
        if (this.isAssignable(flavor)) {
            if (itemName.indexOf(63) == -1 && itemName.indexOf(42) == -1) {
                FwkApplicationInterface appl = (FwkApplicationInterface)this.applicationRegistry.get(itemName);
                if (appl != null) {
                    FwkCommand cmd = new FwkCommand(appl);
                    if (cmd != null) {
                        cmd.execute(new EventObject(this));
                    } else {
                        appl.exit();
                    }
                }
            } else {
                Object[] arr = this.findMultipleDataItems(itemName, flavor);
                if (arr != null && arr.length != 0) {
                    for (int i = arr.length - 1; i >= 0; --i) {
                        FwkApplicationInterface appl = (FwkApplicationInterface)arr[i];
                        if (appl == null) continue;
                        FwkCommand cmd = new FwkCommand(appl);
                        if (cmd != null) {
                            cmd.execute(new EventObject(this));
                            continue;
                        }
                        appl.exit();
                    }
                }
            }
        }
        return true;
    }

    public void unregister(FwkApplicationInterface application) {
        FwkApplicationInterface[] arr;
        String applicationName = application.getName();
        FwkApplicationInterface appl = (FwkApplicationInterface)this.applicationRegistry.get(applicationName);
        if (appl != null) {
            if (appl.isEternal()) {
                this.eternalRegistry.put(applicationName, appl);
            } else {
                this.eternalRegistry.remove(applicationName);
            }
            if ((FwkContainer.getTraceLevel() & 0x100L) != 0L) {
                FwkContainer.sendTrace(appl, 256L, "Unregister <" + applicationName + "> at " + FwkApplicationBus.BUSNAME, FwkContainer.getLocalHost(), FwkContainer.getUserName());
            }
            this.applicationRegistry.remove(applicationName);
            InfoBus ib = this.getInfoBus();
            if (ib != null) {
                ib.fireItemRevoked(applicationName, (InfoBusDataProducer)this);
            }
            if (!appl.isEternal()) {
                Enumeration e = this.applicationMimeTypes.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    Hashtable registry = (Hashtable)this.applicationMimeTypes.get(key);
                    registry.remove(applicationName);
                }
                application.removePropertyChangeListener(this);
                application.removeVetoableChangeListener(this);
            } else {
                DataFlavor[] applDF = FwkContainer.getDataFlavors(FwkContainer.getFwkMimeTypes(application));
                DataFlavor[] df = FwkContainer.getDataFlavor(FwkApplicationInterface.class);
                int i = 0;
                int size = applDF.length;
                int found = -1;
                if (df != null && df[0] != null) {
                    while (found < 0 && i < size) {
                        if (!applDF[i++].equals(df[0])) continue;
                        found = i - 1;
                    }
                }
                df = found >= 0 ? new DataFlavor[size - 1] : new DataFlavor[size];
                if (ib != null) {
                    int j = 0;
                    for (i = 0; i < size; ++i) {
                        if (i == found) continue;
                        df[j++] = applDF[i];
                    }
                    ib.fireItemAvailable(application.getName(), df, (InfoBusDataProducer)this);
                }
            }
        }
        if (FwkContainer.getDebugLevel() >= 5) {
            String[] out = new String[2 + this.applicationRegistry.size() + this.eternalRegistry.size()];
            int outIndex = 0;
            out[outIndex++] = "Registered Applications: (unregistered=" + applicationName + ")";
            out[outIndex++] = "------------------------";
            Enumeration e = this.applicationRegistry.keys();
            while (e.hasMoreElements()) {
                out[outIndex++] = "   " + e.nextElement();
            }
            e = this.eternalRegistry.keys();
            while (e.hasMoreElements()) {
                out[outIndex++] = "   " + e.nextElement() + " (eternal)";
            }
            FwkContainer.debug(5, out);
        }
        if (this.applicationRegistry.isEmpty() && (arr = FwkApplicationBus.findMultipleApplications("*")) == null) {
            FwkContainer.exit(0);
        }
    }

    public FwkApplicationInterface fetchEternal(String applName) throws FwkException {
        FwkApplicationInterface appl = (FwkApplicationInterface)this.applicationRegistry.get(applName);
        if (appl == null) {
            appl = (FwkApplicationInterface)this.eternalRegistry.get(applName);
            if (appl != null && appl.isEternal()) {
                if ((FwkContainer.getTraceLevel() & 0x80L) != 0L) {
                    FwkContainer.sendTrace(appl, 128L, "Unregister <" + applName + "> at " + FwkApplicationBus.BUSNAME, FwkContainer.getLocalHost(), FwkContainer.getUserName());
                }
                this.applicationRegistry.put(applName, appl);
                this.eternalRegistry.remove(applName);
                this.firePatternItemAvailable(applName, FwkContainer.getDataFlavors(FwkContainer.getFwkMimeTypes(appl)), this.applicationRegistry);
                return appl;
            }
            if (appl == null) {
                throw new FwkException(-2147418113, "$RCSfile: FwkApplicationProducer.java,v $", version, "AH 2000-01-11 10:35", "fetchEternal(): Application \"" + applName + "\" isn't eternally registered", this, null);
            }
            throw new FwkException(-2147418113, "$RCSfile: FwkApplicationProducer.java,v $", version, "AH 2000-01-11 10:36", "fetchEternal(): Application \"" + applName + "\" isn't an eternal object.", this, null);
        }
        return appl;
    }

    protected void firePatternItemAvailable(String pattern, DataFlavor[] flavor, Hashtable registry) {
        block6: {
            boolean patternHasWildcards;
            if (registry == null) break block6;
            InfoBus ib = null;
            if (this.isConnected()) {
                ib = this.getInfoBus();
            }
            boolean bl = patternHasWildcards = pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1;
            if (ib != null) {
                if (patternHasWildcards) {
                    Enumeration e = registry.keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        if (!Pattern.match(key, pattern, false)) continue;
                        ib.fireItemAvailable(key, flavor, (InfoBusDataProducer)this);
                    }
                } else {
                    Enumeration e = registry.keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        if (key.compareTo(pattern) != 0) continue;
                        ib.fireItemAvailable(key, flavor, (InfoBusDataProducer)this);
                    }
                }
            }
        }
    }

    protected void firePatternItemAvailable(String pattern, DataFlavor[] flavor) {
        if (this.isConnected() && pattern != null) {
            int size = flavor.length;
            for (int i = 0; i < size; ++i) {
                String mimeType = flavor[i].getMimeType();
                Hashtable registry = (Hashtable)this.applicationMimeTypes.get(mimeType);
                this.firePatternItemAvailable(pattern, flavor, registry);
            }
        }
    }

    protected void findPatternItem(String pattern, DataFlavor[] flavor, Hashtable registry, Vector vector) {
        if (registry != null) {
            boolean patternHasWildcards;
            InfoBus ib = null;
            if (this.isConnected()) {
                ib = this.getInfoBus();
            }
            boolean bl = patternHasWildcards = pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1;
            if (ib != null) {
                Enumeration e = registry.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    FwkApplicationInterface obj = (FwkApplicationInterface)registry.get(key);
                    if (patternHasWildcards) {
                        if (!Pattern.match(key, pattern, false)) continue;
                        vector.add(obj);
                        continue;
                    }
                    if (key.compareTo(pattern) != 0) continue;
                    vector.add(obj);
                }
            }
        }
    }

    protected void findPatternItem(String pattern, DataFlavor[] flavor, Vector arr) {
        if (this.isConnected() && pattern != null) {
            int size = flavor.length;
            for (int i = 0; i < size; ++i) {
                String mimeType = flavor[i].getMimeType();
                Hashtable registry = (Hashtable)this.applicationMimeTypes.get(mimeType);
                this.findPatternItem(pattern, flavor, registry, arr);
            }
        }
    }

    public void dataItemRequested(InfoBusItemRequestedEvent ev) {
        super.dataItemRequested(ev);
        if (ev.getDataItem() == null) {
            FwkApplicationInterface application = null;
            String dataItemName = ev.getDataItemName();
            if (dataItemName.indexOf(42) != -1 || dataItemName.indexOf(63) != -1) {
                Vector arr = new Vector();
                this.findPatternItem(dataItemName, ev.getDataFlavors(), arr);
                if (arr.size() > 0) {
                    if (arr.size() > 1) {
                        ev.setDataItem((Object)arr.toArray());
                    } else {
                        ev.setDataItem(arr.get(0));
                    }
                }
            } else {
                application = (FwkApplicationInterface)this.applicationRegistry.get(dataItemName);
                if (application == null) {
                    application = (FwkApplicationInterface)this.eternalRegistry.get(dataItemName);
                }
                if (application != null) {
                    ev.setDataItem((Object)application);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().compareTo("Name") != 0) return;
        String oldApplicationName = (String)ev.getOldValue();
        String newApplicationName = (String)ev.getNewValue();
        FwkApplicationInterface application = (FwkApplicationInterface)this.applicationRegistry.get(oldApplicationName);
        if (application == null) {
            application = (FwkApplicationInterface)this.eternalRegistry.get(oldApplicationName);
            if (application == null) return;
            this.eternalRegistry.remove(oldApplicationName);
            this.eternalRegistry.put(newApplicationName, application);
        } else {
            this.applicationRegistry.remove(oldApplicationName);
            this.applicationRegistry.put(newApplicationName, application);
        }
        FwkArray arr = new FwkArray();
        Enumeration e = this.applicationMimeTypes.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Hashtable registry = (Hashtable)this.applicationMimeTypes.get(key);
            if (!registry.contains(oldApplicationName)) continue;
            arr.add(key);
            registry.remove(oldApplicationName);
            registry.put(newApplicationName, application);
        }
        if (arr.size() == 0) return;
        String[] mimeType = new String[arr.size()];
        System.arraycopy(arr.toArray(), 0, mimeType, 0, arr.size());
        InfoBus ib = null;
        if (!this.isConnected()) return;
        ib = this.getInfoBus();
        if (ib == null) return;
        ib.fireItemRevoked(oldApplicationName, (InfoBusDataProducer)this);
        ib.fireItemAvailable(newApplicationName, FwkContainer.getDataFlavors(mimeType), (InfoBusDataProducer)this);
    }

    public void vetoableChange(PropertyChangeEvent ev) throws FwkException {
        String oldApplicationName = (String)ev.getOldValue();
        FwkApplicationInterface oldNameAppl = (FwkApplicationInterface)this.applicationRegistry.get(oldApplicationName);
        if (oldNameAppl == null) {
            oldNameAppl = (FwkApplicationInterface)this.eternalRegistry.get(oldApplicationName);
        }
        if (oldNameAppl != null) {
            String newApplicationName = (String)ev.getNewValue();
            FwkApplicationInterface newNameAppl = (FwkApplicationInterface)this.applicationRegistry.get(newApplicationName);
            if (newNameAppl == null) {
                newNameAppl = (FwkApplicationInterface)this.eternalRegistry.get(newApplicationName);
            }
            if (newNameAppl != null) {
                throw new FwkException(-2147461532, "$RCSfile: FwkApplicationProducer.java,v $", version, "AH 1999-11-15 15:12", oldApplicationName + " -> " + newApplicationName, this, new PropertyVetoException("Veto on changing applicationcation from " + oldApplicationName + " to " + newApplicationName + ".\n" + "An application is already registered under the new name.", ev));
            }
        }
    }
}

