/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkTileSelectButton;
import com.highqsoft.interfaces.fwk.FwkColorSelectableInterface;
import com.highqsoft.interfaces.fwk.FwkTileInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class FwkColorSelectButton
extends FwkTileSelectButton
implements FwkColorSelectableInterface {
    public static final String version = "$Revision: 1.3 $";
    public static final Color[] COLORS = new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(1.0f, 1.0f, 1.0f, 1.0f), new Color(1.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 1.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 1.0f, 1.0f), new Color(1.0f, 1.0f, 0.0f, 1.0f), new Color(1.0f, 0.0f, 1.0f, 1.0f), new Color(0.0f, 1.0f, 1.0f, 1.0f), new Color(0.7529412f, 0.7529412f, 0.7529412f, 1.0f), new Color(0.5f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.5f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.5f, 1.0f), new Color(0.5f, 0.5f, 0.0f, 1.0f), new Color(0.5f, 0.0f, 0.5f, 1.0f), new Color(0.0f, 0.5f, 0.5f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(1.0f, 0.64705884f, 0.0f, 1.0f), new Color(1.0f, 0.078431375f, 0.5764706f, 1.0f), new Color(0.78431374f, 0.49803922f, 0.0f, 1.0f), new Color(0.6901961f, 0.1882353f, 0.3764706f, 1.0f)};
    protected Color[] colors;

    public String getVersion() {
        return version;
    }

    public FwkColorSelectButton() {
        this(COLORS, 1);
    }

    public FwkColorSelectButton(int rowCount) {
        this(COLORS, rowCount);
    }

    public FwkColorSelectButton(Dimension tileSize, int rowCount) {
        this(COLORS, tileSize, rowCount);
    }

    public FwkColorSelectButton(Color[] colors) {
        this(colors, (int)Math.round(Math.sqrt(colors.length)));
    }

    public FwkColorSelectButton(Color[] colors, int rowCount) {
        this(colors, new Dimension(15, 15), rowCount);
    }

    public FwkColorSelectButton(Color[] colors, Dimension tileSize, int rowCount) {
        super(FwkColorSelectButton.createTiles(colors, tileSize), rowCount < 1 ? 1 : rowCount);
        this.colors = colors;
    }

    public Color getSelectedColor() {
        int index = this.getSelectedTileIndex();
        if (index >= 0 && index < this.colors.length) {
            return this.colors[index];
        }
        return null;
    }

    protected static FwkTileInterface[] createTiles(Color[] colors, Dimension tileSize) {
        FwkTileInterface[] tiles = new FwkTileInterface[colors.length];
        int size = colors.length;
        for (int i = 0; i < size; ++i) {
            tiles[i] = new FwkColorTile(colors[i], tileSize);
        }
        return tiles;
    }

    public static class FwkColorTile
    implements FwkTileInterface {
        BufferedImage image;
        Dimension size;
        Color color;

        public FwkColorTile(Color color, Dimension size) {
            this.color = color;
            this.size = size;
            this.image = null;
        }

        public Dimension getTileSize() {
            return new Dimension(this.size);
        }

        public Object getValueAsObject() {
            return this.color;
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = new BufferedImage(this.size.width, this.size.height, 2);
                Graphics2D g = this.image.createGraphics();
                g.setColor(this.color);
                g.fillRect(0, 0, this.size.width, this.size.height);
                g.dispose();
            }
            return this.image;
        }
    }
}

