/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkColumnAccessProducer;
import com.highqsoft.fwk.FwkColumnDataObserverDouble;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataItemConsumer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkInfoBusDataAccess;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkColumnDataObserverInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Locale;
import javax.infobus.ArrayAccess;
import javax.infobus.InfoBusDataProducer;
import javax.infobus.InvalidDataException;

public class FwkColumnAccess
extends FwkInfoBusDataAccess
implements FwkColumnAccessInterface {
    public static final boolean CONSIDER_FLAGS = FwkPropertyBus.getProperty("FwkColumnAccessInterface.ConsiderFlags", false);
    public static final String[] DESCRIPTION_COLUMN_NAME = new String[]{FwkPropertyBus.getProperty("Text.Name") + ": ", FwkPropertyBus.getProperty("Text.Unit") + ": ", FwkPropertyBus.getProperty("Text.Length") + ": ", FwkPropertyBus.getProperty("Text.MeanValue") + ": ", FwkPropertyBus.getProperty("Text.StandardDeviation") + ": ", FwkPropertyBus.getProperty("Text.Variance") + ": "};
    public static final String version = "$Revision: 1.8 $";
    protected String columnName = null;
    boolean isIndependent = false;
    protected boolean rangeIsValid;
    protected double upper;
    protected double lower;
    protected double minPositiveValue = Double.NaN;
    protected double average;
    protected double standardDeviation;
    protected boolean averageIsValid;
    protected boolean standardDeviationIsValid;
    protected String unit;
    protected InfoBusDataProducer producer;
    protected static final FwkIconInterface icon = FwkIconFile.getIcon("AoColumn");
    protected String shortName;
    protected FwkColumnDataObserverInterface observer;
    protected Object range_lock = new Object();

    public String getVersion() {
        return version;
    }

    public void release() {
        if (this.observer != null) {
            this.observer.release();
        }
        this.observer = null;
        this.columnName = null;
        this.unit = null;
        this.shortName = null;
        this.rangeIsValid = false;
        this.averageIsValid = false;
        this.standardDeviationIsValid = false;
        super.release();
    }

    protected FwkColumnAccess() {
        this.shortName = null;
        this.observer = null;
        this.suspendChangeManager = false;
        this.averageIsValid = false;
        this.standardDeviationIsValid = false;
        this.rangeIsValid = false;
        this.setTitleName(this.getClass().getName());
        this.setIconKey("Icon.AoColumn");
    }

    public FwkColumnAccess(String name, String columnName, String unit, short[] flags, double[] values) {
        this(name, columnName, unit, new FwkColumnDataObserverDouble(values, flags));
    }

    public FwkColumnAccess(String name, String columnName, String unit, FwkColumnDataObserverInterface observer) {
        this.setName(name);
        this.columnName = columnName != null && columnName.length() != 0 ? columnName : name;
        this.setTitleName(this.getClass().getName());
        this.suspendChangeManager = false;
        this.unit = unit != null ? unit : "";
        this.rangeIsValid = false;
        this.lower = 0.0;
        this.upper = 0.0;
        this.observer = observer;
    }

    public String getColumnName() {
        if (this.columnName == null || this.columnName.length() == 0) {
            return this.getName();
        }
        return this.columnName;
    }

    public void setColumnName(String newColumnName) {
        String old = this.columnName;
        this.fireVetoableChange("ColumnName", old, newColumnName);
        this.columnName = newColumnName;
        this.firePropertyChange("ColumnName", old, newColumnName);
    }

    public void setName(String newName) {
        super.setName(newName);
        this.shortName = null;
    }

    public String getShortName() {
        if (this.shortName == null) {
            String name = this.getName();
            int index = name.lastIndexOf(93);
            this.shortName = index > 0 ? name.substring(index + 1, name.length()) : name;
        }
        return this.shortName;
    }

    public Object getProperty(String propertyName) {
        if (propertyName.compareTo("DataArray") == 0) {
            return this.getValues();
        }
        if (propertyName.compareTo("Name") == 0) {
            return this.getName();
        }
        return super.getProperty(propertyName);
    }

    public Object getTransferData(DataFlavor flavor) throws IOException, UnsupportedFlavorException {
        if (flavor.equals(this.getTransferDataFlavors()[0])) {
            return this.getValueAsString();
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.getValueAsString();
        }
        if (this.isDataFlavorSupported(flavor)) {
            return this.getValueAsObject();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return FwkContainer.getDataFlavors(this.getClass());
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        int i;
        DataFlavor[] flavor = this.getTransferDataFlavors();
        for (i = flavor.length - 1; i >= 0; --i) {
            if (!flavor[i].equals(dataFlavor)) continue;
            return true;
        }
        flavor = FwkContainer.getDataFlavor(FwkColumnAccess.class);
        for (i = flavor.length - 1; i >= 0; --i) {
            if (!flavor[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public int[] getDimensions() {
        int[] ret = new int[]{this.getCount()};
        return ret;
    }

    public void setValueAt(int index, double value) {
        boolean suspended = this.suspendChangeManager;
        this.suspendChangeManager(true);
        if (!suspended) {
            this.observer.suspendChangeManager(false);
        }
        this.observer.setFlagAt(index, (short)15);
        if (!suspended) {
            this.observer.suspendChangeManager(true);
        }
        double old = this.observer.getValueAt(index);
        this.observer.setValueAt(index, value);
        if (this.rangeIsValid) {
            if (Math.abs(old - this.lower) < 1.0E-5 || Math.abs(old - this.upper) < 1.0E-5) {
                this.rangeIsValid = false;
                this.determineRange();
            } else {
                if (value < this.lower) {
                    this.lower = Math.min(this.lower, value);
                }
                if (value > this.upper) {
                    this.upper = Math.max(this.upper, value);
                }
            }
        }
        this.suspendChangeManager(suspended);
        if (!suspended) {
            this.changeManager.fireItemValueChanged((Object)this, null);
        }
    }

    public void setItemByCoordinates(int[] coord, Object item) throws InvalidDataException, FwkException {
        try {
            if (item instanceof Number[]) {
                this.reshape(coord);
                Number[] arr = (Number[])item;
                for (int i = coord[0]; i <= coord[1]; ++i) {
                    this.observer.setValueAt(i, arr[i].doubleValue());
                    this.observer.setFlagAt(i, (short)15);
                }
            } else if (item instanceof double[]) {
                this.setItemByCoordinates(coord, (double[])item);
            } else if (item instanceof float[]) {
                this.setItemByCoordinates(coord, (float[])item);
            } else if (item instanceof long[]) {
                this.setItemByCoordinates(coord, (long[])item);
            } else if (item instanceof int[]) {
                this.setItemByCoordinates(coord, (int[])item);
            } else if (item instanceof byte[]) {
                this.setItemByCoordinates(coord, (byte[])item);
            } else if (item instanceof char[]) {
                this.setItemByCoordinates(coord, (char[])item);
            }
            this.rangeIsValid = false;
            this.averageIsValid = false;
            this.standardDeviationIsValid = false;
            if (!this.suspendChangeManager) {
                this.changeManager.fireItemValueChanged((Object)this, null);
            }
        }
        catch (Throwable t) {
            throw new FwkException(-2147461534, "$RCSfile: FwkColumnAccess.java,v $", this.getVersion(), "AH 1999-14-04 10:03", "array.length=" + this.observer.getCount() + " index=" + coord[0], this, t);
        }
    }

    protected void setItemByCoordinates(int[] coord, double[] item) throws InvalidDataException, FwkException {
        try {
            this.reshape(coord);
            this.observer.suspendChangeManager(true);
            for (int i = coord[0]; i <= coord[1]; ++i) {
                this.observer.setFlagAt(i, (short)15);
                this.observer.setValueAt(i, item[i - coord[0]]);
            }
            this.observer.suspendChangeManager(false);
            if (!this.suspendChangeManager) {
                this.changeManager.fireItemValueChanged((Object)this, null);
            }
        }
        catch (Throwable t) {
            throw new FwkException(-2147461534, "$RCSfile: FwkColumnAccess.java,v $", this.getVersion(), "AH 1999-14-04 10:03", "array.length=" + this.observer.getCount() + " index=" + coord[0], this, t);
        }
    }

    protected void setItemByCoordinates(int[] coord, float[] item) throws InvalidDataException, FwkException {
        try {
            this.reshape(coord);
            this.observer.suspendChangeManager(true);
            for (int i = coord[0]; i <= coord[1]; ++i) {
                this.observer.setFlagAt(i, (short)15);
                this.observer.setValueAt(i, item[i - coord[0]]);
            }
            this.observer.suspendChangeManager(false);
            if (!this.suspendChangeManager) {
                this.changeManager.fireItemValueChanged((Object)this, null);
            }
        }
        catch (Throwable t) {
            throw new FwkException(-2147461534, "$RCSfile: FwkColumnAccess.java,v $", this.getVersion(), "AH 1999-14-04 10:03", "array.length=" + this.observer.getCount() + " index=" + coord[0], this, t);
        }
    }

    protected void setItemByCoordinates(int[] coord, long[] item) throws InvalidDataException, FwkException {
        try {
            this.reshape(coord);
            this.observer.suspendChangeManager(true);
            for (int i = coord[0]; i <= coord[1]; ++i) {
                this.observer.setFlagAt(i, (short)15);
                this.observer.setValueAt(i, item[i - coord[0]]);
            }
            this.observer.suspendChangeManager(false);
            if (!this.suspendChangeManager) {
                this.changeManager.fireItemValueChanged((Object)this, null);
            }
        }
        catch (Throwable t) {
            throw new FwkException(-2147461534, "$RCSfile: FwkColumnAccess.java,v $", this.getVersion(), "AH 1999-14-04 10:03", "array.length=" + this.observer.getCount() + " index=" + coord[0], this, t);
        }
    }

    protected void setItemByCoordinates(int[] coord, int[] item) throws InvalidDataException, FwkException {
        try {
            this.reshape(coord);
            this.observer.suspendChangeManager(true);
            for (int i = coord[0]; i <= coord[1]; ++i) {
                this.observer.setFlagAt(i, (short)15);
                this.observer.setValueAt(i, item[i - coord[0]]);
            }
            this.observer.suspendChangeManager(false);
            if (!this.suspendChangeManager) {
                this.changeManager.fireItemValueChanged((Object)this, null);
            }
        }
        catch (Throwable t) {
            throw new FwkException(-2147461534, "$RCSfile: FwkColumnAccess.java,v $", this.getVersion(), "AH 1999-14-04 10:03", "array.length=" + this.observer.getCount() + " index=" + coord[0], this, t);
        }
    }

    protected void setItemByCoordinates(int[] coord, char[] item) throws InvalidDataException, FwkException {
        try {
            this.reshape(coord);
            this.observer.suspendChangeManager(true);
            for (int i = coord[0]; i <= coord[1]; ++i) {
                this.observer.setFlagAt(i, (short)15);
                this.observer.setValueAt(i, item[i - coord[0]]);
            }
            this.observer.suspendChangeManager(false);
            if (!this.suspendChangeManager) {
                this.changeManager.fireItemValueChanged((Object)this, null);
            }
        }
        catch (Throwable t) {
            throw new FwkException(-2147461534, "$RCSfile: FwkColumnAccess.java,v $", this.getVersion(), "AH 1999-14-04 10:03", "array.length=" + this.observer.getCount() + " index=" + coord[0], this, t);
        }
    }

    protected void setItemByCoordinates(int[] coord, byte[] item) throws InvalidDataException, FwkException {
        try {
            this.reshape(coord);
            this.observer.suspendChangeManager(true);
            for (int i = coord[0]; i <= coord[1]; ++i) {
                this.observer.setFlagAt(i, (short)15);
                this.observer.setValueAt(i, item[i - coord[0]]);
            }
            this.observer.suspendChangeManager(false);
            if (!this.suspendChangeManager) {
                this.changeManager.fireItemValueChanged((Object)this, null);
            }
        }
        catch (Throwable t) {
            throw new FwkException(-2147461534, "$RCSfile: FwkColumnAccess.java,v $", this.getVersion(), "AH 1999-14-04 10:03", "array.length=" + this.observer.getCount() + " index=" + coord[0], this, t);
        }
    }

    protected void reshape(int[] coord) {
        this.getValues();
        try {
            int start = coord[0];
            int end = coord[1];
            if (end > start && end >= this.observer.getCount()) {
                double[] newData = new double[end + 1];
                short[] newFlags = new short[end + 1];
                for (int i = start; i <= end; ++i) {
                    newData[i] = this.observer.getValueAt(i);
                    newFlags[i] = this.observer.getFlagAt(i);
                }
                this.observer = new FwkColumnDataObserverDouble(newData, newFlags);
                this.rangeIsValid = false;
                this.standardDeviationIsValid = false;
                this.averageIsValid = false;
                if (!this.suspendChangeManager) {
                    this.changeManager.fireItemShapeChanged((Object)this, null);
                }
            }
        }
        catch (Throwable t) {
            throw new FwkException(-2147461534, "$RCSfile: FwkColumnAccess.java,v $", this.getVersion(), "AH 1999-14-04 10:03", "array.length=" + this.observer.getCount() + " index=" + coord[0], this, t);
        }
    }

    public ArrayAccess subdivide(int[] start, int[] end) throws UnsupportedOperationException {
        if (this.getCount() > 0) {
            this.getValues();
            if (start[0] >= 0 && end[0] < this.getCount()) {
                return new FwkSubColumnAccess(start[0], end[0]);
            }
            throw new FwkException(-2147461534, "$RCSfile: FwkColumnAccess.java,v $", this.getVersion(), "AH 1999-12-01 14:54", "array.length=" + this.observer.getCount() + " index=[" + start[0] + ":" + end[0] + "]", this, new ArrayIndexOutOfBoundsException("[" + start[0] + ":" + end[0] + "]"));
        }
        return new FwkSubColumnAccess(0, 0);
    }

    public Object getItemByCoordinates(int[] coord) {
        try {
            this.getValues();
            double[] ret = new double[coord[1] - coord[0] + 1];
            for (int i = coord[0]; i <= coord[1]; ++i) {
                ret[i - coord[0]] = this.observer.getValueAt(i);
            }
            return ret;
        }
        catch (Throwable t) {
            throw new FwkException(-2147461534, "$RCSfile: FwkColumnAccess.java,v $", this.getVersion(), "AH 1999-12-01 14:54", "", this, t);
        }
    }

    public long getIndex(double value) {
        long[] tmp;
        if (value < this.getMinimum()) {
            value = this.getMinimum();
        }
        long ret = (tmp = this.getIndexRange(this.getMinimum(), value)).length > 0 ? -1L : tmp[1];
        return ret;
    }

    public long[] getIndexRange(double lower, double upper) {
        long[] ret;
        if (this.getCount() > 0) {
            if (lower > upper) {
                double tmp = lower;
                lower = upper;
                upper = tmp;
            }
            if (lower < this.getMinimum()) {
                lower = this.getMinimum();
            }
            if (upper < this.getMinimum()) {
                upper = this.getMinimum();
            }
            if (lower > this.getMaximum()) {
                lower = this.getMaximum();
            }
            if (upper > this.getMaximum()) {
                upper = this.getMaximum();
            }
            boolean lFound = false;
            boolean uFound = false;
            ret = new long[2];
            int size = this.getCount() - 1;
            for (int i = 0; !(i >= size || lFound && uFound); ++i) {
                double val1 = this.observer.getValueAt(i);
                double val2 = this.observer.getValueAt(i + 1);
                if (!lFound && val1 <= lower && val2 >= lower) {
                    ret[0] = lower - val1 > val2 - lower ? (long)(i + 1) : (long)i;
                    lFound = true;
                }
                if (uFound || !(val1 <= upper) || !(val2 >= upper)) continue;
                ret[1] = upper - val1 > val2 - upper ? (long)(i + 1) : (long)i;
                uFound = true;
            }
        } else {
            ret = new long[]{};
        }
        return ret;
    }

    public Object getValueAsObject() {
        return this;
    }

    public void setValue(Object col) throws InvalidDataException, FwkException {
        if (col instanceof Number[]) {
            Number[] arr = (Number[])col;
            double[] columnData = new double[arr.length];
            short[] columnFlags = new short[arr.length];
            int size = arr.length;
            for (int i = 0; i < size; ++i) {
                columnData[i] = arr[i].doubleValue();
                columnFlags[i] = 15;
            }
            this.observer = new FwkColumnDataObserverDouble(columnData, columnFlags);
            this.rangeIsValid = false;
            this.standardDeviationIsValid = false;
            this.averageIsValid = false;
            if (!this.suspendChangeManager) {
                this.changeManager.fireItemValueChanged((Object)this, null);
            }
        } else {
            throw new InvalidDataException("Value must be of type java.lang.Number[].");
        }
    }

    public String toString() {
        try {
            return DESCRIPTION_COLUMN_NAME[0] + "\t" + this.getColumnName() + "\n" + DESCRIPTION_COLUMN_NAME[1] + "\t" + this.getUnitString() + "\n" + DESCRIPTION_COLUMN_NAME[2] + "\t" + this.getCount() + "\n" + DESCRIPTION_COLUMN_NAME[3] + "\t" + (double)Math.round(this.getAverage() * 10000.0) / 10000.0 + "\n" + DESCRIPTION_COLUMN_NAME[4] + "\t" + (double)Math.round(this.getStandardDeviation() * 10000.0) / 10000.0 + "\n" + DESCRIPTION_COLUMN_NAME[5] + "\t" + (double)Math.round(this.getStandardDeviation() * this.getStandardDeviation() * 10000.0) / 10000.0;
        }
        catch (Throwable t) {
            return this.getName();
        }
    }

    public String getValueAsString() {
        this.getValues();
        StringBuffer buffer = new StringBuffer();
        int size = this.observer.getCount();
        for (int i = 0; i < size - 1; ++i) {
            buffer.append("" + this.observer.getValueAt(i)).append("\t");
        }
        if (size > 0) {
            buffer.append("" + this.observer.getValueAt(size - 1));
        }
        return buffer.toString();
    }

    public int getCount() {
        return this.observer == null ? 0 : this.observer.getCount();
    }

    public double[] getValues() throws FwkException {
        int size = this.observer.getCount();
        double[] ret = new double[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.observer.getValueAt(i);
        }
        return ret;
    }

    public double getValueAt(int index) throws FwkException {
        double ret;
        try {
            ret = this.observer.getValueAt(index);
        }
        catch (Throwable t) {
            throw new FwkException(-2147461534, "$RCSfile: FwkColumnAccess.java,v $", this.getVersion(), "AH 1999-14-04 10:03", "array.length=" + this.observer.getCount() + " index=" + index, this, t);
        }
        return ret;
    }

    public short[] getFlags() {
        int size = this.observer.getCount();
        short[] ret = new short[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.observer.getFlagAt(i);
        }
        return ret;
    }

    public void setFlagAt(int index, short flag) {
        short old = this.getFlagAt(index);
        this.observer.setFlagAt(index, flag);
        if (old != flag && !this.suspendChangeManager) {
            this.changeManager.fireItemValueChanged((Object)this, null);
        }
    }

    public void setFlags(short[] flags) {
        if (flags != null) {
            boolean setting = this.suspendChangeManager;
            this.suspendChangeManager = true;
            int size = flags.length;
            for (int i = 0; i < size; ++i) {
                this.setFlagAt(i, flags[i]);
            }
            this.suspendChangeManager = setting;
            if (!this.suspendChangeManager) {
                this.changeManager.fireItemValueChanged((Object)this, null);
            }
        }
    }

    public short getFlagAt(int index) throws FwkException {
        int ret = 0;
        try {
            ret = this.observer.getFlagAt(index);
        }
        catch (Throwable t) {
            new FwkException(1073743324, "$RCSfile: FwkColumnAccess.java,v $", this.getVersion(), "AH 1999-14-04 10:04", "array.length=" + this.observer.getCount() + " index=" + index, this, t);
            ret = 15;
        }
        return (short)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void determineRange() {
        Object object = this.range_lock;
        synchronized (object) {
            if (!(this.rangeIsValid && this.standardDeviationIsValid && this.averageIsValid)) {
                this.averageIsValid = false;
                this.standardDeviationIsValid = false;
                this.lower = 0.0;
                this.upper = 0.0;
                this.standardDeviation = 0.0;
                this.average = 0.0;
                if (this.observer != null && this.observer.getCount() > 0) {
                    this.lower = Double.POSITIVE_INFINITY;
                    this.minPositiveValue = Double.POSITIVE_INFINITY;
                    this.upper = Double.NEGATIVE_INFINITY;
                    int averageLen = 0;
                    if (this.observer.getCount() > 1) {
                        for (int i = this.observer.getCount() - 1; i >= 0; --i) {
                            short flag = this.observer.getFlagAt(i);
                            double val = this.observer.getValueAt(i);
                            if (flag != 15) continue;
                            this.lower = Math.min(val, this.lower);
                            if (val > 0.0) {
                                this.minPositiveValue = Math.min(val, this.minPositiveValue);
                            }
                            this.upper = Math.max(val, this.upper);
                            this.average += val;
                            ++averageLen;
                        }
                    }
                    if (this.minPositiveValue == Double.POSITIVE_INFINITY) {
                        this.minPositiveValue = Double.NaN;
                    }
                    if (Double.isInfinite(this.lower)) {
                        this.lower = this.lower == Double.NEGATIVE_INFINITY ? -3.4028234663852886E38 : 3.4028234663852886E38;
                    }
                    if (Double.isInfinite(this.upper)) {
                        this.upper = this.upper == Double.NEGATIVE_INFINITY ? -3.4028234663852886E38 : 3.4028234663852886E38;
                    }
                    if (averageLen > 0) {
                        this.average /= (double)averageLen;
                        averageLen = 0;
                        for (int i = this.observer.getCount() - 1; i >= 0; --i) {
                            if (this.observer.getFlagAt(i) != 15) continue;
                            double val = this.observer.getValueAt(i);
                            this.standardDeviation += (this.average - val) * (this.average - val);
                            ++averageLen;
                        }
                        this.standardDeviation = Math.sqrt(this.standardDeviation) / (double)averageLen;
                        this.averageIsValid = true;
                        this.standardDeviationIsValid = true;
                    } else {
                        this.averageIsValid = false;
                        this.standardDeviationIsValid = false;
                    }
                    this.rangeIsValid = true;
                } else {
                    this.lower = Double.NaN;
                    this.upper = Double.NaN;
                    this.standardDeviation = Double.NaN;
                    this.average = Double.NaN;
                    this.averageIsValid = false;
                    this.standardDeviationIsValid = false;
                }
            }
        }
    }

    public double getMinimum() {
        if (!this.rangeIsValid) {
            this.determineRange();
        }
        return this.lower;
    }

    public double getMinPositiveValue() {
        if (!this.rangeIsValid) {
            this.determineRange();
        }
        return this.minPositiveValue;
    }

    public double getMaximum() {
        if (!this.rangeIsValid) {
            this.determineRange();
        }
        return this.upper;
    }

    public String getUnitString() {
        return this.unit;
    }

    public String[] dependsOn() {
        return new String[0];
    }

    public FwkColumnAccessInterface[] independentColumns() {
        String[] names = this.dependsOn();
        FwkColumnAccessInterface[] ret = null;
        if (names != null && names.length != 0) {
            int size = names.length;
            DataFlavor[] df = FwkContainer.getDataFlavor(FwkColumnAccessInterface.class);
            ret = new FwkColumnAccessInterface[size];
            for (int i = 0; i < size; ++i) {
                ret[i] = (FwkColumnAccessInterface)FwkDataItemConsumer.getInstance().findDataItem(names[i], df);
            }
        }
        return ret;
    }

    public boolean isIndependent() {
        return this.isIndependent;
    }

    public void setIndependent(boolean flag) {
        if (flag != this.isIndependent) {
            boolean old = this.isIndependent;
            this.isIndependent = flag;
            this.firePropertyChange("Independent", old, flag);
        }
    }

    public boolean isImplicit() {
        return this.observer != null && this.observer.isImplicit();
    }

    public Class getNativeDatatype() {
        if (this.observer != null) {
            return this.observer.getNativeDatatype();
        }
        return null;
    }

    public Object getNativeValues(int lower, int upper) {
        if (this.observer != null) {
            return this.observer.getNativeValues(lower, upper);
        }
        return new Object[0];
    }

    public Object getNativeValues() {
        if (this.observer != null) {
            return this.observer.getNativeValues();
        }
        return new Object[0];
    }

    public double getAverage() {
        if (!this.averageIsValid) {
            this.determineRange();
        }
        return this.average;
    }

    public double getStandardDeviation() {
        if (!this.standardDeviationIsValid) {
            this.determineRange();
        }
        return this.standardDeviation;
    }

    public short getAverageFlag() {
        if (!this.rangeIsValid) {
            this.determineRange();
        }
        return this.averageIsValid ? (short)15 : 0;
    }

    public short getStandardDeviationFlag() {
        if (!this.rangeIsValid) {
            this.determineRange();
        }
        return this.standardDeviationIsValid ? (short)15 : 0;
    }

    public String getPresentationString(Locale locale) {
        int size = this.observer.getCount();
        StringBuffer buffer = new StringBuffer();
        buffer.append("Name: " + this.getName() + "\n");
        buffer.append("Unit: " + this.getUnitString());
        for (int i = 0; i < size; ++i) {
            buffer.append("\n[" + i + "]\t" + this.observer.getValueAt(i) + "\t" + this.observer.getFlagAt(i));
        }
        buffer.append("\n");
        if (locale.getLanguage() == Locale.GERMAN.getLanguage()) {
            return buffer.toString().replace('.', ',');
        }
        return buffer.toString();
    }

    public FwkCommandInterface[] getCommands(FwkControllerInterface controller) {
        block4: {
            if (!this.commandsAvailable()) {
                if (controller == null) {
                    controller = this;
                }
                super.getCommands(controller);
                try {
                    Class<?> clazz = Class.forName(FwkPropertyBus.getProperty("FwkColumnAccess.Class.DisplayCommand", "com.highqsoft.columndisplay.FwkColumnDisplayCommand"));
                    FwkCommandInterface cmd = (FwkCommandInterface)clazz.newInstance();
                    cmd.setController(controller);
                    this.addCommand(cmd);
                }
                catch (Throwable t) {
                    if (FwkContainer.getDebugLevel() <= 0) break block4;
                    t.printStackTrace();
                }
            }
        }
        return super.getCommands(controller);
    }

    public static FwkColumnAccessInterface createEmptyColumn(String name) {
        return new FwkColumnAccess(name, name, "1", new short[]{15, 15}, new double[]{0.0, 1.0});
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        FwkColumnAccessProducer.add(new FwkColumnAccess("BusName", "Test", "kg", null, new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0}));
    }

    public class FwkSubColumnAccess
    extends FwkInfoBusDataAccess
    implements FwkColumnAccessInterface {
        protected double upper;
        protected double lower;
        protected double minPositiveValue;
        int lowerLimit;
        int upperLimit;
        protected boolean rangeIsValid;
        public static final String version = "$Revision: 1.8 $";
        protected double average;
        protected String shortName = null;
        protected double standardDeviation;
        protected boolean averageIsValid;
        protected boolean standardDeviationIsValid;
        protected Object range_lock = new Object();

        public String getVersion() {
            return "$Revision: 1.8 $";
        }

        public FwkSubColumnAccess(int lowerLimit, int upperLimit) {
            if (lowerLimit < upperLimit) {
                this.lowerLimit = lowerLimit;
                this.upperLimit = upperLimit;
            } else {
                this.upperLimit = lowerLimit;
                this.lowerLimit = upperLimit;
            }
            this.rangeIsValid = false;
            this.averageIsValid = false;
            this.standardDeviationIsValid = false;
            super.setName(FwkColumnAccess.this.getName() + "[" + lowerLimit + ":" + upperLimit + "]");
        }

        public void setName(String newName) {
            super.setName(newName);
            this.shortName = null;
        }

        public String getShortName() {
            return this.getColumnName();
        }

        public FwkIconInterface getIcon() {
            return FwkColumnAccess.this.getIcon();
        }

        public String getColumnName() {
            return FwkColumnAccess.this.getColumnName() + "[" + this.lowerLimit + ":" + this.upperLimit + "]";
        }

        public void setColumnName(String newColumnName) {
            FwkColumnAccess.this.setColumnName(newColumnName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void determineRange() {
            Object object = this.range_lock;
            synchronized (object) {
                if (!this.rangeIsValid) {
                    this.getValues();
                    this.getFlags();
                    this.averageIsValid = false;
                    this.standardDeviationIsValid = false;
                    this.standardDeviation = 0.0;
                    this.average = 0.0;
                    this.minPositiveValue = Double.POSITIVE_INFINITY;
                    this.lower = Double.POSITIVE_INFINITY;
                    this.upper = Double.NEGATIVE_INFINITY;
                    int averageLen = 0;
                    if (FwkColumnAccess.this.observer.getCount() > 1) {
                        double val;
                        int i;
                        for (i = this.upperLimit; i >= this.lowerLimit; --i) {
                            if (FwkColumnAccess.this.observer.getFlagAt(i) != 15) continue;
                            val = FwkColumnAccess.this.observer.getValueAt(i);
                            this.lower = Math.min(val, this.lower);
                            if (val > 0.0) {
                                this.minPositiveValue = Math.min(val, this.minPositiveValue);
                            }
                            this.upper = Math.max(val, this.upper);
                            this.average += val;
                            ++averageLen;
                        }
                        if (this.minPositiveValue == Double.POSITIVE_INFINITY) {
                            this.minPositiveValue = Double.NaN;
                        }
                        if (averageLen > 0) {
                            this.average /= (double)averageLen;
                            averageLen = 0;
                            for (i = this.upperLimit; i >= this.lowerLimit; --i) {
                                if (FwkColumnAccess.this.observer.getFlagAt(i) != 15) continue;
                                val = FwkColumnAccess.this.observer.getValueAt(i);
                                this.standardDeviation += (this.average - val) * (this.average - val);
                                ++averageLen;
                            }
                            this.standardDeviation = Math.sqrt(this.standardDeviation) / (double)averageLen;
                            this.averageIsValid = true;
                            this.standardDeviationIsValid = true;
                        } else {
                            this.averageIsValid = false;
                            this.standardDeviationIsValid = false;
                        }
                        this.rangeIsValid = true;
                    }
                }
            }
        }

        public double getMinimum() {
            if (!this.rangeIsValid) {
                this.determineRange();
            }
            return this.lower;
        }

        public double getMinPositiveValue() {
            if (!this.rangeIsValid) {
                this.determineRange();
            }
            return this.minPositiveValue;
        }

        public double getMaximum() {
            if (!this.rangeIsValid) {
                this.determineRange();
            }
            return this.upper;
        }

        public double getValueAt(int index) throws FwkException {
            return FwkColumnAccess.this.getValueAt(index + this.lowerLimit);
        }

        public void setValueAt(int index, double value) {
            FwkColumnAccess.this.setValueAt(index + this.lowerLimit, value);
        }

        public short[] getFlags() {
            int size = this.getCount();
            short[] columnFlags = new short[size];
            for (int i = 0; i < size; ++i) {
                columnFlags[i] = this.getFlagAt(i);
            }
            return columnFlags;
        }

        public void setFlagAt(int index, short flag) {
            short old = this.getFlagAt(index);
            FwkColumnAccess.this.setFlagAt(index + this.lowerLimit, flag);
            if (old != flag && !this.suspendChangeManager) {
                this.changeManager.fireItemValueChanged((Object)this, null);
            }
        }

        public void setFlags(short[] flags) {
            boolean setting = this.suspendChangeManager;
            this.suspendChangeManager = true;
            int size = flags.length;
            for (int i = 0; i < size; ++i) {
                this.setFlagAt(i, flags[i]);
            }
            this.suspendChangeManager = setting;
            if (!this.suspendChangeManager) {
                this.changeManager.fireItemValueChanged((Object)this, null);
            }
        }

        public short getFlagAt(int index) throws FwkException {
            return FwkColumnAccess.this.getFlagAt(index + this.lowerLimit);
        }

        public String getUnitString() {
            return FwkColumnAccess.this.getUnitString();
        }

        public int getCount() {
            return this.upperLimit - this.lowerLimit;
        }

        public double[] getValues() throws FwkException {
            int size = this.getCount();
            double[] columnData = new double[size];
            for (int i = 0; i < size; ++i) {
                columnData[i] = this.getValueAt(i);
            }
            return columnData;
        }

        public int[] getDimensions() {
            int[] ret = new int[]{this.upperLimit - this.lowerLimit + 1};
            return ret;
        }

        public void setItemByCoordinates(int[] coord, Object item) throws InvalidDataException, FwkException {
            int[] c = new int[]{coord[0] + this.lowerLimit, coord[1] + this.lowerLimit};
            FwkColumnAccess.this.setItemByCoordinates(c, item);
            this.rangeIsValid = false;
            this.averageIsValid = false;
            this.standardDeviationIsValid = false;
            if (!this.suspendChangeManager) {
                this.changeManager.fireItemValueChanged((Object)this, null);
            }
        }

        public ArrayAccess subdivide(int[] start, int[] end) throws UnsupportedOperationException {
            int[] s = new int[1];
            int[] e = new int[1];
            s[0] = start[0] + this.lowerLimit;
            e[0] = end[0] + this.lowerLimit;
            if (s[0] <= this.upperLimit && e[0] <= this.upperLimit) {
                return FwkColumnAccess.this.subdivide(s, e);
            }
            throw new FwkException(-2147461534, "$RCSfile: FwkColumnAccess.java,v $", this.getVersion(), "AH 1999-12-01 14:43", "array.length=" + (this.upperLimit - this.lowerLimit + 1) + " index=[" + start[0] + "," + end[0] + "]", this, new ArrayIndexOutOfBoundsException("[" + start[0] + "," + end[0] + "]"));
        }

        public Object getItemByCoordinates(int[] coord) {
            int[] c = new int[]{coord[0] + this.lowerLimit};
            if (c[0] <= this.upperLimit) {
                return FwkColumnAccess.this.getItemByCoordinates(c);
            }
            throw new FwkException(-2147461534, "$RCSfile: FwkColumnAccess.java,v $", this.getVersion(), "AH 1999-12-01 14:47", "array.length=" + (this.upperLimit - this.lowerLimit + 1) + " index=" + coord[0], this, new ArrayIndexOutOfBoundsException(coord[0]));
        }

        public long getIndex(double value) {
            long[] tmp;
            if (value < this.getMinimum()) {
                value = this.getMinimum();
            }
            long ret = (tmp = this.getIndexRange(this.getMinimum(), value)).length > 0 ? -1L : tmp[1];
            return ret;
        }

        public long[] getIndexRange(double lower, double upper) {
            long[] ret;
            if (this.getCount() > 0) {
                if (lower > upper) {
                    double tmp = lower;
                    lower = upper;
                    upper = tmp;
                }
                if (lower < this.getMinimum()) {
                    lower = this.getMinimum();
                }
                if (upper < this.getMinimum()) {
                    upper = this.getMinimum();
                }
                if (lower > this.getMaximum()) {
                    lower = this.getMaximum();
                }
                if (upper > this.getMaximum()) {
                    upper = this.getMaximum();
                }
                boolean lFound = false;
                boolean uFound = false;
                ret = new long[2];
                double[] columnData = this.getValues();
                int size = this.getCount() - 1;
                for (int i = 0; !(i >= size || lFound && uFound); ++i) {
                    if (!lFound && columnData[i] <= lower && columnData[i + 1] >= lower) {
                        ret[0] = lower - columnData[i] > columnData[i + 1] - lower ? (long)(i + 1) : (long)i;
                        lFound = true;
                    }
                    if (uFound || !(columnData[i] <= upper) || !(columnData[i + 1] >= upper)) continue;
                    ret[1] = upper - columnData[i] > columnData[i + 1] - upper ? (long)(i + 1) : (long)i;
                    uFound = true;
                }
            } else {
                ret = new long[]{};
            }
            return ret;
        }

        public Object getValueAsObject() {
            return this;
        }

        public void setValue(Object col) throws InvalidDataException {
            int[] coord = new int[]{this.lowerLimit, this.upperLimit};
            FwkColumnAccess.this.setItemByCoordinates(coord, col);
            if (!this.suspendChangeManager) {
                this.changeManager.fireItemValueChanged((Object)this, null);
            }
        }

        public String getPresentationString(Locale l) {
            int size = this.getCount();
            StringBuffer buffer = new StringBuffer();
            buffer.append("Name: " + this.getName() + "\n");
            buffer.append("Unit: " + this.getUnitString());
            for (int i = 0; i < size; ++i) {
                buffer.append("\n" + this.getValueAt(i));
            }
            buffer.append("\n");
            if (l.getLanguage() == Locale.GERMAN.getLanguage()) {
                return buffer.toString().replace('.', ',');
            }
            return buffer.toString();
        }

        public String toString() {
            return this.getPresentationString(FwkContainer.getLocale());
        }

        public String getValueAsString() {
            double[] val = this.getValues();
            StringBuffer buffer = new StringBuffer();
            for (int i = this.lowerLimit; i <= this.upperLimit - 1; ++i) {
                buffer.append("" + val[i]).append("\t");
            }
            if (this.upperLimit - this.lowerLimit + 1 > 0) {
                buffer.append("" + val[this.upperLimit]);
            }
            return buffer.toString();
        }

        public String[] dependsOn() {
            return FwkColumnAccess.this.dependsOn();
        }

        public FwkColumnAccessInterface[] independentColumns() {
            String[] names = this.dependsOn();
            int[] start = new int[]{this.lowerLimit};
            int[] end = new int[]{this.upperLimit};
            FwkColumnAccessInterface[] ret = null;
            if (names != null && names.length != 0) {
                int size = names.length;
                DataFlavor[] df = FwkContainer.getDataFlavor(class$com$highqsoft$interfaces$fwk$FwkColumnAccessInterface == null ? (class$com$highqsoft$interfaces$fwk$FwkColumnAccessInterface = FwkColumnAccess.class$("com.highqsoft.interfaces.fwk.FwkColumnAccessInterface")) : class$com$highqsoft$interfaces$fwk$FwkColumnAccessInterface);
                ret = new FwkColumnAccessInterface[size];
                for (int i = 0; i < size; ++i) {
                    try {
                        ret[i] = (FwkColumnAccessInterface)FwkDataItemConsumer.getInstance().findDataItem(names[i], df);
                        if (ret[i] == null) continue;
                        ret[i] = (FwkColumnAccessInterface)ret[i].subdivide(start, end);
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
            return ret;
        }

        public boolean isIndependent() {
            return FwkColumnAccess.this.isIndependent();
        }

        public boolean isImplicit() {
            return false;
        }

        public Class getNativeDatatype() {
            return FwkColumnAccess.this.getNativeDatatype();
        }

        public Object getNativeValues() {
            return FwkColumnAccess.this.getNativeValues(this.lowerLimit, this.upperLimit);
        }

        public Object getNativeValues(int lower, int upper) {
            return FwkColumnAccess.this.getNativeValues(this.lowerLimit + lower, this.lowerLimit + upper);
        }

        public double getAverage() {
            if (!this.rangeIsValid) {
                this.determineRange();
            }
            return this.average;
        }

        public double getStandardDeviation() {
            if (!this.rangeIsValid) {
                this.determineRange();
            }
            return this.standardDeviation;
        }

        public short getAverageFlag() {
            if (!this.rangeIsValid) {
                this.determineRange();
            }
            return this.averageIsValid ? (short)15 : 0;
        }

        public short getStandardDeviationFlag() {
            if (!this.rangeIsValid) {
                this.determineRange();
            }
            return this.standardDeviationIsValid ? (short)15 : 0;
        }

        public Object getTransferData(DataFlavor flavor) throws IOException, UnsupportedFlavorException {
            if (flavor.equals(this.getTransferDataFlavors()[0])) {
                return this.getValueAsString();
            }
            if (this.isDataFlavorSupported(flavor)) {
                return this.getValueAsObject();
            }
            throw new UnsupportedFlavorException(flavor);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return FwkColumnAccess.this.getTransferDataFlavors();
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return FwkColumnAccess.this.isDataFlavorSupported(dataFlavor);
        }
    }
}

