/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkAliasBus;
import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkColumnAccess;
import com.highqsoft.fwk.FwkColumnDataObserverDouble;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataBus;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkImplicitColumnDataObserver;
import com.highqsoft.fwk.FwkInfoBusProducer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkStringTransfer;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkInfoBusDropProducerInterface;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.StringTokenizer;
import javax.infobus.DataItem;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusItemRequestedEvent;

public class FwkColumnAccessProducer
extends FwkInfoBusProducer
implements FwkInfoBusDropProducerInterface {
    public static final String version = "$Revision: 1.5 $";
    protected final String[] testDataItemNames = new String[]{"SIN(X)/EXP(X/10)", "NOISE+SIN(X)/EXP(X/10)", "EXP", "Time", "COS"};
    protected final DataFlavor[] supportedFlavors = new DataFlavor[]{DataFlavor.stringFlavor, FwkStringTransfer.PLAIN_TEXT_FLAVOR};
    protected HashMap dataItems = new HashMap();
    static FwkColumnAccessProducer instance = null;
    static final int testDataItemLength = FwkPropertyBus.getProperty("TestDataProducer.Length", 600000);

    public String getVersion() {
        return version;
    }

    protected FwkColumnAccessProducer() {
        super("FwkColumnAccessProducer@" + FwkDataBus.BUSNAME, FwkContainer.getMimeTypes(FwkColumnAccessInterface.class));
        this.setAuthor("Andreas Hofmann");
        this.setBuild(version);
        this.setDescription("The Column Access Producer.");
        this.setTitleName("Column Access Producer");
        this.setName(this.getClass().getName());
        this.setClassName(this.getClass().getName());
        this.setCreationDate("$Date: 2005/07/01 09:37:38 $", null);
        FwkContainer.registerDropProducer(this);
    }

    public static FwkColumnAccessProducer getInstance() {
        if (instance == null) {
            instance = new FwkColumnAccessProducer();
        }
        return instance;
    }

    public static void add(FwkColumnAccessInterface column) {
        FwkColumnAccessProducer.getInstance().addImpl(column);
    }

    public void addImpl(FwkColumnAccessInterface column) {
        DataFlavor[] df = FwkContainer.getDataFlavors(column.getClass());
        column.setProperty("InfoBusSource", this);
        this.dataItems.put(column.getName(), column);
        this.fireItemAvailable(column, df);
    }

    public static void remove(FwkColumnAccessInterface column) {
        FwkColumnAccessProducer.getInstance().removeImpl(column);
    }

    public void removeImpl(FwkColumnAccessInterface column) {
        DataItem item = (DataItem)this.dataItems.remove(column.getName());
        if (item != null) {
            item.release();
            this.fireItemRevoked(item);
        }
    }

    public boolean revoke(String itemName, DataFlavor[] flavor) {
        if (itemName == null) {
            return true;
        }
        if (this.isAssignable(flavor)) {
            if (itemName.indexOf(63) == -1 && itemName.indexOf(42) == -1) {
                DataItem item = (DataItem)this.dataItems.remove(itemName);
                if (item != null) {
                    item.release();
                    this.fireItemRevoked(item);
                }
            } else {
                Object[] arr = this.findMultipleDataItems(itemName, flavor);
                if (arr != null && arr.length != 0) {
                    for (int i = arr.length - 1; i >= 0; --i) {
                        try {
                            FwkColumnAccessInterface col = (FwkColumnAccessInterface)arr[i];
                            DataItem item = (DataItem)this.dataItems.remove(col.getName());
                            if (item == null) continue;
                            item.release();
                            this.fireItemRevoked(item);
                            continue;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                } else {
                    DataItem item = (DataItem)this.dataItems.remove(itemName);
                    if (item != null) {
                        item.release();
                        this.fireItemRevoked(item);
                    }
                }
            }
        }
        return true;
    }

    public int isDropDataFlavorSupported(DataFlavor[] df) {
        int ret = -1;
        int size = df.length;
        int len = this.supportedFlavors.length;
        int j = 0;
        for (int i = 0; ret == -1 && i < len; ++i) {
            j = 0;
            while (ret == -1 && j < size) {
                if (!df[j++].equals(this.supportedFlavors[i])) continue;
                ret = j - 1;
            }
        }
        return ret;
    }

    public void createFromDroppedObject(Object data) throws FwkException {
        try {
            InfoBus ib = this.getInfoBus();
            if (ib != null) {
                String sData = null;
                if (data instanceof String) {
                    sData = (String)data;
                } else if (data instanceof InputStream) {
                    InputStream is = (InputStream)data;
                    byte[] arr = new byte[is.available()];
                    is.read(arr);
                    sData = new String(arr);
                    arr = null;
                }
                DropColumnAccess dca = new DropColumnAccess(sData);
                if (dca != null) {
                    String name = dca.getName();
                    int counter = 1;
                    while (this.findDataItem(dca.getName()) != null) {
                        dca.setName(name + "[" + counter++ + "]");
                    }
                    this.dataItems.put(dca.getName(), dca);
                    this.fireItemAvailable(dca, FwkContainer.getDataFlavors(FwkColumnAccess.class));
                }
            }
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: FwkColumnAccessProducer.java,v $", version, "AH 2000-02-03 11:52", "Cannot read from input stream.", FwkColumnAccessProducer.getInstance(), t);
        }
    }

    public static void createTestDataItems() {
        FwkColumnAccessProducer.getInstance().createTestDataImpl();
    }

    public void createTestDataImpl() {
        int size = this.testDataItemNames.length;
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            for (int i = 0; i < size; ++i) {
                Object o = this.dataItems.get(this.testDataItemNames[i]);
                if (o != null) continue;
                TestDataItem col = new TestDataItem(this.testDataItemNames[i]);
                this.dataItems.put(this.testDataItemNames[i], col);
                this.fireItemAvailable(col, FwkContainer.getDataFlavors(class$com$highqsoft$fwk$FwkColumnAccess == null ? FwkColumnAccessProducer.class$("com.highqsoft.fwk.FwkColumnAccess") : class$com$highqsoft$fwk$FwkColumnAccess));
            }
        }
    }

    public static void revokeTestDataItems() {
        FwkColumnAccessProducer.getInstance().revokeTestDataImpl();
    }

    public void revokeTestDataImpl() {
        int size = this.testDataItemNames.length;
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            for (int i = 0; i < size; ++i) {
                DataItem item;
                Object o = this.dataItems.get(this.testDataItemNames[i]);
                if (o == null || (item = (DataItem)this.dataItems.remove(this.testDataItemNames[i])) == null) continue;
                item.release();
                this.fireItemRevoked(item);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
    }

    public void dataItemRequested(InfoBusItemRequestedEvent ev) {
        super.dataItemRequested(ev);
        if (ev.getDataItem() == null) {
            String wanted;
            DataFlavor[] flavor = ev.getDataFlavors();
            DataFlavor[] dataFlavor = this.getDataFlavors();
            int size = flavor.length;
            int length = dataFlavor.length;
            boolean assignable = false;
            for (int i = 0; !assignable && i < size; ++i) {
                int j = 0;
                while (!assignable && j < length) {
                    assignable = flavor[i].equals(dataFlavor[j++]);
                }
            }
            if (assignable && (wanted = ev.getDataItemName()) != null && wanted.length() != 0) {
                if (wanted.indexOf(42) != -1 || wanted.indexOf(63) != -1) {
                    FwkArray arr = new FwkArray();
                    Iterator it = this.dataItems.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        if (!Pattern.match(key, wanted, false)) continue;
                        arr.add(this.dataItems.get(key));
                    }
                    if (arr.size() != 0) {
                        ev.setDataItem((Object)arr.toArray());
                    }
                } else {
                    ev.setDataItem(this.dataItems.get(wanted));
                }
            }
        }
    }

    public class DropColumnAccess
    extends FwkColumnAccess
    implements FwkColumnAccessInterface {
        String unit;

        public DropColumnAccess(String data) throws Throwable {
            block15: {
                double[] tmpArr;
                this.setTitleName(this.getClass().getName());
                this.rangeIsValid = false;
                this.lower = 0.0;
                this.upper = 0.0;
                this.unit = "";
                this.setProperty("InfoBusSource", FwkColumnAccessProducer.this);
                int blockSize = 512;
                double[] columnData = new double[blockSize];
                int counter = 0;
                StringTokenizer st = new StringTokenizer(data);
                while (st.hasMoreTokens()) {
                    String tmp = st.nextToken();
                    try {
                        if (counter >= columnData.length) {
                            tmpArr = new double[columnData.length + blockSize];
                            System.arraycopy(columnData, 0, tmpArr, 0, columnData.length);
                            columnData = tmpArr;
                        }
                        columnData[counter] = new Double(tmp);
                        this.observer = new FwkColumnDataObserverDouble(columnData);
                        ++counter;
                    }
                    catch (NumberFormatException nf) {
                        String tok;
                        if (Pattern.match(tmp, "*Name*", true)) {
                            tok = st.nextToken();
                            if (tok.compareTo(":") == 0 || tok.compareTo("=") == 0) {
                                tok = st.nextToken();
                            }
                            this.setName(tok);
                            continue;
                        }
                        if (Pattern.match(tmp, "*Unit*", true)) {
                            tok = st.nextToken();
                            if (tok.compareTo(":") == 0 || tok.compareTo("=") == 0) {
                                tok = st.nextToken();
                            }
                            this.unit = tok;
                            continue;
                        }
                        try {
                            if (counter >= columnData.length) {
                                double[] tmpArr2 = new double[columnData.length + blockSize];
                                System.arraycopy(columnData, 0, tmpArr2, 0, columnData.length);
                                columnData = tmpArr2;
                            }
                            columnData[counter] = new Double(tmp.replace(',', '.'));
                            this.observer = new FwkColumnDataObserverDouble(columnData);
                            ++counter;
                        }
                        catch (Throwable t1) {}
                    }
                }
                if (counter >= 0) {
                    if (counter < columnData.length - 1) {
                        tmpArr = new double[counter + 1];
                        System.arraycopy(columnData, 0, tmpArr, 0, counter + 1);
                        columnData = tmpArr;
                        this.observer = new FwkColumnDataObserverDouble(columnData);
                    }
                    break block15;
                }
                throw new FwkException(-1073676289, "$RCSfile: FwkColumnAccessProducer.java,v $", FwkColumnAccessProducer.version, "AH 2000-02-03 16:31", "No data from drop object read", this, null);
            }
        }

        public String getUnitString() {
            return this.unit;
        }
    }

    public class TestDataItem
    extends FwkColumnAccess
    implements FwkColumnAccessInterface {
        public TestDataItem(String name) {
            this.setName(name);
            this.setColumnName(name);
            this.setDescription(name + "    Length = " + testDataItemLength + ")");
            this.setProperty("InfoBusSource", FwkColumnAccessProducer.this);
            this.lower = Double.MAX_VALUE;
            this.upper = Double.MIN_VALUE;
            this.rangeIsValid = false;
            if (name.toUpperCase().compareTo("SIN(X)/EXP(X/10)") == 0) {
                double[] columnData = new double[testDataItemLength];
                for (int i = 0; i < testDataItemLength; ++i) {
                    columnData[i] = Math.sin((double)i / (double)testDataItemLength * 50.0) / Math.exp((double)i / (double)testDataItemLength * 5.0);
                    this.lower = Math.min(this.lower, columnData[i]);
                    this.upper = Math.max(this.upper, columnData[i]);
                    if (!(columnData[i] > 0.0)) continue;
                    this.minPositiveValue = Math.min(columnData[i], this.minPositiveValue);
                }
                this.observer = new FwkColumnDataObserverDouble(columnData);
                this.rangeIsValid = true;
            } else if (name.toUpperCase().compareTo("NOISE+SIN(X)/EXP(X/10)") == 0) {
                double[] columnData = new double[testDataItemLength];
                for (int i = 0; i < testDataItemLength; ++i) {
                    columnData[i] = Math.random() / 5.0 + Math.sin((double)i / (double)testDataItemLength * 50.0) / Math.exp((double)i / (double)testDataItemLength * 5.0);
                    this.lower = Math.min(this.lower, columnData[i]);
                    this.upper = Math.max(this.upper, columnData[i]);
                    if (!(columnData[i] > 0.0)) continue;
                    this.minPositiveValue = Math.min(columnData[i], this.minPositiveValue);
                }
                this.rangeIsValid = true;
                this.observer = new FwkColumnDataObserverDouble(columnData);
            } else if (name.toUpperCase().compareTo("EXP") == 0) {
                Random r = new Random();
                double[] columnData = new double[testDataItemLength];
                for (int i = 0; i < testDataItemLength; ++i) {
                    columnData[i] = (5.0 + r.nextDouble()) / Math.exp((double)i / (double)testDataItemLength * 5.0);
                    this.lower = Math.min(this.lower, columnData[i]);
                    this.upper = Math.max(this.upper, columnData[i]);
                    if (!(columnData[i] > 0.0)) continue;
                    this.minPositiveValue = Math.min(columnData[i], this.minPositiveValue);
                }
                this.rangeIsValid = true;
                this.observer = new FwkColumnDataObserverDouble(columnData);
                FwkAliasBus.alias("MED.Alias.TestAlias", "EXP", FwkDataBus.BUSNAME, FwkColumnAccessProducer.getInstance().getDataFlavors());
            } else if (name.toUpperCase().compareTo("TIME") == 0) {
                this.observer = new FwkImplicitColumnDataObserver(new double[]{0.0, 10.0}, testDataItemLength, 1);
                this.lower = 0.0;
                this.upper = (this.lower + (double)testDataItemLength - 1.0) * 10.0;
                this.rangeIsValid = true;
            } else if (name != null && name.length() != 0) {
                int len = testDataItemLength * 2;
                double[] columnData = new double[len];
                for (int i = 0; i < len; ++i) {
                    columnData[i] = Math.cos((double)i / (double)testDataItemLength * 50.0) / Math.exp((double)i / (double)len * 5.0);
                    this.lower = Math.min(this.lower, columnData[i]);
                    this.upper = Math.max(this.upper, columnData[i]);
                    if (!(columnData[i] > 0.0)) continue;
                    this.minPositiveValue = Math.min(columnData[i], this.minPositiveValue);
                }
                this.rangeIsValid = true;
                this.observer = new FwkColumnDataObserverDouble(columnData);
            }
        }

        public String getUnitString() {
            String name = this.getName();
            if (name.compareToIgnoreCase("SIN") == 0) {
                return "sin(kg)";
            }
            if (name.compareToIgnoreCase("EXP") == 0) {
                return "exp(Nm)";
            }
            if (name.compareToIgnoreCase("Time") == 0) {
                return "s";
            }
            return "cos(Watt)";
        }

        public String[] dependsOn() {
            return null;
        }
    }
}

