/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkColumnDataObserver;
import java.util.Arrays;
import java.util.Date;

public class FwkColumnDataObserverDate
extends FwkColumnDataObserver {
    protected Date[] values;
    protected Converter converter;

    protected FwkColumnDataObserverDate() {
        this(new Date[0]);
        this.converter = new SecConverter();
    }

    public void release() {
        this.values = null;
        super.release();
    }

    public FwkColumnDataObserverDate(Date[] values) {
        this.values = values != null ? values : new Date[0];
        this.converter = new SecConverter();
    }

    public FwkColumnDataObserverDate(Date[] values, short[] flags) {
        this(values);
        this.flags = flags;
    }

    public FwkColumnDataObserverDate(Date[] values, short flag) {
        this(values);
        this.globalFlag = flag;
        this.globalFlagValid = true;
    }

    public void setFlagAt(int index, short flag) {
        int from = -1;
        int to = -1;
        if (this.flags == null) {
            this.flags = new short[this.values.length];
            from = 0;
            to = this.values.length;
        } else if (this.flags.length < this.values.length) {
            from = this.flags.length;
            to = this.values.length;
            short[] tmp = new short[this.values.length];
            System.arraycopy(this.flags, 0, tmp, 0, this.flags.length);
            this.flags = tmp;
        }
        if (from != -1 && to != -1) {
            if (this.globalFlagValid) {
                Arrays.fill(this.flags, from, to, this.globalFlag);
                this.globalFlagValid = false;
            } else {
                Arrays.fill(this.flags, from, to, (short)15);
            }
        }
        super.setFlagAt(index, flag);
    }

    public double getValueAt(int index) {
        return this.converter.convert(this.values[index]);
    }

    public String getUnitString() {
        return this.converter.getUnit();
    }

    public void setValueAt(int index, double value) {
        this.values[index] = this.converter.convert(value);
        if (!this.suspended) {
            this.changeManager.fireItemValueChanged((Object)this, null);
        }
    }

    public int getCount() {
        return this.values.length;
    }

    public Class getNativeDatatype() {
        return Date.class;
    }

    public Object getNativeValues() {
        return this.values;
    }

    public Object getNativeValues(int lower, int upper) {
        Date[] ret = new Date[upper - lower + 1];
        System.arraycopy(this.values, lower, ret, 0, ret.length);
        return ret;
    }

    protected class SecConverter
    extends Converter {
        protected SecConverter() {
        }

        public double convert(Date date) {
            return (double)(date.getTime() - FwkColumnDataObserverDate.this.values[0].getTime()) / 1000.0;
        }

        public Date convert(double val) {
            return new Date(Math.round(val + (double)FwkColumnDataObserverDate.this.values[0].getTime()) * 1000L);
        }

        public String getUnit() {
            return "sec";
        }
    }

    protected abstract class Converter {
        protected Converter() {
        }

        public abstract double convert(Date var1);

        public abstract Date convert(double var1);

        public abstract String getUnit();
    }
}

