/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkColumnDataObserver;
import java.util.Arrays;

public class FwkColumnDataObserverDouble
extends FwkColumnDataObserver {
    protected double[] values;

    protected FwkColumnDataObserverDouble() {
        this(new double[0]);
    }

    public void release() {
        this.values = null;
        super.release();
    }

    public FwkColumnDataObserverDouble(double[] values) {
        this.values = values != null ? values : new double[0];
    }

    public FwkColumnDataObserverDouble(double[] values, short[] flags) {
        this(values);
        this.flags = flags;
    }

    public FwkColumnDataObserverDouble(double[] values, short flag) {
        this(values);
        this.globalFlag = flag;
        this.globalFlagValid = true;
    }

    public void setFlagAt(int index, short flag) {
        int from = -1;
        int to = -1;
        if (this.flags == null) {
            this.flags = new short[this.values.length];
            from = 0;
            to = this.values.length;
        } else if (this.flags.length < this.values.length) {
            from = this.flags.length;
            to = this.values.length;
            short[] tmp = new short[this.values.length];
            System.arraycopy(this.flags, 0, tmp, 0, this.flags.length);
            this.flags = tmp;
        }
        if (from != -1 && to != -1) {
            if (this.globalFlagValid) {
                Arrays.fill(this.flags, from, to, this.globalFlag);
                this.globalFlagValid = false;
            } else {
                Arrays.fill(this.flags, from, to, (short)15);
            }
        }
        super.setFlagAt(index, flag);
    }

    public double getValueAt(int index) {
        return this.values[index];
    }

    public void setValueAt(int index, double value) {
        this.values[index] = value;
        if (!this.suspended) {
            this.changeManager.fireItemValueChanged((Object)this, null);
        }
    }

    public int getCount() {
        return this.values.length;
    }

    public Class getNativeDatatype() {
        return Double.TYPE;
    }

    public Object getNativeValues() {
        return this.values;
    }

    public Object getNativeValues(int lower, int upper) {
        double[] ret = new double[upper - lower + 1];
        System.arraycopy(this.values, lower, ret, 0, ret.length);
        return ret;
    }
}

