/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkColumnDataObserver;
import java.util.Arrays;

public class FwkColumnDataObserverFloat
extends FwkColumnDataObserver {
    protected float[] values;

    protected FwkColumnDataObserverFloat() {
        this(new float[0]);
    }

    public FwkColumnDataObserverFloat(float[] values) {
        this.values = values != null ? values : new float[0];
    }

    public void release() {
        this.values = null;
        super.release();
    }

    public FwkColumnDataObserverFloat(float[] values, short[] flags) {
        this(values);
        this.flags = flags;
    }

    public FwkColumnDataObserverFloat(float[] values, short flag) {
        this(values);
        this.globalFlag = flag;
        this.globalFlagValid = true;
    }

    public void setFlagAt(int index, short flag) {
        int from = -1;
        int to = -1;
        if (this.flags == null) {
            this.flags = new short[this.values.length];
            from = 0;
            to = this.values.length;
        } else if (this.flags.length < this.values.length) {
            from = this.flags.length;
            to = this.values.length;
            short[] tmp = new short[this.values.length];
            System.arraycopy(this.flags, 0, tmp, 0, this.flags.length);
            this.flags = tmp;
        }
        if (from != -1 && to != -1) {
            if (this.globalFlagValid) {
                Arrays.fill(this.flags, from, to, this.globalFlag);
                this.globalFlagValid = false;
            } else {
                Arrays.fill(this.flags, from, to, (short)15);
            }
        }
        super.setFlagAt(index, flag);
    }

    public double getValueAt(int index) {
        return this.values[index];
    }

    public void setValueAt(int index, double value) {
        this.values[index] = (float)value;
        if (!this.suspended) {
            this.changeManager.fireItemValueChanged((Object)this, null);
        }
    }

    public int getCount() {
        return this.values.length;
    }

    public Class getNativeDatatype() {
        return Float.TYPE;
    }

    public Object getNativeValues() {
        return this.values;
    }

    public Object getNativeValues(int lower, int upper) {
        float[] ret = new float[upper - lower + 1];
        System.arraycopy(this.values, lower, ret, 0, ret.length);
        return ret;
    }
}

