/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkColumnDataObserver;
import java.util.Arrays;

public class FwkColumnDataObserverShort
extends FwkColumnDataObserver {
    protected short[] values;

    protected FwkColumnDataObserverShort() {
        this(new short[0]);
    }

    public FwkColumnDataObserverShort(short[] values) {
        this.values = values != null ? values : new short[0];
    }

    public FwkColumnDataObserverShort(short[] values, short[] flags) {
        this(values);
        this.flags = flags;
    }

    public FwkColumnDataObserverShort(short[] values, short flag) {
        this(values);
        this.globalFlag = flag;
        this.globalFlagValid = true;
    }

    public void release() {
        this.values = null;
        super.release();
    }

    public void setFlagAt(int index, short flag) {
        int from = -1;
        int to = -1;
        if (this.flags == null) {
            this.flags = new short[this.values.length];
            from = 0;
            to = this.values.length;
        } else if (this.flags.length < this.values.length) {
            from = this.flags.length;
            to = this.values.length;
            short[] tmp = new short[this.values.length];
            System.arraycopy(this.flags, 0, tmp, 0, this.flags.length);
            this.flags = tmp;
        }
        if (from != -1 && to != -1) {
            if (this.globalFlagValid) {
                Arrays.fill(this.flags, from, to, this.globalFlag);
                this.globalFlagValid = false;
            } else {
                Arrays.fill(this.flags, from, to, (short)15);
            }
        }
        super.setFlagAt(index, flag);
    }

    public double getValueAt(int index) {
        return this.values[index];
    }

    public void setValueAt(int index, double value) {
        this.values[index] = (short)Math.round(value);
        if (!this.suspended) {
            this.changeManager.fireItemValueChanged((Object)this, null);
        }
    }

    public int getCount() {
        return this.values.length;
    }

    public Class getNativeDatatype() {
        return Short.TYPE;
    }

    public Object getNativeValues() {
        return this.values;
    }

    public Object getNativeValues(int lower, int upper) {
        short[] ret = new short[upper - lower + 1];
        System.arraycopy(this.values, lower, ret, 0, ret.length);
        return ret;
    }
}

