/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkPropertyChange;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkColumnStatisticsInterface;
import javax.infobus.DataItemAddedEvent;
import javax.infobus.DataItemChangeListener;
import javax.infobus.DataItemDeletedEvent;
import javax.infobus.DataItemRevokedEvent;
import javax.infobus.DataItemValueChangedEvent;
import javax.infobus.RowsetCursorMovedEvent;

public class FwkColumnStatistics
extends FwkPropertyChange
implements FwkColumnStatisticsInterface,
DataItemChangeListener {
    String name;
    String unit;
    long count;
    double average;
    double stdev;

    public FwkColumnStatistics(FwkColumnAccessInterface col) {
        this(col.getShortName(), col.getUnitString(), col.getCount(), col.getAverage(), col.getStandardDeviation());
        col.addDataItemChangeListener(this);
    }

    protected void refresh(FwkColumnAccessInterface col) {
        double newstd;
        double newaverage;
        long newcount;
        String newunit;
        String newname = col.getShortName();
        if (!newname.equals(this.name)) {
            String old = this.name;
            this.name = newname;
            this.firePropertyChange("Name", old, this.name);
        }
        if (!(newunit = col.getUnitString()).equals(this.unit)) {
            String old = this.unit;
            this.unit = newunit;
            this.firePropertyChange("Unit", old, this.unit);
        }
        if ((newcount = (long)col.getCount()) != this.count) {
            long old = this.count;
            this.count = newcount;
            this.firePropertyChange("Count", old, this.count);
        }
        if ((newaverage = col.getAverage()) != this.average) {
            double old = this.average;
            this.average = newaverage;
            this.firePropertyChange("Average", old, newaverage);
        }
        if ((newstd = col.getStandardDeviation()) != this.stdev) {
            double old = this.stdev;
            this.stdev = newstd;
            this.firePropertyChange("Stdev", old, this.stdev);
        }
    }

    public FwkColumnStatistics(String name, String unit, long count, double average, double stdev) {
        this.name = name;
        this.unit = unit;
        this.count = count;
        this.average = average;
        this.stdev = stdev;
    }

    public String getName() {
        return this.name;
    }

    public String getUnitString() {
        return this.unit;
    }

    public long getCount() {
        return this.count;
    }

    public double getAverage() {
        return this.average;
    }

    public double getStandardDeviation() {
        return this.stdev;
    }

    public double getVariance() {
        return this.getStandardDeviation() * this.getStandardDeviation();
    }

    public void dataItemAdded(DataItemAddedEvent event) {
        FwkColumnAccessInterface col = (FwkColumnAccessInterface)event.getSource();
        this.refresh(col);
    }

    public void dataItemDeleted(DataItemDeletedEvent event) {
        FwkColumnAccessInterface col = (FwkColumnAccessInterface)event.getSource();
        this.refresh(col);
    }

    public void dataItemRevoked(DataItemRevokedEvent event) {
        FwkColumnAccessInterface col = (FwkColumnAccessInterface)event.getSource();
        col.removeDataItemChangeListener(this);
    }

    public void dataItemValueChanged(DataItemValueChangedEvent event) {
        FwkColumnAccessInterface col = (FwkColumnAccessInterface)event.getSource();
        this.refresh(col);
    }

    public void rowsetCursorMoved(RowsetCursorMovedEvent event) {
    }
}

