/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkInstruction;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkPropertyChange;
import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkCommandActionInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import com.highqsoft.interfaces.fwk.FwkInstructionInterface;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class FwkCommand
extends FwkPropertyChange
implements FwkCommandInterface {
    public static final String version = "$Revision: 1.4 $";
    protected boolean toolBarEnabled = true;
    protected boolean menuEventEnabled = false;
    protected String text = null;
    protected String textKey = null;
    protected String commandName = null;
    protected int mnemonic = 0;
    protected FwkIconInterface icon;
    protected String iconKey = null;
    protected String toolTipText = null;
    protected String toolTipKey = null;
    protected boolean visible = true;
    protected boolean sensitive = true;
    protected boolean separator = false;
    protected boolean toggle = false;
    protected boolean toggleState = false;
    protected boolean radioGroupState = false;
    protected FwkArrayInterface actionListeners = null;
    protected FwkArrayInterface menuListeners = null;
    protected String helpID = null;
    protected Hashtable registry;
    protected FwkInstructionInterface instruction = new FwkInstruction();
    protected Class buttonClass = null;
    protected Class menuItemClass = null;
    protected Properties properties = new Properties();

    public String getVersion() {
        return version;
    }

    public FwkCommand() {
    }

    public FwkCommand(FwkControllerInterface controller) {
        this();
        this.setController(controller);
    }

    public FwkCommand(String text) {
        this();
        this.setTextKey(text);
    }

    public String getCommandName() {
        return this.commandName;
    }

    public FwkControllerInterface getController() {
        return (FwkControllerInterface)this.properties.get("Controller");
    }

    public String getHelpID() {
        return this.helpID;
    }

    public FwkIconInterface getIcon() {
        return this.icon;
    }

    public String getIconKey() {
        return this.iconKey;
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public boolean getRadioGroupState() {
        return this.radioGroupState;
    }

    public boolean getSensitivity() {
        return this.sensitive;
    }

    public boolean getSeparator() {
        return this.separator;
    }

    public String getText() {
        return this.text;
    }

    public String getTextKey() {
        if (this.textKey == null) {
            return this.text;
        }
        return this.textKey;
    }

    public boolean getToggle() {
        return this.toggle;
    }

    public boolean getToggleState() {
        return this.toggleState;
    }

    public String getToolTipKey() {
        if (this.toolTipKey == null) {
            return this.toolTipText;
        }
        return this.toolTipKey;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public boolean getVisibility() {
        return this.visible;
    }

    public void setToolBarEnabled(boolean flag) {
        this.toolBarEnabled = flag;
    }

    public boolean getToolBarEnabled() {
        return this.toolBarEnabled && this.getIcon() != null;
    }

    public boolean isParent() {
        return this.getCommands() != null;
    }

    public void setAsParent() {
        this.instruction.addCommand(null);
    }

    public void setCommandName(String commandName) {
        if (this.commandName == null || commandName.compareTo(this.commandName) != 0) {
            String old = this.commandName;
            this.commandName = commandName;
            this.firePropertyChange("Command", old, commandName);
        }
    }

    public void setController(FwkControllerInterface controller) {
        Object old = this.properties.get("Controller");
        if (controller != null) {
            this.properties.put("Controller", controller);
        } else {
            this.properties.remove("Controller");
        }
        this.firePropertyChange("Controller", old, controller);
    }

    public void setHelpID(String helpID) {
        if (this.helpID == null || helpID.compareTo(this.helpID) != 0) {
            String old = this.helpID;
            this.helpID = helpID;
            this.firePropertyChange("HelpID", old, helpID);
        }
    }

    public void setIcon(FwkIconInterface icon) {
        FwkIconInterface old = this.icon;
        this.icon = icon;
        this.firePropertyChange("IconImage", old, icon);
    }

    public void setIconKey(String iconKey) {
        String old = this.iconKey;
        if (iconKey != null) {
            try {
                FwkIconInterface iIcon = FwkIconFile.getIcon(iconKey);
                if (iIcon != null) {
                    this.iconKey = iconKey;
                    this.firePropertyChange("IconKey", old, iconKey);
                    this.setIcon(iIcon);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setMenuEventEnabled(boolean flag) {
        if (flag != this.menuEventEnabled) {
            boolean old = this.menuEventEnabled;
            this.menuEventEnabled = flag;
            this.firePropertyChange("MenuEventEnabled", old, flag);
        }
    }

    public boolean getMenuEventEnabled() {
        return this.menuEventEnabled;
    }

    public boolean menuSelect(MenuEvent event, int reason) {
        return true;
    }

    public void setMnemonic(int mnemonic) {
        if (mnemonic != this.mnemonic) {
            int old = this.mnemonic;
            this.mnemonic = mnemonic;
            this.firePropertyChange("Mnemonic", old, mnemonic);
        }
    }

    public void setRadioGroupState(boolean flag) {
        if (flag != this.radioGroupState) {
            boolean old = this.radioGroupState;
            this.radioGroupState = flag;
            this.firePropertyChange("RadioGroupState", old, flag);
        }
    }

    public void setSensitivity(boolean flag) {
        if (flag != this.sensitive) {
            boolean old = this.sensitive;
            this.sensitive = flag;
            this.firePropertyChange("Sensitivity", old, flag);
        }
    }

    public void setSeparator(boolean flag) {
        if (flag != this.separator) {
            boolean old = this.separator;
            this.separator = flag;
            this.firePropertyChange("Separator", old, flag);
        }
    }

    public void setText(String text) {
        if (this.text == null || text.compareTo(this.text) != 0) {
            String old = this.text;
            this.setTextKey(text);
            this.firePropertyChange("Text", old, text);
        }
    }

    public void setTextKey(String textKey) {
        String old = this.textKey;
        this.textKey = textKey;
        this.firePropertyChange("TextKey", old, textKey);
        if (textKey != null) {
            this.text = FwkPropertyBus.getProperty(textKey);
        }
    }

    public void setToggle(boolean flag) {
        if (flag != this.toggle) {
            boolean old = this.toggle;
            this.toggle = flag;
            this.firePropertyChange("Toggle", old, flag);
        }
    }

    public void setToggleState(boolean flag) {
        if (flag != this.toggleState) {
            boolean old = this.toggleState;
            this.toggleState = flag;
            this.firePropertyChange("ToggleState", old, flag);
        }
    }

    public void setToolTipText(String toolTipText) {
        String old = this.toolTipText;
        this.toolTipText = toolTipText;
        this.firePropertyChange("ToolTipText", old, toolTipText);
    }

    public void setToolTipKey(String toolTipKey) {
        String old = this.toolTipKey;
        this.toolTipKey = toolTipKey;
        this.firePropertyChange("ToolTipKey", old, toolTipKey);
        if (toolTipKey != null) {
            this.setToolTipText(FwkPropertyBus.getProperty(toolTipKey));
        }
    }

    public void setVisibility(boolean flag) {
        if (flag != this.visible) {
            boolean old = this.visible;
            this.visible = flag;
            this.firePropertyChange("Visibility", old, flag);
        }
    }

    public void register(Object obj) {
        if (this.registry == null) {
            this.registry = new Hashtable();
        }
        this.registry.put(obj, obj);
    }

    public void unregister(Object obj) {
        if (this.registry != null) {
            this.registry.remove(obj);
            if (this.registry.size() == 0) {
                this.registry = null;
            }
        }
    }

    public Enumeration registeredObjects() {
        if (this.registry != null) {
            return this.registry.elements();
        }
        return null;
    }

    public int registrySize() {
        if (this.registry != null) {
            return this.registry.size();
        }
        return 0;
    }

    public boolean hasActionListeners() {
        return this.actionListeners != null && this.actionListeners.size() != 0;
    }

    public boolean hasMenuListeners() {
        return this.menuListeners != null && this.menuListeners.size() != 0;
    }

    public synchronized FwkArrayInterface getActionListenerArray() {
        return this.actionListeners;
    }

    public synchronized FwkArrayInterface getMenuListenerArray() {
        return this.menuListeners;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (this.actionListeners == null) {
            this.actionListeners = new FwkArray();
        }
        this.actionListeners.add(actionListener);
        this.firePropertyChange("AddActionListener", this, actionListener);
    }

    public synchronized void addMenuListener(MenuListener menuListener) {
        if (this.menuListeners == null) {
            this.menuListeners = new FwkArray();
        }
        this.menuListeners.add(menuListener);
        this.firePropertyChange("AddMenuListener", this, menuListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(actionListener);
            this.firePropertyChange("RemoveActionListener", actionListener, this);
        }
    }

    public synchronized void removeMenuListener(MenuListener menuListener) {
        if (this.menuListeners != null) {
            this.menuListeners.remove(menuListener);
            this.firePropertyChange("RemoveMenuListener", menuListener, this);
        }
    }

    public synchronized boolean execute(EventObject ev) {
        boolean ret = false;
        if (this.actionListeners != null && this.actionListeners.size() > 0) {
            int size = this.actionListeners.size();
            for (int i = 0; i < size; ++i) {
                Object ca = this.actionListeners.get(i);
                if (!(ca instanceof FwkCommandActionInterface)) continue;
                try {
                    ((FwkCommandActionInterface)ca).actionPerformed(this);
                    ret = true;
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return ret;
    }

    public void addCommand(FwkCommandInterface command) {
        FwkControllerInterface c;
        this.instruction.addCommand(command);
        if (this.getController() != null && (c = command.getController()) == null) {
            command.setController(this.getController());
        }
    }

    public void addCommand(int index, FwkCommandInterface command) {
        this.instruction.addCommand(index, command);
    }

    public FwkCommandInterface getCommand(String command) {
        return this.instruction.getCommand(command);
    }

    public FwkCommandInterface[] getCommands() {
        return this.instruction.getCommands();
    }

    public synchronized void removeCommand(FwkCommandInterface command) {
        this.instruction.removeCommand(command);
    }

    public void setCommands(FwkCommandInterface[] commands) {
        if (commands != null) {
            for (int i = 0; i < commands.length; ++i) {
                this.addCommand(commands[i]);
            }
        }
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Iterator getProperties() {
        return this.properties.keySet().iterator();
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public boolean commandsAvailable() {
        return this.instruction.commandsAvailable();
    }

    public void clearCommands() {
        this.instruction.clearCommands();
    }

    public void addToGroup(int index, String groupIdent, String commandName) {
        this.instruction.addToGroup(groupIdent, commandName);
    }

    public void addToGroup(String groupIdent, String commandName) {
        this.instruction.addToGroup(groupIdent, commandName);
    }

    public void deleteGroup(String groupIdent) {
        this.instruction.deleteGroup(groupIdent);
    }

    public FwkCommandInterface[] getGroup(String groupIdent) {
        return this.instruction.getGroup(groupIdent);
    }

    public boolean groupExists(String groupIdent) {
        return this.instruction.groupExists(groupIdent);
    }

    public void removeFromGroup(String groupIdent, String commandName) {
        this.instruction.removeFromGroup(groupIdent, commandName);
    }

    public String toString() {
        return "FwkCommand: " + this.commandName + " \"" + this.text + "\"";
    }

    public void setButtonClass(Class clazz) {
        Class old = this.buttonClass;
        this.buttonClass = clazz;
        this.firePropertyChange("ButtonClass", old, clazz);
    }

    public Class getButtonClass() {
        return this.buttonClass;
    }

    public void setMenuItemClass(Class clazz) {
        Class old = this.menuItemClass;
        this.menuItemClass = clazz;
        this.firePropertyChange("MenuItemClass", old, clazz);
    }

    public Class getMenuItemClass() {
        return this.menuItemClass;
    }
}

