/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkStringTransfer;
import com.highqsoft.interfaces.fwk.FwkDragAndDropInterface;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.InvalidDnDOperationException;

public class FwkDragAndDrop
extends FwkDescription
implements FwkDragAndDropInterface {
    int dropActions = 3;
    int dragActions = 3;
    private DragSource dragSource;
    String infoBusName = null;

    private FwkDragAndDrop() {
    }

    public FwkDragAndDrop(Component comp) {
        this();
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(comp, this.getAcceptableDragActions(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dragGestureRecognized(DragGestureEvent ev) {
        try {
            ev.startDrag(DragSource.DefaultCopyNoDrop, this.getTransferData(), this);
            return;
        }
        catch (InvalidDnDOperationException idoe) {}
        finally {
            return;
        }
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dragEnter(DragSourceDragEvent dsde) {
        DragSourceContext context = dsde.getDragSourceContext();
        int action = dsde.getDropAction();
        if ((action & this.getAcceptableDragActions()) != 0) {
            context.setCursor(DragSource.DefaultCopyDrop);
        } else {
            context.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    public void dragExit(DragSourceEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
        DragSourceContext context = dsde.getDragSourceContext();
        int action = dsde.getDropAction();
        if ((action & this.getAcceptableDragActions()) != 0) {
            context.setCursor(DragSource.DefaultCopyDrop);
        } else {
            context.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (!this.isDragOk(dtde)) {
            dtde.rejectDrag();
            return;
        }
        dtde.acceptDrag(this.getAcceptableDropActions());
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void drop(DropTargetDropEvent e) {
        DataFlavor choosen = null;
        DataFlavor[] df = e.getCurrentDataFlavors();
        int i = this.isDataFlavorSupported(df);
        if (i != -1) {
            choosen = df[i];
        }
        Object data = null;
        boolean complete = false;
        if (choosen != null) {
            try {
                e.acceptDrop(this.getAcceptableDropActions());
                data = e.getTransferable().getTransferData(choosen);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (data != null) {
            this.setTransferData(data, choosen);
            complete = true;
        } else {
            System.out.println("FwkDragAndDrop.drop");
            System.out.println("Java 2 still contains a bug that prevents some native-to-Java transfer.");
            System.out.println("\t see also: http://www.javaworld.com/javaworld/jw-03-1999/jw-03-dragndrop-2.html");
        }
        e.dropComplete(complete);
        if (!complete) {
            e.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        if (!this.isDragOk(dtde)) {
            dtde.rejectDrag();
            return;
        }
        dtde.acceptDrag(this.getAcceptableDropActions());
    }

    public boolean isDragOk(DropTargetDragEvent e) {
        return this.isDataFlavorSupported(e.getCurrentDataFlavors()) != -1;
    }

    public void setAcceptableDropActions(int actions) {
        this.dropActions = actions;
    }

    public void setAcceptableDragActions(int actions) {
        this.dragActions = actions;
    }

    public int getAcceptableDropActions() {
        return this.dropActions;
    }

    public int getAcceptableDragActions() {
        return this.dragActions;
    }

    public Transferable getTransferData() {
        return new FwkStringTransfer(this.getPresentationString());
    }

    public void setTransferData(Object data, DataFlavor flavor) {
        FwkContainer.createFromDroppedObject(this.infoBusName, flavor, data);
    }

    public int isDataFlavorSupported(DataFlavor[] df) {
        return FwkContainer.isDropDataFlavorSupported(this.infoBusName, df);
    }

    public void setInfoBusName(String name) {
        this.infoBusName = name;
    }

    public static void printAction(int action) {
        System.out.print("DNDAction ");
        switch (action) {
            case 1: {
                System.out.println("ACTION_COPY");
                break;
            }
            case 3: {
                System.out.println("ACTION_COPY_OR_MOVE");
                break;
            }
            case 0x40000000: {
                System.out.println("ACTION_LINK");
                break;
            }
            case 2: {
                System.out.println("ACTION_MOVE");
                break;
            }
            case 0: {
                System.out.println("ACTION_NONE");
                break;
            }
            default: {
                System.out.println("UNKNOWN");
            }
        }
    }
}

