/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkInfoBusProducer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkPropertyGroup;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.interfaces.fwk.FwkInfoBusProducerInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyGroupInterface;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import javax.infobus.InfoBusItemRequestedEvent;

public class FwkEnvironmentPropertyProducer
extends FwkInfoBusProducer
implements FwkInfoBusProducerInterface {
    public static final String version = "$Revision: 1.5 $";
    public static final String PREFIX = "Environment.";
    protected static int counter = 1;
    private static final String osName = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final String osArch = System.getProperty("os.arch").toLowerCase(Locale.US);
    private static final String osVersion = System.getProperty("os.version").toLowerCase(Locale.US);
    private static final String pathSep = System.getProperty("path.separator");
    protected FwkPropertyGroup cpf = new FwkPropertyGroup();

    public String getVersion() {
        return version;
    }

    public FwkEnvironmentPropertyProducer() {
        super("FwkEnvironmentPropertyProducer[" + counter++ + "]@" + FwkPropertyBus.BUSNAME, FwkPropertyBus.MIMETYPES);
        this.getEnvironment();
    }

    public String getPresentationString(Locale locale) {
        return this.cpf.toString();
    }

    public boolean revoke(String itemName, DataFlavor[] flavor) {
        return false;
    }

    public void dataItemRequested(InfoBusItemRequestedEvent ev) {
        super.dataItemRequested(ev);
        Object property = null;
        if (ev.getDataItem() == null && this.isAssignable(ev.getDataFlavors())) {
            if (FwkInfoBusProducer.isAssignable(ev.getDataFlavors(), FwkContainer.getDataFlavor(FwkPropertyGroupInterface.class))) {
                this.propertyGroupRequested(ev);
            } else {
                String dataItemName = ev.getDataItemName();
                if (dataItemName != null) {
                    if (dataItemName.indexOf(42) != -1 || dataItemName.indexOf(63) != -1) {
                        HashMap<String, String> ret = new HashMap<String, String>();
                        Enumeration e = this.cpf.propertyNames();
                        while (e.hasMoreElements()) {
                            String key = (String)e.nextElement();
                            if (!Pattern.match(key, dataItemName, true)) continue;
                            ret.put(key, this.cpf.getProperty(key));
                        }
                        ev.setDataItem(ret);
                    } else {
                        property = this.cpf.getProperty(dataItemName);
                        DataFlavor[] flavor = ev.getDataFlavors();
                        if (property != null && flavor != null && flavor.length > 0) {
                            if (flavor[0].equals(FwkPropertyBus.getBooleanDataFlavor())) {
                                property = Boolean.valueOf((String)property);
                            } else if (flavor[0].equals(FwkPropertyBus.getByteDataFlavor())) {
                                property = Byte.valueOf((String)property);
                            } else if (flavor[0].equals(FwkPropertyBus.getCharacterDataFlavor())) {
                                property = new Character(((String)property).charAt(0));
                            } else if (flavor[0].equals(FwkPropertyBus.getDoubleDataFlavor())) {
                                property = Double.valueOf((String)property);
                            } else if (flavor[0].equals(FwkPropertyBus.getFloatDataFlavor())) {
                                property = Float.valueOf((String)property);
                            } else if (flavor[0].equals(FwkPropertyBus.getIntegerDataFlavor())) {
                                property = Integer.valueOf((String)property);
                            } else if (flavor[0].equals(FwkPropertyBus.getLongDataFlavor())) {
                                property = Long.valueOf((String)property);
                            } else if (flavor[0].equals(FwkPropertyBus.getShortDataFlavor())) {
                                property = Short.valueOf((String)property);
                            }
                        }
                        ev.setDataItem(property);
                    }
                }
            }
        }
    }

    public void propertyGroupRequested(InfoBusItemRequestedEvent ev) {
        String dataItemName = ev.getDataItemName();
        if (dataItemName != null) {
            if (dataItemName.indexOf(42) != -1 || dataItemName.indexOf(63) != -1) {
                HashMap<String, FwkPropertyGroupInterface> ret = new HashMap<String, FwkPropertyGroupInterface>();
                Enumeration e = this.cpf.groupNames();
                while (e.hasMoreElements()) {
                    FwkPropertyGroupInterface prop;
                    String key = (String)e.nextElement();
                    if (!Pattern.match(key, dataItemName, true) || (prop = this.cpf.getGroup(key)) == null) continue;
                    ret.put(key, prop);
                }
                if (ret.size() != 0) {
                    ev.setDataItem(ret);
                }
            } else {
                ev.setDataItem((Object)this.cpf.getGroup(dataItemName));
            }
        }
    }

    public void getEnvironment() {
        if (this.cpf.size() == 0) {
            try {
                String line;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PumpStreamHandler pump = new PumpStreamHandler(out);
                Process process = Runtime.getRuntime().exec(FwkEnvironmentPropertyProducer.getProcEnvCommand());
                try {
                    pump.setProcessInputStream(process.getOutputStream());
                    pump.setProcessOutputStream(process.getInputStream());
                    pump.setProcessErrorStream(process.getErrorStream());
                }
                catch (Throwable e) {
                    process.destroy();
                    e.printStackTrace();
                }
                pump.start();
                try {
                    process.waitFor();
                    process.exitValue();
                }
                catch (InterruptedException e) {
                    process.destroy();
                }
                pump.stop();
                BufferedReader in = null;
                if (FwkEnvironmentPropertyProducer.isFamily("z/os")) {
                    try {
                        in = new BufferedReader(new StringReader(out.toString("Cp1047")));
                    }
                    catch (UnsupportedEncodingException e) {}
                } else {
                    in = new BufferedReader(new StringReader(out.toString()));
                }
                String var = null;
                String lineSep = System.getProperty("line.separator");
                while ((line = in.readLine()) != null) {
                    if (line.indexOf(61) == -1) {
                        if (var == null) {
                            var = lineSep + line;
                            continue;
                        }
                        var = var + lineSep + line;
                        continue;
                    }
                    if (var != null) {
                        this.addEnvironment(var);
                    }
                    var = line;
                }
                if (var != null) {
                    this.addEnvironment(var);
                }
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
            catch (Throwable ace) {
                System.err.println("No system environment access.");
            }
        }
    }

    protected void addEnvironment(String line) {
        int idx = line.indexOf(61);
        if (idx > 0) {
            this.cpf.put((Object)(PREFIX + line.substring(0, idx)), line.substring(idx + 1, line.length()));
        }
    }

    private static String[] getProcEnvCommand() {
        if (FwkEnvironmentPropertyProducer.isFamily("os/2")) {
            String[] cmd = new String[]{"cmd", "/c", "set"};
            return cmd;
        }
        if (FwkEnvironmentPropertyProducer.isFamily("windows")) {
            if (!FwkEnvironmentPropertyProducer.isFamily("win9x")) {
                String[] cmd = new String[]{"cmd", "/c", "set"};
                return cmd;
            }
            String[] cmd = new String[]{"command.com", "/c", "set"};
            return cmd;
        }
        if (FwkEnvironmentPropertyProducer.isFamily("z/os")) {
            String[] cmd = new String[]{"/bin/env"};
            return cmd;
        }
        if (FwkEnvironmentPropertyProducer.isFamily("unix")) {
            String[] cmd = new String[]{"/usr/bin/env"};
            return cmd;
        }
        if (FwkEnvironmentPropertyProducer.isFamily("netware")) {
            String[] cmd = new String[]{"env"};
            return cmd;
        }
        String[] cmd = null;
        return cmd;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        this.firePropertyChange(ev);
    }

    public static boolean isFamily(String family) {
        return FwkEnvironmentPropertyProducer.isOs(family, null, null, null);
    }

    public static boolean isName(String name) {
        return FwkEnvironmentPropertyProducer.isOs(null, name, null, null);
    }

    public static boolean isArch(String arch) {
        return FwkEnvironmentPropertyProducer.isOs(null, null, arch, null);
    }

    public static boolean isVersion(String version) {
        return FwkEnvironmentPropertyProducer.isOs(null, null, null, version);
    }

    public static boolean isOs(String family, String name, String arch, String version) {
        boolean retValue = false;
        if (family != null || name != null || arch != null || version != null) {
            boolean isFamily = true;
            boolean isName = true;
            boolean isArch = true;
            boolean isVersion = true;
            if (family != null) {
                if (family.equals("windows")) {
                    isFamily = osName.indexOf("windows") > -1;
                } else if (family.equals("os/2")) {
                    isFamily = osName.indexOf("os/2") > -1;
                } else if (family.equals("netware")) {
                    isFamily = osName.indexOf("netware") > -1;
                } else if (family.equals("dos")) {
                    isFamily = pathSep.equals(";") && !FwkEnvironmentPropertyProducer.isFamily("netware");
                } else if (family.equals("mac")) {
                    isFamily = osName.indexOf("mac") > -1;
                } else if (family.equals("unix")) {
                    isFamily = pathSep.equals(":") && (!FwkEnvironmentPropertyProducer.isFamily("mac") || osName.endsWith("x"));
                } else if (family.equals("win9x")) {
                    isFamily = FwkEnvironmentPropertyProducer.isFamily("windows") && osName.indexOf("nt") < 0 && osName.indexOf("2000") < 0 && osName.indexOf("2003") < 0 && osName.indexOf("xp") < 0;
                } else if (family.equals("z/os")) {
                    isFamily = osName.indexOf("z/os") > -1 || osName.indexOf("os/390") > -1;
                } else {
                    System.err.println("Don't know how to detect os family \"" + family + "\"");
                }
            }
            if (name != null) {
                isName = name.equals(osName);
            }
            if (arch != null) {
                isArch = arch.equals(osArch);
            }
            if (version != null) {
                isVersion = version.equals(osVersion);
            }
            retValue = isFamily && isName && isArch && isVersion;
        }
        return retValue;
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        System.out.println(FwkPropertyBus.getProperty("Environment.ATHOS_INI"));
    }

    public class StreamPumper
    implements Runnable {
        private static final int SLEEP = 5;
        private static final int SIZE = 128;
        private InputStream is;
        private OutputStream os;
        private boolean finished;

        public StreamPumper(InputStream is, OutputStream os) {
            this.is = is;
            this.os = os;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.finished = false;
            }
            byte[] buf = new byte[128];
            try {
                int length;
                while ((length = this.is.read(buf)) > 0) {
                    this.os.write(buf, 0, length);
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            catch (Exception exception) {
                StreamPumper streamPumper2 = this;
                synchronized (streamPumper2) {
                    this.finished = true;
                    this.notify();
                }
            }
            finally {
                StreamPumper e = this;
                synchronized (e) {
                    this.finished = true;
                    this.notify();
                }
            }
        }

        public synchronized boolean isFinished() {
            return this.finished;
        }

        public synchronized void waitFor() throws InterruptedException {
            while (!this.isFinished()) {
                this.wait();
            }
        }
    }

    public class PumpStreamHandler {
        private Thread inputThread;
        private Thread errorThread;
        private OutputStream out;
        private OutputStream err;

        public PumpStreamHandler(OutputStream out, OutputStream err) {
            this.out = out;
            this.err = err;
        }

        public PumpStreamHandler(OutputStream outAndErr) {
            this(outAndErr, outAndErr);
        }

        public PumpStreamHandler() {
            this(System.out, System.err);
        }

        public void setProcessOutputStream(InputStream is) {
            this.createProcessOutputPump(is, this.out);
        }

        public void setProcessErrorStream(InputStream is) {
            this.createProcessErrorPump(is, this.err);
        }

        public void setProcessInputStream(OutputStream os) {
        }

        public void start() {
            this.inputThread.start();
            this.errorThread.start();
        }

        public void stop() {
            try {
                this.inputThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.errorThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.err.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected OutputStream getErr() {
            return this.err;
        }

        protected OutputStream getOut() {
            return this.out;
        }

        protected void createProcessOutputPump(InputStream is, OutputStream os) {
            this.inputThread = this.createPump(is, os);
        }

        protected void createProcessErrorPump(InputStream is, OutputStream os) {
            this.errorThread = this.createPump(is, os);
        }

        protected Thread createPump(InputStream is, OutputStream os) {
            Thread result = new Thread(new StreamPumper(is, os));
            result.setDaemon(true);
            return result;
        }
    }
}

