/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.exception.ErrorNumber;
import com.highqsoft.fwk.exception.FwkExceptionWriter;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkExceptionInterface;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Locale;

public class FwkException
extends RuntimeException
implements FwkExceptionInterface {
    public static final String version = "$Revision: 1.3 $";
    private int number;
    private String className;
    private String filename;
    private String codeVersion;
    private String ident;
    private String parameter;
    private Object sourceObject;
    private Throwable sourceThrowable;

    public String getVersion() {
        return version;
    }

    protected FwkException() {
        this.number = 0;
        this.className = "";
        this.codeVersion = "";
        this.ident = "HJB 2000-03-06 21:05";
        this.parameter = "";
        this.setSourceObject(null);
        this.setSourceThrowable(null);
    }

    public FwkException(int number, String filename, String revision, String ident, String parameter, Object srcObj, Throwable srcThr) {
        this.setNumber(number);
        this.setFilename(filename);
        if (srcObj != null) {
            this.setClassName(srcObj.getClass().getName());
        }
        this.setCodeVersion(revision);
        this.setIdent(ident);
        this.setParameter(parameter);
        this.setSourceObject(srcObj);
        this.setSourceThrowable(srcThr);
        this.write();
    }

    public void release() {
    }

    public FwkArrayInterface getFwkMimeTypes() {
        return FwkContainer.getFwkMimeTypes(this);
    }

    public String getPresentationString(Locale l) {
        return this.getParams();
    }

    public String getPresentationString() {
        return this.getPresentationString(FwkContainer.getLocale());
    }

    public void write() {
        FwkExceptionWriter.write(this);
    }

    public void setIdent(String newIdent) {
        this.ident = newIdent != null ? newIdent : "";
    }

    public String getIdent() {
        return this.ident;
    }

    public void setFilename(String newFilename) {
        this.filename = newFilename != null ? newFilename : "";
    }

    public String getFilename() {
        return this.filename;
    }

    public void setNumber(int number) {
        this.number = number == -1073741824 ? -1073676289 : (number == Integer.MIN_VALUE ? -2147418113 : (number == 0x40000000 ? 0x4000FFFF : number));
    }

    public int getNumber() {
        return this.number;
    }

    public void setClassName(String className) {
        this.className = className != null ? className : "";
    }

    public String getClassName() {
        return this.className;
    }

    public void setCodeVersion(String newVersion) {
        if (newVersion != null && newVersion != "") {
            this.codeVersion = newVersion;
        }
    }

    public String getCodeVersion() {
        return this.codeVersion;
    }

    public void setParameter(String newParameter) {
        this.parameter = newParameter != null ? newParameter : "";
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setSourceObject(Object srcObject) {
        this.sourceObject = srcObject;
    }

    public Object getSourceObject() {
        return this.sourceObject;
    }

    public void setSourceThrowable(Throwable srcThrowable) {
        this.sourceThrowable = srcThrowable;
    }

    public Throwable getSourceThrowable() {
        return this.sourceThrowable;
    }

    public String sourceThrowableToString() {
        String ret = "null";
        if (this.sourceThrowable != null) {
            if (this.sourceThrowable instanceof FwkException) {
                ret = this.sourceThrowable.toString();
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos);
                this.sourceThrowable.printStackTrace(ps);
                ret = "Stack trace:\n\t" + baos.toString();
            }
        }
        return ret;
    }

    public String getParams() {
        return "\n   Number         \t" + (this.number & 0x3FFFFFFF) + "\n   Code           \t" + ErrorNumber.getMessage(this.number) + "\n   ClassName      \t" + this.className + "\n   Filename       \t" + this.filename + "\n   CodeVersion    \t" + this.codeVersion + "\n   Ident          \t" + this.ident + "\n   Parameter      \t" + this.parameter + "\n   SourceObject   \t" + this.sourceObject + "\n   SourceThrowable\t" + this.sourceThrowableToString();
    }

    public String getMessage() {
        return "Code: " + ErrorNumber.getMessage(this.number) + " Id: " + this.ident + " " + this.parameter;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getParams() + "]";
    }
}

