/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkExecuteStateEvent;
import com.highqsoft.fwk.FwkOutputStreamApplication;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteOutputEventInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteOutputListenerInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateEventInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateListenerInterface;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class FwkExecuteCommand
extends FwkDescription
implements Runnable {
    public static final String version = "$Revision: 1.3 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    protected static StandardOutputListener standardOutputListener;
    protected Thread processReadThread = null;
    protected Process process;
    EventListenerList listeners;
    StringBuffer errBuffer;
    StringBuffer stdBuffer;
    StringBuffer lastErrBuffer;
    StringBuffer lastStdBuffer;
    int lastState;
    int exitValue;
    File workingDirectory;
    String[] arguments;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return descriptor;
    }

    public FwkExecuteCommand() {
        this.setDescriptor(descriptor);
        this.setName("");
        this.workingDirectory = new File(".");
        this.arguments = new String[0];
        this.lastState = 0;
        this.exitValue = 0;
        this.errBuffer = new StringBuffer();
        this.stdBuffer = new StringBuffer();
        this.lastErrBuffer = new StringBuffer();
        this.lastStdBuffer = new StringBuffer();
        this.listeners = new EventListenerList();
        this.process = null;
        this.addExecuteStateListener(new StateListener());
        this.addExecuteOutputListener(new OutputListener());
    }

    public FwkExecuteCommand(String command) {
        this();
        this.setName(command);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setWorkingDirectory(File dir) throws FileNotFoundException {
        if (dir != null) {
            if (!dir.exists()) throw new FileNotFoundException("Directory does not exist: " + dir.getAbsolutePath());
            this.workingDirectory = dir;
            return;
        } else {
            this.setWorkingDirectory(new File("."));
        }
    }

    public void setWorkingDirectory(String dir) throws FileNotFoundException {
        if (dir != null) {
            this.setWorkingDirectory(new File(dir));
        }
    }

    public File getWorkingDirectory() {
        return new File(this.workingDirectory.getAbsolutePath());
    }

    protected String[] getCmdArray() {
        String[] ret = new String[this.arguments.length + 1];
        ret[0] = this.getName();
        System.arraycopy(this.arguments, 0, ret, 1, this.arguments.length);
        return ret;
    }

    public void setArguments(String[] args) {
        if (args != null) {
            this.arguments = new String[args.length];
            for (int i = args.length - 1; i >= 0; --i) {
                this.arguments[i] = args[i];
            }
        } else {
            this.arguments = new String[0];
        }
    }

    public String[] getArguments() {
        if (this.arguments == null) {
            return new String[0];
        }
        String[] ret = new String[this.arguments.length];
        for (int i = this.arguments.length - 1; i >= 0; --i) {
            ret[i] = this.arguments[i];
        }
        return ret;
    }

    public void insertArgument(String arg, int index) {
        if (this.arguments == null || this.arguments.length == 0) {
            this.arguments = new String[1];
            this.arguments[0] = arg;
        } else {
            int i;
            if (index < 0) {
                index = 0;
            }
            if (index > this.arguments.length) {
                index = this.arguments.length;
            }
            String[] tmp = new String[this.arguments.length + 1];
            for (i = 0; i < index; ++i) {
                tmp[i] = this.arguments[i];
            }
            tmp[i] = arg;
            int size = this.arguments.length;
            ++i;
            while (i <= size) {
                tmp[i] = this.arguments[i - 1];
                ++i;
            }
            this.arguments = tmp;
        }
    }

    public void appendArgument(String arg) {
        this.insertArgument(arg, this.arguments.length);
    }

    public void removeArgument(String arg) {
        boolean found = false;
        int i = 0;
        int size = this.arguments.length;
        while (i < size && !found) {
            if (arg.compareTo(this.arguments[i]) == 0) {
                found = true;
                continue;
            }
            ++i;
        }
        if (found) {
            this.removeArgument(i);
        }
    }

    public void removeArgument(int index) {
        int i;
        if (index < 0 || index >= this.arguments.length) {
            return;
        }
        int size = this.arguments.length;
        String[] tmp = new String[this.arguments.length - 1];
        for (i = 0; i < index; ++i) {
            tmp[i] = this.arguments[i];
        }
        for (i = index + 1; i < size; ++i) {
            tmp[i - 1] = this.arguments[i];
        }
    }

    public void setOSCommand(String command) {
        this.setName(command);
    }

    public String getOSCommand() {
        return this.getName();
    }

    public String getCommandLine() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.getName());
        int size = this.arguments.length;
        for (int i = 0; i < size; ++i) {
            ret.append(" " + this.arguments[i]);
        }
        return ret.toString();
    }

    public int getState() {
        return this.lastState;
    }

    public String getOutputString() {
        return this.stdBuffer.toString();
    }

    public String getErrorString() {
        return this.errBuffer.toString();
    }

    public int getExitValue() throws IllegalThreadStateException {
        if (this.lastState != 0) {
            throw new IllegalThreadStateException("Command is currently running.");
        }
        return this.exitValue;
    }

    protected void execute() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readExecuteStreamContent() {
        if (this.process != null) {
            Process process = this.process;
            synchronized (process) {
                try {
                    this.lastErrBuffer.delete(0, this.lastErrBuffer.length());
                    this.lastStdBuffer.delete(0, this.lastStdBuffer.length());
                    InputStream is = this.process.getErrorStream();
                    while (is.available() > 0) {
                        this.lastErrBuffer.append((char)is.read());
                    }
                    if (this.lastErrBuffer.length() != 0 && this.errBuffer.length() == 0) {
                        this.fireStateEvent(5);
                    }
                    is = this.process.getInputStream();
                    while (is.available() > 0) {
                        this.lastStdBuffer.append((char)is.read());
                    }
                    if (this.lastStdBuffer.length() != 0 || this.lastErrBuffer.length() != 0) {
                        this.fireOutputEvent(this.lastStdBuffer.toString(), this.lastErrBuffer.toString());
                    }
                }
                catch (IOException ioex) {
                    this.printStackTrace(ioex);
                }
            }
        }
    }

    protected synchronized void printStackTrace(Throwable t) {
        this.fireStateEvent(5);
        this.lastErrBuffer.delete(0, this.lastErrBuffer.length());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        t.printStackTrace(ps);
        this.lastErrBuffer.append(baos.toString());
        this.lastErrBuffer.append(this.getStateString() + "\n");
        this.fireOutputEvent("", this.lastErrBuffer.toString());
    }

    public void run() {
        if (this.process == null) {
            try {
                this.process = Runtime.getRuntime().exec(this.getCmdArray(), null, this.workingDirectory);
                this.fireStateEvent(2);
            }
            catch (Throwable th) {
                this.printStackTrace(th);
            }
            Thread thisThread = Thread.currentThread();
            thisThread.setPriority(10);
            while (this.process != null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
                try {
                    this.exitValue = this.process.exitValue();
                    this.stop();
                }
                catch (Throwable t) {
                    this.readExecuteStreamContent();
                }
            }
        } else {
            throw new IllegalThreadStateException("Command is currently running.");
        }
        this.fireStateEvent(4);
        this.fireStateEvent(0);
    }

    protected void start() {
        this.fireStateEvent(1);
        if (this.processReadThread == null) {
            this.processReadThread = new Thread(this);
            this.errBuffer.delete(0, this.errBuffer.length());
            this.stdBuffer.delete(0, this.stdBuffer.length());
            this.processReadThread.start();
        }
    }

    protected void stop() {
        this.fireStateEvent(3);
        this.readExecuteStreamContent();
        this.processReadThread.interrupt();
        try {
            this.processReadThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.processReadThread = null;
        try {
            this.exitValue = this.process.exitValue();
            this.stop();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            this.process.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.process = null;
    }

    public void addStandardOutputListener() {
        this.addExecuteOutputListener(standardOutputListener);
    }

    public void removeStandardOutputListener() {
        this.removeExecuteOutputListener(standardOutputListener);
    }

    public void addExecuteStateListener(FwkExecuteStateListenerInterface listener) {
        listener.executeStateChanged(new FwkExecuteStateEvent(this, this.lastState));
        this.listeners.add(FwkExecuteStateListenerInterface.class, listener);
    }

    public void removeExecuteStateListener(FwkExecuteStateListenerInterface listener) {
        this.listeners.remove(FwkExecuteStateListenerInterface.class, listener);
    }

    public void addExecuteOutputListener(FwkExecuteOutputListenerInterface listener) {
        this.listeners.add(FwkExecuteOutputListenerInterface.class, listener);
    }

    public void removeExecuteOutputListener(FwkExecuteOutputListenerInterface listener) {
        this.listeners.remove(FwkExecuteOutputListenerInterface.class, listener);
    }

    protected synchronized void fireStateEvent(int state) {
        EventListener[] l = this.listeners.getListeners(FwkExecuteStateListenerInterface.class);
        int size = l.length;
        FwkExecuteStateEvent event = new FwkExecuteStateEvent(this, state);
        for (int i = 0; i < size; ++i) {
            ((FwkExecuteStateListenerInterface)l[i]).executeStateChanged(event);
        }
    }

    protected synchronized void fireOutputEvent(String outString, String errString) {
        EventListener[] l = this.listeners.getListeners(FwkExecuteOutputListenerInterface.class);
        int size = l.length;
        OutputEvent event = new OutputEvent(outString, errString);
        for (int i = 0; i < size; ++i) {
            ((FwkExecuteOutputListenerInterface)l[i]).executeOutput(event);
        }
    }

    public String getStateString() {
        String ret = "[" + this.lastState + "] ";
        switch (this.lastState) {
            case 0: {
                ret = ret + "READY ExitValue:" + this.exitValue;
                break;
            }
            case 1: {
                ret = ret + "WILL_START";
                break;
            }
            case 2: {
                ret = ret + "STARTED";
                break;
            }
            case 3: {
                ret = ret + "WILL_STOP";
                break;
            }
            case 4: {
                ret = ret + "STOPPED";
                break;
            }
            case 5: {
                ret = ret + "ERROR";
                break;
            }
            default: {
                ret = ret + "Unknown state";
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        FwkContainer.openFrame(FwkOutputStreamApplication.class.getName());
        FwkExecuteCommand command = new FwkExecuteCommand("dir");
        command.appendArgument("g:\\athos\\bin\\win32");
        System.out.println(command.getCommandLine());
        command.addStandardOutputListener();
        command.execute();
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("Class to execute OS commands.");
        descriptor.setTitleName("Fwk Execute Command");
        descriptor.setName("");
        descriptor.setCreationDate("$Date: 2005/01/04 08:10:21 $", null);
        standardOutputListener = new StandardOutputListener();
    }

    public static class StandardOutputListener
    implements FwkExecuteOutputListenerInterface {
        public String getVersion() {
            return FwkExecuteCommand.version;
        }

        public synchronized void executeOutput(FwkExecuteOutputEventInterface ev) {
            System.err.print(ev.getErrorString());
            System.out.print(ev.getOutputString());
        }

        public void release() {
        }
    }

    public class OutputListener
    implements FwkExecuteOutputListenerInterface {
        public String getVersion() {
            return FwkExecuteCommand.version;
        }

        public void executeOutput(FwkExecuteOutputEventInterface ev) {
            FwkExecuteCommand.this.stdBuffer.append(ev.getOutputString());
            FwkExecuteCommand.this.errBuffer.append(ev.getErrorString());
        }

        public void release() {
        }
    }

    public class StateListener
    implements FwkExecuteStateListenerInterface {
        public String getVersion() {
            return FwkExecuteCommand.version;
        }

        public void executeStateChanged(FwkExecuteStateEventInterface ev) {
            FwkExecuteCommand.this.lastState = ev.getState();
        }

        public void release() {
        }
    }

    public class OutputEvent
    implements FwkExecuteOutputEventInterface {
        String out;
        String err;

        public OutputEvent(String out, String err) {
            if (out == null) {
                out = "";
            }
            if (err == null) {
                err = "";
            }
            this.out = out;
            this.err = err;
        }

        public void release() {
        }

        public String getVersion() {
            return FwkExecuteCommand.version;
        }

        public Object getSource() {
            return FwkExecuteCommand.this;
        }

        public String getOutputString() {
            return this.out;
        }

        public String getErrorString() {
            return this.err;
        }
    }
}

