/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.interfaces.fwk.FwkComponentInterface;
import com.highqsoft.interfaces.fwk.FwkFileFilterInterface;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class FwkFileFilter
extends FileFilter
implements FwkComponentInterface,
FwkFileFilterInterface {
    public static final String version = "$Revision: 1.5 $";
    private Hashtable filters = new Hashtable();
    private String description = null;
    private String fullDescription = null;
    private String pattern = null;
    private boolean useExtensionsInDescription = true;

    public String getVersion() {
        return version;
    }

    public FwkFileFilter() {
    }

    public FwkFileFilter(String extension) {
        this(extension, null);
    }

    public FwkFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public FwkFileFilter(String[] filters) {
        this(filters, null);
    }

    public FwkFileFilter(String[] filters, String description) {
        this();
        for (int i = 0; i < filters.length; ++i) {
            this.addExtension(filters[i]);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public boolean accept(File f) {
        boolean ret = false;
        if (f != null) {
            if (f.isDirectory()) {
                ret = true;
            }
            if (this.pattern == null) {
                String extension = this.getExtension(f);
                if (extension != null && this.filters.get(this.getExtension(f)) != null) {
                    ret = true;
                }
            } else {
                ret = f.getName().matches(this.pattern);
            }
        }
        return ret;
    }

    public boolean accept(URL url) {
        return false;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        String ret = "";
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            ret = filename.substring(i + 1).toLowerCase();
        }
        return ret;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            StringBuffer ret = new StringBuffer();
            if (this.description == null || this.isExtensionListInDescription()) {
                ret.append(this.description == null ? "(" : this.description + " (");
                if (this.pattern == null) {
                    Enumeration extensions = this.filters.keys();
                    if (extensions != null) {
                        ret.append("*." + (String)extensions.nextElement());
                        while (extensions.hasMoreElements()) {
                            ret.append(", *." + (String)extensions.nextElement());
                        }
                    }
                } else {
                    ret.append(this.pattern);
                }
                ret.append(")");
                this.fullDescription = ret.toString();
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }
}

