/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkApplication;
import com.highqsoft.fwk.FwkApplicationBus;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPanel;
import com.highqsoft.fwk.FwkPersistence;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkRootPanel;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.fwk.listener.FwkActiveWindowListener;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import com.highqsoft.interfaces.fwk.FwkPanelInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyChangeListenerInterface;
import com.highqsoft.interfaces.fwk.FwkRootPanelInterface;
import com.highqsoft.interfaces.fwk.FwkWindowInterface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.swing.JFrame;

public class FwkFrame
extends JFrame
implements WindowListener,
FwkWindowInterface,
FwkPropertyChangeListenerInterface {
    public static final String version = "$Revision: 1.4 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    protected String[] args = null;
    protected String applicationClassName = null;
    protected FwkApplicationInterface application = null;
    protected FwkRootPanelInterface fwkRootPanel = new FwkRootPanel();
    protected FwkPersistence fwkPersistence;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return descriptor;
    }

    public FwkFrame() {
        this.getContentPane().add((Component)((Object)this.fwkRootPanel));
        this.applicationClassName = FwkApplication.class.getName();
        this.fwkPersistence = new FwkPersistence();
        this.setDescriptor(descriptor);
    }

    public void release() {
    }

    public FwkFrame(String className) {
        this();
        this.applicationClassName = className;
    }

    public FwkFrame(FwkApplicationInterface application) {
        this(application != null ? application.getClass().getName() : null);
        this.application = application;
    }

    public FwkRootPanelInterface getRootPanel() {
        return this.fwkRootPanel;
    }

    public boolean destroyController() {
        this.dispose();
        return true;
    }

    public FwkApplicationInterface getApplication() {
        return this.application;
    }

    public String getApplicationClassName() {
        return this.applicationClassName;
    }

    public String getApplicationName() {
        if (this.application != null) {
            return this.application.getName();
        }
        return null;
    }

    public String[] getArguments() {
        return this.args;
    }

    public URL getCodeBase() {
        URL url = null;
        try {
            String resourceName = this.getClass().getName();
            int pos = resourceName.lastIndexOf(".");
            if (pos != -1) {
                resourceName = resourceName.substring(pos + 1);
            }
            resourceName = resourceName + ".class";
            String resource = this.getClass().getResource(resourceName).toString();
            if (resource != null) {
                resource = resource.substring(0, resource.length() - resourceName.length());
            }
            url = new URL(resource);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return url;
    }

    public void init() {
        FwkContainer.initialize(this.getArguments());
    }

    public void setApplicationClassName(String className) {
        String old = this.applicationClassName;
        this.applicationClassName = className;
        if (old.compareTo(className) != 0) {
            this.firePropertyChange("ApplicationClassName", old, className);
        }
    }

    public void setArguments(String[] args) {
        this.args = args;
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    public void start() {
        String applicationName = this.getApplicationClassName();
        if (this.application == null) {
            try {
                this.application = (FwkApplicationInterface)FwkApplicationBus.loadClass(applicationName);
            }
            catch (Throwable th) {
                FwkContainer.showErrorMessage(FwkPropertyBus.getProperty("FwkContainer.Text.Error_Instantiation"), applicationName, th);
                new FwkException(-2147461547, "$RCSfile: FwkFrame.java,v $", version, "AH 2001-02-06 12:12", "Cannot instantiate class <" + applicationName + ">", this, th);
            }
        }
        if (this.application != null) {
            FwkIconInterface icon;
            this.application.setArguments(this.getArguments());
            this.application.init();
            FwkPanelInterface applicationPanel = this.application.getPanel();
            if (applicationPanel == null) {
                applicationPanel = new FwkPanel();
            }
            this.fwkRootPanel.setApplicationPanel(applicationPanel);
            FwkPanelInterface statusPanel = this.application.getStatusPanel();
            if (statusPanel == null) {
                statusPanel = new FwkPanel();
            }
            this.fwkRootPanel.setStatusPanel(statusPanel);
            FwkCommandInterface[] commands = this.application.getCommands();
            if (commands != null) {
                this.setJMenuBar(FwkGUIFactory.createMenuBar(commands));
                this.fwkRootPanel.setToolBar(commands);
            }
            if ((icon = this.application.getIcon(1)) == null) {
                icon = this.application.getIcon();
            }
            if (icon != null) {
                this.setIconImage(icon.getImage());
            }
            this.addWindowListener(this);
            this.application.setController(this);
            this.application.start();
        }
        int newHeight = this.getHeight();
        int newWidth = this.getWidth();
        int x = this.getX();
        int y = this.getY();
        String className = null;
        className = this.application != null ? this.application.getClass().getName() : this.getClass().getName();
        String basicName = FwkContainer.getBasicName(className);
        newWidth = FwkPropertyBus.getProperty(basicName + ".Width", -1);
        newHeight = FwkPropertyBus.getProperty(basicName + ".Height", -1);
        x = FwkPropertyBus.getProperty(basicName + ".X", -1);
        y = FwkPropertyBus.getProperty(basicName + ".Y", -1);
        this.pack();
        Dimension prefSize = this.getPreferredSize();
        if (newWidth < 0) {
            newWidth = prefSize.width;
        }
        if (newHeight < 0) {
            newHeight = prefSize.height;
        }
        Rectangle r = FwkActiveWindowListener.getPreferredRectangle(x, y, newWidth, newHeight);
        if (this.application != null) {
            this.setTitleName(this.application.getTitleName());
            this.application.addPropertyChangeListener("TitleName", this);
        } else {
            this.setTitleName(descriptor.getTitleName());
        }
        this.pack();
        this.setSize(new Dimension(r.width, r.height));
        this.setLocation(r.x, r.y);
        this.setVisible(true);
    }

    public void stop() {
        if (this.application != null) {
            this.application.stop();
        }
    }

    public String getAuthor() {
        return this.fwkPersistence.getAuthor();
    }

    public String getBuild() {
        return this.fwkPersistence.getBuild();
    }

    public String getCompany() {
        return this.fwkPersistence.getCompany();
    }

    public void setClassName(String className) {
        this.fwkPersistence.setClassName(className);
    }

    public String getClassName() {
        return this.fwkPersistence.getClassName();
    }

    public String getCompanyInternetAddress() {
        return this.fwkPersistence.getCompanyInternetAddress();
    }

    public String getCopyright() {
        return this.fwkPersistence.getCopyright();
    }

    public String getCreationDate() {
        return this.fwkPersistence.getCreationDate();
    }

    public String getCreationDate(String formatString) {
        return this.fwkPersistence.getCreationDate(formatString);
    }

    public String getDateFormatString() {
        return this.fwkPersistence.getDateFormatString();
    }

    public String getDescription() {
        return this.fwkPersistence.getDescription();
    }

    public FwkIconInterface getIcon() {
        return this.fwkPersistence.getIcon();
    }

    public FwkIconInterface getIcon(int type) {
        return this.fwkPersistence.getIcon(type);
    }

    public String getIconKey() {
        return this.fwkPersistence.getIconKey();
    }

    public String getIconKey(int type) {
        return this.fwkPersistence.getIconKey(type);
    }

    public String getName() {
        return this.fwkPersistence.getName();
    }

    public String getSupportEMail() {
        return this.fwkPersistence.getSupportEMail();
    }

    public String getTitleName() {
        return this.fwkPersistence.getTitleName();
    }

    public String getTitle() {
        return this.fwkPersistence.getTitle();
    }

    public void setAuthor(String author) {
        String old = this.fwkPersistence.getAuthor();
        this.fwkPersistence.setAuthor(author);
        this.firePropertyChange("Author", old, author);
    }

    public void setBuild(String buildnr) {
        String old = this.fwkPersistence.getBuild();
        this.fwkPersistence.setBuild(buildnr);
        this.firePropertyChange("Build", old, buildnr);
    }

    public void setCompany(String company) {
        String old = this.fwkPersistence.getCompany();
        this.fwkPersistence.setCompany(company);
        this.firePropertyChange("Company", old, company);
    }

    public void setCompanyInternetAddress(String address) {
        String old = this.fwkPersistence.getCompanyInternetAddress();
        this.fwkPersistence.setCompanyInternetAddress(address);
        this.firePropertyChange("Company", old, address);
    }

    public void setCreationDate(String dateString, String formatString) {
        String old = this.fwkPersistence.getCreationDate();
        this.fwkPersistence.setCreationDate(dateString, formatString);
        this.firePropertyChange("CreationDate", old, dateString);
    }

    public void setCreationDate(String dateString) {
        this.setCreationDate(dateString, null);
    }

    public void setDateFormatString(String formatString) {
        String old = this.fwkPersistence.getDateFormatString();
        this.fwkPersistence.setDateFormatString(formatString);
        this.firePropertyChange("DateFormatString", old, formatString);
    }

    public void setDescriptor(FwkDescriptionInterface descriptor) {
        this.fwkPersistence.setDescriptor(descriptor);
    }

    public void setCopyright(String copyright) {
        String old = this.fwkPersistence.getCopyright();
        this.fwkPersistence.setCopyright(copyright);
        this.firePropertyChange("Copyright", old, copyright);
    }

    public void setDescription(String description) {
        String old = this.fwkPersistence.getDescription();
        this.fwkPersistence.setDescription(description);
        this.firePropertyChange("Description", old, description);
    }

    public void setIcon(FwkIconInterface icon) {
        this.setIcon(icon, 0);
    }

    public void setIcon(FwkIconInterface icon, int type) {
        FwkIconInterface old = this.fwkPersistence.getIcon(type);
        this.fwkPersistence.setIcon(icon, type);
        this.firePropertyChange("Icon", old, icon);
    }

    public void setIconKey(String key) {
        this.setIconKey(key, 0);
    }

    public void setIconKey(String key, int type) {
        String old = this.fwkPersistence.getIconKey(type);
        this.fwkPersistence.setIconKey(key);
        this.firePropertyChange("IconKey", old, key);
    }

    public void setName(String name) {
        String old = this.fwkPersistence.getName();
        this.fwkPersistence.setName(name);
        this.firePropertyChange("Name", old, name);
    }

    public void setSupportEMail(String eMail) {
        String old = this.fwkPersistence.getSupportEMail();
        this.fwkPersistence.setSupportEMail(eMail);
        this.firePropertyChange("SupportEMail", old, eMail);
    }

    public void setTitleName(String name) {
        String old = this.fwkPersistence.getTitleName();
        this.fwkPersistence.setTitleName(name);
        this.setTitle(name);
        this.firePropertyChange("TitleName", old, name);
    }

    public String getPresentationString(Locale l) {
        return this.getDescription();
    }

    public String getPresentationString() {
        return this.getPresentationString(FwkContainer.getLocale());
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.fwkPersistence.getTransferDataFlavors();
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.fwkPersistence.isDataFlavorSupported(flavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return this.fwkPersistence.getTransferData(flavor);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void propertyChange(PropertyChangeEvent ev) {
        Object source = ev.getSource();
        if (source instanceof FwkApplicationInterface) {
            FwkApplicationInterface application = (FwkApplicationInterface)source;
            this.setTitleName(application.getTitleName());
            FwkIconInterface icon = application.getIcon(1);
            if (icon == null) {
                icon = application.getIcon();
            }
            if (icon != null) {
                this.setIconImage(icon.getImage());
            }
        }
    }

    public void windowOpened(WindowEvent ev) {
    }

    public void windowClosing(WindowEvent ev) {
        if (this.application != null) {
            this.application.exit();
        }
    }

    public void windowClosed(WindowEvent ev) {
    }

    public void windowIconified(WindowEvent ev) {
    }

    public void windowDeiconified(WindowEvent ev) {
    }

    public void windowActivated(WindowEvent ev) {
    }

    public void windowDeactivated(WindowEvent ev) {
    }

    public static void main(String[] args) {
        FwkFrame fwkFrame = new FwkFrame();
        fwkFrame.setArguments(args);
        fwkFrame.init();
        fwkFrame.start();
    }

    static {
        descriptor.setAuthor("Hans-Joachim Bothe");
        descriptor.setBuild(version);
        descriptor.setDescription("Fwk Default Frame");
        descriptor.setTitleName("FwkFrame.Text.Title");
        descriptor.setName(FwkFrame.class.getName());
        descriptor.setClassName(FwkFrame.class.getName());
        descriptor.setCreationDate("$Date: 2006/07/12 12:50:28 $", null);
    }
}

