/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.imageio.ImageIO;

public class FwkIcon
implements FwkIconInterface {
    public static final String version = "$Revision: 1.5 $";
    protected Image image;
    protected FwkIconInterface greyImage;
    protected String description;

    public String getVersion() {
        return version;
    }

    public FwkArrayInterface getFwkMimeTypes() {
        return FwkContainer.getMimeTypes(FwkIconInterface.class);
    }

    public FwkIcon(String filename, String description) {
        this();
        try {
            this.image = ImageIO.read(new File(filename));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.description = description;
    }

    public FwkIcon(String filename) {
        this(filename, filename);
    }

    public FwkIcon(URL location, String description) {
        this();
        try {
            this.image = ImageIO.read(location);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.description = description;
    }

    public FwkIcon(URL location) {
        this(location, location.toExternalForm());
    }

    public FwkIcon(Image image, String description) {
        this.image = image;
        this.description = description;
    }

    public FwkIcon(Image image) {
        this(image, "");
    }

    public FwkIcon(byte[] imageData, String description) {
        this();
        try {
            Toolkit kit = Toolkit.getDefaultToolkit();
            if (kit != null) {
                this.image = kit.createImage(imageData);
            }
            this.description = description;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public FwkIcon(byte[] imageData) {
        this(imageData, "");
    }

    public FwkIcon() {
        this.image = null;
        this.description = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FwkIconInterface scaleGrey() {
        if (this.getImage() != null && this.greyImage == null) {
            Image img = this.getImage();
            int w = this.getImage().getWidth(null);
            int h = this.getImage().getHeight(null);
            Image image = this.image;
            synchronized (image) {
                if (w > 0 && h > 0) {
                    BufferedImage ret = new BufferedImage(w, h, 6);
                    Graphics g = ret.getGraphics();
                    g.drawImage(img, 0, 0, null);
                    g.dispose();
                    for (int x = 0; x < w; ++x) {
                        for (int y = 0; y < h; ++y) {
                            int rgb = ret.getRGB(x, y);
                            int grey = ((rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF)) / 3;
                            grey = (rgb & 0xFF000000) + (grey << 16 | grey << 8 | grey);
                            ret.setRGB(x, y, grey);
                        }
                    }
                    this.greyImage = new FwkIcon(ret, this.description + "[grey scaled]");
                }
            }
        }
        return this.greyImage;
    }

    public String toString() {
        return "FwkIcon[" + this.hashCode() + "] " + this.description + ": " + this.image.toString();
    }

    public Image getImage() {
        return this.image;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.image != null) {
            g.drawImage(this.image, x, y, c);
        }
    }

    public int getIconHeight() {
        if (this.image != null) {
            return this.image.getHeight(null);
        }
        return 0;
    }

    public int getIconWidth() {
        if (this.image != null) {
            return this.image.getWidth(null);
        }
        return 0;
    }

    public void release() {
    }

    public String getPresentationString(Locale l) {
        return this.getClass().getName() + " [Revision: " + FwkContainer.getNiceVersion(version) + "]";
    }

    public String getPresentationString() {
        return this.getPresentationString(FwkContainer.getLocale());
    }
}

