/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkIconButtonModel;
import com.highqsoft.fwk.FwkIconButtonUI;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import com.highqsoft.interfaces.fwk.FwkInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class FwkIconButton
extends AbstractButton
implements FwkInterface,
ContainerListener,
PropertyChangeListener,
Accessible {
    public static final String version = "$Revision: 1.6 $";
    private static final String uiClassID = "FwkIconButtonUI";
    protected static final int MARGIN = 5;
    protected static final int MIN_SIZE = 20;
    int orientation = 0;

    public String getVersion() {
        return version;
    }

    public FwkArrayInterface getFwkMimeTypes() {
        return FwkContainer.getFwkMimeTypes(this);
    }

    public FwkIconButton() {
        this(null);
    }

    public FwkIconButton(FwkIconInterface icon) {
        try {
            FwkIconButtonModel m = new FwkIconButtonModel();
            this.setModel(m);
            this.addMouseListener(m);
            this.setRolloverEnabled(true);
            this.init(null, icon);
            this.setMargin(new Insets(5, 5, 5, 5));
            if (icon != null) {
                this.setPreferredSize(new Dimension(icon.getIconWidth() + 10, icon.getIconHeight() + 10));
            } else {
                this.setPreferredSize(new Dimension(4, 24));
            }
        }
        catch (Throwable t) {
            System.err.println("There is UI for FwkIconButton.");
        }
    }

    public void release() {
    }

    public void setSelectEnabled(boolean flag) {
        boolean oldValue = this.isSelectEnabled();
        ((FwkIconButtonModel)this.model).setSelectEnabled(flag);
        this.firePropertyChange("selectEnabled", oldValue, flag);
        if (flag != oldValue) {
            this.repaint();
        }
    }

    public boolean getSelectEnabled() {
        return ((FwkIconButtonModel)this.model).getSelectEnabled();
    }

    public Color getBackground() {
        if (this.getSelectEnabled()) {
            Color ret = super.getBackground();
            if (this.model.isSelected()) {
                int green = ret.getGreen() + 30;
                return new Color(ret.getRed(), green > 255 ? 255 : green, ret.getBlue());
            }
            return super.getBackground();
        }
        return super.getBackground();
    }

    public boolean isSelectEnabled() {
        return ((FwkIconButtonModel)this.model).isSelectEnabled();
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.model.setRollover(false);
    }

    protected void setOrientation(int val) {
        if (val != 0) {
            this.setPreferredSize(new Dimension(24, 4));
            this.orientation = 1;
        } else {
            this.setPreferredSize(new Dimension(4, 24));
            this.orientation = 0;
        }
    }

    public boolean hasIcon() {
        return this.getIcon() != null;
    }

    protected void paintBorder(Graphics g) {
        Graphics2D gr = (Graphics2D)g;
        gr.setColor(this.getBackground());
        if (this.hasIcon()) {
            if (this.model.isEnabled()) {
                if (this.model.isSelected()) {
                    gr.draw3DRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, this.model.isRollover());
                } else if (this.model.isRollover()) {
                    gr.draw3DRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, !this.model.isPressed() && !this.model.isArmed());
                }
            }
        } else {
            Rectangle rec = new Rectangle();
            g.getClipBounds(rec);
            if (this.orientation == 0) {
                int pos = rec.width / 2;
                gr.setColor(this.getBackground().darker());
                gr.drawLine(pos, rec.y, pos, rec.height);
                gr.setColor(this.getBackground().brighter());
                gr.drawLine(pos + 1, rec.y, pos + 1, rec.height);
            } else {
                int pos = rec.height / 2;
                gr.setColor(this.getBackground().darker());
                gr.drawLine(rec.x, pos, rec.width, pos);
                gr.setColor(this.getBackground().brighter());
                gr.drawLine(rec.x, pos + 1, rec.width, pos + 1);
            }
        }
    }

    public Dimension getMinimumSize() {
        Icon icon = this.getIcon();
        if (icon == null) {
            if (this.orientation == 0) {
                return new Dimension(new Dimension(4, 24));
            }
            return new Dimension(new Dimension(24, 4));
        }
        return new Dimension(10 + icon.getIconWidth(), 10 + icon.getIconHeight());
    }

    public void updateUI() {
        try {
            this.setUI((FwkIconButtonUI)UIManager.getUI(this));
        }
        catch (Throwable th) {
            System.out.println("AHAHAH: FwkIconButton.updateUI, th = " + th);
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleIconButton();
        }
        return this.accessibleContext;
    }

    public void componentAdded(ContainerEvent e) {
        if (this.equals(e.getChild()) && this.getIcon() == null && e.getContainer() instanceof JToolBar) {
            e.getContainer().addPropertyChangeListener("orientation", this);
        }
    }

    public void componentRemoved(ContainerEvent e) {
        if (this.equals(e.getChild()) && this.getIcon() == null && e.getContainer() instanceof JToolBar) {
            e.getContainer().removePropertyChangeListener(this);
            e.getContainer().removeContainerListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() instanceof JToolBar && e.getPropertyName().compareTo("orientation") == 0) {
            this.setOrientation(((JToolBar)e.getSource()).getOrientation());
        }
    }

    public String getParams() {
        return "";
    }

    public void setDefaults() {
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getParams() + "]";
    }

    protected class AccessibleIconButton
    extends AbstractButton.AccessibleAbstractButton {
        protected AccessibleIconButton() {
            super(FwkIconButton.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }
    }
}

