/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkAliasBus;
import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkMimeType;
import com.highqsoft.fwk.factory.FwkInfoBusConsumerFactory;
import com.highqsoft.interfaces.fwk.FwkAliasInterface;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkInfoBusConsumerInterface;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataConsumer;
import javax.infobus.InfoBusItemAvailableEvent;
import javax.infobus.InfoBusItemRevokedEvent;

public class FwkInfoBusConsumer
extends FwkMimeType
implements FwkInfoBusConsumerInterface {
    FwkControllerInterface controller;

    protected void finalize() throws Throwable {
        this.controller = null;
        super.finalize();
    }

    private FwkInfoBusConsumer() {
    }

    protected FwkInfoBusConsumer(String memberName, String[] mimeTypes) {
        super(mimeTypes);
        this.initialize(memberName);
    }

    protected FwkInfoBusConsumer(String memberName, FwkArrayInterface mimeTypes) {
        super(mimeTypes);
        this.initialize(memberName);
    }

    protected FwkInfoBusConsumer(String memberName, String mimeType) {
        super(mimeType);
        this.initialize(memberName);
    }

    public void release() {
        this.unregister();
        this.controller = null;
        super.release();
    }

    protected void initialize(String memberName) {
        this.controller = null;
        this.setMemberName(memberName);
        this.register();
    }

    public void unregister() {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            ib.removeDataConsumer((InfoBusDataConsumer)this);
        }
        FwkInfoBusConsumerFactory.getInstance().unregister(this);
    }

    public void register() {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            ib.addDataConsumer((InfoBusDataConsumer)this);
        }
        FwkInfoBusConsumerFactory.getInstance().register(this);
    }

    public FwkControllerInterface getController() {
        return this.controller;
    }

    public void setController(FwkControllerInterface controller) {
        if (this.controller == null || !this.controller.equals(controller)) {
            this.unregister();
            this.controller = controller;
            this.register();
        }
    }

    public boolean isAssignable(DataFlavor[] flavors) {
        boolean ret = false;
        int j = 0;
        DataFlavor[] dataFlavor = this.getDataFlavors();
        int size = dataFlavor.length;
        int len = flavors.length;
        for (int i = 0; i < size && !ret; ++i) {
            j = 0;
            while (j < len && !ret) {
                ret = flavors[j++].equals(dataFlavor[i]);
            }
        }
        return ret;
    }

    public void setInfoBusName(String newName) {
        this.unregister();
        super.setInfoBusName(newName);
        this.register();
    }

    public Object findDataItem(String dataItemName) {
        return this.findDataItem(dataItemName, this.getDataFlavors());
    }

    public Object findDataItem(String dataItemName, DataFlavor[] flavors) {
        Object ret = null;
        InfoBus ib = null;
        FwkAliasInterface alias = FwkAliasBus.unalias(dataItemName, flavors);
        if (alias != null) {
            ib = InfoBus.get((String)alias.getSourceBusName());
            if (ib != null) {
                ret = ib.findDataItem(alias.unalias(), flavors, (InfoBusDataConsumer)this);
            }
        } else {
            ib = this.getInfoBus();
            if (ib != null) {
                ret = ib.findDataItem(dataItemName, flavors, (InfoBusDataConsumer)this);
            }
        }
        return ret;
    }

    public Object[] findMultipleDataItems(String dataItemName) {
        return this.findMultipleDataItems(dataItemName, this.getDataFlavors());
    }

    public Object[] findMultipleDataItems(String dataItemName, DataFlavor[] flavors) {
        Object[] arr;
        Object[] ret = new Object[]{};
        InfoBus ib = this.getInfoBus();
        if (ib != null && (arr = ib.findMultipleDataItems(dataItemName, flavors, (InfoBusDataConsumer)this)) != null && arr.length != 0) {
            FwkArray rArr = new FwkArray();
            for (int i = arr.length - 1; i >= 0; --i) {
                if (arr[i] instanceof Object[]) {
                    Object[] sArr = (Object[])arr[i];
                    for (int j = sArr.length - 1; j >= 0; --j) {
                        rArr.add(sArr[j]);
                    }
                    continue;
                }
                rArr.add(arr[i]);
            }
            return rArr.toArray();
        }
        return ret;
    }

    public void dataItemRevoked(InfoBusItemRevokedEvent ev) {
        if ((FwkContainer.getTraceLevel() & 2L) != 0L) {
            FwkContainer.sendTrace(this, 2L, "Item <" + ev.getDataItemName() + "> revoked at " + this.getInfoBusName(), FwkContainer.getLocalHost(), FwkContainer.getUserName());
        }
    }

    public void dataItemAvailable(InfoBusItemAvailableEvent ev) {
        if ((FwkContainer.getTraceLevel() & 1L) != 0L) {
            FwkContainer.sendTrace(this, 1L, "Item <" + ev.getDataItemName() + "> available at " + this.getInfoBusName(), FwkContainer.getLocalHost(), FwkContainer.getUserName());
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
    }
}

