/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPort;
import com.highqsoft.fwk.factory.FwkInfoBusControllerFactory;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkControlledByInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkInfoBusControllerInterface;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataConsumer;
import javax.infobus.InfoBusDataController;
import javax.infobus.InfoBusDataProducer;

public class FwkInfoBusController
extends FwkPort
implements FwkInfoBusControllerInterface {
    public static final String version = "$Revision: 1.3 $";
    FwkControllerInterface controller;
    protected int priority;
    protected Hashtable consumerList;
    protected Hashtable producerList;

    public String getVersion() {
        return version;
    }

    protected void finalize() throws Throwable {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            ib.removeDataController((InfoBusDataController)this);
        }
        super.finalize();
    }

    protected FwkInfoBusController() {
    }

    public FwkInfoBusController(String memberName, int prio) {
        super(memberName);
        this.initialize(prio);
    }

    public FwkInfoBusController(String memberName, FwkArrayInterface mimeTypes, int prio) {
        super(memberName, mimeTypes, mimeTypes);
        this.initialize(prio);
    }

    public FwkInfoBusController(String memberName, String mimeType, int prio) {
        super(memberName, mimeType, mimeType);
        this.initialize(prio);
    }

    public FwkInfoBusController(String memberName, String[] mimeTypes, int prio) {
        super(memberName, mimeTypes, mimeTypes);
        this.initialize(prio);
    }

    protected void initialize(int prio) {
        this.consumerList = new Hashtable();
        this.producerList = new Hashtable();
        this.setPriority(prio);
        FwkInfoBusControllerFactory.getInstance().register(this);
    }

    public FwkControllerInterface getController() {
        return this.controller;
    }

    public void setController(FwkControllerInterface controller) {
        FwkControlledByInterface appl;
        this.controller = controller;
        Iterator it = this.consumerList.keySet().iterator();
        while (it.hasNext()) {
            appl = (FwkControlledByInterface)this.consumerList.get(it.next());
            if (controller.equals(appl.getController())) continue;
            this.consumerList.remove(appl);
        }
        it = this.producerList.keySet().iterator();
        while (it.hasNext()) {
            appl = (FwkControlledByInterface)this.producerList.get(it.next());
            if (controller.equals(appl.getController())) continue;
            this.producerList.remove(appl);
        }
    }

    public void setInfoBusName(String newName) {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            ib.removeDataController((InfoBusDataController)this);
        }
        super.setInfoBusName(newName);
        ib = this.getInfoBus();
        if (ib != null) {
            try {
                ib.addDataController((InfoBusDataController)this, this.priority);
            }
            catch (Throwable t) {
                throw new FwkException(Integer.MIN_VALUE, "$RCSfile: FwkInfoBusController.java,v $", version, "AH 1999-12-06 16:13", null, this, t);
            }
        }
    }

    public void setPriority(int prio) {
        if (prio != this.priority) {
            int old = this.priority;
            this.fireVetoableChange("Priority", old, prio);
            this.priority = prio;
            InfoBus ib = this.getInfoBus();
            if (ib != null) {
                ib.removeDataController((InfoBusDataController)this);
                try {
                    ib.addDataController((InfoBusDataController)this, this.priority);
                }
                catch (Throwable t) {
                    throw new FwkException(-1073741824, "$RCSfile: FwkInfoBusController.java,v $", version, "AH 1999-12-06 16:13", null, this, t);
                }
            }
            this.firePropertyChange("Priority", old, prio);
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void addDataConsumer(InfoBusDataConsumer consumer) throws FwkException {
        if (this.outAllowed != -1 && this.outAllowed <= this.consumerList.size()) {
            throw new FwkException(1073743324, "$RCSfile: FwkInfoBusController.java,v $", version, "AH 1999-12-07 11:42", "limit = " + this.outAllowed, this, null);
        }
        this.consumerList.put(consumer, consumer);
    }

    public void addDataProducer(InfoBusDataProducer producer) {
        if (this.inAllowed != -1 && this.inAllowed <= this.producerList.size()) {
            throw new FwkException(-1073741824, "$RCSfile: FwkInfoBusController.java,v $", version, "AH 1999-12-07 11:42", "limit = " + this.inAllowed, this, null);
        }
        this.producerList.put(producer, producer);
    }

    public void setConsumerList(Vector consumers) {
        int size = consumers.size();
        for (int i = 0; i < size; ++i) {
            this.addDataConsumer((InfoBusDataConsumer)consumers.get(i));
        }
    }

    public void setProducerList(Vector producers) {
        int size = producers.size();
        for (int i = 0; i < size; ++i) {
            this.addDataProducer((InfoBusDataProducer)producers.get(i));
        }
    }

    public void removeDataConsumer(InfoBusDataConsumer consumer) {
        this.consumerList.remove(consumer);
    }

    public void removeDataProducer(InfoBusDataProducer producer) {
        this.producerList.remove(producer);
    }

    public boolean fireItemRevoked(String dataItemName, InfoBusDataProducer producer) {
        InfoBus ib;
        InfoBusDataProducer p;
        if (this.consumerList.size() != 0 && this.producerList.size() != 0 && (p = (InfoBusDataProducer)this.producerList.get(producer)) != null && (ib = this.getInfoBus()) != null) {
            Vector c = new Vector(this.consumerList.values());
            ib.fireItemRevoked(dataItemName, producer, c);
            return true;
        }
        return false;
    }

    public boolean fireItemAvailable(String dataItemName, DataFlavor[] flavors, InfoBusDataProducer producer) {
        InfoBus ib;
        InfoBusDataProducer p;
        if (this.consumerList.size() != 0 && this.producerList.size() != 0 && (p = (InfoBusDataProducer)this.producerList.get(producer)) != null && (ib = this.getInfoBus()) != null) {
            Vector c = new Vector(this.consumerList.values());
            ib.fireItemAvailable(dataItemName, flavors, producer, c);
            return true;
        }
        return false;
    }

    public boolean findDataItem(String dataItemName, DataFlavor[] flavors, InfoBusDataConsumer consumer, Vector foundItem) {
        Vector p;
        Object o;
        InfoBus ib;
        InfoBusDataConsumer c;
        boolean ret = false;
        if (this.consumerList.size() != 0 && this.producerList.size() != 0 && (c = (InfoBusDataConsumer)this.consumerList.get(consumer)) != null && (ib = this.getInfoBus()) != null && (o = ib.findDataItem(dataItemName, flavors, consumer, p = new Vector(this.producerList.values()))) != null) {
            foundItem.add(o);
            ret = true;
        }
        return ret;
    }

    public boolean findMultipleDataItems(String dataItemName, DataFlavor[] flavors, InfoBusDataConsumer consumer, Vector foundItems) {
        InfoBus ib;
        InfoBusDataConsumer c;
        boolean ret = false;
        if (this.consumerList.size() != 0 && this.producerList.size() != 0 && (c = (InfoBusDataConsumer)this.consumerList.get(consumer)) != null && (ib = this.getInfoBus()) != null) {
            Vector p = new Vector(this.producerList.values());
            int size = p.size();
            for (int i = 0; i < size; ++i) {
                Object o = ib.findDataItem(dataItemName, flavors, consumer, (InfoBusDataProducer)p.get(i));
                if (o == null) continue;
                foundItems.add(o);
                ret = true;
            }
        }
        return ret;
    }

    public void propertyChange(PropertyChangeEvent ev) {
    }
}

