/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkItem;
import com.highqsoft.interfaces.fwk.FwkInfoBusMemberInterface;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusMemberSupport;
import javax.infobus.InfoBusMembershipException;

public class FwkInfoBusMember
extends FwkItem
implements FwkInfoBusMemberInterface {
    public static final String version = "$Revision: 1.3 $";
    protected InfoBusMemberSupport infoBusMemberSupport;

    public String getVersion() {
        return version;
    }

    protected void finalize() throws Throwable {
        this.infoBusMemberSupport.leaveInfoBus();
        super.finalize();
    }

    public FwkInfoBusMember() {
        this("");
    }

    public FwkInfoBusMember(String memberName) {
        if (this.infoBusMemberSupport == null) {
            this.infoBusMemberSupport = new InfoBusMemberSupport();
        }
        if (memberName != null && memberName.length() != 0) {
            this.setMemberName(memberName);
        }
    }

    public String getMemberName() {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            return this.getName() + "@" + ib.getName();
        }
        return this.getName() + "@<none>";
    }

    public synchronized void setMemberName(String dataItemName) throws FwkException {
        String old = this.getMemberName();
        this.fireVetoableChange("MemberName", old, dataItemName);
        int idx = dataItemName.lastIndexOf(64);
        String infoBusName = "";
        String name = dataItemName;
        if (idx > 0 && idx < dataItemName.length() - 2) {
            infoBusName = dataItemName.substring(idx + 1).trim();
            name = dataItemName.substring(0, idx).trim();
        }
        if (infoBusName.length() != 0 && name.length() != 0) {
            this.setName(name);
            try {
                this.setInfoBusName(infoBusName);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new FwkException(-2147460648, "FwkInfoBusMember.java", this.getVersion(), "AH 1999-12-04 16:32", infoBusName, this, t);
            }
        }
        if (name.length() == 0) {
            throw new FwkException(-2147462348, "FwkInfoBusMember.java", this.getVersion(), "AH 1999-12-04 16:26", dataItemName, this, null);
        }
        this.setName(name);
        this.firePropertyChange("MemberName", old, this.getMemberName());
    }

    public void joinInfoBus(String infoBusName) throws FwkException {
        if (infoBusName == null || infoBusName.length() == 0) {
            infoBusName = "<none>";
        }
        try {
            this.infoBusMemberSupport.leaveInfoBus();
        }
        catch (PropertyVetoException pve) {
            throw new FwkException(-2147460645, "$RCSfile: FwkInfoBusMember.java,v $", this.getVersion(), "AH 1999-14-04 11:30", this.getInfoBus().getName(), this, pve);
        }
        catch (InfoBusMembershipException ime) {
            // empty catch block
        }
        if (infoBusName.compareTo("<none>") != 0) {
            try {
                this.infoBusMemberSupport.joinInfoBus(infoBusName);
            }
            catch (Throwable t) {
                throw new FwkException(-2147460648, "$RCSfile: FwkInfoBusMember.java,v $", this.getVersion(), "AH 1999-12-04 16:24", infoBusName, this, t);
            }
        }
    }

    public boolean isConnected() {
        return this.getInfoBus() != null;
    }

    public String getInfoBusName() {
        InfoBus ib;
        if (this.infoBusMemberSupport == null) {
            this.infoBusMemberSupport = new InfoBusMemberSupport();
        }
        if ((ib = this.infoBusMemberSupport.getInfoBus()) != null) {
            return ib.getName();
        }
        return "<none>";
    }

    public void setInfoBusName(String newName) {
        String old = this.getInfoBusName();
        String oldMemberName = this.getMemberName();
        this.fireVetoableChange("InfoBusName", old, newName);
        this.joinInfoBus(newName);
        this.firePropertyChange("InfoBusName", old, newName);
        this.firePropertyChange("MemberName", oldMemberName, this.getMemberName());
    }

    public void setName(String newName) {
        String oldMemberName = this.getMemberName();
        super.setName(newName);
        this.firePropertyChange("MemberName", oldMemberName, this.getMemberName());
    }

    public void addInfoBusPropertyListener(PropertyChangeListener pcl) {
        this.infoBusMemberSupport.addInfoBusPropertyListener(pcl);
    }

    public void addInfoBusVetoableListener(VetoableChangeListener vcl) {
        this.infoBusMemberSupport.addInfoBusVetoableListener(vcl);
    }

    public InfoBus getInfoBus() {
        if (this.infoBusMemberSupport != null) {
            return this.infoBusMemberSupport.getInfoBus();
        }
        return null;
    }

    public void removeInfoBusPropertyListener(PropertyChangeListener pcl) {
        this.infoBusMemberSupport.removeInfoBusPropertyListener(pcl);
    }

    public void removeInfoBusVetoableListener(VetoableChangeListener vcl) {
        this.infoBusMemberSupport.removeInfoBusVetoableListener(vcl);
    }

    public void setInfoBus(InfoBus newInfoBus) throws PropertyVetoException {
        this.infoBusMemberSupport.setInfoBus(newInfoBus);
    }
}

