/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkMimeType;
import com.highqsoft.fwk.factory.FwkInfoBusProducerFactory;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkInfoBusProducerInterface;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import javax.infobus.DataItem;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataConsumer;
import javax.infobus.InfoBusDataProducer;
import javax.infobus.InfoBusItemAvailableEvent;
import javax.infobus.InfoBusItemRequestedEvent;
import javax.infobus.InfoBusItemRevokedEvent;
import javax.infobus.InfoBusMemberSupport;

public abstract class FwkInfoBusProducer
extends FwkMimeType
implements FwkInfoBusProducerInterface {
    FwkControllerInterface controller;

    protected void finalize() throws Throwable {
        this.unregister();
        super.finalize();
    }

    protected FwkInfoBusProducer() {
    }

    protected FwkInfoBusProducer(String memberName, String[] mimeTypes) {
        super(mimeTypes);
        this.initialize(memberName);
    }

    protected FwkInfoBusProducer(String memberName, FwkArrayInterface mimeTypes) {
        super(mimeTypes);
        this.initialize(memberName);
    }

    protected FwkInfoBusProducer(String memberName, String mimeType) {
        super(mimeType);
        this.initialize(memberName);
    }

    public void release() {
        this.unregister();
        this.controller = null;
        super.release();
    }

    protected void initialize(String memberName) {
        this.controller = null;
        this.setMemberName(memberName);
        this.register();
    }

    public FwkControllerInterface getController() {
        return this.controller;
    }

    public void setController(FwkControllerInterface controller) {
        if (this.controller == null || !this.controller.equals(controller)) {
            this.unregister();
            this.controller = controller;
            this.register();
        }
    }

    public static boolean isAssignable(DataFlavor[] flavors1, DataFlavor[] flavors2) {
        boolean ret = false;
        if (flavors1 != null && flavors2 != null) {
            int j = 0;
            int size = flavors1.length;
            int len = flavors2.length;
            for (int i = 0; i < size && !ret; ++i) {
                j = 0;
                while (j < len && !ret) {
                    ret = flavors2[j++].equals(flavors1[i]);
                }
            }
        }
        return ret;
    }

    public boolean isAssignable(DataFlavor[] flavors) {
        return FwkInfoBusProducer.isAssignable(flavors, this.getDataFlavors());
    }

    public abstract boolean revoke(String var1, DataFlavor[] var2);

    public void fireItemAvailable(DataItem item, DataFlavor[] flavor) {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            try {
                Method m = item.getClass().getMethod("fireItemAvailable", null);
                m.invoke((Object)item, null);
            }
            catch (Throwable t) {
                // empty catch block
            }
            ib.fireItemAvailable((String)item.getProperty("Name"), flavor, (InfoBusDataProducer)this);
        }
    }

    public void fireItemRevoked(DataItem item) {
        if (item != null) {
            InfoBus ib = this.getInfoBus();
            try {
                Method m = item.getClass().getMethod("fireItemRevoked", null);
                m.invoke((Object)item, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (ib != null) {
                ib.fireItemRevoked((String)item.getProperty("Name"), (InfoBusDataProducer)this);
            }
        }
    }

    public Object findDataItem(String dataItemName) {
        return this.findDataItem(dataItemName, this.getDataFlavors());
    }

    public Object findDataItem(String dataItemName, DataFlavor[] flavors) {
        Object ret = null;
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            FwkInfoBusProducerConsumer consumer = new FwkInfoBusProducerConsumer();
            ib.addDataConsumer((InfoBusDataConsumer)consumer);
            ret = ib.findDataItem(dataItemName, flavors, (InfoBusDataConsumer)consumer);
            ib.removeDataConsumer((InfoBusDataConsumer)consumer);
        }
        return ret;
    }

    public Object[] findMultipleDataItems(String dataItemName) {
        return this.findMultipleDataItems(dataItemName, this.getDataFlavors());
    }

    public Object[] findMultipleDataItems(String dataItemName, DataFlavor[] flavors) {
        Object[] ret = new Object[]{};
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            FwkInfoBusProducerConsumer consumer = new FwkInfoBusProducerConsumer();
            ib.addDataConsumer((InfoBusDataConsumer)consumer);
            ret = ib.findMultipleDataItems(dataItemName, flavors, (InfoBusDataConsumer)consumer);
            if (ret != null && ret.length != 0) {
                FwkArray arr = new FwkArray();
                for (int i = ret.length - 1; i >= 0; --i) {
                    if (ret instanceof Object[]) {
                        Object[] tmp = (Object[])ret[i];
                        for (int j = tmp.length - 1; j >= 0; --j) {
                            arr.add(tmp[j]);
                        }
                        continue;
                    }
                    arr.add(ret[i]);
                }
                ret = arr.toArray();
            }
            ib.removeDataConsumer((InfoBusDataConsumer)consumer);
        }
        return ret;
    }

    public void unregister() {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            ib.removeDataProducer((InfoBusDataProducer)this);
        }
        FwkInfoBusProducerFactory.getInstance().unregister(this);
    }

    public void register() {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            ib.addDataProducer((InfoBusDataProducer)this);
        }
        FwkInfoBusProducerFactory.getInstance().register(this);
    }

    public void setInfoBusName(String newName) {
        this.unregister();
        super.setInfoBusName(newName);
        this.register();
    }

    public void dataItemRequested(InfoBusItemRequestedEvent ev) {
        if (ev.getDataItem() == null) {
            DataFlavor[] flavor;
            if ((FwkContainer.getTraceLevel() & 4L) != 0L) {
                FwkContainer.sendTrace(this, 4L, "Item <" + ev.getDataItemName() + "> requested at " + this.getInfoBusName(), FwkContainer.getLocalHost(), FwkContainer.getUserName());
            }
            if ((flavor = ev.getDataFlavors()) != null) {
                for (int i = flavor.length - 1; i >= 0; --i) {
                    if (flavor[i].getMimeType().compareTo(FWKMIMETYPE) != 0) continue;
                    ev.setDataItem((Object)this);
                    return;
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        this.firePropertyChange(ev);
    }

    class FwkInfoBusProducerConsumer
    extends InfoBusMemberSupport
    implements InfoBusDataConsumer {
        public void dataItemAvailable(InfoBusItemAvailableEvent event) {
        }

        public void dataItemRevoked(InfoBusItemRevokedEvent event) {
        }

        public void propertyChange(PropertyChangeEvent event) {
        }
    }
}

