/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkPresentation;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkInstructionInterface;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class FwkInstruction
extends FwkPresentation
implements FwkInstructionInterface {
    public static final String version = "$Revision: 1.2 $";
    protected FwkArrayInterface commands;
    protected HashMap groups;
    protected static FwkCommandInterface[] fwkCommandTemplate = new FwkCommand[0];

    public String getVersion() {
        return version;
    }

    public void release() {
        if (this.commands != null) {
            this.commands.clear();
        }
        this.commands = null;
        if (this.groups != null) {
            this.groups.clear();
        }
        this.groups = null;
        super.release();
    }

    public void addCommand(FwkCommandInterface command) {
        if (this.commands == null) {
            this.commands = new FwkArray();
        }
        if (command != null) {
            this.commands.add(command);
        }
    }

    public void addCommand(int index, FwkCommandInterface command) {
        if (this.commands == null) {
            this.commands = new FwkArray();
        }
        if (command != null) {
            if (index >= 0 && index < this.commands.size()) {
                this.commands.add(index, command);
            } else if (index < 0) {
                this.commands.add(0, command);
            } else {
                this.addCommand(command);
            }
        }
    }

    public FwkCommandInterface getCommand(String commandName) {
        FwkCommandInterface ret = null;
        if (this.commands != null) {
            int i = 0;
            int size = this.commands.size();
            FwkCommandInterface cmd = null;
            while (ret == null && i < size) {
                if ((cmd = (FwkCommandInterface)this.commands.get(i++)) == null) continue;
                String name = cmd.getCommandName();
                if (name != null && name.compareTo(commandName) == 0) {
                    ret = cmd;
                    continue;
                }
                ret = cmd.getCommand(commandName);
            }
        }
        return ret;
    }

    public FwkCommandInterface[] getCommands() {
        return this.commands != null ? this.commands.toArray(fwkCommandTemplate) : null;
    }

    public synchronized void removeCommand(FwkCommandInterface command) {
        if (this.commands != null) {
            this.commands.remove(command);
        }
    }

    public void setCommands(FwkCommandInterface[] commandArray) {
        this.commands = commandArray != null ? new FwkArray(Arrays.asList(commandArray)) : null;
    }

    public boolean commandsAvailable() {
        return this.commands != null && this.commands.size() != 0;
    }

    public void clearCommands() {
        if (this.commandsAvailable()) {
            this.commands.clear();
            if (this.groups != null) {
                this.groups.clear();
            }
        }
    }

    public void addToGroup(int index, String groupIdent, String commandName) {
        FwkArray group;
        if (this.groups == null) {
            this.groups = new HashMap();
        }
        if ((group = (FwkArray)this.groups.get(groupIdent)) == null) {
            group = new FwkArray();
            this.groups.put(groupIdent, group);
        }
        if (index >= 0 && index < group.size()) {
            group.add(index, commandName);
        } else if (index < 0) {
            group.add(0, commandName);
        } else {
            group.add(commandName);
        }
    }

    public void addToGroup(String groupIdent, String commandName) {
        FwkArray group;
        if (this.groups == null) {
            this.groups = new HashMap();
        }
        if ((group = (FwkArray)this.groups.get(groupIdent)) == null) {
            group = new FwkArray();
            this.groups.put(groupIdent, group);
        }
        group.add(commandName);
    }

    public void removeFromGroup(String groupIdent, String commandName) {
        FwkArray group;
        if (this.groups != null && (group = (FwkArray)this.groups.get(groupIdent)) != null) {
            group.remove(commandName);
        }
    }

    public void deleteGroup(String groupIdent) {
        if (this.groups != null) {
            this.groups.remove(groupIdent);
        }
    }

    public FwkCommandInterface[] getGroup(String groupIdent) {
        FwkArray group;
        List ret = null;
        if (this.groups != null && (group = (FwkArray)this.groups.get(groupIdent)) != null) {
            ret = new FwkArray();
            int size = group.size();
            for (int i = 0; i < size; ++i) {
                String commandName = (String)group.get(i);
                FwkCommandInterface cmd = this.getCommand(commandName);
                if (cmd == null) continue;
                ret.add(cmd);
            }
            if (ret.size() == 0) {
                ret = null;
            }
        }
        return ret != null ? ret.toArray(fwkCommandTemplate) : null;
    }

    public boolean groupExists(String groupIdent) {
        return this.groups != null && this.groups.get(groupIdent) != null;
    }
}

