/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkPersistence;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkPropertyGroup;
import com.highqsoft.interfaces.fwk.FwkItemInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyGroupInterface;
import java.util.Enumeration;
import javax.infobus.DataItemChangeListener;
import javax.infobus.DataItemChangeManagerSupport;
import javax.infobus.InfoBusEventListener;

public class FwkItem
extends FwkPersistence
implements FwkItemInterface {
    public static final String version = "$Revision: 1.7 $";
    protected FwkPropertyGroup properties = null;
    protected boolean suspendChangeManager = false;
    static final Object LOCK = new Object();
    protected transient DataItemChangeManagerSupport changeManager;

    public String getVersion() {
        return version;
    }

    public FwkItem() {
        this.setName(this.getClass().getName());
        this.changeManager = new DataItemChangeManagerSupport((Object)this);
    }

    public FwkItem(String itemName) {
        this();
        this.setName(itemName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String key) {
        Object object = LOCK;
        synchronized (object) {
            String ret = null;
            if (key.compareTo("Name") == 0) {
                ret = this.getName();
            }
            if (ret == null) {
                if (this.properties != null) {
                    ret = this.properties.getProperty(key, (String)null);
                }
                if (ret == null) {
                    ret = FwkPropertyBus.getProperty(key, key);
                }
            }
            return ret;
        }
    }

    public FwkPropertyGroupInterface getPropertyGroup(String groupName) {
        FwkPropertyGroupInterface ret = null;
        if (this.properties != null) {
            ret = this.properties.getGroup(groupName);
        }
        if (ret == null) {
            ret = FwkPropertyBus.getPropertyGroup(groupName);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String key, Object value) {
        Object object = LOCK;
        synchronized (object) {
            if (this.properties == null) {
                this.properties = new FwkPropertyGroup();
            }
            Object old = this.properties.get(key);
            this.fireVetoableChange("Property" + key, old, value);
            this.properties.put((Object)key, value);
            this.firePropertyChange("Property" + key, old, value);
        }
    }

    public void setPropertyGroup(FwkPropertyGroupInterface group) {
        Enumeration e = group.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.setProperty(key, group.getProperty(key));
        }
    }

    public void suspendChangeManager(boolean flag) {
        if (flag != this.suspendChangeManager) {
            boolean old = !flag;
            this.fireVetoableChange("SuspendChangeManager", old, flag);
            this.suspendChangeManager = flag;
            this.firePropertyChange("SuspendChangeManager", old, flag);
            if (!flag) {
                this.changeManager.fireItemValueChanged((Object)this, null);
            }
        }
    }

    public boolean isChangeManagerSuspended() {
        return this.suspendChangeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Object object = LOCK;
        synchronized (object) {
            return super.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        Object object = LOCK;
        synchronized (object) {
            String curName;
            if (this.properties == null) {
                this.properties = new FwkPropertyGroup();
            }
            if ((curName = this.getName()) != null) {
                if (curName.compareTo(name) != 0) {
                    super.setName(name);
                }
                this.properties.setName(name);
            } else {
                super.setName(name);
                this.properties.setName(name);
            }
        }
    }

    public void release() {
        this.changeManager.removeAllListeners();
        super.release();
    }

    public InfoBusEventListener getSource() {
        try {
            Object val = this.getProperty("InfoBusSource");
            if (val != null && val instanceof InfoBusEventListener) {
                return (InfoBusEventListener)val;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public void addDataItemChangeListener(DataItemChangeListener listener) {
        this.changeManager.addDataItemChangeListener(listener);
    }

    public void removeDataItemChangeListener(DataItemChangeListener listener) {
        this.changeManager.removeDataItemChangeListener(listener);
    }

    public void fireItemAdded() {
        if (!this.suspendChangeManager) {
            this.changeManager.fireItemAdded((Object)this.getName(), null, null);
        }
    }

    public void fireItemDeleted() {
        if (!this.suspendChangeManager) {
            this.changeManager.fireItemDeleted((Object)this.getName(), null, null);
        }
    }

    public void fireItemRevoked() {
        if (!this.suspendChangeManager) {
            this.changeManager.fireItemRevoked((Object)this.getName(), null);
        }
    }

    public void fireItemValueChanged() {
        if (!this.suspendChangeManager) {
            this.changeManager.fireItemValueChanged((Object)this, null);
        }
    }
}

