/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkApplication;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkPanel;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.fwk.listener.FwkListener;
import com.highqsoft.fwk.listener.FwkPopupMenuUnregisterListener;
import com.highqsoft.interfaces.fwk.FwkCommandActionInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkHasOutputStreamInterface;
import com.highqsoft.interfaces.fwk.FwkPanelInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.PanelUI;

public class FwkOutputStreamApplication
extends FwkApplication
implements FwkHasOutputStreamInterface {
    public static final String version = "$Revision: 1.4 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    OutputPanel outPanel;
    JScrollPane jScrollPane = null;
    PrintStream sysOut = null;
    PrintStream sysErr = null;
    HashMap outputStreams = new HashMap();
    protected static final Object TEXTLOCK;
    protected static final Object DRAWLOCK;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return descriptor;
    }

    public FwkOutputStreamApplication() {
        this.outputStreams.put(Color.black, new TextAreaOutputStream(Color.black));
        this.outputStreams.put(Color.blue, new TextAreaOutputStream(Color.blue));
        this.outputStreams.put(Color.cyan, new TextAreaOutputStream(Color.cyan));
        this.outputStreams.put(Color.darkGray, new TextAreaOutputStream(Color.darkGray));
        this.outputStreams.put(Color.gray, new TextAreaOutputStream(Color.gray));
        this.outputStreams.put(Color.green, new TextAreaOutputStream(Color.green));
        this.outputStreams.put(Color.lightGray, new TextAreaOutputStream(Color.lightGray));
        this.outputStreams.put(Color.magenta, new TextAreaOutputStream(Color.magenta));
        this.outputStreams.put(Color.orange, new TextAreaOutputStream(Color.orange));
        this.outputStreams.put(Color.pink, new TextAreaOutputStream(Color.pink));
        this.outputStreams.put(Color.red, new TextAreaOutputStream(Color.red));
        this.outputStreams.put(Color.white, new TextAreaOutputStream(Color.white));
        this.outputStreams.put(Color.yellow, new TextAreaOutputStream(Color.yellow));
        this.sysOut = System.out;
        this.sysErr = System.err;
        System.setOut(new PrintStream((OutputStream)this.outputStreams.get(Color.black)));
        System.setErr(new PrintStream((OutputStream)this.outputStreams.get(Color.red)));
        this.setDescriptor(descriptor);
        this.setEternal(true);
        this.register();
    }

    public void run() {
    }

    public boolean exit() {
        boolean ret = super.exit();
        if (ret) {
            System.setErr(this.sysErr);
            System.setOut(this.sysOut);
        }
        return ret;
    }

    public FwkCommandInterface[] getCommands() {
        if (!this.commandsAvailable()) {
            int menuPos = 0;
            FwkCommand parent = new FwkCommand(this);
            parent.setTextKey("Text.Edit");
            parent.setCommandName("Edit");
            this.addCommand(menuPos++, parent);
            FwkCommand cmd1 = new FwkCommand(this);
            cmd1.setTextKey("Text.Paste");
            cmd1.setCommandName("Paste");
            cmd1.setIconKey("Icon.Paste");
            cmd1.setToolBarEnabled(true);
            cmd1.addActionListener(new CopyFromClipboardListener());
            parent.addCommand(cmd1);
        }
        return super.getCommands();
    }

    public FwkPanelInterface getPanel() {
        if (this.panel == null) {
            this.panel = new FwkPanel();
            ((JPanel)((Object)this.panel)).setPreferredSize(new Dimension(400, 100));
            ((JPanel)((Object)this.panel)).setLayout(new BorderLayout());
            this.outPanel = new OutputPanel();
            this.outPanel.jScrollPane = this.jScrollPane = new JScrollPane(this.outPanel);
            ((JPanel)((Object)this.panel)).add((Component)this.jScrollPane, "Center");
            Iterator it = this.outputStreams.keySet().iterator();
            while (it.hasNext()) {
                ((TextAreaOutputStream)this.outputStreams.get(it.next())).setPanel(this.outPanel);
            }
        }
        return this.panel;
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        FwkContainer.openFrame(FwkOutputStreamApplication.class.getName());
        System.out.println(FwkOutputStreamApplication.getDescriptor());
        System.err.println("This is an error message");
        System.out.println("the author");
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("The output stream stream application");
        descriptor.setTitleName("FwkOutputStreamApplication.Text.Title");
        descriptor.setName(FwkOutputStreamApplication.class.getName());
        descriptor.setIconKey("Icon.OutputStream");
        descriptor.setCreationDate("$Date: 2007/06/12 09:10:15 $", null);
        TEXTLOCK = new Object();
        DRAWLOCK = new Object();
    }

    class CopyFromClipboard
    extends Thread {
        Object obj;

        public CopyFromClipboard(Object obj) {
            this.obj = obj;
        }

        public void run() {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            try {
                StringSelection selection = (StringSelection)clipboard.getContents(this.obj);
                String out = (String)selection.getTransferData(DataFlavor.stringFlavor);
                OutputStream oStream = (OutputStream)FwkOutputStreamApplication.this.outputStreams.get(Color.cyan);
                oStream.write(out.getBytes());
                oStream.write("\n".getBytes());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public class CopyFromClipboardListener
    extends FwkListener
    implements FwkCommandActionInterface,
    ActionListener {
        public static final String version = "$Revision: 1.4 $";

        public String getVersion() {
            return "$Revision: 1.4 $";
        }

        private CopyFromClipboardListener() {
        }

        public void actionPerformed(ActionEvent ev) {
            if (ev == null) {
                return;
            }
            CopyFromClipboard ctc = new CopyFromClipboard(FwkContainer.getController((JComponent)ev.getSource()));
            ctc.run();
        }

        public void actionPerformed(FwkCommandInterface cmd) {
            if (cmd == null) {
                return;
            }
            CopyFromClipboard ctc = new CopyFromClipboard(cmd.getController());
            ctc.run();
        }
    }

    public class OutputPanelMouseListener
    extends MouseInputAdapter {
        public void mouseClicked(MouseEvent e) {
            FwkCommandInterface[] arr;
            JPopupMenu popup;
            if (e.getClickCount() == 1 && e.getModifiers() == 4 && (popup = FwkGUIFactory.createPopupMenu(arr = FwkOutputStreamApplication.this.getCommands())) != null) {
                popup.addPopupMenuListener(FwkPopupMenuUnregisterListener.getInstance());
                popup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }

    public class OutputPanelUI
    extends PanelUI {
        public void paint(Graphics gr, JComponent component) {
            Graphics2D g = (Graphics2D)gr.create();
            super.paint(g, component);
            OutputPanel panel = (OutputPanel)component;
            Font font = component.getFont();
            TextLayout layout = new TextLayout(this.getClass().getName(), font, g.getFontRenderContext());
            int lineDist = (int)(layout.getAscent() + layout.getDescent() + layout.getLeading());
            Rectangle bounds = g.getClipBounds();
            int start = bounds.y / lineDist;
            int end = start + bounds.height / lineDist + 1;
            if (start > 1) {
                --start;
            }
            Vector text = panel.getTextVector();
            Vector colors = panel.getColorVector();
            int size = text.size();
            int curY = start * lineDist;
            int width = 0;
            for (int i = start; i < size && i <= end; ++i) {
                g.setColor((Color)colors.get(i));
                layout = new TextLayout((String)text.get(i), font, g.getFontRenderContext());
                curY = (int)((float)curY + layout.getAscent());
                if (layout.getAdvance() > (float)width) {
                    width = (int)layout.getAdvance();
                }
                layout.draw(g, 0.0f, curY);
                curY = (int)((float)curY + (layout.getDescent() + layout.getLeading()));
            }
            g.dispose();
        }
    }

    public class OutputPanel
    extends JPanel {
        Vector colors;
        Vector text = new Vector();
        JScrollPane jScrollPane;

        public OutputPanel() {
            this.colors = new Vector();
            this.setUI(new OutputPanelUI());
            this.setFont(new Font("monospaced", 0, 12));
            this.setBackground(new Color(0.64453125f, 0.64453125f, 0.8203125f));
            this.addMouseListener(new OutputPanelMouseListener());
        }

        public Vector getTextVector() {
            return this.text;
        }

        public Vector getColorVector() {
            return this.colors;
        }

        public void append(Color color, String value) {
            final Color c = color;
            final String val = value;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){
                    Color col;
                    String txt;
                    {
                        this.col = c;
                        this.txt = val;
                    }

                    public void run() {
                        OutputPanel.this.colors.add(this.col);
                        OutputPanel.this.text.add(this.txt);
                        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
                        TextLayout layout = new TextLayout(this.getClass().getName(), OutputPanel.this.getFont(), frc);
                        int lineDist = (int)(layout.getAscent() + layout.getDescent() + layout.getLeading());
                        OutputPanel.this.setPreferredSize(new Dimension(1000, (OutputPanel.this.text.size() + 5) * lineDist));
                        OutputPanel.this.revalidate();
                        OutputPanel.this.repaint();
                    }
                });
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public class TextAreaOutputStream
    extends OutputStream {
        OutputPanel textArea = null;
        StringBuffer buffer = new StringBuffer(256);
        Color color;

        public TextAreaOutputStream(Color color) {
            this.color = color;
        }

        public void setPanel(OutputPanel out) {
            this.textArea = out;
            this.buffer.delete(0, this.buffer.length());
            if (FwkOutputStreamApplication.this.jScrollPane != null) {
                JScrollBar vScrollBar = FwkOutputStreamApplication.this.jScrollPane.getVerticalScrollBar();
                JScrollBar hScrollBar = FwkOutputStreamApplication.this.jScrollPane.getHorizontalScrollBar();
                vScrollBar.setValue(vScrollBar.getMaximum());
                hScrollBar.setValue(0);
            }
        }

        public void write(int b) {
            if (b < 0) {
                b += 256;
            }
            if (b == 10 && this.textArea != null) {
                this.textArea.append(this.color, this.buffer.toString() + '\n');
                this.textArea.revalidate();
                this.buffer.delete(0, this.buffer.length());
                if (FwkOutputStreamApplication.this.jScrollPane != null) {
                    JScrollBar vScrollBar = FwkOutputStreamApplication.this.jScrollPane.getVerticalScrollBar();
                    int vValue = vScrollBar.getMaximum();
                    vScrollBar.setValue(vValue);
                }
            } else {
                this.buffer.append((char)b);
            }
        }
    }
}

