/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPropertyConsumer;
import com.highqsoft.fwk.FwkPropertyGroup;
import com.highqsoft.fwk.FwkPropertyProducer;
import com.highqsoft.interfaces.fwk.FwkPropertyBusInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyGroupInterface;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.Serializable;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class FwkPropertyBus
implements Serializable,
FwkPropertyBusInterface {
    public static final String version = "$Revision: 1.3 $";
    static Map propertyMap;
    public static final String BUSDEFAULTNAME = "FwkPropertyBus";
    public static final String BUSNAMEKEY = "FwkPropertyBus.Name";
    public static String BUSNAME;
    public static final String[] MIMETYPES;
    protected static final int OBJECT_INDEX = 0;
    protected static final int BOOLEAN_INDEX = 1;
    protected static final int BYTE_INDEX = 2;
    protected static final int CHARACTER_INDEX = 3;
    protected static final int DOUBLE_INDEX = 4;
    protected static final int FLOAT_INDEX = 5;
    protected static final int INTEGER_INDEX = 6;
    protected static final int LONG_INDEX = 7;
    protected static final int SHORT_INDEX = 8;
    protected static final int STRING_INDEX = 9;
    protected static final int GROUP_INDEX = 10;
    protected static final int INDEX_LENGTH = 11;
    public static final DataFlavor[] DATAFLAVORS;
    public static final DataFlavor OBJECT;
    public static final DataFlavor BOOLEAN;
    public static final DataFlavor BYTE;
    public static final DataFlavor CHARACTER;
    public static final DataFlavor DOUBLE;
    public static final DataFlavor FLOAT;
    public static final DataFlavor INTEGER;
    public static final DataFlavor LONG;
    public static final DataFlavor SHORT;
    public static final DataFlavor STRING;
    public static final DataFlavor GROUP;
    protected static DataFlavor[] flavors;
    protected static DataFlavor BOOLEAN_FLAVOR;
    protected static DataFlavor BYTE_FLAVOR;
    protected static DataFlavor CHARACTER_FLAVOR;
    protected static DataFlavor DOUBLE_FLAVOR;
    protected static DataFlavor FLOAT_FLAVOR;
    protected static DataFlavor INTEGER_FLAVOR;
    protected static DataFlavor LONG_FLAVOR;
    protected static DataFlavor SHORT_FLAVOR;
    protected static DataFlavor STRING_FLAVOR;
    protected static DataFlavor GROUP_FLAVOR;
    private static FwkPropertyConsumer pcb;
    private static FwkPropertyProducer ppb;
    private static FwkPropertyGroup userProperties;

    public String getVersion() {
        return version;
    }

    public static void readUserPropertyFile(String className) {
        if (userProperties == null) {
            ClassLoader loader = FwkContainer.class.getClassLoader();
            Locale locale = FwkContainer.getLocale();
            String fn = className.replace('.', '_');
            userProperties = new FwkPropertyGroup();
            String baseName = FwkContainer.getUserDirectory() + File.separatorChar + fn + ".properties";
            fn = baseName + "_" + locale.toString();
            if (!userProperties.fileLoad(fn, loader)) {
                fn = baseName + "_" + locale.getLanguage();
                if (!userProperties.fileLoad(fn, loader)) {
                    fn = baseName + "_" + locale.getCountry();
                    if (!userProperties.fileLoad(fn, loader)) {
                        fn = baseName;
                        if (!userProperties.fileLoad(fn, loader)) {
                            userProperties = null;
                            FwkContainer.debug(1, "Cannot read user Property <" + fn + ">.");
                        } else {
                            FwkContainer.debug(1, "Read user Property <" + fn + ">.");
                        }
                    } else {
                        FwkContainer.debug(1, "Read user Property <" + fn + ">.");
                    }
                } else {
                    FwkContainer.debug(1, "Read user Property <" + fn + ">.");
                }
            } else {
                FwkContainer.debug(1, "Read user Property <" + fn + ">.");
            }
        }
    }

    public static void setProperties(Map map) {
        propertyMap = map;
    }

    public static Object getProperty(String propertyName, DataFlavor flavor) {
        Object ret;
        block26: {
            ret = null;
            if (propertyName != null) {
                String val = null;
                if (userProperties != null) {
                    val = userProperties.getProperty(propertyName);
                }
                if (val == null && propertyMap != null) {
                    val = propertyMap.get(propertyName);
                }
                if (val != null) {
                    try {
                        if (flavor.equals(flavors[9])) {
                            ret = val.toString();
                        } else if (flavor.equals(flavors[1])) {
                            ret = Boolean.valueOf(val.toString());
                        } else if (flavor.equals(flavors[2])) {
                            ret = Byte.valueOf(val.toString());
                        } else if (flavor.equals(flavors[3])) {
                            ret = new Character(val.toString().charAt(0));
                        } else if (flavor.equals(flavors[4])) {
                            ret = Double.valueOf(val.toString());
                        } else if (flavor.equals(flavors[5])) {
                            ret = Float.valueOf(val.toString());
                        } else if (flavor.equals(flavors[6])) {
                            ret = Integer.valueOf(val.toString());
                        } else if (flavor.equals(flavors[7])) {
                            ret = Long.valueOf(val.toString());
                        } else if (flavor.equals(flavors[8])) {
                            ret = Short.valueOf(val.toString());
                        }
                    }
                    catch (Throwable t) {
                        String charString;
                        if (!flavor.equals(flavors[6]) || (charString = val.toString()).length() == 0) break block26;
                        ret = new Integer(charString.charAt(0));
                    }
                }
            }
        }
        if (ret == null && (ret = pcb.getProperty(propertyName, new DataFlavor[]{flavor})) == null) {
            int index = propertyName.indexOf(46);
            String propName = propertyName;
            while (ret == null && index != -1) {
                ret = pcb.getProperty(propName = propName.substring(index + 1), new DataFlavor[]{flavor});
                if (ret != null) continue;
                index = propName.indexOf(46);
            }
            if (ret == null) {
                ret = propertyName;
            }
        }
        return ret;
    }

    public static String getProperty(String propertyName) {
        String ret = null;
        try {
            ret = (String)FwkPropertyBus.getProperty(propertyName, STRING);
        }
        catch (Throwable t) {
            new FwkException(-2147461528, "$RCSfile: FwkPropertyBus.java,v $", version, "AH 1999-05-12 09:33", propertyName + " to " + STRING, null, t);
        }
        if (ret == null) {
            ret = propertyName;
        }
        return ret;
    }

    public static boolean getProperty(String propertyName, boolean propertyDefault) {
        boolean ret = false;
        String key = FwkPropertyBus.getProperty(propertyName);
        ret = key.compareTo(propertyName) == 0 ? propertyDefault : Boolean.valueOf(key);
        return ret;
    }

    public static int getProperty(String propertyName, int propertyDefault) {
        int ret = 0;
        String key = FwkPropertyBus.getProperty(propertyName);
        if (key.compareTo(propertyName) == 0) {
            ret = propertyDefault;
        } else {
            try {
                ret = Integer.parseInt(key);
            }
            catch (Throwable t) {
                ret = key.charAt(0);
            }
        }
        return ret;
    }

    public static short getProperty(String propertyName, short propertyDefault) {
        short ret = 0;
        String key = FwkPropertyBus.getProperty(propertyName);
        if (key.compareTo(propertyName) == 0) {
            ret = propertyDefault;
        } else {
            try {
                ret = Short.parseShort(key);
            }
            catch (Throwable t) {
                ret = (short)key.charAt(0);
            }
        }
        return ret;
    }

    public static byte getProperty(String propertyName, byte propertyDefault) {
        byte ret = 0;
        String key = FwkPropertyBus.getProperty(propertyName);
        if (key.compareTo(propertyName) == 0) {
            ret = propertyDefault;
        } else {
            try {
                ret = Byte.parseByte(key);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return ret;
    }

    public static char getProperty(String propertyName, char propertyDefault) {
        char ret = '\u0000';
        String key = FwkPropertyBus.getProperty(propertyName);
        ret = key.compareTo(propertyName) == 0 ? propertyDefault : key.toCharArray()[0];
        return ret;
    }

    public static long getProperty(String propertyName, long propertyDefault) {
        long ret = 0L;
        String key = FwkPropertyBus.getProperty(propertyName);
        if (key.compareTo(propertyName) == 0) {
            ret = propertyDefault;
        } else {
            try {
                ret = Long.parseLong(key);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return ret;
    }

    public static float getProperty(String propertyName, float propertyDefault) {
        float ret = 0.0f;
        String key = FwkPropertyBus.getProperty(propertyName);
        if (key.compareTo(propertyName) == 0) {
            ret = propertyDefault;
        } else {
            try {
                ret = Float.parseFloat(key);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return ret;
    }

    public static double getProperty(String propertyName, double propertyDefault) {
        double ret = 0.0;
        String key = FwkPropertyBus.getProperty(propertyName);
        if (key.compareTo(propertyName) == 0) {
            ret = propertyDefault;
        } else {
            try {
                ret = Double.parseDouble(key);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return ret;
    }

    public static String getProperty(String propertyName, String propertyDefault) {
        String ret = FwkPropertyBus.getProperty(propertyName);
        if (ret.compareTo(propertyName) == 0) {
            ret = propertyDefault;
        }
        return ret;
    }

    public static Object getProperty(String propertyName, Object propertyDefault) {
        String key;
        Object ret = FwkPropertyBus.getProperty(propertyName, FwkContainer.getDataFlavor(propertyDefault.getClass())[0]);
        if (ret instanceof String && (key = (String)ret).compareTo(propertyName) == 0) {
            ret = propertyDefault;
        }
        return ret;
    }

    public static FwkPropertyGroupInterface getPropertyGroup(String groupName) {
        Map ret = null;
        if (groupName != null) {
            String key;
            Iterator<Object> it;
            Object[] askFor = pcb.findMultipleDataItems(groupName, FwkContainer.getDataFlavor(FwkPropertyGroupInterface.class));
            if (askFor != null && askFor.length != 0) {
                ret = new FwkPropertyGroup();
                for (int i = 0; i < askFor.length; ++i) {
                    ret.putAll((Map)askFor[i]);
                }
            }
            if (userProperties != null) {
                if (ret == null) {
                    ret = userProperties.getPropertyGroup(groupName);
                } else {
                    FwkPropertyGroupInterface grp = userProperties.getPropertyGroup(groupName);
                    if (grp != null && grp.size() > 0) {
                        ret.putAll(grp);
                    }
                }
            }
            String grpName = groupName + ".";
            int minLen = grpName.length() + 1;
            if (propertyMap != null) {
                if (ret == null) {
                    ret = new FwkPropertyGroup();
                }
                it = propertyMap.keySet().iterator();
                while (it.hasNext()) {
                    key = (String)it.next();
                    if (!key.startsWith(grpName) || minLen >= key.length()) continue;
                    ret.setProperty(key.substring(minLen - 1, key.length()), (String)propertyMap.get(key));
                }
            }
            if (ret == null) {
                ret = new FwkPropertyGroup();
            }
            try {
                it = System.getProperties().keySet().iterator();
                while (it.hasNext()) {
                    key = (String)it.next();
                    if (!key.startsWith(grpName) || minLen >= key.length()) continue;
                    ret.setProperty(key.substring(minLen - 1, key.length()), System.getProperty(key));
                }
            }
            catch (AccessControlException notAllowedForApplets) {
                // empty catch block
            }
        }
        if (ret != null && ret.size() == 0) {
            ret = null;
        }
        return ret;
    }

    public static Map getProperties() {
        int propLen;
        HashMap ret = null;
        Object[] askFor = pcb.findMultipleDataItems("*", new DataFlavor[]{STRING});
        Object[] props = askFor != null ? (!(askFor instanceof Object[]) ? new Object[]{askFor} : askFor) : new Object[]{};
        ret = new HashMap();
        if (props != null && (propLen = props.length) > 0) {
            for (int i = 0; i < propLen; ++i) {
                ret.putAll((Map)props[i]);
            }
        }
        if (propertyMap != null) {
            Iterator it = propertyMap.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                ret.put(key, propertyMap.get(key));
            }
        }
        return ret;
    }

    public static Map getPropertyGroups() {
        int propLen;
        HashMap ret = null;
        Object askFor = pcb.getPropertyGroups("*");
        Object[] props = askFor != null ? (!(askFor instanceof Object[]) ? new Object[]{askFor} : (Object[])askFor) : new Object[]{};
        ret = new HashMap();
        if (props != null && (propLen = props.length) > 0) {
            for (int i = 0; i < propLen; ++i) {
                ret.putAll((Map)props[i]);
            }
        }
        return ret;
    }

    public static void loadFile(String filename) {
        ppb.loadFile(filename);
    }

    public static DataFlavor getObjectDataFlavor() {
        return flavors[0];
    }

    public static DataFlavor getBooleanDataFlavor() {
        return flavors[1];
    }

    public static DataFlavor getByteDataFlavor() {
        return flavors[2];
    }

    public static DataFlavor getCharacterDataFlavor() {
        return flavors[3];
    }

    public static DataFlavor getDoubleDataFlavor() {
        return flavors[4];
    }

    public static DataFlavor getFloatDataFlavor() {
        return flavors[5];
    }

    public static DataFlavor getIntegerDataFlavor() {
        return flavors[6];
    }

    public static DataFlavor getLongDataFlavor() {
        return flavors[7];
    }

    public static DataFlavor getShortDataFlavor() {
        return flavors[8];
    }

    public static DataFlavor getStringDataFlavor() {
        return flavors[9];
    }

    public static DataFlavor getGroupDataFlavor() {
        return flavors[10];
    }

    public static DataFlavor[] getDataFlavors() {
        return flavors;
    }

    static {
        BUSNAME = FwkContainer.getSystemProperty("fwkPropertyBus", BUSDEFAULTNAME);
        MIMETYPES = new String[]{"application/x-java-serialized-object; class=" + Object.class.getName(), "application/x-java-serialized-object; class=" + Boolean.class.getName(), "application/x-java-serialized-object; class=" + Byte.class.getName(), "application/x-java-serialized-object; class=" + Character.class.getName(), "application/x-java-serialized-object; class=" + Double.class.getName(), "application/x-java-serialized-object; class=" + Float.class.getName(), "application/x-java-serialized-object; class=" + Integer.class.getName(), "application/x-java-serialized-object; class=" + Long.class.getName(), "application/x-java-serialized-object; class=" + Short.class.getName(), "application/x-java-serialized-object; class=" + String.class.getName(), "application/x-java-serialized-object; class=" + FwkPropertyGroupInterface.class.getName()};
        DATAFLAVORS = new DataFlavor[11];
        try {
            FwkPropertyBus.DATAFLAVORS[0] = new DataFlavor("application/x-java-serialized-object; class=" + Object.class.getName());
            FwkPropertyBus.DATAFLAVORS[1] = new DataFlavor("application/x-java-serialized-object; class=" + Boolean.class.getName());
            FwkPropertyBus.DATAFLAVORS[2] = new DataFlavor("application/x-java-serialized-object; class=" + Byte.class.getName());
            FwkPropertyBus.DATAFLAVORS[3] = new DataFlavor("application/x-java-serialized-object; class=" + Character.class.getName());
            FwkPropertyBus.DATAFLAVORS[4] = new DataFlavor("application/x-java-serialized-object; class=" + Double.class.getName());
            FwkPropertyBus.DATAFLAVORS[5] = new DataFlavor("application/x-java-serialized-object; class=" + Float.class.getName());
            FwkPropertyBus.DATAFLAVORS[6] = new DataFlavor("application/x-java-serialized-object; class=" + Integer.class.getName());
            FwkPropertyBus.DATAFLAVORS[7] = new DataFlavor("application/x-java-serialized-object; class=" + Long.class.getName());
            FwkPropertyBus.DATAFLAVORS[8] = new DataFlavor("application/x-java-serialized-object; class=" + Short.class.getName());
            FwkPropertyBus.DATAFLAVORS[9] = new DataFlavor("application/x-java-serialized-object; class=" + String.class.getName());
            FwkPropertyBus.DATAFLAVORS[10] = new DataFlavor("application/x-java-serialized-object; class=" + FwkPropertyGroupInterface.class.getName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        OBJECT = DATAFLAVORS[0];
        BOOLEAN = DATAFLAVORS[1];
        BYTE = DATAFLAVORS[2];
        CHARACTER = DATAFLAVORS[3];
        DOUBLE = DATAFLAVORS[4];
        FLOAT = DATAFLAVORS[5];
        INTEGER = DATAFLAVORS[6];
        LONG = DATAFLAVORS[7];
        SHORT = DATAFLAVORS[8];
        STRING = DATAFLAVORS[9];
        GROUP = DATAFLAVORS[10];
        pcb = new FwkPropertyConsumer();
        ppb = new FwkPropertyProducer();
        userProperties = null;
        flavors = FwkContainer.getDataFlavors(MIMETYPES);
        propertyMap = null;
    }
}

