/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyChangeInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyChangeListenerInterface;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Iterator;

public class FwkPropertyChange
extends FwkDescription
implements FwkPropertyChangeInterface {
    public static final String version = "$Revision: 1.4 $";
    protected FwkInterface source;
    private HashMap propertyChangeListenerList;
    private HashMap propertyTable = new HashMap();
    boolean suspended = false;

    public String getVersion() {
        return version;
    }

    public FwkPropertyChange() {
        this.setSource(this);
    }

    public FwkPropertyChange(FwkInterface source) {
        this.setSource(source);
    }

    public synchronized void setSource(FwkInterface source) {
        this.propertyChangeListenerList = new HashMap();
        this.suspendPropertyChangeEvents(false);
        this.source = source != null ? source : this;
    }

    public synchronized void suspendPropertyChangeEvents(boolean flag) {
        if (flag != this.suspended) {
            this.suspended = flag;
            this.firePropertyChange("SuspendPropertyChangeEvent", new Boolean(!flag), new Boolean(flag));
        }
    }

    public boolean isPropertyChangeEventSuspended() {
        return this.suspended;
    }

    public FwkArrayInterface getPropertyChangeListenerArray() {
        FwkArray ret = new FwkArray();
        if (this.propertyChangeListenerList != null) {
            Iterator it = this.propertyChangeListenerList.values().iterator();
            while (it.hasNext()) {
                ret.add(it.next());
            }
        }
        return ret;
    }

    public FwkArrayInterface getPropertyChangeListenerArray(String propertyName) {
        FwkArray ret = new FwkArray();
        HashMap listenerList = (HashMap)this.propertyTable.get(propertyName);
        if (listenerList != null) {
            Iterator it = listenerList.values().iterator();
            while (it.hasNext()) {
                ret.add(it.next());
            }
        }
        return ret;
    }

    public FwkArrayInterface getPropertyChangeArray() {
        FwkArray ret = new FwkArray();
        if (this.propertyTable != null) {
            Iterator it = this.propertyTable.keySet().iterator();
            while (it.hasNext()) {
                ret.add(it.next());
            }
        }
        return ret;
    }

    public synchronized void addPropertyChangeListener(FwkPropertyChangeListenerInterface listener) {
        if (this.propertyChangeListenerList == null) {
            this.propertyChangeListenerList = new HashMap();
        }
        this.propertyChangeListenerList.put(listener, listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, FwkPropertyChangeListenerInterface listener) {
        HashMap<FwkPropertyChangeListenerInterface, FwkPropertyChangeListenerInterface> listenerList = (HashMap<FwkPropertyChangeListenerInterface, FwkPropertyChangeListenerInterface>)this.propertyTable.get(propertyName);
        if (listenerList == null) {
            listenerList = new HashMap<FwkPropertyChangeListenerInterface, FwkPropertyChangeListenerInterface>();
            this.propertyTable.put(propertyName, listenerList);
        }
        listenerList.put(listener, listener);
    }

    protected synchronized void firePropertyChange(HashMap listeners, PropertyChangeEvent event) {
        if (listeners == null) {
            return;
        }
        if (event == null) {
            return;
        }
        Iterator it = listeners.values().iterator();
        while (it.hasNext()) {
            ((FwkPropertyChangeListenerInterface)it.next()).propertyChange(event);
        }
    }

    public synchronized void firePropertyChange(PropertyChangeEvent evt) {
        if (!this.suspended) {
            HashMap list;
            String propertyName = evt.getPropertyName();
            if (propertyName != null && (list = (HashMap)this.propertyTable.get(propertyName)) != null) {
                this.firePropertyChange(list, evt);
            }
            this.firePropertyChange(this.propertyChangeListenerList, evt);
        }
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.firePropertyChange(propertyName, new Boolean(oldValue), new Boolean(newValue));
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        this.firePropertyChange(propertyName, new Character(oldValue), new Character(newValue));
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        this.firePropertyChange(propertyName, new Long(oldValue), new Long(newValue));
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        this.firePropertyChange(propertyName, new Float(oldValue), new Float(newValue));
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        this.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent ev = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        this.firePropertyChange(ev);
    }

    public synchronized void removePropertyChangeListener(FwkPropertyChangeListenerInterface listener) {
        this.propertyChangeListenerList.remove(listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, FwkPropertyChangeListenerInterface listener) {
        HashMap ell = (HashMap)this.propertyTable.get(propertyName);
        if (ell != null) {
            ell.remove(listener);
            if (ell.size() == 0) {
                this.propertyTable.remove(propertyName);
            }
        }
    }
}

