/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPropertyConsumer;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkInterface;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class FwkPropertyFile
extends Properties
implements FwkInterface,
Map {
    public static final String version = "$Revision: 1.3 $";
    private String node = FwkContainer.getLocalHost();
    private String username = FwkContainer.getSystemProperty("user.name", null);
    static FwkPropertyConsumer cpc = new FwkPropertyConsumer();

    public String getVersion() {
        return version;
    }

    public FwkArrayInterface getFwkMimeTypes() {
        return FwkContainer.getFwkMimeTypes(FwkInterface.class);
    }

    public void release() {
    }

    protected String[] createKeys(String key) {
        String[] keyList = new String[5];
        int keyIndex = 0;
        if (this.node != null && this.username != null) {
            keyList[keyIndex] = this.node + "." + this.username + "." + key;
            ++keyIndex;
        }
        if (this.username != null) {
            keyList[keyIndex] = this.username + "." + key;
            ++keyIndex;
        }
        if (this.node != null) {
            keyList[keyIndex] = this.node + "." + key;
            ++keyIndex;
        }
        keyList[keyIndex] = key;
        return keyList;
    }

    protected String[] createKeys(String type, String key) {
        String[] keyList = new String[5];
        int keyIndex = 0;
        if (this.node != null && this.username != null) {
            keyList[keyIndex] = this.node + "." + this.username + "." + type + "." + key;
            ++keyIndex;
        }
        if (this.username != null) {
            keyList[keyIndex] = this.username + "." + type + "." + key;
            ++keyIndex;
        }
        if (this.node != null) {
            keyList[keyIndex] = this.node + "." + type + "." + key;
        }
        int n = ++keyIndex;
        keyList[n] = type + "." + key;
        keyList[++keyIndex] = key;
        return keyList;
    }

    protected String createUserKey(String type, String key) {
        String newKey = this.node != null && this.username != null ? this.node + "." + this.username + "." + type + "." + key : (this.username != null ? this.username + "." + type + "." + key : (this.node != null ? this.node + "." + type + "." + key : type + "." + key));
        return newKey;
    }

    protected String createUserKey(String key) {
        String newKey = this.node != null && this.username != null ? this.node + "." + this.username + "." + key : (this.username != null ? this.username + "." + key : (this.node != null ? this.node + "." + key : key));
        return newKey;
    }

    public String getParams() {
        return "";
    }

    public Object getObject(String key) {
        return this.searchForProperty(this.createKeys(key));
    }

    public Object getObject(String type, String key) {
        return this.searchForProperty(this.createKeys(type, key));
    }

    protected ClassLoader getClassLoader(Class clazz) {
        final Class constClass = clazz;
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return constClass.getClassLoader();
            }
        });
    }

    protected InputStream getInputStream(String filename, ClassLoader classLoader) {
        final String fn = filename;
        final ClassLoader cl = classLoader;
        if (cl != null) {
            return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return cl.getResourceAsStream(fn);
                }
            });
        }
        return this.getClass().getResourceAsStream(filename);
    }

    public boolean load(String resource, Class clazz) {
        boolean ret = false;
        ClassLoader loader = clazz == null ? this.getClassLoader(this.getClass()) : this.getClassLoader(clazz);
        loader = this.getClassLoader(clazz);
        String sysProp = resource + ".Properties";
        String propName = FwkContainer.getSystemProperty(sysProp, null);
        if (propName != null && !propName.equals(propName)) {
            ret = this.fileLoad(propName = propName.replace('\\', '/'), loader);
            if (!ret) {
                ret = this.urlLoad(propName);
            }
        } else {
            propName = (String)cpc.getProperty(sysProp);
            if (propName != null && !propName.equals(sysProp) && !(ret = this.fileLoad(propName = propName.replace('\\', '/'), loader))) {
                ret = this.urlLoad(propName);
            }
        }
        if (!ret) {
            ret = this.fileLoad(resource, loader);
            if (!ret && !(ret = this.urlLoad(resource))) {
                ret = this.load(resource, clazz.getName(), loader);
            }
            if (!ret) {
                throw new FwkException(-2147461543, "FwkPropertyFile.java", this.getVersion(), "AH 1999-08-30 14:52", "no properties found for <" + resource + ">", this, null);
            }
        }
        return ret;
    }

    public boolean fileLoad(String filename, ClassLoader loader) {
        InputStream in = this.getInputStream(filename, loader);
        if (in == null) {
            try {
                in = new FileInputStream(filename);
            }
            catch (Throwable th) {
                FwkContainer.debug(2, "failed to read <" + filename + ">.");
            }
        }
        if (in != null) {
            try {
                FwkContainer.debug(2, "FwkPropertyFile.load(): loading property file <" + filename + "> ...");
                this.load(in);
                in.close();
                return true;
            }
            catch (IOException exception) {
                FwkContainer.debug(2, "failed to read <" + filename + ">.");
            }
        }
        return false;
    }

    public boolean urlLoad(String urlString) {
        InputStream in = null;
        URL url = null;
        try {
            url = new URL(urlString);
            in = url.openStream();
        }
        catch (Throwable th) {
            // empty catch block
        }
        if (in != null) {
            try {
                FwkContainer.debug(2, "PropertyFile.load(): loading property file <" + url.toString() + "> ...");
                this.load(in);
                in.close();
                return true;
            }
            catch (IOException exception) {
                FwkContainer.debug(2, "failed to read <" + url.toString() + ">.");
            }
        }
        return false;
    }

    public boolean load(String resource, String className, ClassLoader loader) {
        String urlBaseFilename;
        URL url;
        String fn = "";
        if (className == null) {
            className = this.getClass().getName();
        }
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        Locale locale = FwkContainer.getLocale();
        String baseFilename = resource.replace('.', '/') + ".properties";
        fn = baseFilename + "_" + locale.toString();
        if (!this.fileLoad(fn, loader) && (url = loader.getResource((urlBaseFilename = className.replace('.', '/')) + ".class")) != null) {
            urlBaseFilename = url.toString();
            fn = (urlBaseFilename = urlBaseFilename.substring(0, urlBaseFilename.lastIndexOf(47) + 1) + resource + ".properties") + "_" + locale.toString();
            if (!this.urlLoad(fn) && !this.fileLoad(fn = baseFilename + "_" + locale.getLanguage(), loader)) {
                fn = baseFilename + "_" + locale.getCountry();
                if (!this.fileLoad(fn, loader)) {
                    fn = baseFilename;
                    if (!(this.fileLoad(fn, loader) || this.urlLoad(fn = urlBaseFilename + "_" + locale.getLanguage()) || this.urlLoad(fn = urlBaseFilename + "_" + locale.getCountry()) || this.urlLoad(fn = urlBaseFilename))) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }
        FwkContainer.debug(1, "FwkPropertyFile file <" + fn + "> loaded.");
        return true;
    }

    public boolean load(String filename) {
        boolean ret = false;
        try {
            FileInputStream infile = new FileInputStream(filename);
            this.load(infile);
            infile.close();
            ret = true;
        }
        catch (IOException exception) {
            throw new FwkException(-2147461543, "FwkPropertyFile.java", this.getVersion(), "HJB 1999-03-01 21:32", filename, this, exception);
        }
        return ret;
    }

    public boolean load(URL url) {
        boolean ret = false;
        try {
            InputStream infile = url.openStream();
            this.load(infile);
            infile.close();
            ret = true;
        }
        catch (Throwable t) {
            throw new FwkException(-2147461543, "FwkPropertyFile.java", this.getVersion(), "AH 1999-08-31 10:38", url.toString(), this, t);
        }
        return ret;
    }

    protected Object searchForProperty(String[] keyList) {
        return this.getProperty(keyList[keyList.length - 1]);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getParams() + "]";
    }
}

