/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDOMHandler;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkPropertyFile;
import com.highqsoft.fwk.FwkSortedArray;
import com.highqsoft.fwk.FwkXmlInterpreter;
import com.highqsoft.fwk.util.FileUtilities;
import com.highqsoft.interfaces.fwk.FwkDOMHandlerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyGroupInterface;
import com.highqsoft.interfaces.fwk.FwkXmlDtdInterface;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FwkPropertyGroup
extends FwkPropertyFile
implements FwkPropertyGroupInterface {
    protected static final String BEGIN = "BEGIN";
    protected static final String END = "END";
    protected static final String COMMENT_CHARS = ";#";
    public static final String version = "$Revision: 1.10 $";
    FwkDescription description = new FwkDescription();
    boolean readingDOM = false;
    static /* synthetic */ Class class$java$lang$String;

    public String getVersion() {
        return version;
    }

    public FwkPropertyGroup() {
        this.setName(this.getClass().getName() + "_" + this.hashCode());
    }

    public Object clone() {
        FwkPropertyGroup ret = new FwkPropertyGroup();
        ret.setName(this.getName());
        ret.setDescription("Copy(" + this.getName() + ")");
        Iterator<Object> it = this.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object val = super.get(key);
            if (val instanceof FwkPropertyGroupInterface) {
                ret.put((Object)key, ((FwkPropertyGroupInterface)val).clone());
                continue;
            }
            ret.put((Object)key, val.toString());
        }
        return ret;
    }

    public Object getProperty(String group, String propertyName, DataFlavor flavor) {
        Object ret = null;
        if (propertyName != null) {
            Object val = null;
            try {
                val = this.getGroup(group).get(propertyName);
                if (val == null) {
                    String prop = propertyName;
                    String grp = group;
                    while (val == null) {
                        int index = prop.indexOf(46);
                        grp = grp + "." + prop.substring(0, index);
                        prop = prop.substring(index + 1);
                        val = this.getProperty(grp, prop, flavor);
                    }
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (val != null) {
                try {
                    if (flavor.equals(FwkPropertyBus.STRING)) {
                        ret = val.toString();
                    } else if (flavor.equals(FwkPropertyBus.BOOLEAN)) {
                        ret = Boolean.valueOf(val.toString());
                    } else if (flavor.equals(FwkPropertyBus.BYTE)) {
                        ret = Byte.valueOf(val.toString());
                    } else if (flavor.equals(FwkPropertyBus.CHARACTER)) {
                        ret = new Character(val.toString().charAt(0));
                    } else if (flavor.equals(FwkPropertyBus.DOUBLE)) {
                        ret = Double.valueOf(val.toString());
                    } else if (flavor.equals(FwkPropertyBus.FLOAT)) {
                        ret = Float.valueOf(val.toString());
                    } else if (flavor.equals(FwkPropertyBus.INTEGER)) {
                        ret = Integer.valueOf(val.toString());
                    } else if (flavor.equals(FwkPropertyBus.LONG)) {
                        ret = Long.valueOf(val.toString());
                    } else if (flavor.equals(FwkPropertyBus.SHORT)) {
                        ret = Short.valueOf(val.toString());
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    public Object getProperty(String propertyName, DataFlavor flavor) {
        Object ret = null;
        if (propertyName != null) {
            String val = null;
            try {
                int index;
                val = super.getProperty(propertyName);
                if (val == null && (index = propertyName.indexOf(46)) > 0) {
                    return this.getProperty(propertyName.substring(0, index), propertyName.substring(index + 1), flavor);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (val != null) {
                try {
                    if (flavor.equals(FwkPropertyBus.STRING)) {
                        ret = val.toString();
                    } else if (flavor.equals(FwkPropertyBus.BOOLEAN)) {
                        ret = Boolean.valueOf(val.toString());
                    } else if (flavor.equals(FwkPropertyBus.BYTE)) {
                        ret = Byte.valueOf(val.toString());
                    } else if (flavor.equals(FwkPropertyBus.CHARACTER)) {
                        ret = new Character(val.toString().charAt(0));
                    } else if (flavor.equals(FwkPropertyBus.DOUBLE)) {
                        ret = Double.valueOf(val.toString());
                    } else if (flavor.equals(FwkPropertyBus.FLOAT)) {
                        ret = Float.valueOf(val.toString());
                    } else if (flavor.equals(FwkPropertyBus.INTEGER)) {
                        ret = Integer.valueOf(val.toString());
                    } else if (flavor.equals(FwkPropertyBus.LONG)) {
                        ret = Long.valueOf(val.toString());
                    } else if (flavor.equals(FwkPropertyBus.SHORT)) {
                        ret = Short.valueOf(val.toString());
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    public Object getProperty(String groupKey, Object defaultValue) {
        Object ret = null;
        int index = groupKey.lastIndexOf(46);
        if (index > 0) {
            FwkPropertyGroupInterface grp = this.getPropertyGroup(groupKey.substring(0, index));
            if (grp != null) {
                ret = grp.getProperty(groupKey.substring(index + 1), defaultValue);
            }
            if (ret == null) {
                ret = super.get(groupKey);
            }
        } else {
            ret = super.get(groupKey);
        }
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public String getProperty(String groupKey, String defaultValue) {
        String ret = null;
        int index = groupKey.lastIndexOf(46);
        if (index > 0) {
            FwkPropertyGroupInterface grp = this.getPropertyGroup(groupKey.substring(0, index));
            if (grp != null) {
                ret = grp.getProperty(groupKey.substring(index + 1));
            }
            if (ret == null) {
                ret = super.getProperty(groupKey);
            }
        } else {
            ret = super.getProperty(groupKey);
        }
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public boolean getProperty(String key, boolean dflt) {
        boolean ret = dflt;
        int index = key.indexOf(46);
        if (index > 0) {
            ret = this.getProperty(key.substring(0, index), key.substring(index + 1), dflt);
        } else {
            Boolean obj = (Boolean)this.getProperty(key, FwkPropertyBus.BOOLEAN);
            if (obj != null) {
                ret = obj;
            }
        }
        return ret;
    }

    public int getProperty(String key, int dflt) {
        int ret = dflt;
        int index = key.indexOf(46);
        if (index > 0) {
            ret = this.getProperty(key.substring(0, index), key.substring(index + 1), dflt);
        } else {
            Integer obj = (Integer)this.getProperty(key, FwkPropertyBus.INTEGER);
            if (obj != null) {
                ret = obj;
            }
        }
        return ret;
    }

    public short getProperty(String key, short dflt) {
        short ret = dflt;
        int index = key.indexOf(46);
        if (index > 0) {
            ret = this.getProperty(key.substring(0, index), key.substring(index + 1), dflt);
        } else {
            Short obj = (Short)this.getProperty(key, FwkPropertyBus.SHORT);
            if (obj != null) {
                ret = obj;
            }
        }
        return ret;
    }

    public byte getProperty(String key, byte dflt) {
        byte ret = dflt;
        int index = key.indexOf(46);
        if (index > 0) {
            ret = this.getProperty(key.substring(0, index), key.substring(index + 1), dflt);
        } else {
            Byte obj = (Byte)this.getProperty(key, FwkPropertyBus.BYTE);
            if (obj != null) {
                ret = obj;
            }
        }
        return ret;
    }

    public char getProperty(String key, char dflt) {
        char ret = dflt;
        int index = key.indexOf(46);
        if (index > 0) {
            ret = this.getProperty(key.substring(0, index), key.substring(index + 1), dflt);
        } else {
            Character obj = (Character)this.getProperty(key, FwkPropertyBus.CHARACTER);
            if (obj != null) {
                ret = obj.charValue();
            }
        }
        return ret;
    }

    public long getProperty(String key, long dflt) {
        long ret = dflt;
        int index = key.indexOf(46);
        if (index > 0) {
            ret = this.getProperty(key.substring(0, index), key.substring(index + 1), dflt);
        } else {
            Long obj = (Long)this.getProperty(key, FwkPropertyBus.LONG);
            if (obj != null) {
                ret = obj;
            }
        }
        return ret;
    }

    public float getProperty(String key, float dflt) {
        float ret = dflt;
        int index = key.indexOf(46);
        if (index > 0) {
            ret = this.getProperty(key.substring(0, index), key.substring(index + 1), dflt);
        } else {
            Float obj = (Float)this.getProperty(key, FwkPropertyBus.FLOAT);
            if (obj != null) {
                ret = obj.floatValue();
            }
        }
        return ret;
    }

    public double getProperty(String key, double dflt) {
        double ret = dflt;
        int index = key.indexOf(46);
        if (index > 0) {
            ret = this.getProperty(key.substring(0, index), key.substring(index + 1), dflt);
        } else {
            Double obj = (Double)this.getProperty(key, FwkPropertyBus.DOUBLE);
            if (obj != null) {
                ret = obj;
            }
        }
        return ret;
    }

    public String getProperty(String key) {
        String ret = null;
        int index = key.indexOf(46);
        if (index > 0) {
            FwkPropertyGroupInterface group = null;
            Object o = this.get(key.substring(0, index));
            if (o != null && o instanceof FwkPropertyGroupInterface) {
                group = (FwkPropertyGroupInterface)o;
                ret = group.getProperty(key.substring(index + 1));
            }
        } else {
            ret = super.getProperty(key);
        }
        return ret;
    }

    public Object setProperty(String key, String value) {
        int index = key.indexOf(46);
        if (index >= 0) {
            String groupKey = key.substring(0, index);
            String s = key.substring(index + 1);
            Properties group = (Properties)this.get(groupKey);
            if (group == null) {
                group = new FwkPropertyGroup();
                ((FwkPropertyGroup)group).setName(groupKey);
                this.put(groupKey, group);
            }
            group.put(s, value);
        } else {
            super.put(key, value);
        }
        return value;
    }

    public Object setProperty(String key, boolean value) {
        return this.setProperty(key, "" + value);
    }

    public Object setProperty(String key, int value) {
        return this.setProperty(key, "" + value);
    }

    public Object setProperty(String key, short value) {
        return this.setProperty(key, "" + value);
    }

    public Object setProperty(String key, byte value) {
        return this.setProperty(key, "" + value);
    }

    public Object setProperty(String key, char value) {
        return this.setProperty(key, "" + value);
    }

    public Object setProperty(String key, long value) {
        return this.setProperty(key, "" + value);
    }

    public Object setProperty(String key, float value) {
        return this.setProperty(key, "" + value);
    }

    public Object setProperty(String key, double value) {
        return this.setProperty(key, "" + value);
    }

    public Object setProperty(String groupKey, String key, String value) {
        FwkPropertyGroupInterface group = (FwkPropertyGroupInterface)this.get(groupKey);
        if (group == null) {
            group = new FwkPropertyGroup();
            group.setName(groupKey);
            this.put(groupKey, group);
        }
        return group.put(key, value);
    }

    public Object setProperty(String groupKey, String key, boolean value) {
        return this.setProperty(groupKey, key, "" + value);
    }

    public Object setProperty(String groupKey, String key, int value) {
        return this.setProperty(groupKey, key, "" + value);
    }

    public Object setProperty(String groupKey, String key, short value) {
        return this.setProperty(groupKey, key, "" + value);
    }

    public Object setProperty(String groupKey, String key, byte value) {
        return this.setProperty(groupKey, key, "" + value);
    }

    public Object setProperty(String groupKey, String key, char value) {
        return this.setProperty(groupKey, key, "" + value);
    }

    public Object setProperty(String groupKey, String key, long value) {
        return this.setProperty(groupKey, key, "" + value);
    }

    public Object setProperty(String groupKey, String key, float value) {
        return this.setProperty(groupKey, key, "" + value);
    }

    public Object setProperty(String groupKey, String key, double value) {
        return this.setProperty(groupKey, key, "" + value);
    }

    public boolean getProperty(String group, String propertyName, boolean propertyDefault) {
        boolean ret = propertyDefault;
        Boolean obj = (Boolean)this.getProperty(group, propertyName, FwkPropertyBus.BOOLEAN);
        if (obj != null) {
            ret = obj;
        }
        return ret;
    }

    public int getProperty(String group, String propertyName, int propertyDefault) {
        int ret = propertyDefault;
        Integer obj = (Integer)this.getProperty(group, propertyName, FwkPropertyBus.INTEGER);
        if (obj != null) {
            ret = obj;
        }
        return ret;
    }

    public short getProperty(String group, String propertyName, short propertyDefault) {
        short ret = propertyDefault;
        Short obj = (Short)this.getProperty(group, propertyName, FwkPropertyBus.SHORT);
        if (obj != null) {
            ret = obj;
        }
        return ret;
    }

    public byte getProperty(String group, String propertyName, byte propertyDefault) {
        byte ret = propertyDefault;
        Byte obj = (Byte)this.getProperty(group, propertyName, FwkPropertyBus.BYTE);
        if (obj != null) {
            ret = obj;
        }
        return ret;
    }

    public char getProperty(String group, String propertyName, char propertyDefault) {
        char ret = propertyDefault;
        Character obj = (Character)this.getProperty(group, propertyName, FwkPropertyBus.CHARACTER);
        if (obj != null) {
            ret = obj.charValue();
        }
        return ret;
    }

    public long getProperty(String group, String propertyName, long propertyDefault) {
        long ret = propertyDefault;
        Long obj = (Long)this.getProperty(group, propertyName, FwkPropertyBus.LONG);
        if (obj != null) {
            ret = obj;
        }
        return ret;
    }

    public float getProperty(String group, String propertyName, float propertyDefault) {
        float ret = propertyDefault;
        Float obj = (Float)this.getProperty(group, propertyName, FwkPropertyBus.FLOAT);
        if (obj != null) {
            ret = obj.floatValue();
        }
        return ret;
    }

    public double getProperty(String group, String propertyName, double propertyDefault) {
        double ret = propertyDefault;
        Double obj = (Double)this.getProperty(group, propertyName, FwkPropertyBus.DOUBLE);
        if (obj != null) {
            ret = obj;
        }
        return ret;
    }

    public String getProperty(String group, String propertyName, String propertyDefault) {
        String ret = propertyDefault;
        String obj = (String)this.getProperty(group, propertyName, FwkPropertyBus.STRING);
        if (obj != null) {
            ret = obj;
        }
        return ret;
    }

    public Object getProperty(String group, String propertyName, Object propertyDefault) {
        Object ret = this.getProperty(group, propertyName, FwkContainer.getDataFlavor(propertyDefault.getClass())[0]);
        Object val = null;
        try {
            val = ((Properties)this.get(group)).get(propertyName);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (val != null) {
            ret = val;
        }
        return ret;
    }

    public FwkPropertyGroupInterface getPropertyGroup(String name) {
        String topName;
        FwkPropertyGroupInterface grp;
        int index;
        FwkPropertyGroupInterface ret = null;
        try {
            ret = (FwkPropertyGroupInterface)super.get(name);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (ret == null && (index = name.indexOf(46)) >= 0 && (grp = this.getPropertyGroup(topName = name.substring(0, index))) != null) {
            ret = grp.getPropertyGroup(name.substring(index + 1));
        }
        return ret;
    }

    public FwkPropertyGroupInterface addGroup(String name, FwkPropertyGroupInterface newGroup) {
        FwkPropertyGroupInterface ret = this.getPropertyGroup(name);
        if (ret == null) {
            Enumeration e = newGroup.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.setProperty(name + "." + key, newGroup.getProperty(key));
            }
            ret = this.getPropertyGroup(name);
        } else {
            Enumeration e = newGroup.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                ret.setProperty(key, newGroup.getProperty(key));
            }
        }
        return ret;
    }

    public FwkPropertyGroupInterface removeGroup(String name) {
        FwkPropertyGroupInterface ret = null;
        try {
            ret = (FwkPropertyGroupInterface)super.get(name);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (ret == null) {
            FwkPropertyGroupInterface grp;
            int index = name.indexOf(46);
            if (index <= 0 && (grp = this.getPropertyGroup(name.substring(0, index))) != null) {
                ret = grp.removeGroup(name.substring(index + 1));
            }
        } else {
            super.remove(name);
        }
        return ret;
    }

    public void list(PrintStream out) {
        this.list(new PrintWriter(out));
    }

    public void list(PrintWriter out) {
        this.list(out, null);
    }

    public void list(PrintWriter out, String prefix) {
        String fill;
        char[] spaces;
        int max;
        int count;
        Object[] keys;
        int size;
        Object val;
        if (prefix == null) {
            prefix = "";
        }
        Iterator<Object> it = this.keySet().iterator();
        Vector<String> rootKeys = new Vector<String>();
        FwkSortedArray grpKeys = new FwkSortedArray();
        while (it.hasNext()) {
            String groupKey = (String)it.next();
            val = super.get(groupKey);
            if (val instanceof Properties) {
                grpKeys.add((Comparable)((Object)groupKey));
                continue;
            }
            rootKeys.add(groupKey);
        }
        int listLen = grpKeys.size();
        for (int i = 0; i < listLen; ++i) {
            Properties group = (Properties)super.get(grpKeys.get(i));
            if (group == null) continue;
            out.println(prefix + BEGIN + " " + grpKeys.get(i));
            size = group.size();
            keys = new String[size];
            Iterator<Object> gIt = group.keySet().iterator();
            count = 0;
            max = 0;
            while (gIt.hasNext()) {
                keys[count] = (String)gIt.next();
                max = Math.max(max, ((String)keys[count++]).length());
            }
            spaces = new char[max + 2];
            Arrays.fill(spaces, ' ');
            fill = new String(spaces);
            Arrays.sort(keys);
            for (count = 0; count < size; ++count) {
                val = group.get(keys[count]);
                if (val instanceof FwkPropertyGroupInterface) {
                    out.println(prefix + "   " + BEGIN + " " + (String)keys[count]);
                    ((FwkPropertyGroupInterface)val).list(out, prefix + "      ");
                    out.println(prefix + "   " + END);
                    continue;
                }
                out.println(prefix + "   " + (String)keys[count] + fill.substring(0, max - ((String)keys[count]).length()) + " = " + val.toString());
            }
            out.println(prefix + END + "\n");
        }
        size = rootKeys.size();
        if (size != 0) {
            keys = new String[size];
            keys = rootKeys.toArray(keys);
            count = 0;
            max = 0;
            while (count < size) {
                max = Math.max(max, keys[count++].length());
            }
            spaces = new char[max + 2];
            Arrays.fill(spaces, ' ');
            fill = new String(spaces);
            Arrays.sort(keys);
            for (count = 0; count < size; ++count) {
                out.println(prefix + (String)keys[count] + fill.substring(0, max - ((String)keys[count]).length()) + " = " + this.getProperty((String)keys[count], (Object)"").toString());
            }
        }
        out.flush();
    }

    public void store(OutputStream out, String header) throws IOException {
        PrintStream ps = new PrintStream(out);
        if (header != null) {
            ps.println("# " + header);
        }
        ps.println("# " + new Date().toString());
        this.list(ps);
    }

    public Enumeration groupNames() {
        return super.propertyNames();
    }

    public Enumeration propertyNames() {
        return new Enumeration(){
            Enumeration enumeration;
            Enumeration groupEnum;
            String groupKey;
            {
                this.enumeration = FwkPropertyGroup.super.propertyNames();
                this.groupEnum = null;
                this.groupKey = "";
            }

            public boolean hasMoreElements() {
                boolean ret = false;
                if (this.enumeration != null) {
                    ret = this.groupEnum != null && this.groupEnum.hasMoreElements() ? true : this.enumeration.hasMoreElements();
                }
                return ret;
            }

            public Object nextElement() {
                String ret = null;
                if (this.enumeration != null) {
                    if (this.groupEnum != null && this.groupEnum.hasMoreElements()) {
                        ret = this.groupKey + '.' + this.groupEnum.nextElement();
                    } else {
                        while (this.hasMoreElements() && ret == null) {
                            String key = (String)this.enumeration.nextElement();
                            Object next = FwkPropertyGroup.this.get(key);
                            if (next instanceof FwkPropertyGroupInterface) {
                                this.groupEnum = ((FwkPropertyGroupInterface)next).propertyNames();
                                if (!this.groupEnum.hasMoreElements()) continue;
                                this.groupKey = key;
                                ret = key + "." + this.groupEnum.nextElement();
                                continue;
                            }
                            ret = key;
                        }
                    }
                }
                return ret;
            }
        };
    }

    public boolean load(String resource) {
        return super.load(resource, this.getClass());
    }

    public boolean save(String resource) {
        OutputStream out = FileUtilities.getOutputStream(resource, this.getClass().getClassLoader());
        boolean ret = false;
        if (out != null) {
            try {
                PrintWriter pw = new PrintWriter(out);
                this.list(pw);
                out.flush();
                out.close();
                ret = true;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return ret;
    }

    public void load(InputStream inStream) {
        FwkPropertyGroup.read(inStream, (FwkPropertyGroupInterface)this);
    }

    public static FwkPropertyGroupInterface read(String spec, FwkPropertyGroupInterface ret) {
        try {
            return FwkPropertyGroup.read(new URL(spec), ret);
        }
        catch (Throwable t) {
            try {
                return FwkPropertyGroup.read(ClassLoader.getSystemResourceAsStream(spec), ret);
            }
            catch (Throwable turl) {
                return FwkPropertyGroup.read(new File(spec), ret);
            }
        }
    }

    public static FwkPropertyGroupInterface read(File file, FwkPropertyGroupInterface ret) {
        try {
            FileInputStream fis = new FileInputStream(file);
            ret = FwkPropertyGroup.read(fis, ret);
            fis.close();
        }
        catch (Throwable t) {
            new FwkException(-1073676289, "$RCSfile: FwkPropertyGroup.java,v $", version, "AH 2001-10-05 16:07", null, null, t);
        }
        return ret;
    }

    public FwkPropertyGroupInterface getGroup(String name) {
        FwkPropertyGroupInterface ret = null;
        Object val = super.get(name);
        if (val != null && val instanceof FwkPropertyGroup) {
            ret = (FwkPropertyGroupInterface)val;
        }
        if (ret == null) {
            int index = 0;
            String grp = name;
            FwkPropertyGroupInterface group = this;
            while (index >= 0 && ret == null) {
                index = grp.indexOf(46);
                if (index > 0) {
                    FwkPropertyGroupInterface tmp = group.getGroup(grp.substring(0, index));
                    if (tmp != null) {
                        group = tmp;
                        if ((grp = grp.substring(index + 1)).indexOf(46) != -1) continue;
                        ret = group.getGroup(grp);
                        continue;
                    }
                    index = -1;
                    continue;
                }
                index = -1;
            }
        }
        return ret;
    }

    public Object put(String group, Map values) {
        if (values instanceof FwkPropertyGroupInterface) {
            FwkPropertyGroupInterface curVal = this.getGroup(group);
            if (curVal == null) {
                int index = group.lastIndexOf(46);
                if (index < 0) {
                    return super.put(group, values);
                }
                String newSubGroup = group.substring(index + 1);
                FwkPropertyGroup newGroup = new FwkPropertyGroup();
                newGroup.setName(newSubGroup);
                newGroup.put(newSubGroup, values);
                this.put(group.substring(0, index), values);
                return values;
            }
            if (curVal instanceof FwkPropertyGroupInterface) {
                curVal.putAll(values);
                return curVal;
            }
            System.err.println("Cannot add group " + group + ". It is already defined as another type.");
            return null;
        }
        FwkPropertyGroup props = new FwkPropertyGroup();
        props.setName(group);
        Iterator it = values.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            props.put(key, values.get(key));
        }
        return this.put(group, props);
    }

    public Object put(Object key, Object value) {
        String keyString = key.toString();
        int index = keyString.indexOf(46);
        boolean saveValue = true;
        if (index > 0) {
            try {
                FwkPropertyGroupInterface group = (FwkPropertyGroupInterface)this.get(keyString.substring(0, index));
                if (group == null) {
                    group = new FwkPropertyGroup();
                    group.setName(keyString.substring(0, index));
                    this.put(keyString.substring(0, index), group);
                }
                group.put(keyString.substring(index + 1), value);
                saveValue = false;
            }
            catch (Throwable t) {
                System.err.println("The group of property <" + key + "> is already defined as string value. Use another property name for this value or for the group property keyword.");
            }
        }
        if (saveValue) {
            Object curVal = super.get(key);
            if (curVal != null) {
                if (curVal instanceof FwkPropertyGroupInterface) {
                    if (value instanceof Map) {
                        ((FwkPropertyGroupInterface)curVal).putAll((Map)value);
                    } else {
                        System.err.println("Cannot add key " + key + " with value " + value + ". It is already defined as FwkPropertyGroupInterface.");
                    }
                } else {
                    super.put(key, value);
                }
            } else {
                super.put(key, value);
            }
        }
        return value;
    }

    public Object readConstructor(Document document, Element node) {
        return FwkDOMHandler.readConstructor(this, document, node);
    }

    public void readFromDOM(Document doc, Element element) {
        this.readingDOM(true);
        FwkDOMHandler.readMapFromDOM(this, doc, element);
        this.readingDOM(false);
    }

    public Element writeConstructor(Document document, FwkXmlDtdInterface dtd, Node node, Map classProperties) {
        return FwkDOMHandler.writeConstructor(this, "Map", true, document, dtd, node, classProperties, true);
    }

    public Element writeToDOM(Document document, FwkXmlDtdInterface dtd, Node node, Map classProperties) {
        Element thisNode = this.writeConstructor(document, dtd, node, classProperties);
        FwkDOMHandler.writePropertiesToDOM(this, document, dtd, thisNode, classProperties);
        this.writeMapToDOM(document, dtd, thisNode, classProperties);
        return thisNode;
    }

    public Element writeMapToDOM(Document document, FwkXmlDtdInterface dtd, Element node, Map classProperties) {
        Class[] pType = new Class[1];
        Object[] params = new Object[1];
        Element elementNode = null;
        Iterator<Object> it = this.keySet().iterator();
        FwkSortedArray arr = new FwkSortedArray();
        while (it.hasNext()) {
            arr.add((Comparable)((Object)((String)it.next())));
        }
        int size = arr.size();
        Element parent = node;
        for (int i = 0; i < size; ++i) {
            try {
                String stringValue;
                String key = (String)arr.get(i);
                if (!Character.isLetterOrDigit(key.charAt(0))) continue;
                Object value = super.get(key);
                Class<?> rt = value.getClass();
                if (!rt.isPrimitive() && !(class$java$lang$String == null ? FwkPropertyGroup.class$("java.lang.String") : class$java$lang$String).equals(rt)) {
                    if (value instanceof FwkDOMHandlerInterface) {
                        ((FwkDOMHandlerInterface)value).writeToDOM(document, dtd, parent, classProperties);
                        continue;
                    }
                    if (value instanceof Map) {
                        FwkDOMHandler.writeMapToDOM((Map)value, document, dtd, parent, classProperties);
                        continue;
                    }
                    Class interpreter = (Class)classProperties.get(rt.getName());
                    if (interpreter != null) {
                        pType[0] = rt;
                        stringValue = null;
                        try {
                            Method intMethod = interpreter.getMethod("encode_" + rt.getName().replace('.', '_'), pType);
                            params[0] = value;
                            stringValue = (String)intMethod.invoke(null, params);
                            elementNode = document.createElement("Entry");
                            elementNode.setAttribute("Name", key);
                            elementNode.setAttribute("Value", stringValue);
                            elementNode.setAttribute("Interpreter", interpreter.getName());
                            parent.appendChild(elementNode);
                        }
                        catch (Throwable tIntMethod) {
                            tIntMethod.printStackTrace();
                        }
                        continue;
                    }
                    System.err.println("FwkDOMHandler.writeMapToDOM no interpreter found for key <" + key + "> with class <" + rt.getName() + ">");
                    continue;
                }
                stringValue = FwkXmlInterpreter.encode_java_lang_String(value.toString());
                if (stringValue.length() <= 2) continue;
                elementNode = document.createElement("Entry");
                elementNode.setAttribute("Name", key);
                elementNode.setAttribute("Value", stringValue.substring(1, stringValue.length() - 1));
                parent.appendChild(elementNode);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return parent;
    }

    public boolean writeToXML(String filename, boolean validate) {
        return FwkDOMHandler.writeToXML((FwkDOMHandlerInterface)this, filename, FwkXmlInterpreter.class, validate);
    }

    public void readingDOM(boolean flag) {
        if (flag != this.readingDOM) {
            this.readingDOM = flag;
        }
    }

    public boolean readingDOM() {
        return this.readingDOM;
    }

    public String getAuthor() {
        return this.description.getAuthor();
    }

    public String getBuild() {
        return this.description.getBuild();
    }

    public String getClassName() {
        return this.description.getClassName();
    }

    public String getCompany() {
        return this.description.getCompany();
    }

    public String getCompanyInternetAddress() {
        return this.description.getCompanyInternetAddress();
    }

    public String getCopyright() {
        return this.description.getCopyright();
    }

    public String getCreationDate() {
        return this.description.getCreationDate();
    }

    public String getCreationDate(String formatString) {
        return this.description.getCreationDate(formatString);
    }

    public String getDateFormatString() {
        return this.description.getDateFormatString();
    }

    public String getDescription() {
        return this.description.getDescription();
    }

    public FwkIconInterface getIcon() {
        return this.description.getIcon();
    }

    public FwkIconInterface getIcon(int type) {
        return this.description.getIcon(type);
    }

    public String getIconKey() {
        return this.description.getIconKey();
    }

    public String getIconKey(int type) {
        return this.description.getIconKey(type);
    }

    public String getName() {
        return this.description.getName();
    }

    public String getPresentationString(Locale locale) {
        return this.description.getPresentationString(locale);
    }

    public String getPresentationString() {
        CharArrayWriter caw = new CharArrayWriter(1024);
        this.list(new PrintWriter(caw));
        return caw.toString();
    }

    public String getSupportEMail() {
        return this.description.getSupportEMail();
    }

    public String getTitle() {
        return this.description.getTitle();
    }

    public String getTitleName() {
        return this.description.getTitleName();
    }

    public void setAuthor(String author) {
        this.description.setAuthor(author);
    }

    public void setBuild(String buildnr) {
        this.description.setBuild(buildnr);
    }

    public void setClassName(String className) {
        this.description.setClassName(className);
    }

    public void setCompany(String company) {
        this.description.setCompany(company);
    }

    public void setCompanyInternetAddress(String address) {
        this.description.setCompanyInternetAddress(address);
    }

    public void setCopyright(String copyright) {
        this.description.setCopyright(copyright);
    }

    public void setCreationDate(String dateString, String formatString) {
        this.description.setCreationDate(dateString, formatString);
    }

    public void setCreationDate(String dateString) {
        this.description.setCreationDate(dateString, null);
    }

    public void setDateFormatString(String formatString) {
        this.description.setDateFormatString(formatString);
    }

    public void setDescription(String description) {
        this.description.setDescription(description);
    }

    public void setDescriptor(FwkDescriptionInterface descriptor) throws FwkException {
        this.description.setDescriptor(descriptor);
    }

    public void setIcon(FwkIconInterface icon) {
        this.description.setIcon(icon, 0);
    }

    public void setIcon(FwkIconInterface icon, int type) {
        this.description.setIcon(icon, type);
    }

    public void setIconKey(String key) {
        this.description.setIconKey(key, 0);
    }

    public void setIconKey(String key, int type) {
        this.description.setIconKey(key, type);
    }

    public void setName(String name) {
        this.description.setName(name);
    }

    public void setSupportEMail(String eMail) {
        this.description.setSupportEMail(eMail);
    }

    public void setTitleName(String titleName) {
        this.description.setTitleName(titleName);
    }

    public String toString() {
        CharArrayWriter caw = new CharArrayWriter(1024);
        this.list(new PrintWriter(caw));
        return caw.toString();
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] ret = new DataFlavor[]{DataFlavor.stringFlavor};
        return ret;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(DataFlavor.stringFlavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            return this.getPresentationString();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public static FwkPropertyGroupInterface read(URL url, FwkPropertyGroupInterface ret) {
        try {
            InputStream fis = url.openStream();
            ret = FwkPropertyGroup.read(fis, ret);
            fis.close();
        }
        catch (Throwable t) {
            new FwkException(-1073676289, "$RCSfile: FwkPropertyGroup.java,v $", version, "AH 2001-10-05 16:07", null, null, t);
        }
        return ret;
    }

    public static FwkPropertyGroupInterface read(InputStream is, FwkPropertyGroupInterface ret) {
        try {
            ret = FwkPropertyGroup.read(new InputStreamReader(is), ret);
        }
        catch (Throwable t) {
            new FwkException(-1073676289, "$RCSfile: FwkPropertyGroup.java,v $", version, "AH 2001-10-05 16:09", null, null, t);
        }
        return ret;
    }

    public static FwkPropertyGroupInterface read(Reader reader, FwkPropertyGroupInterface ret) {
        if (ret == null) {
            ret = new FwkPropertyGroup();
        }
        try {
            BufferedReader in = new BufferedReader(reader);
            while (!FwkPropertyGroup.readNextSection(ret, in, null)) {
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            new FwkException(-1073676289, "$RCSfile: FwkPropertyGroup.java,v $", version, "AH 2001-10-05 16:10", null, null, t);
        }
        return ret;
    }

    protected static boolean readNextSection(FwkPropertyGroupInterface parent, BufferedReader in, String sectionName) {
        boolean ret = false;
        SectionInputStream sis = new SectionInputStream(in);
        Properties props = new Properties();
        while (!ret && !sis.endOfSection()) {
            try {
                props.load(sis);
                ret = sis.endOfFile();
                if (!sis.endOfSection()) {
                    if (ret || sis.getGroupName() == null) continue;
                    FwkPropertyGroup grp = new FwkPropertyGroup();
                    grp.setName(sis.getGroupName());
                    ret = FwkPropertyGroup.readNextSection(grp, in, grp.getName());
                    if (grp.size() > 0) {
                        props.put(grp.getName(), grp);
                    }
                    sis.setGroupName(null);
                    continue;
                }
                if (sis.getGroupName() == null) continue;
                SectionInputStream secsis = new SectionInputStream(in);
                String grpName = sis.getGroupName();
                do {
                    Properties secprops = new Properties();
                    try {
                        secsis.setGroupName(null);
                        secprops.load(secsis);
                        if (secprops.size() > 0) {
                            FwkPropertyGroup grp = new FwkPropertyGroup();
                            grp.setName(grpName);
                            grp.putAll(secprops);
                            parent.put(grp.getName(), grp);
                        }
                    }
                    catch (Throwable tSec) {
                        // empty catch block
                    }
                    secsis.endOfSection(false);
                    ret = secsis.endOfFile();
                    grpName = secsis.getGroupName();
                } while (!ret && secsis.getGroupName() != null);
                sis.reset();
            }
            catch (Throwable t) {}
        }
        parent.putAll(props);
        return ret;
    }

    public static void main(String[] args) {
        FwkPropertyGroup pg = new FwkPropertyGroup();
        pg.load("D:\\Java\\com\\highqsoft\\fwk\\FwkContainer.properties_de_DE");
        System.out.println(pg);
        System.exit(0);
    }

    public static class SectionInputStream
    extends InputStream {
        int count;
        boolean endOfFile;
        String groupName;
        StreamTokenizer st;
        boolean newLine;
        boolean endOfBlock;
        char comment;

        SectionInputStream(BufferedReader reader) {
            this.st = new StreamTokenizer(reader);
            this.st.resetSyntax();
            this.st.wordChars(33, 128);
            this.st.wordChars(160, 255);
            this.st.whitespaceChars(0, 32);
            this.st.eolIsSignificant(true);
            this.count = 0;
            this.groupName = null;
            this.endOfFile = false;
            this.newLine = true;
            this.endOfBlock = false;
            this.comment = '\u0000';
        }

        public boolean endOfFile() {
            return this.endOfFile;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String name) {
            this.groupName = name;
        }

        public boolean endOfSection() {
            return this.endOfBlock;
        }

        public void endOfSection(boolean flag) {
            this.endOfBlock = flag;
        }

        public void reset() {
            this.endOfBlock = false;
            this.groupName = null;
        }

        public int available() {
            return 1;
        }

        public int read() throws IOException {
            if (this.endOfBlock || this.groupName != null) {
                return -1;
            }
            if (this.comment != '\u0000' || this.count == 0) {
                this.st.nextToken();
                while (this.st.ttype != -3) {
                    if (this.st.ttype == -1) {
                        this.endOfFile = true;
                        this.endOfBlock = true;
                        return -1;
                    }
                    if (this.st.ttype == 10) {
                        this.newLine = true;
                        if (this.comment == '#') {
                            this.comment = '\u0000';
                        }
                        return 10;
                    }
                    this.st.nextToken();
                }
                if (this.comment == '\u0000' && FwkPropertyGroup.COMMENT_CHARS.indexOf(this.st.sval.charAt(0)) >= 0) {
                    this.comment = (char)35;
                    this.newLine = false;
                    return this.read();
                }
                if (this.newLine) {
                    if (this.st.sval.startsWith("[")) {
                        if (this.st.sval.endsWith("]")) {
                            this.groupName = this.st.sval.substring(1, this.st.sval.length() - 1);
                        } else {
                            StringBuffer sb = new StringBuffer();
                            sb.append(this.st.sval.substring(1, this.st.sval.length())).append(" ");
                            this.st.nextToken();
                            boolean stop = false;
                            while (!stop && this.st.ttype != 10 && this.st.ttype != -1) {
                                if (this.st.sval.endsWith("]")) {
                                    sb.append(this.st.sval.substring(0, this.st.sval.length() - 1));
                                    stop = true;
                                    continue;
                                }
                                sb.append(this.st.sval).append(" ");
                                this.st.nextToken();
                            }
                            this.groupName = sb.toString().trim();
                        }
                        this.endOfBlock = true;
                        return -1;
                    }
                    if (this.st.sval.toUpperCase().compareTo(FwkPropertyGroup.BEGIN) == 0) {
                        this.st.nextToken();
                        StringBuffer sb = new StringBuffer();
                        while (this.st.ttype != 10 && this.st.ttype != -1) {
                            sb.append(this.st.sval).append(" ");
                            this.st.nextToken();
                        }
                        this.groupName = sb.toString().trim();
                        this.endOfBlock = false;
                        return -1;
                    }
                    if (this.st.sval.toUpperCase().compareTo(FwkPropertyGroup.END) == 0) {
                        this.endOfBlock = true;
                        this.groupName = null;
                        this.st.nextToken();
                        while (this.st.ttype != -3) {
                            if (this.st.ttype == -1) {
                                this.endOfFile = true;
                                this.endOfBlock = true;
                                return -1;
                            }
                            if (this.st.ttype == 10) {
                                this.newLine = true;
                                return 10;
                            }
                            this.st.nextToken();
                        }
                        return -1;
                    }
                }
                if (this.comment == '\u0000') {
                    this.newLine = false;
                    if (this.st.sval.startsWith("/*")) {
                        this.comment = (char)42;
                        return this.read();
                    }
                    if (this.st.sval.startsWith("//")) {
                        this.comment = (char)47;
                        return this.read();
                    }
                } else if (this.newLine && this.comment == '/') {
                    this.comment = '\u0000';
                    this.newLine = false;
                    if (this.st.sval.startsWith("/*")) {
                        this.comment = (char)42;
                        return this.read();
                    }
                    if (this.st.sval.startsWith("//")) {
                        this.comment = (char)47;
                        return this.read();
                    }
                } else if (this.comment == '*') {
                    this.newLine = false;
                    if (this.st.sval.endsWith("*/")) {
                        this.comment = '\u0000';
                    }
                    return this.read();
                }
            }
            if (this.comment != '\u0000' || this.count > this.st.sval.length()) {
                this.count = 0;
                return this.read();
            }
            ++this.count;
            if (this.count == 1) {
                return 32;
            }
            return this.st.sval.charAt(this.count - 2);
        }
    }
}

