/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkInfoBusProducer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkPropertyGroup;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.interfaces.fwk.FwkInfoBusProducerInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyGroupInterface;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import javax.infobus.InfoBusItemRequestedEvent;

public class FwkPropertyProducer
extends FwkInfoBusProducer
implements FwkInfoBusProducerInterface {
    public static final String version = "$Revision: 1.5 $";
    protected FwkPropertyGroup cpf = new FwkPropertyGroup();
    protected static int counter = 1;

    public String getVersion() {
        return version;
    }

    public FwkPropertyProducer() {
        super("FwkPropertyProducer[" + counter++ + "]@" + FwkPropertyBus.BUSNAME, FwkPropertyBus.MIMETYPES);
    }

    public FwkPropertyProducer(String resource, Class clazz) throws RuntimeException {
        super(resource + "-FwkPropertyProducer[" + counter++ + "]@" + FwkPropertyBus.BUSNAME, FwkPropertyBus.MIMETYPES);
        try {
            this.loadResource(resource, clazz);
        }
        catch (Throwable th) {
            this.unregister();
            throw new RuntimeException("Properties for resource <" + resource + "> missing.");
        }
    }

    public String getPresentationString(Locale locale) {
        return this.cpf.toString();
    }

    public boolean revoke(String itemName, DataFlavor[] flavor) {
        return false;
    }

    public void dataItemRequested(InfoBusItemRequestedEvent ev) {
        super.dataItemRequested(ev);
        Object property = null;
        if (ev.getDataItem() == null && this.isAssignable(ev.getDataFlavors())) {
            if (FwkInfoBusProducer.isAssignable(ev.getDataFlavors(), FwkContainer.getDataFlavor(FwkPropertyGroupInterface.class))) {
                this.propertyGroupRequested(ev);
            } else {
                String dataItemName = ev.getDataItemName();
                if (dataItemName != null) {
                    if (dataItemName.indexOf(42) != -1 || dataItemName.indexOf(63) != -1) {
                        HashMap<String, String> ret = new HashMap<String, String>();
                        Enumeration e = this.cpf.propertyNames();
                        while (e.hasMoreElements()) {
                            String key = (String)e.nextElement();
                            if (!Pattern.match(key, dataItemName, true)) continue;
                            ret.put(key, this.cpf.getProperty(key));
                        }
                        ev.setDataItem(ret);
                    } else {
                        property = this.cpf.getProperty(dataItemName);
                        DataFlavor[] flavor = ev.getDataFlavors();
                        if (property != null && flavor != null && flavor.length > 0) {
                            if (flavor[0].equals(FwkPropertyBus.getBooleanDataFlavor())) {
                                property = Boolean.valueOf((String)property);
                            } else if (flavor[0].equals(FwkPropertyBus.getByteDataFlavor())) {
                                property = Byte.valueOf((String)property);
                            } else if (flavor[0].equals(FwkPropertyBus.getCharacterDataFlavor())) {
                                property = new Character(((String)property).charAt(0));
                            } else if (flavor[0].equals(FwkPropertyBus.getDoubleDataFlavor())) {
                                property = Double.valueOf((String)property);
                            } else if (flavor[0].equals(FwkPropertyBus.getFloatDataFlavor())) {
                                property = Float.valueOf((String)property);
                            } else if (flavor[0].equals(FwkPropertyBus.getIntegerDataFlavor())) {
                                property = Integer.valueOf((String)property);
                            } else if (flavor[0].equals(FwkPropertyBus.getLongDataFlavor())) {
                                property = Long.valueOf((String)property);
                            } else if (flavor[0].equals(FwkPropertyBus.getShortDataFlavor())) {
                                property = Short.valueOf((String)property);
                            }
                        }
                        ev.setDataItem(property);
                    }
                }
            }
        }
    }

    public void propertyGroupRequested(InfoBusItemRequestedEvent ev) {
        String dataItemName = ev.getDataItemName();
        if (dataItemName != null) {
            if (dataItemName.indexOf(42) != -1 || dataItemName.indexOf(63) != -1) {
                HashMap<String, FwkPropertyGroupInterface> ret = new HashMap<String, FwkPropertyGroupInterface>();
                Enumeration e = this.cpf.groupNames();
                while (e.hasMoreElements()) {
                    FwkPropertyGroupInterface prop;
                    String key = (String)e.nextElement();
                    if (!Pattern.match(key, dataItemName, true) || (prop = this.cpf.getGroup(key)) == null) continue;
                    ret.put(key, prop);
                }
                if (ret.size() != 0) {
                    ev.setDataItem(ret);
                }
            } else {
                ev.setDataItem((Object)this.cpf.getGroup(dataItemName));
            }
        }
    }

    public void loadResource(String resource, Class clazz) {
        this.cpf.load(resource, clazz);
    }

    public void loadFile(String filename) {
        this.cpf.load(filename);
    }

    public void loadURL(URL url) {
        this.cpf.load(url);
    }

    public void propertyChange(PropertyChangeEvent ev) {
        this.firePropertyChange(ev);
    }

    public FwkPropertyGroupInterface getPropertyGroup() {
        return this.cpf;
    }
}

