/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkApplication;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDOMHandler;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkIcon;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkServiceControlManagerPanel;
import com.highqsoft.fwk.command.FwkDumpToXMLCommand;
import com.highqsoft.fwk.command.FwkExitCommand;
import com.highqsoft.fwk.command.FwkPrintCommand;
import com.highqsoft.fwk.command.FwkServiceInterrogateCommand;
import com.highqsoft.fwk.command.FwkServicePauseCommand;
import com.highqsoft.fwk.command.FwkServiceStartCommand;
import com.highqsoft.fwk.command.FwkServiceStopCommand;
import com.highqsoft.fwk.dialog.FwkPropertyEditorDialogPaneValue;
import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import com.highqsoft.interfaces.fwk.FwkPanelInterface;
import com.highqsoft.interfaces.fwk.FwkServiceControlManagerInterface;
import com.highqsoft.interfaces.fwk.FwkXmlDtdInterface;
import java.util.Map;
import java.util.TreeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FwkServiceControlManager
extends FwkApplication
implements FwkServiceControlManagerInterface {
    public static final String version = "$Revision: 1.3 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    public static final String applicationName = "FwkServiceControlManager";
    protected static final String loadLibName = "fwkntsupport";
    protected boolean nativeMode = true;
    protected int currentState = 0;
    protected FwkApplicationInterface application = null;
    protected boolean shutdownRequested = false;
    protected FwkPropertyEditorDialogPaneValue propertyList;
    protected int checkPoint = 0;
    protected int waitHint = 1000;
    protected int threadMonitor = 0;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return descriptor;
    }

    public FwkServiceControlManager() {
        this.setDescriptor(descriptor);
        this.propertyList = new FwkPropertyEditorDialogPaneValue();
        this.register();
    }

    public boolean exit() {
        if (this.application != null) {
            this.application.exit();
        }
        return super.exit();
    }

    public FwkApplicationInterface getApplication() {
        return this.application;
    }

    public int getCheckPoint() {
        return this.checkPoint;
    }

    public FwkCommandInterface[] getCommands() {
        if (!this.commandsAvailable()) {
            int menuPos = 0;
            FwkCommand parent = new FwkCommand(this);
            parent.setTextKey("Text.File");
            parent.setCommandName("File");
            this.addCommand(menuPos++, parent);
            FwkCommand cmd1 = new FwkDumpToXMLCommand(this);
            cmd1.setIconKey("Icon.Save");
            parent.addCommand(cmd1);
            cmd1 = new FwkCommand();
            cmd1.setSeparator(true);
            parent.addCommand(cmd1);
            cmd1 = new FwkPrintCommand(this);
            parent.addCommand(cmd1);
            cmd1 = new FwkCommand();
            cmd1.setSeparator(true);
            parent.addCommand(cmd1);
            cmd1 = new FwkExitCommand(this);
            parent.addCommand(cmd1);
            parent = new FwkCommand();
            parent.setTextKey("Text.Service");
            parent.setCommandName("Service");
            this.addCommand(menuPos++, parent);
            cmd1 = new FwkServiceStartCommand(this);
            cmd1.setToolBarEnabled(false);
            cmd1.setIconKey("Icon.Start");
            parent.addCommand(cmd1);
            cmd1 = new FwkServicePauseCommand(this);
            cmd1.setToolBarEnabled(false);
            cmd1.setIconKey("Icon.Pause");
            parent.addCommand(cmd1);
            cmd1 = new FwkServiceStopCommand(this);
            cmd1.setToolBarEnabled(false);
            cmd1.setIconKey("Icon.Stop");
            parent.addCommand(cmd1);
            cmd1 = new FwkCommand();
            cmd1.setSeparator(true);
            parent.addCommand(cmd1);
            cmd1 = new FwkServiceInterrogateCommand(this);
            cmd1.setIconKey("Icon.Interrogate");
            parent.addCommand(cmd1);
        }
        return super.getCommands();
    }

    public FwkIconInterface getIcon() {
        FwkIconInterface icon = new FwkIcon(this.getClass().getResource("FwkServiceControlManager.gif"));
        if (icon == null) {
            icon = this.getIcon(0);
        }
        return icon;
    }

    public FwkIconInterface getIcon(int type) {
        return FwkIconFile.getIcon(applicationName);
    }

    public FwkPanelInterface getPanel() {
        if (this.panel == null) {
            this.panel = new FwkServiceControlManagerPanel(this);
        }
        return this.panel;
    }

    public int getState() {
        return this.currentState;
    }

    public void incrementCheckPoint() {
        ++this.checkPoint;
    }

    public void init() {
        super.init();
    }

    public boolean isPauseRequested() {
        return this.currentState == 6;
    }

    public boolean isShutdownRequested() {
        return this.shutdownRequested;
    }

    public boolean isContinueRequested() {
        return this.currentState == 5;
    }

    public boolean isStopRequested() {
        return this.currentState == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceCtrlHandler(int controlCode) {
        switch (controlCode) {
            case 1: {
                FwkApplicationInterface fwkApplicationInterface = this.application;
                synchronized (fwkApplicationInterface) {
                    if (this.currentState == 4 || this.currentState == 7) {
                        this.setState(3);
                    }
                    break;
                }
            }
            case 2: {
                FwkApplicationInterface fwkApplicationInterface = this.application;
                synchronized (fwkApplicationInterface) {
                    if (this.currentState == 4) {
                        this.setState(6);
                    }
                    break;
                }
            }
            case 3: {
                FwkApplicationInterface fwkApplicationInterface = this.application;
                synchronized (fwkApplicationInterface) {
                    if (this.currentState == 7) {
                        this.setState(5);
                        this.application.start();
                    } else if (this.currentState == 0) {
                        this.setState(2);
                        this.application.start();
                    }
                    break;
                }
            }
            case 4: {
                this.reportStatus(0, 0, this.checkPoint, this.waitHint);
                break;
            }
            case 5: {
                this.currentState = -1;
                this.shutdownRequested = true;
            }
        }
    }

    public boolean reportStatus(int exitCode, int specificExitCode, int checkPoint, int waitHint) {
        if (this.nativeMode) {
            try {
                this.sendStatusToSCM(this.currentState, exitCode, specificExitCode, checkPoint, waitHint);
            }
            catch (Throwable th) {
                this.nativeMode = false;
            }
        }
        if (!this.nativeMode) {
            System.out.println("\nSCM status = " + this.currentState + ", " + exitCode + ", " + specificExitCode + ", " + checkPoint + ", " + waitHint);
        }
        return this.nativeMode;
    }

    public void run() {
        this.threadMonitor = FwkPropertyBus.getProperty("threadMonitor", 0) * 1000;
        if (this.panel != null) {
            String[] emptyArray = new String[]{};
            while (this.threadMonitor > 0) {
                TreeSet<String> sortedSet = new TreeSet<String>();
                Thread[] threads = new Thread[Thread.activeCount()];
                int nThreads = Thread.enumerate(threads);
                for (int i = 0; i < nThreads; ++i) {
                    sortedSet.add(threads[i].getName());
                }
                ((FwkServiceControlManagerPanel)this.panel).setThreadList(sortedSet.toArray(emptyArray));
                try {
                    Thread.sleep(this.threadMonitor);
                }
                catch (InterruptedException ex) {
                    break;
                }
                this.panel.refresh();
            }
        }
    }

    private native boolean sendStatusToSCM(int var1, int var2, int var3, int var4, int var5);

    public void setApplication(FwkApplicationInterface application) {
        this.application = application;
        if (this.panel != null && application != null) {
            String applName = FwkContainer.getBasicName(application.getName());
            ((FwkServiceControlManagerPanel)this.panel).setApplicationLabel(applName);
        }
    }

    public void setNativeMode(boolean nativeMode) {
        this.nativeMode = nativeMode;
    }

    public void setState(int newState) {
        this.checkPoint = 1;
        this.currentState = newState;
        if (this.panel != null) {
            this.panel.refresh();
        }
        this.reportStatus(0, 0, this.checkPoint, this.waitHint);
    }

    public void setWaitHint(int waitHint) {
        this.waitHint = waitHint;
    }

    public Element writeConstructor(Document document, FwkXmlDtdInterface dtd, Node node, Map classProperties) {
        return FwkDOMHandler.writeConstructor(this, "Application", true, document, null, node, classProperties, false);
    }

    public Element writeToDOM(Document document, FwkXmlDtdInterface dtd, Node node, Map classProperties) {
        Element thisNode = this.writeConstructor(document, dtd, node, classProperties);
        FwkDOMHandler.writeFrameToDOM(this, document, dtd, thisNode);
        FwkDOMHandler.writePropertiesToDOM(this, document, dtd, thisNode, classProperties);
        return thisNode;
    }

    public static void main(String[] args) {
        FwkContainer.startServiceControlManager(args);
    }

    static {
        descriptor.setAuthor("Hans-Joachim Bothe");
        descriptor.setBuild(version);
        descriptor.setDescription("The HighQSoft Service Control Manager");
        descriptor.setTitleName("FwkServiceControlManager.Text.Title");
        descriptor.setName(FwkServiceControlManager.class.getName());
        descriptor.setIconKey("Icon.FwkServiceControlManager");
        descriptor.setCreationDate("$Date: 2005/01/04 08:10:21 $", null);
        try {
            System.loadLibrary(loadLibName);
        }
        catch (Throwable th) {
            new FwkException(-1073719323, "$RCSfile: FwkServiceControlManager.java,v $", version, "HJB 2001-03-06 17:06", loadLibName, null, th);
        }
    }
}

