/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkPanel;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import com.highqsoft.interfaces.fwk.FwkServiceControlManagerInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FwkServiceControlManagerPanel
extends FwkPanel {
    public static final String version = "$Revision: 1.3 $";
    protected static final FwkIconInterface continuePendingIcon = FwkIconFile.getIcon("DukeRunning");
    protected static final FwkIconInterface notInitializedIcon = FwkIconFile.getIcon("DukePlug");
    protected static final FwkIconInterface pausedIcon = FwkIconFile.getIcon("DukeSnooze");
    protected static final FwkIconInterface pausePendingIcon = FwkIconFile.getIcon("DukeRunning");
    protected static final FwkIconInterface shuttingDownIcon = FwkIconFile.getIcon("DukeFight");
    protected static final FwkIconInterface stoppedIcon = FwkIconFile.getIcon("DukeThumbsUp");
    protected static final FwkIconInterface startPendingIcon = FwkIconFile.getIcon("DukeRunning");
    protected static final FwkIconInterface stopPendingIcon = FwkIconFile.getIcon("DukeRunning");
    protected static final FwkIconInterface runningIcon = FwkIconFile.getIcon("DukeWithGlobe");
    protected JLabel pictogramLabel;
    protected FwkCommandInterface interrogateCommand;
    protected FwkCommandInterface pauseCommand;
    protected FwkCommandInterface startCommand;
    protected FwkCommandInterface stopCommand;
    protected JPanel labelPanel;
    protected JLabel nameLabel;
    protected JLabel statusLabel;
    protected JList threadList;

    public String getVersion() {
        return version;
    }

    public FwkServiceControlManagerPanel(FwkApplicationInterface controller) {
        super(controller);
        JPanel borderPanel = new JPanel(new BorderLayout());
        this.add(borderPanel);
        JPanel mainPanel = new JPanel();
        borderPanel.add((Component)mainPanel, "Center");
        GridBagLayout panelGridbag = new GridBagLayout();
        mainPanel.setLayout(panelGridbag);
        GridBagConstraints panelConstraints = new GridBagConstraints();
        panelConstraints.fill = 1;
        panelConstraints.gridwidth = 0;
        panelConstraints.anchor = 10;
        panelConstraints.weightx = 0.0;
        panelConstraints.weighty = 0.0;
        panelConstraints.insets = new Insets(20, 5, 0, 5);
        this.labelPanel = new JPanel();
        this.labelPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        panelGridbag.setConstraints(this.labelPanel, panelConstraints);
        JPanel pictogramPanel = new JPanel();
        panelConstraints.fill = 0;
        panelConstraints.gridwidth = -1;
        panelConstraints.anchor = 17;
        panelConstraints.insets = new Insets(0, 0, 0, 0);
        panelGridbag.setConstraints(pictogramPanel, panelConstraints);
        JPanel buttonPanel = new JPanel();
        panelConstraints.fill = 0;
        panelConstraints.gridwidth = 0;
        panelConstraints.anchor = 10;
        panelConstraints.insets = new Insets(0, 0, 20, 0);
        panelGridbag.setConstraints(buttonPanel, panelConstraints);
        mainPanel.add(this.labelPanel);
        mainPanel.add(pictogramPanel);
        mainPanel.add(buttonPanel);
        this.pictogramLabel = new JLabel();
        pictogramPanel.add(this.pictogramLabel);
        GridBagLayout buttonGridbag = new GridBagLayout();
        buttonPanel.setLayout(buttonGridbag);
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.fill = 1;
        buttonConstraints.gridwidth = 0;
        buttonConstraints.anchor = 10;
        buttonConstraints.weightx = 1.0;
        buttonConstraints.weighty = 1.0;
        this.startCommand = controller.getCommand("ServiceStart");
        JButton startButton = (JButton)FwkGUIFactory.createButton(this.startCommand, null);
        buttonConstraints.insets = new Insets(10, 5, 5, 5);
        buttonConstraints.gridy = 0;
        buttonGridbag.setConstraints(startButton, buttonConstraints);
        buttonPanel.add(startButton);
        this.pauseCommand = controller.getCommand("ServicePause");
        JButton pauseButton = (JButton)FwkGUIFactory.createButton(this.pauseCommand, null);
        buttonConstraints.insets = new Insets(5, 5, 5, 5);
        buttonConstraints.gridy = 1;
        buttonGridbag.setConstraints(pauseButton, buttonConstraints);
        buttonPanel.add(pauseButton);
        this.stopCommand = controller.getCommand("ServiceStop");
        JButton stopButton = (JButton)FwkGUIFactory.createButton(this.stopCommand, null);
        buttonConstraints.insets = new Insets(5, 5, 10, 5);
        buttonConstraints.gridy = 2;
        buttonGridbag.setConstraints(stopButton, buttonConstraints);
        buttonPanel.add(stopButton);
        JPanel statusPanel = (JPanel)((Object)controller.getStatusPanel());
        this.statusLabel = new JLabel(FwkPropertyBus.getProperty("Text.ServiceNotInitialized"));
        this.statusLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        statusPanel.add(this.statusLabel);
        int threadMonitor = FwkPropertyBus.getProperty("threadMonitor", 0);
        if (threadMonitor > 0) {
            JPanel threadPanel = new JPanel();
            this.threadList = new JList();
            this.threadList.setVisibleRowCount(10);
            JScrollPane scrollPane = new JScrollPane(this.threadList);
            scrollPane.setMinimumSize(new Dimension(250, 200));
            panelConstraints.fill = 1;
            panelConstraints.gridwidth = 0;
            panelConstraints.anchor = 17;
            panelConstraints.insets = new Insets(5, 5, 5, 5);
            panelGridbag.setConstraints(threadPanel, panelConstraints);
            threadPanel.add(scrollPane);
            mainPanel.add(threadPanel);
        }
        this.refresh();
    }

    public void refresh() {
        FwkServiceControlManagerInterface scm = (FwkServiceControlManagerInterface)this.controller;
        String cpc = "";
        if (FwkPropertyBus.getProperty("threadMonitor", 0) > 0) {
            cpc = "   " + scm.getCheckPoint();
        }
        switch (scm.getState()) {
            case -1: {
                this.startCommand.setSensitivity(false);
                this.stopCommand.setSensitivity(false);
                this.pauseCommand.setSensitivity(false);
                this.pictogramLabel.setIcon(shuttingDownIcon);
                this.statusLabel.setText(FwkPropertyBus.getProperty("Text.ServiceShuttingDown") + cpc);
                break;
            }
            case 0: {
                this.startCommand.setSensitivity(true);
                this.stopCommand.setSensitivity(false);
                this.pauseCommand.setSensitivity(false);
                this.pictogramLabel.setIcon(notInitializedIcon);
                this.statusLabel.setText(FwkPropertyBus.getProperty("Text.ServiceNotInitialized") + cpc);
                break;
            }
            case 1: {
                this.startCommand.setSensitivity(false);
                this.stopCommand.setSensitivity(false);
                this.pauseCommand.setSensitivity(false);
                this.pictogramLabel.setIcon(stoppedIcon);
                this.statusLabel.setText(FwkPropertyBus.getProperty("Text.ServiceStopped") + cpc);
                break;
            }
            case 2: {
                this.startCommand.setSensitivity(false);
                this.stopCommand.setSensitivity(false);
                this.pauseCommand.setSensitivity(false);
                this.pictogramLabel.setIcon(startPendingIcon);
                this.statusLabel.setText(FwkPropertyBus.getProperty("Text.ServiceStartPending") + cpc);
                break;
            }
            case 3: {
                this.startCommand.setSensitivity(false);
                this.stopCommand.setSensitivity(false);
                this.pauseCommand.setSensitivity(false);
                this.pictogramLabel.setIcon(stopPendingIcon);
                this.statusLabel.setText(FwkPropertyBus.getProperty("Text.ServiceStopPending") + cpc);
                break;
            }
            case 4: {
                this.startCommand.setSensitivity(false);
                this.stopCommand.setSensitivity(true);
                this.pauseCommand.setSensitivity(true);
                this.pictogramLabel.setIcon(runningIcon);
                this.statusLabel.setText(FwkPropertyBus.getProperty("Text.ServiceRunning") + cpc);
                break;
            }
            case 5: {
                this.startCommand.setSensitivity(false);
                this.stopCommand.setSensitivity(false);
                this.pauseCommand.setSensitivity(false);
                this.pictogramLabel.setIcon(continuePendingIcon);
                this.statusLabel.setText(FwkPropertyBus.getProperty("Text.ServiceContinuePending") + cpc);
                break;
            }
            case 6: {
                this.startCommand.setSensitivity(false);
                this.stopCommand.setSensitivity(false);
                this.pauseCommand.setSensitivity(false);
                this.pictogramLabel.setIcon(pausePendingIcon);
                this.statusLabel.setText(FwkPropertyBus.getProperty("Text.ServicePausePending") + cpc);
                break;
            }
            case 7: {
                this.startCommand.setSensitivity(true);
                this.stopCommand.setSensitivity(false);
                this.pauseCommand.setSensitivity(false);
                this.pictogramLabel.setIcon(pausedIcon);
                this.statusLabel.setText(FwkPropertyBus.getProperty("Text.ServicePaused") + cpc);
            }
        }
    }

    public void setApplicationLabel(String applicationName) {
        if (this.nameLabel == null) {
            this.nameLabel = new JLabel(applicationName);
            Font font = this.nameLabel.getFont();
            font = new Font(font.getName(), 1, 16);
            this.nameLabel.setFont(font);
            this.labelPanel.add(this.nameLabel);
        }
    }

    public void setThreadList(String[] threadNames) {
        if (this.threadList != null) {
            this.threadList.setListData(threadNames);
        }
    }
}

