/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPropertyProducer;
import com.highqsoft.interfaces.fwk.FwkPropertyGroupInterface;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class FwkServiceProvider {
    public static final String SPI = "spi";
    public static final String SPI_VERSION = "version";
    public static final String VERSION = "version";
    public static final String DEFAULT_SPIVERSION = "1.0";
    public static final String SERVICELIST = "servicelist";
    public static final String SERVICE = "service";
    public static final String INTERFACE = "interface";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String CLASS = "class";
    public static final String PROPERTY = "property";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_VALUE = "value";
    public static final String PROPERTY_LOCALE = "locale";
    public static final String CLASSPATH = "classpath";
    public static final String JARFILE = "url";
    public static final String SERVICES_SUBDIR = "services";
    private static FwkServiceProvider instance = null;
    private static HashMap loaders = new HashMap();
    public static final String[][] XML_REPLACEMENTS = new String[][]{{"<", "&lt;"}, {">", "&gt;"}, {"\\n", "&#x0a;"}, {"\\r", "&#x0d;"}, {"\"", "&quot;"}, {"'", "&apos;"}, {"\u0007", "/"}};
    public static final String[][] REVERSE_XML_REPLACEMENTS = new String[][]{{"&lt;", "<"}, {"&gt;", ">"}, {"&#x0d;", "\\n"}, {"&quot;", "\""}, {"&apos;", "'"}};

    private FwkServiceProvider() {
    }

    public static FwkServiceProvider getInstance() {
        if (instance == null) {
            instance = new FwkServiceProvider();
        }
        return instance;
    }

    public Object[] lookup(Class clazz) {
        return this.lookup(clazz, clazz.getClassLoader(), null);
    }

    public Object[] lookup(Class clazz, String[] list) {
        return this.lookup(clazz, clazz.getClassLoader(), list);
    }

    public Object[] lookup(Class clazz, ClassLoader classLoader, String[] list) {
        int debugLevel = FwkContainer.getDebugLevel();
        Vector ret = new Vector();
        String name = clazz.getName();
        String resource = "services/" + name;
        if (classLoader == null) {
            classLoader = clazz.getClassLoader();
        }
        InputStream is = classLoader.getResourceAsStream(resource);
        Document doc = null;
        try {
            if (is == null) {
                is = classLoader.getResourceAsStream(resource = resource + ".xml");
                if (is != null) {
                    doc = FwkServiceProvider.readXMLDocument(is);
                }
            } else {
                doc = FwkServiceProvider.readTextDocument(is, name);
            }
        }
        catch (Throwable docExc) {
            if (debugLevel > 5) {
                System.out.println(this.getClass().getName() + ":> unable to read the resource <" + SERVICES_SUBDIR + "/" + name + "(.xml)>.");
            }
            FwkException exc = new FwkException(-1073676289, "$RCSfile: FwkServiceProvider.java,v $", "$Revision: 1.20 $", "AH 2004-09-21 14:36", "unable to read the resource <services/" + name + "(.xml)>.", null, docExc);
            exc.printStackTrace();
        }
        if (debugLevel > 5) {
            if (doc != null) {
                try {
                    FwkServiceProvider.writeXML(System.out, doc);
                }
                catch (Exception ioe) {
                    ioe.printStackTrace();
                }
                System.out.println(FwkServiceProvider.class.getName() + ".lookup " + resource + " read.");
            } else {
                System.out.println(FwkServiceProvider.class.getName() + ".lookup " + resource + " not found.");
            }
        }
        if (doc != null) {
            Element spi = doc.getDocumentElement();
            NodeList serviceList = spi.getElementsByTagName(SERVICELIST);
            int size = serviceList.getLength();
            for (int i = 0; i < size; ++i) {
                Element serviceListItem = (Element)serviceList.item(i);
                String serviceInterface = serviceListItem.getAttribute(INTERFACE);
                if (serviceInterface.compareTo(name) != 0) continue;
                NodeList services = serviceListItem.getElementsByTagName(SERVICE);
                int nServices = services.getLength();
                for (int j = 0; j < nServices; ++j) {
                    Element service = (Element)services.item(j);
                    String classname = null;
                    String jarFile = null;
                    classname = service.getAttribute(CLASS);
                    jarFile = service.getAttribute(JARFILE);
                    if (classname == null || classname.length() <= 0) continue;
                    Class<?> serviceClazz = null;
                    try {
                        if (debugLevel > 5) {
                            System.out.println("Try to load class <" + classname + "> from jar file <" + jarFile + ">.");
                        }
                        ClassLoader loader = this.loadJAR(classLoader, jarFile);
                        serviceClazz = loader.loadClass(classname);
                    }
                    catch (FileNotFoundException fnf) {
                        if (debugLevel > 5) {
                            fnf.printStackTrace();
                        }
                        new FwkException(-1073676289, "$RCSfile: FwkServiceProvider.java,v $", "$Revision: 1.20 $", "AH 2004-09-21 16:23", "Unable to find jarfile <" + jarFile + ">.", null, null);
                    }
                    catch (ClassNotFoundException cne) {
                        if (debugLevel > 5) {
                            cne.printStackTrace();
                        }
                        new FwkException(-2147461546, "$RCSfile: FwkServiceProvider.java,v $", "$Revision: 1.20 $", "AH 2004-09-21 14:34", classname, null, cne);
                    }
                    if (serviceClazz == null) continue;
                    try {
                        if (clazz.isAssignableFrom(serviceClazz)) {
                            NodeList nodeList = service.getElementsByTagName(PROPERTY);
                            int pCount = nodeList.getLength();
                            if (pCount > 0) {
                                Locale locale = FwkContainer.getLocale();
                                FwkContainer.addComponentProperties(serviceClazz);
                                FwkPropertyProducer pp = (FwkPropertyProducer)FwkContainer.getComponentProperties(serviceClazz);
                                if (pp == null) {
                                    pp = (FwkPropertyProducer)FwkContainer.registerComponentProperties(serviceClazz);
                                }
                                FwkPropertyGroupInterface pGroup = pp.getPropertyGroup();
                                for (int p = 0; p < pCount; ++p) {
                                    Element elm = (Element)nodeList.item(p);
                                    String pName = elm.getAttribute("name");
                                    String pValue = elm.getAttribute(PROPERTY_VALUE);
                                    String pLocale = elm.getAttribute(PROPERTY_LOCALE);
                                    if (pName == null || pName.length() <= 0 || pValue == null || !this.localeMatches(locale, pLocale)) continue;
                                    pGroup.setProperty(pName, pValue);
                                }
                            }
                            Object serviceObject = serviceClazz.newInstance();
                            ret.add(serviceObject);
                            continue;
                        }
                        if (debugLevel > 5) {
                            System.out.println(this.getClass().getName() + ":> Class <" + classname + "> is not assingable to requested interface.");
                        }
                        new FwkException(-1073676289, "$RCSfile: FwkServiceProvider.java,v $", "$Revision: 1.20 $", "AH 2004-09-21 14:35", "Class <" + classname + "> is not assingable to requested interface.", null, null);
                        continue;
                    }
                    catch (Throwable ie) {
                        if (debugLevel > 5) {
                            ie.printStackTrace();
                        }
                        new FwkException(-2147461547, "$RCSfile: FwkServiceProvider.java,v $", "$Revision: 1.20 $", "AH 2004-09-21 14:33", classname, null, ie);
                    }
                }
            }
        }
        if (ret.size() == 0 && list != null && list.length != 0) {
            int size = list.length;
            String classname = null;
            for (int i = 0; i < size; ++i) {
                Class<?> serviceClazz = null;
                try {
                    classname = list[i];
                    serviceClazz = classLoader.loadClass(classname);
                }
                catch (ClassNotFoundException cne) {
                    if (debugLevel > 5) {
                        cne.printStackTrace();
                    }
                    new FwkException(-2147461546, "$RCSfile: FwkServiceProvider.java,v $", "$Revision: 1.20 $", "AH 2004-09-23 08:30", classname, null, cne);
                }
                if (serviceClazz == null) continue;
                try {
                    Object o = serviceClazz.newInstance();
                    if (clazz.isAssignableFrom(serviceClazz)) {
                        ret.add(o);
                        continue;
                    }
                    if (debugLevel > 5) {
                        System.out.println(this.getClass().getName() + ":> Class <" + classname + "> is not assingable to requested interface.");
                    }
                    new FwkException(-1073676289, "$RCSfile: FwkServiceProvider.java,v $", "$Revision: 1.20 $", "AH 2004-09-23 08:31", "Class <" + classname + "> is not assingable to requested interface.", null, null);
                    continue;
                }
                catch (Throwable ie) {
                    if (debugLevel > 5) {
                        ie.printStackTrace();
                    }
                    new FwkException(-2147461547, "$RCSfile: FwkServiceProvider.java,v $", "$Revision: 1.20 $", "AH 2004-09-23 08:32", classname, null, ie);
                }
            }
        }
        if (doc == null && ret.size() == 0) {
            return null;
        }
        return ret.toArray();
    }

    protected boolean localeMatches(Locale locale, String value) {
        if (value == null) {
            return true;
        }
        if ((value = value.trim()).length() == 0) {
            return true;
        }
        if (locale.toString().equals(value)) {
            return true;
        }
        if (locale.getLanguage().equals(value)) {
            return true;
        }
        return locale.getLanguage().equals(value);
    }

    protected static Document readTextDocument(InputStream is, String rootName) throws IOException, ParserConfigurationException {
        int type;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document ret = builder.newDocument();
        Element root = ret.createElement(SPI);
        ret.appendChild(root);
        Element serviceList = ret.createElement(SERVICELIST);
        serviceList.setAttribute("name", rootName);
        root.appendChild(serviceList);
        StreamTokenizer st = new StreamTokenizer(new InputStreamReader(is));
        st.commentChar(35);
        while ((type = st.nextToken()) != -1) {
            if (type != -3) continue;
            String serviceName = st.sval.trim();
            if (FwkContainer.getDebugLevel() > 5) {
                System.out.println("com.highqsoft.fwk.FwkServiceProvider:> Found service <" + serviceName + ">");
            }
            Element service = ret.createElement(SERVICE);
            Element classname = ret.createElement(CLASS);
            classname.setAttribute("name", serviceName);
            service.appendChild(service);
            serviceList.appendChild(service);
        }
        is.close();
        return ret;
    }

    protected static Document readXMLDocument(InputStream is) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        Document ret = db.parse(is);
        return ret;
    }

    public static String convertToXML(String in) {
        String ret = in;
        if (in != null) {
            ret = in.replaceAll(XML_REPLACEMENTS[0][0], XML_REPLACEMENTS[0][1]);
            int size = XML_REPLACEMENTS.length;
            for (int i = 1; i < size; ++i) {
                ret = ret.replaceAll(XML_REPLACEMENTS[i][0], XML_REPLACEMENTS[i][1]);
            }
        }
        return ret;
    }

    public static String reverse_convertToXML(String in) {
        String ret = in.replaceAll(REVERSE_XML_REPLACEMENTS[0][0], REVERSE_XML_REPLACEMENTS[0][1]);
        int size = REVERSE_XML_REPLACEMENTS.length;
        for (int i = 1; i < size; ++i) {
            ret = ret.replaceAll(REVERSE_XML_REPLACEMENTS[i][0], REVERSE_XML_REPLACEMENTS[i][1]);
        }
        return ret;
    }

    public static void printOutNode(PrintStream out, String prefix, Node node, boolean recursive) {
        if (node != null) {
            if (node.getNodeType() != 8) {
                Node aNode;
                String name = node.getNodeName();
                NamedNodeMap attr = node.getAttributes();
                NodeList children = node.getChildNodes();
                int attrCount = 0;
                if (attr != null) {
                    attrCount = attr.getLength();
                }
                int childCount = 0;
                if (children != null) {
                    childCount = children.getLength();
                }
                if (attrCount > 0) {
                    StringBuffer sBuf = new StringBuffer();
                    sBuf.append(prefix).append("<").append(FwkServiceProvider.convertToXML(name));
                    for (int i = 0; i < attrCount - 1; ++i) {
                        aNode = attr.item(i);
                        sBuf.append(" ").append(FwkServiceProvider.convertToXML(aNode.getNodeName()));
                        sBuf.append("=\"").append(FwkServiceProvider.convertToXML(aNode.getNodeValue())).append("\"");
                    }
                    Node aNode2 = attr.item(attrCount - 1);
                    sBuf.append(" ").append(FwkServiceProvider.convertToXML(aNode2.getNodeName()));
                    sBuf.append("=\"").append(FwkServiceProvider.convertToXML(aNode2.getNodeValue()));
                    if (childCount == 0) {
                        sBuf.append("\"/>");
                    } else {
                        sBuf.append("\">");
                    }
                    out.print(sBuf.toString());
                } else if (childCount == 0) {
                    out.print(prefix + "<" + FwkServiceProvider.convertToXML(name) + "/>");
                } else {
                    out.print(prefix + "<" + FwkServiceProvider.convertToXML(name) + ">");
                }
                if (recursive && childCount > 0) {
                    boolean hasText = false;
                    for (int i = 0; i < childCount; ++i) {
                        aNode = children.item(i);
                        if (aNode.getNodeType() != 3) {
                            out.println();
                            FwkServiceProvider.printOutNode(out, prefix + "   ", aNode, recursive);
                            continue;
                        }
                        out.print(((Text)aNode).getData());
                        hasText = true;
                    }
                    if (hasText) {
                        out.print("</" + FwkServiceProvider.convertToXML(name) + ">");
                    } else {
                        out.println("\n" + prefix + "</" + FwkServiceProvider.convertToXML(name) + ">");
                    }
                } else {
                    out.println();
                }
            } else {
                Comment comment = (Comment)node;
                String data = comment.getData().trim();
                if (data.length() > 0) {
                    if (data.indexOf(10) >= 0) {
                        out.println(prefix + "<!-- ");
                        String[] arr = data.split("\n");
                        for (int i = 0; i < arr.length; ++i) {
                            out.print(prefix + "     ");
                            out.println(arr[i]);
                        }
                        out.println(prefix + "-->");
                    } else {
                        out.print(prefix + "<!-- ");
                        out.print(data);
                        out.println(" -->");
                    }
                }
            }
        }
    }

    public static void writeXML(File file, Document doc) throws Exception {
        PrintStream out = new PrintStream(new FileOutputStream(file));
        FwkServiceProvider.writeXML(out, doc);
        out.close();
    }

    public static void writeXML(PrintStream out, Document doc) throws Exception {
        out.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n");
        NodeList list = doc.getChildNodes();
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            FwkServiceProvider.printOutNode(out, "", list.item(i), true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ClassLoader loadJAR(ClassLoader classLoader, String jarFile) throws FileNotFoundException {
        ClassLoader ret = null;
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (jarFile == null) return classLoader;
        if (jarFile.length() <= 0) return classLoader;
        URL url = null;
        try {
            url = new URL(jarFile);
        }
        catch (Throwable t) {
            url = classLoader.getResource(jarFile);
        }
        if (url == null) throw new FileNotFoundException(jarFile);
        URL[] arr = null;
        try {
            String filename = url.getFile();
            File file = new File(filename);
            JarFile jar = new JarFile(file.getPath());
            Manifest manifest = jar.getManifest();
            Attributes attrs = manifest.getMainAttributes();
            String classpath = (String)attrs.get(new Attributes.Name("Class-Path"));
            if (classpath != null) {
                String[] sArr = classpath.split("\\s");
                String p = url.getProtocol();
                String h = url.getHost();
                int port = url.getPort();
                arr = new URL[sArr.length + 1];
                arr[0] = url;
                for (int i = 0; i < sArr.length; ++i) {
                    arr[i + 1] = new URL(p, h, port, ("/" + file.getParent() + File.separatorChar + sArr[i]).replace(File.separatorChar, '/'));
                }
            } else {
                arr = new URL[]{url};
            }
        }
        catch (Throwable t) {
            arr = new URL[]{url};
        }
        if (FwkContainer.getDebugLevel() > 0) {
            System.out.println("Loading from " + url.toString());
            for (int i = 0; i < arr.length; ++i) {
                System.out.println("\t" + arr[i].toString());
            }
        }
        URLClassLoader loader = new URLClassLoader(arr, classLoader);
        loaders.put(url, loader);
        return loader;
    }
}

