/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkServiceProvider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class FwkServicesTreeModel
extends DefaultTreeModel {
    protected File servicesDir;
    protected File[] files;
    protected Vector zippedFiles;
    protected HashMap zippedNodes;
    protected StringBuffer error;

    public FwkServicesTreeModel(File servicesDir) {
        super(new XMLTreeNode(FwkServicesTreeModel.createRoot()), true);
        XMLTreeNode root = (XMLTreeNode)this.getRoot();
        this.zippedFiles = new Vector();
        this.zippedNodes = new HashMap();
        this.error = new StringBuffer();
        this.files = null;
        if (servicesDir != null && servicesDir.isDirectory()) {
            this.servicesDir = servicesDir;
        }
        if (this.servicesDir != null && this.servicesDir.exists()) {
            this.files = this.servicesDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".xml");
                }
            });
            if (this.files != null && this.files.length > 0) {
                Arrays.sort(this.files, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
                int count = 0;
                for (int i = 0; i < this.files.length; ++i) {
                    try {
                        Element serviceList = this.readServiceListFromXML(this.files[i]);
                        if (serviceList != null) {
                            root.insert(serviceList, count++);
                            continue;
                        }
                        this.error.append(this.files[i].toString());
                        this.error.append("\n\t ").append("servicelist not found.");
                        continue;
                    }
                    catch (Throwable t) {
                        this.error.append(this.files[i].toString());
                        this.error.append("\n\t ").append(t.getClass().getName()).append(" ").append(t.getMessage());
                        this.error.append("\n");
                        t.printStackTrace();
                    }
                }
            }
        } else {
            this.files = new File[0];
        }
    }

    public void addService(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        Vector<ZipEntry> result = new Vector<ZipEntry>();
        String subdir = "services/";
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName().toLowerCase();
            if (!name.startsWith(subdir) || !name.endsWith(".xml")) continue;
            result.add(entry);
        }
        int size = result.size();
        if (size > 0) {
            int i;
            XMLTreeNode root = (XMLTreeNode)this.getRoot();
            int count = root.getChildCount();
            HashMap<String, TreeNode> interfaceMap = new HashMap<String, TreeNode>();
            for (i = 0; i < count; ++i) {
                interfaceMap.put(this.getInterfaceName(root.getChildAt(i)), root.getChildAt(i));
            }
            for (i = 0; i < size; ++i) {
                ZipEntry entry = (ZipEntry)result.get(i);
                try {
                    Element newServiceList = this.readServiceListFromXML(entry, zipFile.getInputStream(entry));
                    String iFace = newServiceList.getAttribute("interface");
                    NodeList newServices = newServiceList.getElementsByTagName("service");
                    int len = newServices.getLength();
                    boolean stop = false;
                    for (int n = 0; !stop && n < len; ++n) {
                        Element newService = (Element)newServices.item(n);
                        if (interfaceMap.get(iFace) == null) {
                            XMLTreeNode node = new XMLTreeNode(newServiceList);
                            node.spfAdded = true;
                            this.zippedNodes.put(node.element, zipFile);
                            root.insert(newServiceList, count);
                            node = (XMLTreeNode)root.getChildAt(count);
                            interfaceMap.put(this.getInterfaceName(root.getChildAt(count)), root.getChildAt(count));
                            this.fireTreeNodesInserted(this, new TreePath(new TreeNode[]{root}).getPath(), new int[]{count}, new XMLTreeNode[]{node});
                            count = root.getChildCount();
                            int nCount = node.getChildCount();
                            for (int c = 0; c < nCount; ++c) {
                                XMLTreeNode service = (XMLTreeNode)node.getChildAt(c);
                                service.spfAdded = true;
                                this.zippedNodes.put(service.element, zipFile);
                            }
                            stop = true;
                            continue;
                        }
                        String classname = newService.getAttribute("class");
                        XMLTreeNode serviceList = (XMLTreeNode)interfaceMap.get(iFace);
                        XMLTreeNode sameClass = null;
                        count = serviceList.getChildCount();
                        for (int c = 0; sameClass == null && c < count; ++c) {
                            XMLTreeNode service = (XMLTreeNode)serviceList.getChildAt(c);
                            if (!this.getNodeClassname(service).equals(classname)) continue;
                            sameClass = service;
                        }
                        if (sameClass == null) {
                            serviceList.insert(newService, count);
                            XMLTreeNode node = (XMLTreeNode)serviceList.getChildAt(count);
                            node.spfAdded = true;
                            this.zippedNodes.put(node.element, zipFile);
                            this.fireTreeNodesInserted(this, serviceList.getTreePath().getPath(), new int[]{count}, new XMLTreeNode[]{node});
                            continue;
                        }
                        int index = serviceList.getIndex(sameClass);
                        serviceList.remove(index);
                        this.fireTreeNodesRemoved(this, serviceList.getTreePath().getPath(), new int[]{index}, new XMLTreeNode[]{sameClass});
                        serviceList.insert(newService, index);
                        XMLTreeNode node = (XMLTreeNode)serviceList.getChildAt(index);
                        node.spfAdded = true;
                        this.zippedNodes.put(node.element, zipFile);
                        this.fireTreeNodesInserted(this, serviceList.getTreePath().getPath(), new int[]{index}, new XMLTreeNode[]{node});
                    }
                    this.zippedFiles.add(zipFile);
                    continue;
                }
                catch (Throwable t) {
                    this.error.append(zipFile.toString()).append("\n");
                    this.error.append(entry.toString());
                    this.error.append("\n\t ").append(t.getClass().getName()).append(" ").append(t.getMessage());
                    this.error.append("\n");
                    t.printStackTrace();
                }
            }
        }
    }

    public int getIncludedFilesCount() {
        return this.files.length + this.zippedFiles.size();
    }

    public File[] getIncludedFiles() {
        return this.files;
    }

    public String[] getIncludedItems() {
        int size;
        Vector<String> ret = new Vector<String>();
        File[] f = this.getIncludedFiles();
        if (f != null) {
            size = f.length;
            for (int i = 0; i < size; ++i) {
                ret.add(f[i].getName());
            }
        }
        size = this.zippedFiles.size();
        for (int i = 0; i < size; ++i) {
            ZipFile zipFile = (ZipFile)this.zippedFiles.get(i);
            ret.add("SPF[" + zipFile.getName() + "]");
        }
        return ret.toArray(new String[ret.size()]);
    }

    public String getIncludedItem(int index) {
        if (index < this.files.length) {
            return this.files[index].getName();
        }
        if ((index -= this.files.length) < this.zippedFiles.size()) {
            ZipFile zipFile = (ZipFile)this.zippedFiles.get(index);
            return "SPF[" + zipFile.getName() + "]";
        }
        return "";
    }

    public StringBuffer getErrorBuffer() {
        return this.error;
    }

    public boolean isRoot(TreeNode node) {
        return this.getRoot().equals(node);
    }

    public boolean isServiceList(MutableTreeNode node) {
        boolean ret = false;
        Element elem = this.getElement(node);
        if (elem != null) {
            ret = elem.getNodeName().equals("servicelist");
        }
        return ret;
    }

    public void removeNode(TreeNode node) {
        XMLTreeNode xmlNode = (XMLTreeNode)node;
        XMLTreeNode parent = (XMLTreeNode)xmlNode.getParent();
        int index = parent.getIndex(node);
        parent.remove(index);
        this.fireTreeNodesRemoved(this, parent.getTreePath().getPath(), new int[]{index}, new XMLTreeNode[]{xmlNode});
    }

    public boolean isService(TreeNode node) {
        boolean ret = false;
        Element elem = this.getElement(node);
        if (elem != null) {
            ret = elem.getNodeName().equals("service");
        }
        return ret;
    }

    public boolean isSPFNode(TreeNode node) {
        return ((XMLTreeNode)node).isSPFNode();
    }

    public boolean isProperty(TreeNode node) {
        boolean ret = false;
        Element elem = this.getElement(node);
        if (elem != null) {
            ret = elem.getNodeName().equals("property");
        }
        return ret;
    }

    public String getSPIVersion(TreeNode node) {
        String ret = null;
        try {
            Element elem = this.getElement(node);
            Document doc = FwkServicesTreeModel.getDocument(elem);
            NodeList spi = doc.getElementsByTagName("spi");
            if (spi.getLength() > 0) {
                ret = ((Element)spi.item(0)).getAttribute("version");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (ret == null || ret.length() == 0) {
            ret = "1.0";
        }
        return ret;
    }

    public String getNodeName(TreeNode node) {
        Element elem = this.getElement(node);
        if (elem != null) {
            return elem.getAttribute("name");
        }
        return "";
    }

    public String getNodeVersion(TreeNode node) {
        String ret = null;
        Element elem = this.getElement(node);
        if (elem != null) {
            ret = elem.getAttribute("version");
        }
        if (ret == null || ret.length() == 0) {
            ret = "1.0";
        }
        return ret;
    }

    public String getNodeClassname(TreeNode node) {
        Element elem = this.getElement(node);
        if (elem != null) {
            return elem.getAttribute("class");
        }
        return "";
    }

    public String getNodeURL(TreeNode node) {
        Element elem = this.getElement(node);
        if (elem != null) {
            return elem.getAttribute("url");
        }
        return "";
    }

    public String getInterfaceName(TreeNode node) {
        Element elem = this.getElement(node);
        if (elem != null) {
            return elem.getAttribute("interface");
        }
        return "";
    }

    public String getNodeDescription(TreeNode node) {
        NodeList list;
        Node description = null;
        String ret = null;
        Element elem = this.getElement(node);
        if (elem != null && (list = elem.getElementsByTagName("description")) != null && list.getLength() > 0) {
            int i;
            Locale locale = FwkContainer.getLocale();
            String laco = locale.getLanguage() + "_" + locale.getCountry();
            for (i = 0; i < list.getLength(); ++i) {
                Element desc = (Element)list.item(i);
                String localeAttr = desc.getAttribute("locale");
                if (localeAttr != null && localeAttr.length() > 0) {
                    if (laco.compareTo(localeAttr) == 0) {
                        description = desc;
                        continue;
                    }
                    if (description == null || laco.indexOf(localeAttr) < 0) continue;
                    description = desc;
                    continue;
                }
                if (description != null) continue;
                description = desc;
            }
            if (description != null && (list = description.getChildNodes()) != null && list.getLength() > 0) {
                for (i = 0; ret == null && i < list.getLength(); ++i) {
                    Node n = list.item(i);
                    if (n.getNodeType() != 3) continue;
                    ret = n.getNodeValue();
                }
            }
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public String getPropertyValue(TreeNode node) {
        Element elem = this.getElement(node);
        if (elem != null) {
            return elem.getAttribute("value");
        }
        return "";
    }

    public String getPropertyName(TreeNode node) {
        Element elem = this.getElement(node);
        if (elem != null) {
            return elem.getAttribute("name");
        }
        return "";
    }

    public String getPropertyLocale(TreeNode node) {
        Element elem = this.getElement(node);
        if (elem != null) {
            return elem.getAttribute("locale");
        }
        return "";
    }

    public Element getElement(TreeNode node) {
        Element ret = null;
        try {
            ret = ((XMLTreeNode)node).element;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    protected static Document getDocument(Node node) {
        if (node != null && node.getNodeType() != 9) {
            return FwkServicesTreeModel.getDocument(node.getParentNode());
        }
        return (Document)node;
    }

    protected static Node copyNode(Document doc, Node src) {
        if (src.getNodeType() == 1) {
            return FwkServicesTreeModel.copyElement(doc, (Element)src);
        }
        return FwkServicesTreeModel.copyText(doc, (Text)src);
    }

    protected static Element copyElement(Document doc, Element src) {
        Element ret = doc.createElement(src.getNodeName());
        NamedNodeMap attrs = src.getAttributes();
        int size = attrs.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = attrs.item(i);
            ret.setAttribute(node.getNodeName(), node.getNodeValue());
        }
        NodeList nList = src.getChildNodes();
        size = nList.getLength();
        for (int i = 0; i < size; ++i) {
            ret.appendChild(FwkServicesTreeModel.copyNode(doc, nList.item(i)));
        }
        return ret;
    }

    protected static Text copyText(Document doc, Text src) {
        Text ret = doc.createTextNode(src.getNodeName());
        ret.setData(src.getData());
        return ret;
    }

    public void copyFiles(File dir) throws IOException {
        XMLTreeNode xmlNode = (XMLTreeNode)this.getRoot();
        Element root = xmlNode.element;
        NodeList services = root.getElementsByTagName("service");
        int size = services.getLength();
        HashMap<String, String> handled = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            Element service = (Element)services.item(i);
            String url = service.getAttribute("url");
            if (handled.get(url) != null) continue;
            ZipFile zipFile = (ZipFile)this.zippedNodes.get(service);
            if (zipFile != null) {
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    if (entry.getName().endsWith(".xml")) continue;
                    this.copyZipEntry(dir, zipFile, entry, handled);
                }
            }
            handled.put(url, url);
        }
    }

    protected void copyZipEntry(File dir, ZipFile zipFile, ZipEntry entry, HashMap handled) throws IOException, FileNotFoundException {
        byte[] buffer = new byte[4096];
        if (entry != null && handled.get(entry.getName()) == null) {
            if (!entry.isDirectory()) {
                int len;
                File file = new File(dir, entry.getName());
                if (file.exists()) {
                    File dest = new File(dir, entry.getName() + ".bak");
                    file.renameTo(dest);
                    file = new File(dir, entry.getName());
                } else {
                    File parent = file.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                }
                if (FwkContainer.getDebugLevel() > 0) {
                    System.out.println(this.getClass().getName() + ".copyZipEntry " + entry.getName() + " to " + file.toString());
                }
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                do {
                    len = bis.read(buffer);
                    bos.write(buffer, 0, len);
                } while (len == buffer.length);
                bis.close();
                bos.close();
            }
            handled.put(entry.getName(), entry.getName());
        }
    }

    public void writeServiceListToXML(File dir) throws IOException, FileNotFoundException {
        XMLTreeNode xmlNode = (XMLTreeNode)this.getRoot();
        Element root = xmlNode.element;
        NodeList children = root.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            this.writeServiceToXMLFile(dir, children.item(i));
        }
    }

    public void writeServiceToXMLFile(File dir, Node node) throws IOException, FileNotFoundException {
        Element serviceList = (Element)node;
        String iFace = serviceList.getAttribute("interface");
        if (iFace != null && iFace.length() != 0) {
            File file;
            if (!(dir = new File(dir, "services")).exists()) {
                dir.mkdirs();
            }
            if ((file = new File(dir, iFace + ".xml")).exists()) {
                File dest = new File(dir, iFace + ".xml.bak");
                file.renameTo(dest);
                file = new File(dir, iFace + ".xml");
            }
            FileOutputStream fos = new FileOutputStream(file);
            PrintStream printer = new PrintStream(fos);
            printer.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n");
            printer.println("<spi>");
            this.printXML(printer, "   ", node);
            printer.println("</spi>\n");
            printer.flush();
            printer.close();
        }
    }

    public void writeServiceListToXML(PrintStream printer) throws IOException, FileNotFoundException {
        XMLTreeNode xmlNode = (XMLTreeNode)this.getRoot();
        Element root = xmlNode.element;
        NodeList children = root.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            this.writeServiceToXMLFile(printer, children.item(0));
        }
    }

    public void writeServiceToXMLFile(PrintStream printer, Node node) throws IOException, FileNotFoundException {
        Element serviceList = (Element)node;
        String iFace = serviceList.getAttribute("interface");
        if (iFace != null && iFace.length() != 0) {
            printer.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n");
            printer.println("<spi filename=\"" + iFace + ".xml\">");
            this.printXML(printer, "   ", node);
            printer.println("</spi>\n");
            printer.flush();
        }
    }

    public void printXML(PrintStream printer, String prefix, Node node) {
        String nodeName = node.getNodeName();
        String tailor = null;
        NamedNodeMap attrs = node.getAttributes();
        int size = 0;
        if (!nodeName.startsWith("#")) {
            if (attrs != null) {
                attrs.getLength();
            }
            if ((size = attrs.getLength()) > 0) {
                String spaces = prefix + "<" + nodeName + " ";
                Node attr = attrs.item(0);
                if (size > 1) {
                    this.printAttribute(printer, spaces, attr);
                    printer.println();
                    spaces = spaces.replaceAll(".", " ");
                    for (int i = 1; i < size - 1; ++i) {
                        attr = attrs.item(i);
                        this.printAttribute(printer, spaces, attr);
                        printer.println();
                    }
                    attr = attrs.item(size - 1);
                    this.printAttribute(printer, spaces, attr);
                    printer.println(">");
                } else {
                    this.printAttribute(printer, spaces, attr);
                    printer.println(">");
                }
            } else {
                printer.println(prefix + "<" + nodeName + ">");
            }
            tailor = prefix + "</" + nodeName + ">";
        } else {
            String sVal;
            String value = node.getNodeValue();
            if (value != null && (sVal = value.toString().trim()).length() > 0) {
                if (node.getNodeType() == 3) {
                    printer.println(prefix + sVal.toString());
                } else if (node.getNodeType() == 8) {
                    printer.println(prefix + "<!--");
                    printer.println(prefix + sVal.toString());
                    printer.println(prefix + "-->");
                }
            }
        }
        NodeList children = node.getChildNodes();
        if (children != null) {
            size = children.getLength();
            for (int i = 0; i < size; ++i) {
                this.printXML(printer, prefix + "   ", children.item(i));
            }
        }
        if (tailor != null) {
            printer.println(tailor);
        }
    }

    protected void printAttribute(PrintStream printer, String spaces, Node attr) {
        String value = FwkServiceProvider.convertToXML(attr.getNodeValue());
        printer.print(spaces + " " + attr.getNodeName() + "=\"" + value + "\"");
    }

    protected Element readServiceListFromXML(File file) throws ParserConfigurationException, IOException, FileNotFoundException, SAXException {
        Element ret = this.readServiceListFromXML(file, new FileInputStream(file));
        return ret;
    }

    protected Element readServiceListFromXML(Object spiKey, InputStream is) throws ParserConfigurationException, IOException, FileNotFoundException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        Document ret = db.parse(is);
        NodeList nList = ret.getElementsByTagName("servicelist");
        if (nList != null && nList.getLength() > 0) {
            return (Element)nList.item(0);
        }
        return null;
    }

    protected static Element createRoot() {
        Element root = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            Document doc = db.newDocument();
            root = doc.createElement("spitree");
            root.setAttribute("name", FwkPropertyBus.getProperty("FwkServiceTreeModel.Text.Root", "Plug-Ins"));
            doc.appendChild(root);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return root;
    }

    public void write() throws IOException {
        throw new IOException("Not yet implemented!");
    }

    protected static void printParamterHelp() {
        System.err.println("not enough parameters:");
        System.err.println("\tusage: [-outputdir dir] *.spf");
        System.err.println("\tIf the output directory is not specified, the current working directory will be used.");
        System.err.println("\tThe output directory should be included into the classpath.");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            FwkServicesTreeModel.printParamterHelp();
            System.exit(1);
        }
        File outputDir = null;
        int start = 0;
        if (args[0].compareToIgnoreCase("-outputdir") == 0) {
            if (args.length < 3) {
                FwkServicesTreeModel.printParamterHelp();
                System.exit(1);
            }
            outputDir = new File(args[1]);
            start = 2;
        } else {
            outputDir = new File(System.getProperty("user.dir"));
        }
        File serviceDir = new File(outputDir, "services");
        if (!serviceDir.exists()) {
            serviceDir.mkdirs();
        }
        FwkServicesTreeModel model = new FwkServicesTreeModel(serviceDir);
        if (start < args.length) {
            try {
                for (int i = start; i < args.length; ++i) {
                    System.out.println("Read the configuration from " + args[i]);
                    model.addService(new ZipFile(args[i]));
                }
                model.writeServiceListToXML(outputDir);
                model.copyFiles(outputDir);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.exit(1);
            }
        }
        System.exit(0);
    }

    protected static class XMLTreeNode
    implements MutableTreeNode {
        Element element;
        XMLTreeNode parent;
        Vector treeChildren;
        boolean spfAdded;

        public XMLTreeNode(Element element) {
            int i;
            this.element = element;
            this.spfAdded = false;
            this.treeChildren = new Vector();
            Vector<Node> vec = new Vector<Node>();
            NodeList nList = element.getElementsByTagName("servicelist");
            int size = nList.getLength();
            boolean count = false;
            for (i = 0; i < size; ++i) {
                vec.add(nList.item(i));
            }
            if (!count) {
                nList = element.getElementsByTagName("service");
                size = nList.getLength();
                for (i = 0; i < size; ++i) {
                    vec.add(nList.item(i));
                }
            }
            if (element.getNodeName().equals("service")) {
                nList = element.getElementsByTagName("property");
                size = nList.getLength();
                for (i = 0; i < size; ++i) {
                    vec.add(nList.item(i));
                }
            }
            size = vec.size();
            for (i = 0; i < size; ++i) {
                this.insert((Element)vec.get(i), i);
            }
        }

        public Enumeration children() {
            return this.treeChildren.elements();
        }

        public TreeNode getChildAt(int childIndex) {
            return (TreeNode)this.treeChildren.get(childIndex);
        }

        public int getChildCount() {
            return this.treeChildren.size();
        }

        public int getIndex(TreeNode node) {
            return this.treeChildren.indexOf(node);
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public boolean isLeaf() {
            String nName = this.element.getNodeName();
            return this.getChildCount() == 0 || !nName.equals("servicelist") && !nName.equals("service");
        }

        public boolean getAllowsChildren() {
            return !this.element.getNodeName().equals("property");
        }

        public void insert(MutableTreeNode child, int index) {
            int count;
            Element elem = ((XMLTreeNode)child).element;
            Document destDoc = FwkServicesTreeModel.getDocument(this.element);
            Document srcDoc = FwkServicesTreeModel.getDocument(elem);
            if (destDoc != null && srcDoc != null && !srcDoc.equals(destDoc)) {
                ((XMLTreeNode)child).element = elem = FwkServicesTreeModel.copyElement(destDoc, elem);
            }
            if (index == (count = this.getChildCount())) {
                this.element.appendChild(elem);
            } else {
                XMLTreeNode treeNode = (XMLTreeNode)this.getChildAt(index);
                this.element.insertBefore(elem, treeNode.element);
            }
            this.treeChildren.add(index, child);
            child.setParent(this);
        }

        public void insert(Element elem, int index) {
            Document destDoc = FwkServicesTreeModel.getDocument(this.element);
            Document srcDoc = FwkServicesTreeModel.getDocument(elem);
            if (destDoc != null && srcDoc != null && !srcDoc.equals(destDoc)) {
                elem = FwkServicesTreeModel.copyElement(destDoc, elem);
            }
            this.insert(new XMLTreeNode(elem), index);
        }

        public void remove(int index) {
            this.remove((MutableTreeNode)this.getChildAt(index));
        }

        public void remove(MutableTreeNode node) {
            XMLTreeNode treeNode = (XMLTreeNode)node;
            this.element.removeChild(treeNode.element);
            this.treeChildren.remove(node);
        }

        public void removeFromParent() {
            Node node = this.element.getParentNode();
            if (node != null) {
                node.removeChild(this.element);
            }
            this.parent = null;
        }

        public void setParent(MutableTreeNode newParent) {
            this.removeFromParent();
            Element par = ((XMLTreeNode)newParent).element;
            if (par != null) {
                par.appendChild(this.element);
            }
            this.parent = (XMLTreeNode)newParent;
        }

        public TreePath getTreePath() {
            Vector vec = new Vector();
            vec.add(this);
            vec = this.insertParent(vec);
            return new TreePath(vec.toArray(new XMLTreeNode[vec.size()]));
        }

        public Vector insertParent(Vector vec) {
            XMLTreeNode parent = (XMLTreeNode)this.getParent();
            if (parent != null) {
                vec.add(0, parent);
                return parent.insertParent(vec);
            }
            return vec;
        }

        public void setUserObject(Object object) {
            this.element = (Element)object;
        }

        public boolean isSPFNode() {
            return this.spfAdded;
        }

        public String toString() {
            String ret = this.element.getAttribute("name");
            if (ret == null && ((ret = this.element.getAttribute("class")).length() == 0 || ret == null)) {
                ret = this.element.getAttribute("interface");
            }
            if (ret.length() == 0 || ret == null) {
                ret = this.element.getNodeName();
            }
            return ret;
        }
    }
}

