/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;

public class FwkSortedArray
extends FwkArray
implements FwkArrayInterface,
Cloneable,
Serializable {
    public static final String version = "$Revision: 1.3 $";
    public static final char ASCENDING = 'a';
    public static final char DESCENDING = 'd';
    char order = (char)97;
    boolean dup = false;
    Comparable lastInsertedElement = null;

    public String getVersion() {
        return version;
    }

    public FwkSortedArray() {
        this(10);
    }

    public FwkSortedArray(char order) {
        this(10, order);
    }

    public FwkSortedArray(int initialCapacity, char order) {
        super(initialCapacity);
        this.order = order;
    }

    public FwkSortedArray(int initialCapacity) {
        this(initialCapacity, 'a');
    }

    public FwkSortedArray(Collection c) {
        this(c != null && c.size() > 0 ? c.size() : 10, 'a');
        this.addAll(c);
    }

    public FwkSortedArray(Collection c, char order) {
        this(c != null && c.size() > 0 ? c.size() : 10, order);
        this.addAll(c);
    }

    public void setOrder(char order) {
        if (this.order != order) {
            Comparable[] arr = new Comparable[this.size()];
            arr = this.toArray(arr);
            this.clear();
            this.order = order;
            for (int i = arr.length - 1; i >= 0; --i) {
                this.add(arr[i]);
            }
        }
    }

    public char getOrder() {
        return this.order;
    }

    public boolean getDuplicate() {
        return this.dup;
    }

    public void setDuplicate(boolean dup) {
        this.dup = dup;
    }

    public void insertElementAt(Object element, int index) {
        this.add((Comparable)element);
    }

    public synchronized void addElement(Comparable obj) {
        this.add(obj);
    }

    public synchronized Object set(int index, Object element) {
        Object ret = this.get(index);
        this.remove(index);
        this.add(element);
        return ret;
    }

    public void setElementAt(Object obj, int index) {
        this.set(index, obj);
    }

    public void add(int index, Object element) {
        this.add((Comparable)element);
    }

    public synchronized boolean add(Object element) {
        int size = this.size();
        this.add((Comparable)element);
        return size > this.size();
    }

    public synchronized boolean add(Comparable obj) {
        int size = this.size();
        if (size == 0) {
            super.add(obj);
        } else if (size == 1) {
            int comp = ((Comparable)this.get(0)).compareTo(obj);
            if (comp == 0) {
                if (this.dup) {
                    super.add(obj);
                }
            } else if (this.order == 'a') {
                if (comp < 1) {
                    super.add(obj);
                } else {
                    super.insertElementAt(obj, 0);
                }
            } else if (comp > 1) {
                super.add(obj);
            } else {
                super.insertElementAt(obj, 0);
            }
        } else if (this.order == 'a') {
            this.insertAscend(obj, size / 2, 0, size - 1);
        } else {
            this.insertDescend(obj, size / 2, 0, size - 1);
        }
        this.lastInsertedElement = obj;
        return size != this.size();
    }

    public synchronized boolean addAll(Collection c) {
        int size = this.size();
        if (c != null && c.size() > 0) {
            Comparable[] arr = new Comparable[c.size()];
            arr = c.toArray(arr);
            for (int i = arr.length - 1; i >= 0; --i) {
                this.add(arr[i]);
            }
        }
        return size < this.size();
    }

    public boolean addAll(int index, Collection c) {
        return this.addAll(c);
    }

    public synchronized Comparable getLastInsertedElement() {
        return this.lastInsertedElement;
    }

    public synchronized void print(PrintStream out) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            out.println("(" + i + ") " + this.get(i));
        }
    }

    protected synchronized void insertAscend(Comparable obj, int pos, int lower, int upper) {
        int comp = ((Comparable)this.get(pos)).compareTo(obj);
        if (comp == 0) {
            if (this.dup) {
                super.insertElementAt(obj, pos);
            }
            return;
        }
        if (upper - lower < 2) {
            if (comp < 0) {
                comp = ((Comparable)this.get(upper)).compareTo(obj);
                if (comp == 0) {
                    if (this.dup) {
                        super.insertElementAt(obj, upper);
                    }
                } else if (comp < 0) {
                    super.insertElementAt(obj, upper + 1);
                } else {
                    super.insertElementAt(obj, upper);
                }
            } else {
                comp = ((Comparable)this.get(lower)).compareTo(obj);
                if (comp == 0) {
                    if (this.dup) {
                        super.insertElementAt(obj, lower);
                    }
                } else if (comp < 0) {
                    super.insertElementAt(obj, lower + 1);
                } else {
                    super.insertElementAt(obj, lower);
                }
            }
            return;
        }
        if (comp < 0) {
            this.insertAscend(obj, (upper + pos) / 2, pos, upper);
        } else {
            this.insertAscend(obj, (lower + pos) / 2, lower, pos);
        }
    }

    protected synchronized void insertDescend(Comparable obj, int pos, int lower, int upper) {
        int comp = ((Comparable)this.get(pos)).compareTo(obj);
        if (comp == 0) {
            if (this.dup) {
                super.insertElementAt(obj, pos);
            }
            return;
        }
        if (upper - lower < 2) {
            if (comp > 0) {
                comp = ((Comparable)this.get(upper)).compareTo(obj);
                if (comp == 0) {
                    if (this.dup) {
                        super.insertElementAt(obj, upper);
                    }
                } else if (comp > 0) {
                    super.insertElementAt(obj, upper + 1);
                } else {
                    super.insertElementAt(obj, upper);
                }
            } else {
                comp = ((Comparable)this.get(lower)).compareTo(obj);
                if (comp == 0) {
                    if (this.dup) {
                        super.insertElementAt(obj, lower);
                    }
                } else if (comp > 0) {
                    super.insertElementAt(obj, pos);
                } else {
                    super.insertElementAt(obj, lower);
                }
            }
            return;
        }
        if (comp > 0) {
            this.insertDescend(obj, (upper + pos) / 2, pos, upper);
        } else {
            this.insertDescend(obj, (lower + pos) / 2, lower, pos);
        }
    }

    public synchronized int find(Comparable obj) {
        int size = this.size();
        if (size == 0) {
            return -1;
        }
        if (size == 1) {
            if (((Comparable)this.get(0)).compareTo(obj) == 0) {
                return 0;
            }
            return -1;
        }
        if (this.order == 'a') {
            return this.findAscend(obj, size / 2, 0, size - 1);
        }
        return this.findDescend(obj, size / 2, 0, size - 1);
    }

    protected synchronized int findAscend(Comparable obj, int pos, int lower, int upper) {
        int comp = ((Comparable)this.get(pos)).compareTo(obj);
        if (comp == 0) {
            return pos;
        }
        if (pos == lower) {
            comp = ((Comparable)this.get(lower + 1)).compareTo(obj);
            if (comp == 0) {
                return lower + 1;
            }
            return -1;
        }
        if (pos == upper) {
            comp = ((Comparable)this.get(upper - 1)).compareTo(obj);
            if (comp == 0) {
                return upper - 1;
            }
            return -1;
        }
        if (comp < 0) {
            return this.findAscend(obj, (upper + pos) / 2, pos, upper);
        }
        return this.findAscend(obj, (lower + pos) / 2, lower, pos);
    }

    protected synchronized int findDescend(Comparable obj, int pos, int lower, int upper) {
        int comp = ((Comparable)this.get(pos)).compareTo(obj);
        if (comp == 0) {
            return pos;
        }
        if (pos == lower) {
            comp = ((Comparable)this.get(lower + 1)).compareTo(obj);
            if (comp == 0) {
                return lower + 1;
            }
            return -1;
        }
        if (pos == upper) {
            comp = ((Comparable)this.get(upper - 1)).compareTo(obj);
            if (comp == 0) {
                return upper - 1;
            }
            return -1;
        }
        if (comp > 0) {
            return this.findDescend(obj, (upper + pos) / 2, pos, upper);
        }
        return this.findDescend(obj, (lower + pos) / 2, lower, pos);
    }

    public String getParams() {
        return "Order=" + (this.order == 'a' ? "ASCENDING" : "DESCENDING") + " Duplicate=" + (this.dup ? "true" : "false") + " size=" + this.size();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getParams() + "]";
    }
}

