/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkInfoBusProducer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.interfaces.fwk.FwkInfoBusProducerInterface;
import com.highqsoft.interfaces.fwk.FwkMimeTypeInterface;
import java.awt.datatransfer.DataFlavor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataProducer;
import javax.infobus.InfoBusItemRequestedEvent;

public class FwkSystemPropertyProducer
extends FwkInfoBusProducer
implements FwkInfoBusProducerInterface {
    public static String[] MIMETYPES = new String[]{FwkContainer.getMimeType(FwkMimeTypeInterface.class), FwkPropertyBus.MIMETYPES[0], FwkPropertyBus.MIMETYPES[1], FwkPropertyBus.MIMETYPES[9]};

    public FwkSystemPropertyProducer() {
        super("FwkSystemProperties@" + FwkPropertyBus.BUSNAME, MIMETYPES);
    }

    public boolean revoke(String itemName, DataFlavor[] flavor) {
        return false;
    }

    protected void firePatternItemAvailable(String pattern, DataFlavor[] flavor) {
        InfoBus ib = this.getInfoBus();
        if (ib != null && pattern != null) {
            Enumeration<?> propNames = System.getProperties().propertyNames();
            while (propNames.hasMoreElements()) {
                String ident = (String)propNames.nextElement();
                if (!Pattern.match(ident, pattern, true)) continue;
                this.fireItemAvailable(ident, flavor);
            }
        }
    }

    protected void fireItemAvailable(String ident, DataFlavor[] flavor) {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            boolean added = false;
            DataFlavor[] dataFlavor = this.getDataFlavors();
            if (dataFlavor != null) {
                int size = dataFlavor.length;
                for (int row = 0; row < size && !added; ++row) {
                    int col = flavor.length - 1;
                    while (col >= 0 && !added) {
                        if (!(added = dataFlavor[row].equals(flavor[col--]))) continue;
                        ib.fireItemAvailable(ident, flavor, (InfoBusDataProducer)this);
                    }
                }
            }
        }
    }

    public void dataItemRequested(InfoBusItemRequestedEvent ev) {
        String dataItemName;
        super.dataItemRequested(ev);
        Object property = null;
        if (ev.getDataItem() == null && this.isAssignable(ev.getDataFlavors()) && (dataItemName = ev.getDataItemName().trim()) != null && dataItemName.length() != 0) {
            if (dataItemName.indexOf(42) != -1 || dataItemName.indexOf(63) != -1) {
                HashMap<String, String> ret = new HashMap<String, String>();
                Iterator<Object> it = System.getProperties().keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (!Pattern.match(key, dataItemName, true)) continue;
                    ret.put(key, System.getProperty(key));
                }
                ev.setDataItem(ret);
            } else {
                if (!dataItemName.equals("Properties")) {
                    property = System.getProperty(dataItemName);
                    DataFlavor[] flavor = ev.getDataFlavors();
                    if (property != null && flavor != null && flavor.length > 0) {
                        if (flavor[0].equals(FwkPropertyBus.getBooleanDataFlavor())) {
                            property = Boolean.valueOf((String)property);
                        } else if (flavor[0].equals(FwkPropertyBus.getByteDataFlavor())) {
                            property = Byte.valueOf((String)property);
                        } else if (flavor[0].equals(FwkPropertyBus.getCharacterDataFlavor())) {
                            property = new Character(((String)property).charAt(0));
                        } else if (flavor[0].equals(FwkPropertyBus.getDoubleDataFlavor())) {
                            property = Double.valueOf((String)property);
                        } else if (flavor[0].equals(FwkPropertyBus.getFloatDataFlavor())) {
                            property = Float.valueOf((String)property);
                        } else if (flavor[0].equals(FwkPropertyBus.getIntegerDataFlavor())) {
                            property = Integer.valueOf((String)property);
                        } else if (flavor[0].equals(FwkPropertyBus.getLongDataFlavor())) {
                            property = Long.valueOf((String)property);
                        } else if (flavor[0].equals(FwkPropertyBus.getShortDataFlavor())) {
                            property = Short.valueOf((String)property);
                        }
                    }
                }
                ev.setDataItem(property);
            }
        }
    }
}

