/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkTableMap;
import com.sun.java.swing.plaf.motif.MotifGraphicsUtils;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class FwkTableSorter
extends FwkTableMap {
    static final ImageIcon UP_ICON = new ImageIcon(MotifGraphicsUtils.class.getResource("icons/ScrollUpArrow.gif"));
    static final ImageIcon DOWN_ICON = new ImageIcon(MotifGraphicsUtils.class.getResource("icons/ScrollDownArrow.gif"));
    int[] indexes;
    Vector sortingColumns = new Vector();
    boolean ascending = true;
    boolean ignoreCase = true;
    int compares;
    int sortedColumn = -1;

    public FwkTableSorter() {
        this.indexes = new int[0];
    }

    public FwkTableSorter(TableModel model) {
        this.setModel(model);
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        this.reallocateIndexes();
        this.sortByColumn(0, true);
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        int result;
        Class<?> type = this.model.getColumnClass(column);
        TableModel data = this.model;
        Object o1 = data.getValueAt(row1, column);
        Object o2 = data.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (type.getSuperclass() == Number.class) {
            Number n2;
            double d2;
            Number n1 = (Number)data.getValueAt(row1, column);
            double d1 = n1.doubleValue();
            if (d1 < (d2 = (n2 = (Number)data.getValueAt(row2, column)).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        if (type == Date.class) {
            Date d2;
            long n2;
            Date d1 = (Date)data.getValueAt(row1, column);
            long n1 = d1.getTime();
            if (n1 < (n2 = (d2 = (Date)data.getValueAt(row2, column)).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (type == String.class) {
            int result2;
            String s1 = (String)data.getValueAt(row1, column);
            String s2 = (String)data.getValueAt(row2, column);
            int n = result2 = this.ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
            if (result2 < 0) {
                return -1;
            }
            if (result2 > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Boolean.class) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)data.getValueAt(row1, column);
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)data.getValueAt(row2, column)).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        Object v1 = data.getValueAt(row1, column);
        String s1 = v1.toString();
        Object v2 = data.getValueAt(row2, column);
        String s2 = v2.toString();
        int n = result = this.ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int row1, int row2) {
        ++this.compares;
        for (int level = 0; level < this.sortingColumns.size(); ++level) {
            Integer column = (Integer)this.sortingColumns.elementAt(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result == 0) continue;
            return this.ascending ? result : -result;
        }
        return 0;
    }

    public int[] getIndexes() {
        return this.indexes;
    }

    public void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        this.indexes = new int[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            this.indexes[row] = row;
        }
    }

    public void tableChanged(TableModelEvent e) {
        this.reallocateIndexes();
        super.tableChanged(e);
    }

    public void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            System.err.println("FwkTableSorter not informed of a change in model.");
        }
    }

    public void sort(Object sender) {
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void n2sort() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = i + 1; j < this.getRowCount(); ++j) {
                if (this.compare(this.indexes[i], this.indexes[j]) != -1) continue;
                this.swap(i, j);
            }
        }
    }

    public void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    public void swap(int i, int j) {
        int tmp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = tmp;
    }

    public Object getValueAt(int aRow, int aColumn) {
        this.checkModel();
        return this.model.getValueAt(this.indexes[aRow], aColumn);
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
    }

    public void sortByColumn(int column) {
        this.sortByColumn(column, true);
    }

    public void sortByColumn(int column, boolean ascending) {
        if (this.sortedColumn == column) {
            ascending = !this.ascending;
        } else {
            this.sortedColumn = column;
        }
        this.ascending = ascending;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(column));
        this.sort(this);
        super.tableChanged(new TableModelEvent(this));
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final FwkTableSorter sorter = this;
        final JTable tableView = table;
        TableColumnModel columnModel = tableView.getTableHeader().getColumnModel();
        int count = columnModel.getColumnCount();
        TableHeaderRenderer renderer = new TableHeaderRenderer();
        for (int i = 0; i < count; ++i) {
            columnModel.getColumn(i).setHeaderRenderer(renderer);
        }
        tableView.setColumnSelectionAllowed(false);
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int column = columnModel.getColumnIndexAtX(e.getX());
                if (e.getClickCount() == 1 && column != -1) {
                    if (FwkTableSorter.this.sortedColumn != column) {
                        FwkTableSorter.this.ascending = false;
                    }
                    sorter.sortByColumn(column, !FwkTableSorter.this.ascending);
                }
            }
        });
    }

    protected class TableHeaderRenderer
    extends DefaultTableCellRenderer {
        public TableHeaderRenderer() {
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(2);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header = table.getTableHeader();
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
            this.setText(value == null ? "" : value.toString());
            if (column == FwkTableSorter.this.sortedColumn) {
                if (FwkTableSorter.this.ascending) {
                    this.setIcon(UP_ICON);
                } else {
                    this.setIcon(DOWN_ICON);
                }
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }
}

