/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkTileSelectButtonUI;
import com.highqsoft.fwk.FwkTileSelectModel;
import com.highqsoft.interfaces.fwk.FwkTileInterface;
import com.highqsoft.interfaces.fwk.FwkTileSelectComponentInterface;
import com.highqsoft.interfaces.fwk.FwkTileSelectModelInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class FwkTileSelectButton
extends AbstractButton
implements FwkTileSelectComponentInterface,
MouseMotionListener {
    public static final String version = "$Revision: 1.6 $";
    protected static Color tileBackground;
    private static final String uiClassID = "FwkTileSelectButtonUI";
    protected static final int MARGIN = 2;
    protected static final int INNER_MARGIN = 3;
    protected static final int PAT_SIZE = 15;

    public String getVersion() {
        return version;
    }

    public FwkTileSelectButton(FwkTileInterface[] tiles) {
        this(tiles, 1);
    }

    public FwkTileSelectButton(FwkTileInterface[] tiles, int rowCount) {
        FwkTileSelectModel model = new FwkTileSelectModel(tiles);
        model.setRowCount(rowCount);
        model.setTileMargin(new Dimension(3, 3));
        this.setModel(model);
        this.addMouseMotionListener(this);
        this.setRolloverEnabled(true);
        this.init(null, null);
        this.setMargin(new Insets(2, 2, 2, 2));
        this.setPreferredSize(this.getMinimumSize());
    }

    public void release() {
    }

    public void setRowCount(int rowCount) {
        FwkTileSelectModel model = (FwkTileSelectModel)this.getModel();
        model.setRowCount(rowCount);
        this.setPreferredSize(this.getMinimumSize());
        this.repaint();
    }

    public void setTileMargin(Dimension margin) {
        ((FwkTileSelectModelInterface)((Object)this.getModel())).setTileMargin(margin);
        this.setPreferredSize(this.getMinimumSize());
        this.repaint();
    }

    public FwkTileInterface getSelectedTile() {
        return ((FwkTileSelectModelInterface)((Object)this.getModel())).getSelectedTile();
    }

    public FwkTileInterface[] getTiles() {
        return ((FwkTileSelectModelInterface)((Object)this.getModel())).getTiles();
    }

    public Dimension getTileMargin() {
        return ((FwkTileSelectModelInterface)((Object)this.getModel())).getTileMargin();
    }

    public int getSelectedTileIndex() {
        return ((FwkTileSelectModelInterface)((Object)this.getModel())).getTileIndex();
    }

    public void setSelectEnabled(boolean flag) {
        boolean oldValue = this.isSelectEnabled();
        ((FwkTileSelectModelInterface)((Object)this.model)).setSelectEnabled(flag);
        this.firePropertyChange("selectEnabled", oldValue, flag);
        if (flag != oldValue) {
            this.repaint();
        }
    }

    public void setText(String text) {
    }

    public void setIcon(Icon icon) {
    }

    public boolean getSelectEnabled() {
        return ((FwkTileSelectModelInterface)((Object)this.model)).getSelectEnabled();
    }

    public boolean isSelectEnabled() {
        return ((FwkTileSelectModelInterface)((Object)this.model)).isSelectEnabled();
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.getModel().setRollover(false);
    }

    protected void paintBorder(Graphics g) {
        Graphics2D gr = (Graphics2D)g;
        ButtonModel model = this.getModel();
        if (model.isArmed()) {
            if (!this.hasFocus()) {
                this.requestFocus();
            }
            gr.setColor(this.getBackground());
            if (model.isEnabled()) {
                if (model.isSelected()) {
                    gr.draw3DRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, model.isRollover());
                } else if (model.isRollover()) {
                    gr.draw3DRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, !model.isPressed() && !model.isArmed());
                }
            }
        }
    }

    public Dimension getGridDimension() {
        return ((FwkTileSelectModelInterface)((Object)this.getModel())).getGridDimension();
    }

    public Dimension getMaximumSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        Dimension grid = ((FwkTileSelectModelInterface)((Object)this.getModel())).getGridDimension();
        Dimension tileSize = ((FwkTileSelectModelInterface)((Object)this.getModel())).getMaximumTileSize();
        Dimension tileMargin = ((FwkTileSelectModelInterface)((Object)this.getModel())).getTileMargin();
        Insets insets = this.getInsets();
        return new Dimension(insets.left + insets.right + grid.width * (tileSize.width + tileMargin.width * 2), insets.top + insets.bottom + grid.height * (tileSize.height + tileMargin.height * 2));
    }

    public void updateUI() {
        try {
            this.setUI((FwkTileSelectButtonUI)UIManager.getUI(this));
        }
        catch (Throwable th) {
            System.out.println("AHAHAH: FwkTileSelectButton.updateUI, th = " + th);
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void mouseMoved(MouseEvent e) {
        Dimension grid = this.getGridDimension();
        FwkTileSelectModel model = (FwkTileSelectModel)this.getModel();
        Dimension size = this.getSize();
        Dimension dim = this.getMinimumSize();
        int old = model.getTileIndex();
        int xpos = e.getX() - (size.width - dim.width) / 2;
        int ypos = e.getY() - (size.height - dim.height) / 2;
        if (xpos > 0 && xpos < dim.width && ypos > 0 && ypos < dim.height) {
            model.setTileIndex(xpos * grid.width / dim.width + ypos * grid.height / dim.height * grid.width);
        } else {
            model.setTileIndex(-1);
        }
        if (old != model.getTileIndex()) {
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    static {
        JLabel comp = new JLabel();
        tileBackground = comp.getBackground();
    }
}

