/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkTileSelectMenuItemUI;
import com.highqsoft.fwk.FwkTileSelectModel;
import com.highqsoft.interfaces.fwk.FwkTileInterface;
import com.highqsoft.interfaces.fwk.FwkTileSelectComponentInterface;
import com.highqsoft.interfaces.fwk.FwkTileSelectModelInterface;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.UIManager;

public class FwkTileSelectMenuItem
extends JMenuItem
implements FwkTileSelectComponentInterface {
    public static final String version = "$Revision: 1.5 $";
    private static final String uiClassID = "FwkTileSelectMenuItemUI";
    protected static final int MARGIN = 2;
    protected static final int INNER_MARGIN = 2;
    protected static final int PAT_SIZE = 15;

    public String getVersion() {
        return version;
    }

    public FwkTileSelectMenuItem(FwkTileInterface[] tiles) {
        this(tiles, (int)Math.round(Math.sqrt(tiles.length)));
    }

    public FwkTileSelectMenuItem(FwkTileInterface[] tiles, int rowCount) {
        FwkTileSelectModel model = new FwkTileSelectModel(tiles);
        model.setRowCount(rowCount);
        model.setTileMargin(new Dimension(2, 2));
        this.setModel(model);
        this.addMouseMotionListener(new MouseListener());
        this.setPreferredSize(this.getMinimumSize());
        super.init(null, null);
        this.setMargin(new Insets(2, 2, 2, 2));
        this.updateUI();
    }

    public void release() {
    }

    public void setTileMargin(Dimension margin) {
        ((FwkTileSelectModelInterface)((Object)this.getModel())).setTileMargin(margin);
        this.setPreferredSize(this.getMinimumSize());
        this.repaint();
    }

    public FwkTileInterface getSelectedTile() {
        return ((FwkTileSelectModelInterface)((Object)this.getModel())).getSelectedTile();
    }

    public FwkTileInterface[] getTiles() {
        return ((FwkTileSelectModelInterface)((Object)this.getModel())).getTiles();
    }

    public Dimension getTileMargin() {
        return ((FwkTileSelectModelInterface)((Object)this.getModel())).getTileMargin();
    }

    public int getSelectedTileIndex() {
        return ((FwkTileSelectModelInterface)((Object)this.getModel())).getTileIndex();
    }

    public void setSelectEnabled(boolean flag) {
        boolean oldValue = this.isSelectEnabled();
        ((FwkTileSelectModelInterface)((Object)this.model)).setSelectEnabled(flag);
        this.firePropertyChange("selectEnabled", oldValue, flag);
        if (flag != oldValue) {
            this.repaint();
        }
    }

    public void setText(String text) {
    }

    public void setIcon(Icon icon) {
    }

    public boolean getSelectEnabled() {
        return ((FwkTileSelectModelInterface)((Object)this.model)).getSelectEnabled();
    }

    public boolean isSelectEnabled() {
        return ((FwkTileSelectModelInterface)((Object)this.model)).isSelectEnabled();
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.getModel().setRollover(false);
    }

    public Dimension getGridDimension() {
        return ((FwkTileSelectModelInterface)((Object)this.getModel())).getGridDimension();
    }

    public Dimension getMaximumSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        Dimension grid = ((FwkTileSelectModelInterface)((Object)this.getModel())).getGridDimension();
        Dimension tileSize = ((FwkTileSelectModelInterface)((Object)this.getModel())).getMaximumTileSize();
        Dimension tileMargin = ((FwkTileSelectModelInterface)((Object)this.getModel())).getTileMargin();
        Insets insets = this.getInsets();
        return new Dimension(insets.left + insets.right + grid.width * (tileSize.width + tileMargin.width * 2), insets.top + insets.bottom + grid.height * (tileSize.height + tileMargin.height * 2));
    }

    public void updateUI() {
        try {
            this.setUI((FwkTileSelectMenuItemUI)UIManager.getUI(this));
        }
        catch (Throwable th) {
            System.out.println("AHAHAH: FwkTileSelectMenuItem.updateUI, th = " + th);
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    class MouseListener
    implements MouseMotionListener {
        MouseListener() {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            Dimension grid = FwkTileSelectMenuItem.this.getGridDimension();
            FwkTileSelectModel model = (FwkTileSelectModel)FwkTileSelectMenuItem.this.getModel();
            Dimension size = FwkTileSelectMenuItem.this.getSize();
            Dimension dim = FwkTileSelectMenuItem.this.getMinimumSize();
            int old = model.getTileIndex();
            int xpos = e.getX() - (size.width - dim.width) / 2;
            int ypos = e.getY() - (size.height - dim.height) / 2;
            if (xpos > 0 && xpos < dim.width && ypos > 0 && ypos < dim.height) {
                model.setTileIndex(xpos * grid.width / dim.width + ypos * grid.height / dim.height * grid.width);
            } else {
                model.setTileIndex(-1);
            }
            if (old != model.getTileIndex()) {
                FwkTileSelectMenuItem.this.repaint();
            }
        }
    }
}

