/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkColorSelectButton;
import com.highqsoft.interfaces.fwk.FwkInterface;
import com.highqsoft.interfaces.fwk.FwkTileInterface;
import com.highqsoft.interfaces.fwk.FwkTileSelectModelInterface;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class FwkTileSelectMenuItemUI
extends BasicMenuItemUI
implements FwkInterface {
    public static final String version = "$Revision: 1.4 $";

    public String getVersion() {
        return version;
    }

    public void release() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new FwkTileSelectMenuItemUI();
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        FwkColorSelectButton ibb = (FwkColorSelectButton)c;
        return ibb.getMinimumSize();
    }

    public void paint(Graphics gr, JComponent c) {
        Graphics g = gr.create();
        super.paint(g, c);
        AbstractButton b = (AbstractButton)c;
        FwkTileSelectModelInterface model = (FwkTileSelectModelInterface)((Object)b.getModel());
        ButtonModel butModel = (ButtonModel)((Object)model);
        int tileIndex = model.getTileIndex();
        Insets insets = c.getInsets();
        Dimension patMargin = model.getTileMargin();
        Dimension patSize = model.getMaximumTileSize();
        Dimension grid = model.getGridDimension();
        Dimension size = c.getSize();
        int xOffset = insets.left + (size.width - grid.width * (patSize.width + 2 * patMargin.width)) / 2;
        int yOffset = insets.top + (size.height - grid.height * (patSize.height + 2 * patMargin.height)) / 2;
        FwkTileInterface[] tiles = model.getTiles();
        int tLen = tiles.length;
        for (int i = 0; i < tLen; ++i) {
            int xpos = xOffset + i % grid.width * (patSize.width + 2 * patMargin.width);
            int ypos = yOffset + i / grid.width * (patSize.height + 2 * patMargin.height);
            g.drawImage(tiles[i].getImage(), xpos, ypos, patSize.width, patSize.height, null);
            if (i != tileIndex || !butModel.isArmed()) continue;
            g.setColor(c.getBackground());
            g.draw3DRect(xpos - 1, ypos - 1, patSize.width + 2, patSize.height + 2, !butModel.isArmed() || !butModel.isPressed());
            g.draw3DRect(xpos, ypos, patSize.width, patSize.height, !butModel.isArmed() || !butModel.isPressed());
        }
        g.dispose();
    }
}

