/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.interfaces.fwk.FwkTileInterface;
import com.highqsoft.interfaces.fwk.FwkTileSelectModelInterface;
import java.awt.Dimension;
import javax.swing.DefaultButtonModel;

public class FwkTileSelectModel
extends DefaultButtonModel
implements FwkTileSelectModelInterface {
    public static final String version = "$Revision: 1.3 $";
    boolean selectEnabled = false;
    FwkTileInterface[] tiles;
    int tileIndex;
    Dimension grid;
    Dimension maxTileSize;
    Dimension tileMargin;

    public String getVersion() {
        return version;
    }

    public FwkTileSelectModel(FwkTileInterface[] tiles) {
        this.tiles = tiles;
        this.tileIndex = -1;
        this.maxTileSize = null;
    }

    public void release() {
    }

    public Dimension getMaximumTileSize() {
        if (this.maxTileSize == null && this.tiles != null && this.tiles.length != 0) {
            int size = this.tiles.length;
            this.maxTileSize = new Dimension();
            for (int i = 0; i < size; ++i) {
                Dimension dim = this.tiles[i].getTileSize();
                this.maxTileSize.width = Math.max(this.maxTileSize.width, dim.width);
                this.maxTileSize.height = Math.max(this.maxTileSize.height, dim.height);
            }
        }
        return new Dimension(this.maxTileSize);
    }

    public void setRowCount(int count) {
        int xLen = 0;
        int yLen = count;
        if (this.tiles != null && this.tiles.length > 0) {
            if (yLen <= 0) {
                yLen = (int)Math.round(Math.sqrt(this.tiles.length));
            }
            if ((xLen = this.tiles.length / yLen) * yLen < this.tiles.length) {
                ++xLen;
            }
        }
        this.grid = new Dimension(xLen, yLen);
    }

    public Dimension getGridDimension() {
        return new Dimension(this.grid);
    }

    public int getTileIndex() {
        return this.tileIndex;
    }

    public void setTileIndex(int index) {
        this.tileIndex = this.tiles == null || index < 0 || index >= this.tiles.length ? -1 : index;
    }

    public FwkTileInterface getSelectedTile() {
        if (this.tileIndex >= 0 && this.tileIndex < this.tiles.length) {
            return this.tiles[this.tileIndex];
        }
        return null;
    }

    public FwkTileInterface[] getTiles() {
        return this.tiles;
    }

    public void setSelectEnabled(boolean flag) {
        this.selectEnabled = flag;
    }

    public boolean getSelectEnabled() {
        return this.selectEnabled;
    }

    public boolean isSelectEnabled() {
        return this.selectEnabled;
    }

    public Dimension getTileMargin() {
        return new Dimension(this.tileMargin);
    }

    public void setTileMargin(Dimension margin) {
        this.tileMargin = new Dimension(margin);
    }
}

