/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPresentation;
import com.highqsoft.interfaces.fwk.FwkTraceEventInterface;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FwkTraceEvent
extends FwkPresentation
implements FwkTraceEventInterface {
    public static final String version = "$Revision: 1.3 $";
    protected long level;
    protected long timestamp;
    protected String host;
    protected String user;
    protected Object source;
    protected String message;

    public String getVersion() {
        return version;
    }

    private FwkTraceEvent() {
    }

    public FwkTraceEvent(Object source, long level, String message, String host, String user) {
        if (message == null) {
            message = "";
        }
        if (level == 0L) {
            level = FwkContainer.getTraceLevel();
        }
        if (host == null) {
            host = FwkContainer.getLocalHost();
        }
        if (user == null) {
            user = FwkContainer.getUserName();
        }
        this.init(source, level, message, System.currentTimeMillis(), host, user);
    }

    protected void init(Object source, long level, String message, long timestamp, String host, String user) {
        this.source = source;
        this.level = level;
        this.message = message;
        this.timestamp = timestamp;
        this.host = host;
        this.user = user;
    }

    public Object getSource() {
        return this.source;
    }

    public String getMessage() {
        return this.message;
    }

    public long getLevel() {
        return this.level;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public String getHost() {
        return this.host;
    }

    public String getUser() {
        return this.user;
    }

    public String toString() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        Date currentTime_1 = new Date(this.timestamp);
        String dateString = formatter.format(currentTime_1);
        return "source=[" + this.source.hashCode() + "] level =[" + this.level + "] timestamp =[" + dateString + "] host =[" + this.host + "] user=[" + this.user + "] message=[" + this.message + "]";
    }
}

