/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk;

import com.highqsoft.fwk.FwkSortedArray;
import com.highqsoft.fwk.util.StringUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class FwkXmlInterpreter {
    static /* synthetic */ Class class$java$lang$String;

    public static String encode_java_lang_Boolean(Boolean b) {
        if (b != null) {
            return "" + b;
        }
        return null;
    }

    public static Boolean decode_java_lang_Boolean(String s) {
        if (s.trim().compareToIgnoreCase("true") == 0) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    public static String encode_java_lang_String(String s) {
        int index = s.indexOf(10);
        if (index < 0) {
            index = s.indexOf(9);
        }
        if (index >= 0) {
            StringBuffer ret = new StringBuffer();
            StringTokenizer tok = new StringTokenizer(s, "\n\t\"", true);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (token.indexOf(10) >= 0) {
                    ret.append("\\n");
                    continue;
                }
                if (token.indexOf(9) >= 0) {
                    ret.append("\\t");
                    continue;
                }
                if (token.indexOf(34) >= 0) {
                    ret.append("\\\"");
                    continue;
                }
                ret.append(token);
            }
            return "\"" + ret.toString() + "\"";
        }
        return "\"" + s + "\"";
    }

    public static String decode_java_lang_String(String s) {
        String[] arr = StringUtilities.split(s, "\\n", false);
        if (arr.length > 1) {
            s = StringUtilities.concatenate(arr, "\n", false);
        }
        if ((arr = StringUtilities.split(s, "\\t", false)).length > 1) {
            s = StringUtilities.concatenate(arr, "\t", false);
        }
        if (s.startsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String encode_java_awt_Color(Color c) {
        if (c != null) {
            return "r=" + c.getRed() + ", g=" + c.getGreen() + ", b=" + c.getBlue() + ", a=" + c.getAlpha();
        }
        return null;
    }

    public static Color decode_java_awt_Color(String s) {
        StringTokenizer tok = new StringTokenizer(s, ",=");
        int counter = 0;
        int[] arr = new int[4];
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            if (token.compareToIgnoreCase("R") == 0 || token.compareToIgnoreCase("RED") == 0) {
                counter = 0;
                continue;
            }
            if (token.compareToIgnoreCase("G") == 0 || token.compareToIgnoreCase("GREEN") == 0) {
                counter = 1;
                continue;
            }
            if (token.compareToIgnoreCase("B") == 0 || token.compareToIgnoreCase("BLUE") == 0) {
                counter = 2;
                continue;
            }
            if (token.compareToIgnoreCase("A") == 0 || token.compareToIgnoreCase("ALPHA") == 0) {
                counter = 3;
                continue;
            }
            try {
                arr[counter] = Integer.parseInt(token);
            }
            catch (Throwable t) {}
        }
        return new Color(arr[0], arr[1], arr[2], arr[3]);
    }

    public static String encode_java_net_URL(URL url) {
        return url.toString();
    }

    public static URL decode_java_net_URL(String s) {
        try {
            return new URL(s);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String encode_java_awt_Dimension(Dimension dim) {
        return dim.getWidth() + ", " + dim.getHeight();
    }

    public static Dimension decode_java_awt_Dimension(String s) {
        StringTokenizer tok = new StringTokenizer(s, ",");
        int counter = 0;
        int[] arr = new int[2];
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            try {
                arr[counter++] = Integer.parseInt(token);
            }
            catch (Throwable t) {}
        }
        return new Dimension(arr[0], arr[1]);
    }

    public static String encode_java_awt_Font(Font f) {
        return f.toString();
    }

    public static Font decode_java_awt_Font(String s) {
        StringTokenizer tok = new StringTokenizer(s, ",=");
        String name = "Helvetica";
        int size = 12;
        int style = 0;
        int key = -1;
        while (tok.hasMoreTokens()) {
            String val = tok.nextToken().trim();
            if (val.compareToIgnoreCase("name") == 0) {
                key = 0;
                continue;
            }
            if (val.compareToIgnoreCase("style") == 0) {
                key = 1;
                continue;
            }
            if (val.compareToIgnoreCase("size") == 0) {
                key = 2;
                continue;
            }
            if (key <= -1) continue;
            switch (key) {
                case 0: {
                    name = val;
                    break;
                }
                case 1: {
                    if (val.compareToIgnoreCase("BOLD") == 0) {
                        style = 1;
                        break;
                    }
                    if (val.compareToIgnoreCase("ITALIC") == 0) {
                        style = 2;
                        break;
                    }
                    if (val.compareToIgnoreCase("PLAIN") != 0) break;
                    style = 0;
                    break;
                }
                case 2: {
                    int index = val.indexOf(93);
                    if (index != -1) {
                        val = val.substring(0, index);
                    }
                    size = Integer.parseInt(val);
                    break;
                }
            }
            key = -1;
        }
        return new Font(name, style, size);
    }

    public static Map getInterpreterMethods(Class interpreterClass, Map map) {
        String name;
        int i;
        if (map == null) {
            map = new HashMap<String, Class>();
        }
        if (interpreterClass == null) {
            interpreterClass = FwkXmlInterpreter.class;
        }
        Method[] m = interpreterClass.getMethods();
        int size = m.length;
        FwkSortedArray readM = new FwkSortedArray();
        FwkSortedArray writeM = new FwkSortedArray();
        for (i = 0; i < size; ++i) {
            name = m[i].getName();
            if (name.startsWith("decode_")) {
                readM.add((Comparable)((Object)name.substring(7)));
                continue;
            }
            if (!name.startsWith("encode_")) continue;
            writeM.add((Comparable)((Object)name.substring(7)));
        }
        size = readM.size();
        for (i = 0; i < size; ++i) {
            if (writeM.find((Comparable)((Object)((String)readM.get(i)))) == -1 || map.containsKey(name = ((String)readM.get(i)).replace('_', '.'))) continue;
            map.put(name, interpreterClass);
        }
        return map;
    }

    public static FwkSortedArray getXMLProperties(Class clazz, FwkSortedArray arr, Class intClazz) {
        Class[] classArr = new Class[]{clazz != null ? intClazz : FwkXmlInterpreter.class};
        return FwkXmlInterpreter.getXMLProperties(clazz, arr, classArr);
    }

    public static FwkSortedArray getXMLProperties(Class clazz, FwkSortedArray arr, Class[] intClazz) {
        if (arr == null) {
            arr = new FwkSortedArray();
        }
        Map interpreter = null;
        int size = intClazz.length;
        for (int i = 0; i < size; ++i) {
            interpreter = FwkXmlInterpreter.getInterpreterMethods(intClazz[i], interpreter);
        }
        return FwkXmlInterpreter.getXMLProperties(clazz, arr, interpreter);
    }

    public static FwkSortedArray getXMLProperties(Class clazz, FwkSortedArray arr, Map interpreterProps) {
        if (arr == null) {
            arr = new FwkSortedArray();
        }
        Method[] m = clazz.getMethods();
        Class[] param = new Class[1];
        int mSize = m.length;
        for (int count = 0; count < mSize; ++count) {
            Class<?> returnType;
            String name = m[count].getName();
            if (!name.startsWith("get") || name.compareTo("getName") == 0) continue;
            name = name.substring(3);
            param[0] = returnType = m[count].getReturnType();
            String rName = returnType.getName();
            if (returnType.isPrimitive() || returnType.equals(class$java$lang$String == null ? FwkXmlInterpreter.class$("java.lang.String") : class$java$lang$String)) {
                if (rName.compareTo("void") == 0) continue;
                try {
                    clazz.getMethod("set" + name, param);
                    arr.add((Comparable)((Object)name));
                }
                catch (Throwable tSet) {}
                continue;
            }
            if (interpreterProps == null || interpreterProps.get(rName) == null) continue;
            try {
                clazz.getMethod("set" + name, param);
                arr.add((Comparable)((Object)name));
                continue;
            }
            catch (Throwable tSet) {
                // empty catch block
            }
        }
        return arr;
    }

    public static StringBuffer getDTD(String[] classes, Class interpreterClass) {
        Class[] arr = new Class[]{interpreterClass};
        return FwkXmlInterpreter.getDTD(classes, arr);
    }

    public static StringBuffer getDTD(String[] classes, Class[] interpreterClass) {
        int i;
        String name;
        int index;
        int i2;
        String space = "      ";
        StringBuffer ret = new StringBuffer();
        ret.append("<!--\n");
        ret.append(" The DTD file for com.highqsoft.P2D components.\n\n");
        ret.append("     **************************************\n");
        ret.append("     * This file is machine generated!!!  *\n");
        ret.append("     * Do not change it by hand!!!        *\n");
        ret.append("     * " + new Date() + " *\n");
        ret.append("     **************************************\n");
        ret.append("-->\n\n");
        String leading = "   ";
        FwkSortedArray elements = new FwkSortedArray();
        FwkSortedArray arr = null;
        HashMap<String, String> names = new HashMap<String, String>();
        Map interpreter = null;
        int size = interpreterClass.length;
        for (int i3 = 0; i3 < size; ++i3) {
            interpreter = FwkXmlInterpreter.getInterpreterMethods(interpreterClass[i3], interpreter);
        }
        size = classes.length;
        for (i2 = 0; i2 < size; ++i2) {
            index = classes[i2].lastIndexOf(46);
            name = index != -1 ? classes[i2].substring(index + 1) : classes[i2];
            names.put(classes[i2], name);
        }
        ret.append(leading + "<!ENTITY % HighQSoft-Package \"com.highqsoft\">\n");
        for (i2 = 0; i2 < size; ++i2) {
            ret.append(leading + "<!ENTITY % " + names.get(classes[i2]) + " \"" + classes[i2] + "\">\n");
        }
        ret.append("\n");
        ret.append(leading + "<!ELEMENT P2DRoot (\n");
        for (i2 = 0; i2 < size; ++i2) {
            if (i2 < size - 1) {
                ret.append(leading + space + "%" + names.get(classes[i2]) + "; |\n");
                continue;
            }
            ret.append(leading + space + "%" + names.get(classes[i2]) + ";)*>\n\n");
        }
        for (i = 0; i < size; ++i) {
            try {
                int count;
                Class<?> clazz = Class.forName(classes[i]);
                Method[] m = clazz.getMethods();
                FwkSortedArray getM = new FwkSortedArray();
                FwkSortedArray setM = new FwkSortedArray();
                int mSize = m.length;
                for (count = 0; count < mSize; ++count) {
                    name = m[count].getName();
                    if (name.compareTo("getName") == 0 || name.compareTo("setName") == 0) continue;
                    if (name.startsWith("get")) {
                        name = name.substring(3);
                        Class<?> returnType = m[count].getReturnType();
                        if (returnType.isPrimitive() || returnType.getName().compareTo("java.lang.String") == 0) {
                            if (returnType.getName().compareTo("void") == 0) continue;
                            getM.add((Comparable)((Object)name));
                            continue;
                        }
                        index = returnType.getName().lastIndexOf(46);
                        String intName = index != -1 ? returnType.getName().substring(index + 1) : returnType.getName();
                        if (interpreter.get(intName) == null) continue;
                        getM.add((Comparable)((Object)name));
                        continue;
                    }
                    if (!name.startsWith("set")) continue;
                    setM.add((Comparable)((Object)name.substring(3)));
                }
                ret.append(leading + "<!ELEMENT %" + names.get(clazz.getName()) + "; (\n");
                arr = new FwkSortedArray();
                mSize = getM.size();
                for (count = 0; count < mSize; ++count) {
                    name = (String)getM.get(count);
                    if (setM.find((Comparable)((Object)name)) == -1) continue;
                    arr.add((Comparable)((Object)name));
                    elements.add((Comparable)((Object)name));
                }
                mSize = arr.size() - 1;
                if (mSize >= 0) {
                    for (count = 0; count < mSize; ++count) {
                        ret.append(leading + space + arr.get(count) + " |\n");
                    }
                    ret.append(leading + space + arr.get(arr.size() - 1) + ")*>\n");
                }
                ret.append(leading + "<!ATTLIST %" + names.get(clazz.getName()) + ";\n");
                ret.append(leading + space + "Name          CDATA #REQUIRED\n");
                ret.append(leading + space + "Interpreter   CDATA #IMPLIED>\n\n");
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        size = elements.size();
        for (i = 0; i < size; ++i) {
            ret.append(leading + "<!ELEMENT " + elements.get(i) + "  (#PCDATA)>\n");
            ret.append(leading + "<!ATTLIST " + elements.get(i) + "\n");
            ret.append(leading + "          Interpreter   CDATA #IMPLIED>\n\n");
        }
        return ret;
    }

    public static void writeDTD(String filename, String[] classes, Class clazz) throws IOException {
        FileOutputStream fos = new FileOutputStream(filename);
        PrintStream ps = new PrintStream(fos);
        ps.println(FwkXmlInterpreter.getDTD(classes, clazz));
        ps.close();
        fos.close();
    }

    public static float[] getDashArray() {
        return new float[5];
    }

    public static void main(String[] args) {
        try {
            Class clazz = FwkXmlInterpreter.class;
            Method m = clazz.getMethod("getDashArray", null);
            Class<?> ret = m.getReturnType();
            System.out.println(ret);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

