/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.application.help;

import com.highqsoft.fwk.FwkApplication;
import com.highqsoft.fwk.FwkApplicationBus;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.application.help.FwkHelp;
import com.highqsoft.fwk.listener.FwkHelpIDActionListener;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkHelpBrokerInterface;
import com.highqsoft.interfaces.fwk.FwkPanelInterface;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import javax.help.BadIDException;
import javax.help.CSH;
import javax.help.DefaultHelpModel;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.TextHelpModel;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class FwkHelpBroker
extends FwkApplication
implements FwkHelpBrokerInterface,
KeyListener {
    public static final String version = "$Revision: 1.4 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    protected static HelpSet helpset;
    protected FwkHelp fwkHelp = null;
    protected Font font = null;
    protected ActionListener displayHelpFromFocus;
    protected ActionListener displayHelpFromSource;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return descriptor;
    }

    public FwkHelpBroker() {
        FwkApplicationInterface[] appls;
        this.setDescriptor(descriptor);
        this.setEternal(true);
        this.register();
        helpset = FwkHelpBroker.findHelpSet();
        if (helpset != null) {
            this.createComponent();
        }
        if ((appls = FwkApplicationBus.findMultipleApplications("*", FwkContainer.getDataFlavor(FwkApplicationInterface.class))) != null && appls.length > 1) {
            this.unregister();
        }
    }

    public FwkHelpBroker(HelpSet hs) {
        helpset = hs;
        this.setDescriptor(descriptor);
        FwkContainer.addComponentProperties("FwkHelpBroker", FwkHelpBroker.class.getName());
        this.setEternal(true);
        this.register();
        FwkContainer.register((FwkApplicationInterface)this, FwkContainer.getMimeType(FwkHelpBrokerInterface.class));
        this.createComponent();
        FwkApplicationInterface[] appls = FwkApplicationBus.findMultipleApplications("*", FwkContainer.getDataFlavor(FwkApplicationInterface.class));
        if (appls != null && appls.length > 1) {
            this.unregister();
        }
    }

    public static HelpSet findHelpSet() {
        if (helpset == null) {
            FwkContainer.addComponentProperties("FwkHelpBroker", FwkHelpBroker.class.getName());
            String key = "FwkHelpBroker.URL.HelpSet";
            String helpSetUrl = FwkPropertyBus.getProperty(key);
            if (key.compareTo(helpSetUrl) == 0) {
                helpSetUrl = "com/highqsoft/help/" + FwkContainer.getLocale().getLanguage() + "/Help.hs";
            }
            try {
                ClassLoader cl = FwkHelpBroker.class.getClassLoader();
                URL hsURL = HelpSet.findHelpSet((ClassLoader)cl, (String)helpSetUrl);
                helpset = new HelpSet(cl, hsURL);
                FwkContainer.debug(3, "HelpSet <" + hsURL + "> loaded");
            }
            catch (Exception e) {
                System.err.println("FwkHelpBroker: Helpset " + helpSetUrl + " not found.");
                FwkContainer.showErrorMessage((String)null, FwkPropertyBus.getProperty("FwkHelpBroker.Text.ApplicationName"), FwkPropertyBus.getProperty("FwkHelpBroker.Text.HelpSetNotFound") + "\n" + helpSetUrl);
            }
        }
        return helpset;
    }

    public void run() {
    }

    public void createComponent() {
        if (helpset != null) {
            try {
                this.fwkHelp = new FwkHelp(helpset);
                this.fwkHelp.setLocale(FwkContainer.getLocale());
                FwkCommandInterface cmd = this.fwkHelp.getCommand("Help");
                if (cmd != null) {
                    FwkArrayInterface listeners = cmd.getActionListenerArray();
                    if (listeners != null) {
                        listeners.clear();
                    }
                    cmd.addActionListener(new FwkHelpIDActionListener(this));
                }
                if ((cmd = this.fwkHelp.getCommand("About")) != null) {
                    cmd.setController(this);
                }
                if ((cmd = this.fwkHelp.getCommand("Exit")) != null) {
                    cmd.setController(this);
                }
                this.fwkHelp.setController(this);
            }
            catch (Throwable t) {
                System.err.println("No Helper System available.");
            }
        }
    }

    public FwkPanelInterface getPanel() {
        return this.fwkHelp;
    }

    public Dimension getSize() {
        return this.fwkHelp.getSize();
    }

    public void setSize(Dimension size) {
        this.fwkHelp.setSize(size);
    }

    public void addCommand(FwkCommandInterface command) {
        if (this.fwkHelp != null) {
            this.fwkHelp.addCommand(command);
        }
    }

    public FwkCommandInterface getCommand(String commandName) {
        if (this.fwkHelp != null) {
            return this.fwkHelp.getCommand(commandName);
        }
        return null;
    }

    public boolean commandsAvailable() {
        if (this.fwkHelp != null) {
            return this.fwkHelp.commandsAvailable();
        }
        return false;
    }

    public FwkCommandInterface[] getCommands() {
        if (this.fwkHelp != null) {
            return this.fwkHelp.getCommands();
        }
        return null;
    }

    public synchronized void removeCommand(FwkCommandInterface command) {
        if (this.fwkHelp != null) {
            this.fwkHelp.removeCommand(command);
        }
    }

    public void setCommands(FwkCommandInterface[] commands) {
        if (this.fwkHelp != null) {
            this.fwkHelp.setCommands(commands);
        }
    }

    public HelpSet getHelpSet() {
        return helpset;
    }

    public void setHelpSet(HelpSet hs) {
        if (this.fwkHelp != null && hs != null && helpset != hs) {
            if (this.fwkHelp != null) {
                DefaultHelpModel model = new DefaultHelpModel(hs);
                this.fwkHelp.setModel((TextHelpModel)model);
            }
            helpset = hs;
        }
    }

    public Locale getLocale() {
        return FwkContainer.getLocale();
    }

    public void setLocale(Locale l) {
        FwkContainer.setLocale(l);
        if (this.fwkHelp != null) {
            this.fwkHelp.setLocale(l);
        }
    }

    public Font getFont() {
        if (this.fwkHelp != null) {
            return this.fwkHelp.getFont();
        }
        return null;
    }

    public void setFont(Font f) {
        if (this.fwkHelp != null) {
            this.fwkHelp.setFont(this.font);
        }
    }

    public void setCurrentView(String name) {
        if (this.fwkHelp == null) {
            return;
        }
        JHelpNavigator nav = null;
        Enumeration e = this.fwkHelp.getHelpNavigators();
        while (e.hasMoreElements() && !(nav = (JHelpNavigator)e.nextElement()).getNavigatorName().equals(name)) {
            nav = null;
        }
        if (nav == null) {
            throw new IllegalArgumentException("Invalid view name");
        }
        this.fwkHelp.setCurrentNavigator(nav);
    }

    public String getCurrentView() {
        if (this.fwkHelp != null) {
            return this.fwkHelp.getCurrentNavigator().getNavigatorName();
        }
        return null;
    }

    public void initPresentation() {
    }

    public void setDisplayed(boolean b) {
        if (this.fwkHelp != null) {
            this.fwkHelp.setVisible(b);
            try {
                Frame frame = (Frame)this.fwkHelp.getTopLevelAncestor();
                if (frame != null) {
                    frame.setVisible(b);
                    if (this.isEternal()) {
                        FwkApplicationBus.fetchEternal(this.getName());
                    }
                    frame.setState(0);
                } else if (b) {
                    FwkContainer.openFrame(this);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean isDisplayed() {
        if (this.fwkHelp != null && this.fwkHelp.isVisible()) {
            try {
                Frame frame = (Frame)this.fwkHelp.getTopLevelAncestor();
                if (frame != null) {
                    return frame.isVisible();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public void setViewDisplayed(boolean displayed) {
        if (this.fwkHelp != null) {
            this.fwkHelp.setNavigatorDisplayed(displayed);
        }
    }

    public boolean isViewDisplayed() {
        if (this.fwkHelp != null) {
            return this.fwkHelp.isNavigatorDisplayed();
        }
        return false;
    }

    public void setCurrentID(String id) throws BadIDException {
        try {
            this.setCurrentID(Map.ID.create((String)id, (HelpSet)helpset));
        }
        catch (InvalidHelpSetContextException ex) {
            new Error("internal error?");
        }
    }

    public void setCurrentID(Map.ID id) throws InvalidHelpSetContextException {
        if (this.fwkHelp != null) {
            this.fwkHelp.getModel().setCurrentID(id);
            this.fwkHelp.setVisible(true);
        }
    }

    public Map.ID getCurrentID() {
        if (this.fwkHelp != null) {
            return this.fwkHelp.getModel().getCurrentID();
        }
        return null;
    }

    public void setCurrentURL(URL url) {
        if (this.fwkHelp != null) {
            this.fwkHelp.getModel().setCurrentURL(url);
            this.fwkHelp.setVisible(true);
        }
    }

    public URL getCurrentURL() {
        if (this.fwkHelp != null) {
            return this.fwkHelp.getModel().getCurrentURL();
        }
        return null;
    }

    public void enableHelpKey(Component comp, String id, HelpSet hs) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString((Component)comp, (String)id);
        if (hs != null) {
            CSH.setHelpSet((Component)comp, (HelpSet)hs);
        }
        if (comp instanceof JComponent) {
            JComponent root = (JComponent)comp;
            root.registerKeyboardAction(this.getDisplayHelpFromFocus(), KeyStroke.getKeyStroke(156, 0), 2);
            root.registerKeyboardAction(this.getDisplayHelpFromFocus(), KeyStroke.getKeyStroke(112, 0), 2);
        } else {
            comp.addKeyListener(this);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 112 || code == 156) {
            ActionListener al = this.getDisplayHelpFromFocus();
            al.actionPerformed(new ActionEvent(e.getComponent(), 1001, null));
        }
    }

    public void enableHelp(Component comp, String id, HelpSet hs) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString((Component)comp, (String)id);
        if (hs != null) {
            CSH.setHelpSet((Component)comp, (HelpSet)hs);
        }
    }

    public void enableHelp(MenuItem comp, String id, HelpSet hs) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString((MenuItem)comp, (String)id);
        if (hs != null) {
            CSH.setHelpSet((MenuItem)comp, (HelpSet)hs);
        }
    }

    public void enableHelpOnButton(Component comp, String id, HelpSet hs) {
        if (!(comp instanceof AbstractButton) && !(comp instanceof Button)) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString((Component)comp, (String)id);
        if (hs != null) {
            CSH.setHelpSet((Component)comp, (HelpSet)hs);
        }
        if (comp instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)comp;
            button.addActionListener(this.getDisplayHelpFromSource());
        } else if (comp instanceof Button) {
            Button button = (Button)comp;
            button.addActionListener(this.getDisplayHelpFromSource());
        }
    }

    public void enableHelpOnButton(MenuItem comp, String id, HelpSet hs) {
        if (comp == null) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString((MenuItem)comp, (String)id);
        if (hs != null) {
            CSH.setHelpSet((MenuItem)comp, (HelpSet)hs);
        }
        comp.addActionListener(this.getDisplayHelpFromSource());
    }

    protected ActionListener getDisplayHelpFromFocus() {
        if (this.displayHelpFromFocus == null) {
            this.displayHelpFromFocus = new CSH.DisplayHelpFromFocus((HelpBroker)this);
        }
        return this.displayHelpFromFocus;
    }

    protected ActionListener getDisplayHelpFromSource() {
        if (this.displayHelpFromSource == null) {
            this.displayHelpFromSource = new CSH.DisplayHelpFromSource((HelpBroker)this);
        }
        return this.displayHelpFromSource;
    }

    public Point getLocation() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setLocation(Point p) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        FwkContainer.initialize(args);
        FwkContainer.openFrame(FwkHelpBroker.class.getName());
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("Online-Help Broker");
        descriptor.setTitleName("HelpBroker");
        descriptor.setName(FwkHelpBroker.class.getName());
        descriptor.setCreationDate("$Date: 2005/01/04 08:10:21 $", null);
        descriptor.setIconKey("Icon.FwkHelpBroker");
        helpset = null;
    }
}

