/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.application.help;

import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.interfaces.fwk.FwkInterface;
import java.awt.Component;
import java.net.URL;
import java.util.Locale;
import javax.help.Map;
import javax.help.TOCItem;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class FwkHelpTOCCellRenderer
extends DefaultTreeCellRenderer
implements FwkInterface {
    public static final String version = "$Revision: 1.3 $";
    protected Map map;

    public String getVersion() {
        return version;
    }

    public FwkHelpTOCCellRenderer(Map map) {
        this.map = map;
        this.leafIcon = FwkIconFile.getIcon("Icon.Ball_red");
        this.openIcon = FwkIconFile.getIcon("Icon.OpenBook_red");
        this.closedIcon = FwkIconFile.getIcon("Icon.Book_red");
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Locale locale;
        Map.ID id;
        String stringValue = "";
        TOCItem item = (TOCItem)((DefaultMutableTreeNode)value).getUserObject();
        if (item != null) {
            stringValue = item.getName();
        }
        this.setText(stringValue);
        if (sel) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        ImageIcon icon = null;
        if (item != null && (id = item.getImageID()) != null) {
            try {
                URL url = this.map.getURLFromID(id);
                icon = new ImageIcon(url);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (item != null && (locale = item.getLocale()) != null) {
            this.setLocale(locale);
        }
        if (icon != null) {
            this.setIcon(icon);
        } else if (leaf) {
            this.setIcon(this.getLeafIcon());
        } else if (expanded) {
            this.setIcon(this.getOpenIcon());
        } else {
            this.setIcon(this.getClosedIcon());
        }
        this.selected = sel;
        return this;
    }

    public void release() {
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getVersion() + "]";
    }
}

