/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.fwk.application.help;

import com.highqsoft.fwk.application.help.FwkHelpTOCCellRenderer;
import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import com.highqsoft.interfaces.fwk.FwkInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpTOCNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.HelpNavigatorUI;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class FwkHelpTOCNavigatorUI
extends HelpNavigatorUI
implements FwkInterface,
HelpModelListener,
TreeSelectionListener,
PropertyChangeListener {
    public static final String version = "$Revision: 1.4 $";
    protected JHelpTOCNavigator toc;
    protected HelpModel model;
    protected DefaultMutableTreeNode topNode;
    protected JTree tree;
    protected JScrollPane sp;

    public String getVersion() {
        return version;
    }

    public FwkHelpTOCNavigatorUI() {
    }

    public FwkHelpTOCNavigatorUI(JHelpTOCNavigator b) {
        FwkIconInterface icon = FwkIconFile.getIcon("Icon.Book_mauve");
        if (icon != null) {
            this.setIcon(icon);
        }
    }

    public static ComponentUI createUI(JComponent x) {
        return new FwkHelpTOCNavigatorUI((JHelpTOCNavigator)x);
    }

    public void release() {
    }

    public void installUI(JComponent c) {
        this.toc = (JHelpTOCNavigator)c;
        HelpModel model = this.toc.getModel();
        this.toc.setLayout((LayoutManager)new BorderLayout());
        this.toc.addPropertyChangeListener((PropertyChangeListener)this);
        if (model != null) {
            model.addHelpModelListener((HelpModelListener)this);
        }
        this.topNode = new DefaultMutableTreeNode();
        this.tree = new JTree(this.topNode);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree);
        this.toc.add("Center", (Component)this.sp);
        this.reloadData();
    }

    public void uninstallUI(JComponent c) {
        HelpModel model = this.toc.getModel();
        this.toc.removePropertyChangeListener((PropertyChangeListener)this);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.removeTreeSelectionListener(this);
        this.toc.setLayout(null);
        this.toc.removeAll();
        if (model != null) {
            model.removeHelpModelListener((HelpModelListener)this);
        }
        this.toc = null;
    }

    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(250, 100);
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(100, 100);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    protected void setCellRenderer(NavigatorView view, JTree tree) {
        Map map = view.getHelpSet().getCombinedMap();
        FwkHelpTOCCellRenderer cr = new FwkHelpTOCCellRenderer(map);
        tree.setCellRenderer(cr);
    }

    private void reloadData() {
        if (this.toc.getModel() == null) {
            return;
        }
        this.topNode.removeAllChildren();
        TOCView view = (TOCView)this.toc.getNavigatorView();
        if (view == null) {
            return;
        }
        DefaultMutableTreeNode node = view.getDataAsTree();
        while (node.getChildCount() > 0) {
            this.topNode.add((DefaultMutableTreeNode)node.getFirstChild());
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
        this.setCellRenderer((NavigatorView)view, this.tree);
    }

    public void merge(NavigatorView view) {
        TOCView tocView = (TOCView)view;
        DefaultMutableTreeNode node = tocView.getDataAsTree();
        while (node.getChildCount() > 0) {
            this.topNode.add((DefaultMutableTreeNode)node.getFirstChild());
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
        this.setCellRenderer((NavigatorView)tocView, this.tree);
    }

    public void remove(NavigatorView view) {
        this.remove(this.topNode, view.getHelpSet());
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
        this.setCellRenderer(view, this.tree);
    }

    private void remove(DefaultMutableTreeNode node, HelpSet hs) {
        Vector<DefaultMutableTreeNode> toRemove = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            TOCItem item = (TOCItem)child.getUserObject();
            HelpSet chs = item.getHelpSet();
            if (chs != null && hs.contains(chs)) {
                toRemove.addElement(child);
                continue;
            }
            this.remove(child, hs);
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            node.remove((DefaultMutableTreeNode)toRemove.elementAt(i));
        }
    }

    private void setVisibility(DefaultMutableTreeNode node) {
        int max = node.getChildCount();
        for (int i = 0; i < max; ++i) {
            DefaultMutableTreeNode subnode = (DefaultMutableTreeNode)node.getChildAt(i);
            this.tree.expandPath(new TreePath(subnode.getPath()));
        }
    }

    public void idChanged(HelpModelEvent e) {
        Map.ID nId;
        DefaultMutableTreeNode tn;
        TOCItem item;
        Object o;
        TreePath s;
        Map.ID id = e.getID();
        HelpModel helpModel = this.toc.getModel();
        if (e.getSource() != helpModel) {
            System.err.println("Internal inconsistency!");
            System.err.println("  " + e.getSource() + " != " + helpModel);
            throw new Error("Internal error");
        }
        if (id == null) {
            // empty if block
        }
        if ((s = this.tree.getSelectionPath()) != null && (o = s.getLastPathComponent()) instanceof DefaultMutableTreeNode && (item = (TOCItem)(tn = (DefaultMutableTreeNode)o).getUserObject()) != null && (nId = item.getID()) != null && nId.equals((Object)id)) {
            return;
        }
        DefaultMutableTreeNode node = this.findID(this.topNode, id);
        if (node == null) {
            this.tree.clearSelection();
            return;
        }
        TreePath path = new TreePath(node.getPath());
        this.tree.expandPath(path);
        this.tree.setSelectionPath(path);
    }

    private DefaultMutableTreeNode findID(DefaultMutableTreeNode node, Map.ID id) {
        Map.ID testID;
        if (id == null) {
            return null;
        }
        TOCItem item = (TOCItem)node.getUserObject();
        if (item != null && (testID = item.getID()) != null && testID.equals((Object)id)) {
            return node;
        }
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode test = this.findID(tmp, id);
            if (test == null) continue;
            return test;
        }
        return null;
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        TOCItem tocEl = (TOCItem)node.getUserObject();
        if (tocEl != null && tocEl.getID() != null) {
            try {
                this.toc.getModel().setCurrentID(tocEl.getID());
            }
            catch (InvalidHelpSetContextException e2) {
                return;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.toc) {
            String changeName = event.getPropertyName();
            if (changeName.equals("helpModel")) {
                this.reloadData();
            } else if (changeName.equals("font")) {
                Font newFont = (Font)event.getNewValue();
                this.tree.setFont(newFont);
                RepaintManager.currentManager(this.tree).markCompletelyDirty(this.tree);
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getVersion() + "]";
    }
}

